/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.agent.mbean;

import com.ibm.java.diagnostics.healthcenter.agent.mbean.AgentLogFactory;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.HealthCenterOptionHandler;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.Messages;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JavacoreAgent {
    static final String DEBUG_PROPERTY = "com.ibm.java.diagnostics.healthcenter.agent.debug";
    public static boolean isDebug = false;
    private HealthCenterOptionHandler handler;
    private final int processId;
    private int sessionID;
    private Logger logger;
    private int javacoreInterval = 0;
    private int numberOfJavacores = 0;
    private static final long SECONDS_TO_MILLIS = 1000L;

    public JavacoreAgent(HealthCenterOptionHandler handler) {
        this.handler = handler;
        this.processId = handler.getPid();
        System.setProperty("com.ibm.java.diagnostics.healthcenter.running", "true");
        if (this.logger == null) {
            AgentLogFactory.setPid(this.processId);
            this.logger = AgentLogFactory.setUpLogging(this.getClass());
        }
        if (System.getProperty(DEBUG_PROPERTY) != null) {
            isDebug = true;
        }
    }

    public void run() {
        JavacoreStarterThread startThread = new JavacoreStarterThread(Messages.getString("Javacore.thread.name"));
        startThread.start();
    }

    private class JavacoreStarterThread
    extends Thread {
        public JavacoreStarterThread(String name) {
            super(name);
        }

        public void run() {
            System.setProperty("com.ibm.java.diagnostics.healthcenter.running", "true");
            long timeToSleep = 20000L;
            JavacoreAgent.this.javacoreInterval = JavacoreAgent.this.handler.getJavacorePauseDuration();
            if (JavacoreAgent.this.javacoreInterval > 0) {
                timeToSleep = (long)JavacoreAgent.this.javacoreInterval * 1000L;
            }
            String formattedMessage = MessageFormat.format(Messages.getString("Javacore.interval"), timeToSleep / 1000L);
            JavacoreAgent.this.logger.info(formattedMessage);
            JavacoreAgent.this.numberOfJavacores = JavacoreAgent.this.handler.getJavacoreCreationNumber();
            if (JavacoreAgent.this.numberOfJavacores > 0) {
                formattedMessage = MessageFormat.format(Messages.getString("Javacore.max.number.javacore"), JavacoreAgent.this.numberOfJavacores);
                JavacoreAgent.this.logger.info(formattedMessage);
            }
            int javacoresSoFar = 0;
            int javacoreDelayStart = JavacoreAgent.this.handler.getJavacoreStartDelay();
            if (javacoreDelayStart > 0) {
                formattedMessage = MessageFormat.format(Messages.getString("Javacore.delay.start"), javacoreDelayStart);
                JavacoreAgent.this.logger.info(formattedMessage);
                try {
                    Thread.sleep((long)(javacoreDelayStart * 60) * 1000L);
                }
                catch (InterruptedException e) {
                    JavacoreAgent.this.logger.log(Level.WARNING, e.getLocalizedMessage());
                }
            }
            while (true) {
                try {
                    do {
                        try {
                            Thread.sleep(timeToSleep);
                        }
                        catch (InterruptedException e) {
                            JavacoreAgent.this.logger.log(Level.WARNING, e.getLocalizedMessage());
                        }
                        if (!System.getProperty("java.vm.vendor").contains("IBM")) continue;
                        try {
                            Class[] noparams = new Class[]{};
                            Class<?> dumpClass = Class.forName("com.ibm.jvm.Dump");
                            Method dumpMethod = dumpClass.getDeclaredMethod("JavaDump", noparams);
                            dumpMethod.invoke(null, (Object[])null);
                        }
                        catch (Exception e) {
                            System.out.println(e.getMessage());
                        }
                    } while (JavacoreAgent.this.numberOfJavacores != ++javacoresSoFar);
                }
                catch (Exception e) {
                    JavacoreAgent.this.logger.log(Level.WARNING, e.getLocalizedMessage());
                    continue;
                }
                break;
            }
            System.setProperty("com.ibm.java.diagnostics.healthcenter.running", "false");
        }
    }
}

