/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.agent.mbean;

import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.Util;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.AgentLogFactory;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.HealthCenter;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.HealthCenterClientConnectedException;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.HealthCenterOptionHandler;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.Messages;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class HeadlessAgent {
    private static final String UNDERSCORE = "_";
    private static final String VERSION_PROPERTIES = "version.properties";
    private String HEALTHCENTER_FILENAME = "healthcenter";
    static final String HEALTHCENTER_FILE_EXTENSION = ".hcd";
    static final String SOURCE_MAX_SEND = "max_bytes_to_send";
    private static final int SECONDS_TO_MILLIS = 1000;
    private static final int ERROR_SLEEP_TIME = 30000;
    private static final long MINUTES_TO_MILLIS = 60000L;
    private static final int INVALID = -1;
    public static final int UNLIMITED_MAXSEND = -1;
    private static final int FIVE_MB = 0x500000;
    private HealthCenterOptionHandler handler;
    private String startDateTime;
    private final int processId;
    private int sessionID;
    private List<Map<String, String>> liveSourceData;
    private Logger logger;
    private String directory = null;
    private String outFilename;
    int currentRun = 1;
    int hcdFilesToKeep;
    private int maxFileSize = 0;
    TimingControlThread tCT = null;

    public HeadlessAgent(HealthCenterOptionHandler handler) {
        this.handler = handler;
        this.processId = handler.getPid();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd_hhmmss");
        this.startDateTime = dateFormat.format(Calendar.getInstance().getTime());
        if (this.logger == null) {
            AgentLogFactory.setPid(this.processId);
            this.logger = AgentLogFactory.setUpLogging(this.getClass());
        }
        if (handler.getHeadlessFileName() != null && handler.getHeadlessFileName().length() != 0) {
            this.HEALTHCENTER_FILENAME = handler.getHeadlessFileName() + UNDERSCORE + this.HEALTHCENTER_FILENAME;
        }
    }

    public void run() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                if (HeadlessAgent.this.tCT != null) {
                    HeadlessAgent.this.tCT.stopRunning();
                }
            }
        });
        HeadlessStarterThread startThread = new HeadlessStarterThread(Messages.getString("HCLaunchMBean.jmx.starter.thread.name"), this.processId);
        startThread.setDaemon(true);
        startThread.start();
    }

    private SourceControlThread createSourceControlThread(HealthCenter mbean, int sourceIndex, TimingControlThread tCT, FileOutputStream[] outputStreams) {
        SourceControlThread sCT = new SourceControlThread(mbean, sourceIndex, tCT);
        sCT.setDaemon(true);
        if (sCT.keepRunning) {
            sCT.createSourceOutputFile(outputStreams);
            sCT.setPriority(10);
            sCT.start();
        }
        return sCT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createHCDFile(int runNumber, FileOutputStream[] outputStreams) {
        block41: {
            String message;
            if (outputStreams == null) {
                return;
            }
            boolean entriesWritten = false;
            byte[] buf = new byte[1024];
            this.outFilename = this.HEALTHCENTER_FILENAME + this.startDateTime + UNDERSCORE + this.processId + UNDERSCORE + runNumber + HEALTHCENTER_FILE_EXTENSION;
            FileOutputStream fos = null;
            ZipOutputStream out = null;
            try {
                File zipFile = new File(this.directory, this.outFilename);
                fos = new FileOutputStream(zipFile);
                out = new ZipOutputStream(fos);
                for (FileOutputStream tempFos : outputStreams) {
                    try {
                        if (tempFos == null) continue;
                        tempFos.close();
                    }
                    catch (Exception e2) {
                        String message2 = Messages.getString("Headless.agent.error.closing.file");
                        this.logger.log(Level.WARNING, message2, e2);
                    }
                }
                if (this.liveSourceData == null) break block41;
                for (int i = 0; i < this.liveSourceData.size(); ++i) {
                    String hcdFilename;
                    File hcdFile;
                    String fileToZip = this.liveSourceData.get(i).get("name") + this.processId + UNDERSCORE + runNumber;
                    File sourceFileToZip = new File(this.directory, fileToZip);
                    if (sourceFileToZip.exists()) {
                        String message3;
                        String fileToZipAtRoot = this.liveSourceData.get(i).get("name") + this.processId + UNDERSCORE + runNumber;
                        FileInputStream in = null;
                        try {
                            if (sourceFileToZip.length() > 0L) {
                                int len;
                                in = new FileInputStream(sourceFileToZip);
                                out.putNextEntry(new ZipEntry(fileToZipAtRoot));
                                while ((len = in.read(buf)) > 0) {
                                    out.write(buf, 0, len);
                                }
                                out.closeEntry();
                                in.close();
                                entriesWritten = true;
                            }
                        }
                        catch (IOException e) {
                            message3 = Messages.getString("Headless.agent.write.file.error");
                            this.logger.log(Level.WARNING, message3, e);
                        }
                        finally {
                            if (in != null) {
                                try {
                                    in.close();
                                    out.closeEntry();
                                }
                                catch (IOException e) {
                                    message3 = Messages.getString("Headless.agent.write.file.error");
                                    this.logger.log(Level.WARNING, message3, e);
                                }
                            }
                        }
                        if (!sourceFileToZip.delete()) {
                            String errorMsg = MessageFormat.format(Messages.getString("Headless.agent.delete.file.error"), sourceFileToZip.getName());
                            this.logger.log(Level.WARNING, errorMsg);
                        }
                    }
                    if (this.hcdFilesToKeep <= 0 || runNumber - this.hcdFilesToKeep <= 0 || !(hcdFile = new File(this.directory, hcdFilename = this.HEALTHCENTER_FILENAME + this.startDateTime + UNDERSCORE + this.processId + UNDERSCORE + (runNumber - this.hcdFilesToKeep) + HEALTHCENTER_FILE_EXTENSION)).exists() || hcdFile.delete()) continue;
                    String errorMsg = MessageFormat.format(Messages.getString("Headless.agent.delete.file.error"), hcdFile.getName());
                    this.logger.log(Level.WARNING, errorMsg);
                }
                if (entriesWritten) {
                    out.close();
                    String fileCreate = MessageFormat.format(Messages.getString("Headless.agent.hcd.file.created"), this.outFilename);
                    this.logger.info(fileCreate);
                }
            }
            catch (IOException e) {
                message = Messages.getString("Headless.agent.write.file.error");
                this.logger.log(Level.WARNING, message, e);
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {
                        message = Messages.getString("Headless.agent.write.file.error");
                        this.logger.log(Level.WARNING, message, e);
                    }
                }
                if (out != null && entriesWritten) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        message = Messages.getString("Headless.agent.write.file.error");
                        this.logger.log(Level.WARNING, message, e);
                    }
                }
            }
        }
    }

    private void stopSourcesRunning(SourceControlThread[] sourceThreadArray) {
        if (sourceThreadArray != null) {
            for (SourceControlThread sourceEntry : sourceThreadArray) {
                sourceEntry.stopRunning();
                try {
                    sourceEntry.interrupt();
                    sourceEntry.join();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
    }

    private void initialiseSourceThreadArray(SourceControlThread[] sourceThreadArray, HealthCenter mbean, TimingControlThread tCT, FileOutputStream[] outputStreams) {
        for (int i = 0; i < this.liveSourceData.size(); ++i) {
            sourceThreadArray[i] = this.createSourceControlThread(mbean, i, tCT, outputStreams);
            mbean.resetForHeadless(i, this.sessionID);
        }
    }

    private class sourceCleanUp
    extends Thread {
        private int currentRun;
        private FileOutputStream[] outputStreams;
        private SourceControlThread[] sourceThreadArray;

        public sourceCleanUp(SourceControlThread[] sourceThreadArray, int currentRun, FileOutputStream[] outputStreams) {
            this.setSourceThreadArray(sourceThreadArray);
            this.setCurrentRun(currentRun);
            this.outputStreams = outputStreams;
        }

        public void run() {
            HeadlessAgent.this.createHCDFile(this.getCurrentRun(), this.outputStreams);
        }

        private int getCurrentRun() {
            return this.currentRun;
        }

        private void setCurrentRun(int currentRun) {
            this.currentRun = currentRun;
        }

        private SourceControlThread[] getSourceThreadArray() {
            return this.sourceThreadArray;
        }

        private void setSourceThreadArray(SourceControlThread[] sourceThreadArray) {
            this.sourceThreadArray = sourceThreadArray;
        }
    }

    private class SourceControlThread
    extends Thread {
        String sourceName;
        HealthCenter sourceObject;
        int sourceIndex;
        File file;
        FileOutputStream fos;
        long updateIntervalInMilliseconds;
        int expectedBytes;
        private boolean keepRunning = true;
        private TimingControlThread parent;
        int totalBytesRead;

        public void stopRunning() {
            this.keepRunning = false;
        }

        public SourceControlThread(HealthCenter mbean, int index, TimingControlThread tCT) {
            this.parent = tCT;
            this.sourceIndex = index;
            this.sourceObject = mbean;
            this.sourceName = mbean.getLiveSourceDetails().get(this.sourceIndex).get("name");
            this.expectedBytes = Integer.valueOf(mbean.getLiveSourceDetails().get(this.sourceIndex).get(HeadlessAgent.SOURCE_MAX_SEND));
            if (this.sourceObject.getLiveSourceDetails().get(this.sourceIndex).get("suggested_update_frequency") != null) {
                this.updateIntervalInMilliseconds = this.sourceObject.getLiveSourceDetails().get(this.sourceIndex).get("suggested_update_frequency").equals(Integer.toString(Integer.MAX_VALUE)) ? 0L : (long)(Integer.valueOf(this.sourceObject.getLiveSourceDetails().get(this.sourceIndex).get("suggested_update_frequency")) * 1000);
            }
        }

        private void createSourceOutputFile(FileOutputStream[] outputStreams) {
            try {
                this.file = new File(HeadlessAgent.this.directory, this.sourceName + HeadlessAgent.this.processId + HeadlessAgent.UNDERSCORE + HeadlessAgent.this.currentRun);
                outputStreams[this.sourceIndex] = this.fos = new FileOutputStream(this.file);
            }
            catch (FileNotFoundException e) {
                String message = Messages.getString("Headless.agent.create.file.error");
                HeadlessAgent.this.logger.log(Level.WARNING, message, e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (this.updateIntervalInMilliseconds == 0L) {
                return;
            }
            this.totalBytesRead = 0;
            this.keepRunning = true;
            while (this.keepRunning) {
                long timeToSleep = 10L;
                try {
                    block16: {
                        try {
                            if (this.fos == null) break block16;
                            byte[] dataFromJMXSource = this.sourceObject.getJMXData(this.sourceIndex, HeadlessAgent.this.sessionID);
                            if (dataFromJMXSource == null) {
                                if (HealthCenter.isDebug) {
                                    HeadlessAgent.this.logger.info("HeadlessAgent : dataFromJMXSource is null " + this.sourceName);
                                }
                                timeToSleep = this.updateIntervalInMilliseconds;
                                break block16;
                            }
                            int bytesRead = dataFromJMXSource.length;
                            this.fos.write(dataFromJMXSource);
                            this.totalBytesRead += bytesRead;
                            if (bytesRead < this.expectedBytes || this.expectedBytes == -1) {
                                timeToSleep = this.updateIntervalInMilliseconds;
                            }
                            if (!((double)this.totalBytesRead + (double)bytesRead >= (double)HeadlessAgent.this.maxFileSize) || !this.keepRunning) break block16;
                            TimingControlThread timingControlThread = this.parent;
                            synchronized (timingControlThread) {
                                this.parent.sourceTooBig = true;
                                this.parent.notify();
                            }
                            this.stopRunning();
                        }
                        catch (IOException e1) {
                            String formattedMessage = MessageFormat.format(Messages.getString("Headless.agent.write.file.error"), this.file);
                            try {
                                HeadlessAgent.this.logger.log(Level.WARNING, formattedMessage, e1);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                    }
                    try {
                        Thread.sleep(timeToSleep);
                    }
                    catch (InterruptedException e) {
                    }
                }
                catch (HealthCenterClientConnectedException e) {
                    HeadlessAgent.this.logger.log(Level.WARNING, e.getLocalizedMessage());
                }
            }
        }
    }

    private class TimingControlThread
    extends Thread {
        private HealthCenter mbean;
        private boolean sourceTooBig = false;
        private boolean keepRunning = true;

        public TimingControlThread(HealthCenter mbean) {
            this.mbean = mbean;
        }

        private FileOutputStream[] initialiseFiles() {
            HeadlessAgent.this.directory = HeadlessAgent.this.handler.getHeadlessOutputDirectory();
            if (HeadlessAgent.this.directory != null && HeadlessAgent.this.directory.length() == 0) {
                HeadlessAgent.this.directory = null;
            }
            HeadlessAgent.this.directory = Util.findWriteableDirectory(HeadlessAgent.this.directory);
            if (HeadlessAgent.this.directory == null) {
                return null;
            }
            HeadlessAgent.this.logger.log(Level.INFO, MessageFormat.format(Messages.getString("Headless.agent.writing.to"), HeadlessAgent.this.directory));
            FileOutputStream[] outputStreams = new FileOutputStream[HeadlessAgent.this.liveSourceData.size()];
            return outputStreams;
        }

        public void stopRunning() {
            this.keepRunning = false;
            this.interrupt();
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            String formattedMessage;
            int numberOfRuns;
            int pauseDuration;
            int runDuration = HeadlessAgent.this.handler.getHeadlessRunDuration();
            if (runDuration > 0) {
                String formattedMessage2 = MessageFormat.format(Messages.getString("Headless.agent.run.length"), runDuration);
                HeadlessAgent.this.logger.info(formattedMessage2);
            }
            if ((pauseDuration = HeadlessAgent.this.handler.getHeadlessRunPauseDuration()) > 0) {
                String formattedMessage3 = MessageFormat.format(Messages.getString("Headless.agent.pause.duration"), pauseDuration);
                HeadlessAgent.this.logger.info(formattedMessage3);
            }
            if ((numberOfRuns = HeadlessAgent.this.handler.getHeadlessRunCount()) > 0) {
                formattedMessage = MessageFormat.format(Messages.getString("Headless.agent.run.count"), numberOfRuns);
                HeadlessAgent.this.logger.info(formattedMessage);
            }
            HeadlessAgent.this.hcdFilesToKeep = HeadlessAgent.this.handler.getFilesToKeep();
            if (HeadlessAgent.this.hcdFilesToKeep > 0) {
                formattedMessage = MessageFormat.format(Messages.getString("Headless.agent.file.count"), HeadlessAgent.this.hcdFilesToKeep);
                HeadlessAgent.this.logger.info(formattedMessage);
            }
            if (HeadlessAgent.this.liveSourceData != null) {
                SourceControlThread[] sourceThreadArray = new SourceControlThread[HeadlessAgent.this.liveSourceData.size()];
                FileOutputStream[] outputStreams = null;
                while (this.keepRunning) {
                    String message;
                    TimingControlThread timingControlThread;
                    outputStreams = this.initialiseFiles();
                    if (outputStreams == null) {
                        HeadlessAgent.this.logger.log(Level.SEVERE, Messages.getString("Headless.agent.create.file.error"));
                        return;
                    }
                    HeadlessAgent.this.initialiseSourceThreadArray(sourceThreadArray, this.mbean, this, outputStreams);
                    if (runDuration > 0) {
                        timingControlThread = this;
                        synchronized (timingControlThread) {
                            try {
                                long timeLeftToPause = (long)runDuration * 60000L;
                                while (timeLeftToPause > 0L) {
                                    long timeBeforeWait = System.currentTimeMillis();
                                    this.wait(timeLeftToPause);
                                    if (this.sourceTooBig) {
                                        long timeAfterWait = System.currentTimeMillis();
                                        timeLeftToPause -= timeAfterWait - timeBeforeWait;
                                        HeadlessAgent.this.stopSourcesRunning(sourceThreadArray);
                                        sourceCleanUp sCU = new sourceCleanUp(sourceThreadArray, HeadlessAgent.this.currentRun, outputStreams);
                                        sCU.setDaemon(true);
                                        sCU.start();
                                        ++HeadlessAgent.this.currentRun;
                                        this.sourceTooBig = false;
                                        outputStreams = this.initialiseFiles();
                                        if (outputStreams == null) {
                                            HeadlessAgent.this.logger.log(Level.SEVERE, Messages.getString("Headless.agent.create.file.error"));
                                            return;
                                        }
                                        HeadlessAgent.this.initialiseSourceThreadArray(sourceThreadArray, this.mbean, this, outputStreams);
                                        continue;
                                    }
                                    timeLeftToPause = 0L;
                                }
                            }
                            catch (InterruptedException e) {
                                if (!this.keepRunning) {
                                    break;
                                }
                                message = Messages.getString("Headless.agent.delay.start.failure");
                                HeadlessAgent.this.logger.log(Level.WARNING, message, e);
                            }
                        }
                        HeadlessAgent.this.stopSourcesRunning(sourceThreadArray);
                        sourceCleanUp sCU = new sourceCleanUp(sourceThreadArray, HeadlessAgent.this.currentRun, outputStreams);
                        sCU.setDaemon(true);
                        sCU.start();
                        if (numberOfRuns > 0 && HeadlessAgent.this.currentRun == numberOfRuns) {
                            ++HeadlessAgent.this.currentRun;
                            break;
                        }
                        ++HeadlessAgent.this.currentRun;
                        if (pauseDuration <= 0) continue;
                        try {
                            Thread.sleep((long)pauseDuration * 60000L);
                        }
                        catch (InterruptedException e) {
                            if (!this.keepRunning) break;
                            message = Messages.getString("Headless.agent.pause.failure");
                            HeadlessAgent.this.logger.log(Level.WARNING, message, e);
                        }
                        continue;
                    }
                    timingControlThread = this;
                    synchronized (timingControlThread) {
                        try {
                            this.wait();
                            HeadlessAgent.this.stopSourcesRunning(sourceThreadArray);
                            sourceCleanUp sCU = new sourceCleanUp(sourceThreadArray, HeadlessAgent.this.currentRun, outputStreams);
                            sCU.setDaemon(true);
                            sCU.start();
                            ++HeadlessAgent.this.currentRun;
                        }
                        catch (InterruptedException e) {
                            if (!this.keepRunning) {
                                break;
                            }
                            message = Messages.getString("Headless.agent.delay.start.failure");
                            HeadlessAgent.this.logger.log(Level.WARNING, message, e);
                        }
                    }
                }
                HeadlessAgent.this.stopSourcesRunning(sourceThreadArray);
                HeadlessAgent.this.createHCDFile(HeadlessAgent.this.currentRun, outputStreams);
                System.setProperty("com.ibm.java.diagnostics.healthcenter.running", "false");
            }
        }
    }

    private class HeadlessStarterThread
    extends Thread {
        protected int pid;

        public HeadlessStarterThread(String name, int pid) {
            super(name);
            this.pid = 0;
            this.pid = pid;
        }

        public void run() {
            int startDelay;
            System.setProperty("com.ibm.java.diagnostics.healthcenter.running", "true");
            HeadlessAgent.this.maxFileSize = HeadlessAgent.this.handler.getMaxHeadlessFileSize();
            if (HeadlessAgent.this.maxFileSize == 0) {
                HeadlessAgent.this.maxFileSize = Integer.MAX_VALUE;
            }
            if (HeadlessAgent.this.maxFileSize < 0x500000) {
                HeadlessAgent.this.maxFileSize = 0x500000;
            }
            if ((startDelay = HeadlessAgent.this.handler.getHeadlessStartDelay()) > 0) {
                try {
                    String formattedMessage = MessageFormat.format(Messages.getString("Headless.agent.delay.start"), startDelay);
                    HeadlessAgent.this.logger.info(formattedMessage);
                    Thread.sleep((long)startDelay * 60000L);
                }
                catch (InterruptedException e) {
                    String message = Messages.getString("Headless.agent.delay.start.failure");
                    HeadlessAgent.this.logger.log(Level.WARNING, message, e);
                }
            }
            try {
                HealthCenter mbean = new HealthCenter(HeadlessAgent.this.processId, HeadlessAgent.this.handler);
                HeadlessAgent.this.sessionID = mbean.startSession();
                HeadlessAgent.this.liveSourceData = mbean.getLiveSourceDetails();
                if (HeadlessAgent.this.sessionID <= -1) {
                    HeadlessAgent.this.logger.log(Level.SEVERE, Messages.getString("HCLaunchMBean.agent.did.not.start"));
                    return;
                }
                String formattedMessage = Messages.getString("Headless.agent.started");
                HeadlessAgent.this.logger.info(formattedMessage);
                HeadlessAgent.this.tCT = new TimingControlThread(mbean);
                HeadlessAgent.this.tCT.setPriority(10);
                HeadlessAgent.this.tCT.start();
            }
            catch (Exception e) {
                HeadlessAgent.this.logger.fine(MessageFormat.format(Messages.getString("HCLaunchMBean.thread.interrupted"), this.getName()));
            }
        }
    }
}

