/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.agent.mbean;

import com.ibm.java.diagnostics.healthcenter.agent.mbean.Messages;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentLogFactory {
    private static final String TEMP_DIR = System.getProperty("java.io.tmpdir");
    private static final String LOG_FILE_SUFFIX = ".log";
    private static final String HEALTHCENTER_LOG_FILE_PREFIX = "healthcenter.";
    private static FileHandler _fileHandler;
    private static boolean loggingInit;
    private static int pid;

    public static Logger setUpLogging(Class<?> clazz) {
        if (clazz == null) {
            Logger logger = Logger.global;
            logger.warning(Messages.getString("AgentLogFactory.could.not.initialize.logging"));
            return logger;
        }
        try {
            LogManager mgr = LogManager.getLogManager();
            File logFile = null;
            if (!loggingInit) {
                loggingInit = true;
                Logger parentLogger = Logger.getLogger("com.ibm.java.diagnostics.healthcenter.agent");
                mgr.addLogger(parentLogger);
                try {
                    if (pid > 0) {
                        File tempDir = new File(TEMP_DIR);
                        String fileName = HEALTHCENTER_LOG_FILE_PREFIX + pid + LOG_FILE_SUFFIX;
                        logFile = new File(tempDir, fileName);
                    } else {
                        logFile = File.createTempFile(HEALTHCENTER_LOG_FILE_PREFIX, LOG_FILE_SUFFIX);
                    }
                    _fileHandler = new FileHandler(logFile.getAbsolutePath());
                    _fileHandler.setFormatter(new SimpleFormatter());
                    _fileHandler.setLevel(Level.FINEST);
                    parentLogger.addHandler(_fileHandler);
                }
                catch (IOException e) {
                    parentLogger.warning(MessageFormat.format(Messages.getString("HCLaunchMBean.cannot.create.log.file"), TEMP_DIR));
                }
            }
            Logger logger = Logger.getLogger(clazz.getName());
            mgr.addLogger(logger);
            String debugProp = System.getProperty("com.ibm.java.diagnostics.healthcenter.agent.debug");
            if (debugProp != null) {
                logger.setLevel(Level.FINEST);
            } else {
                logger.setLevel(Level.INFO);
            }
            return logger;
        }
        catch (Throwable e) {
            e.printStackTrace();
            Logger logger = Logger.global;
            logger.warning(Messages.getString("AgentLogFactory.could.not.initialize.logging") + e.toString());
            return logger;
        }
    }

    public static void setPid(int newPid) {
        pid = newPid;
    }

    static {
        loggingInit = false;
        pid = 0;
    }
}

