/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.agent.dataproviders.threads;

import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.DataCollectionLevel;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.DataProvider;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.DataProviderConstants;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.Util;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.capabilities.EnablementManager;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.HealthCenterOptionHandler;
import java.io.UnsupportedEncodingException;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadDataProvider
implements DataProvider,
DataProviderConstants {
    public static final String CAPABILITY_THREAD_SUBSYSTEM = "threads_subsystem";
    private static final String DELIMITER = "@#";
    private static final String START_THREAD_REPORT = "startThreads";
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final String EMPTY_STRING = "";
    private static final String REPORT_VERSION = "2.2.1";
    public static final String SET_STACK_DEPTH = "setStack";
    private static String VERSION = "1.0";
    public static final String TAG = "ThreadsSource";
    private String parsertime = "30";
    private static int stackDepth = Integer.MAX_VALUE;
    protected final HealthCenterOptionHandler handler;
    private boolean dataProviderActive = false;
    private EnablementManager enablementManager;
    ThreadMXBean threadBean;
    private boolean isObjectMonitorUsageSupported = false;
    private boolean isSynchronizerUsageSupported = false;

    public ThreadDataProvider(HealthCenterOptionHandler handler) {
        this.handler = handler;
        this.enablementManager = new EnablementManager(TAG, handler.getDataCollectionLevel());
        DataCollectionLevel level = handler.getDataCollectionLevel();
        if (level.ordinal() > DataCollectionLevel.OFF.ordinal()) {
            this.providerInitialisation();
            this.dataProviderActive = true;
        }
        this.parsertime = Integer.toString(handler.getTheadCollectionInterval());
        stackDepth = handler.getThreadStackDepth();
    }

    @Override
    public synchronized void startSession() {
        if (!this.dataProviderActive) {
            this.enablementManager.setLevel(DataCollectionLevel.FULL);
            if (this.enablementManager.isEnabled(CAPABILITY_THREAD_SUBSYSTEM)) {
                this.providerInitialisation();
                this.dataProviderActive = true;
            }
        }
    }

    @Override
    public boolean isDataSupported() {
        return true;
    }

    @Override
    public Map<String, String> getLiveSourceDetails() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", TAG);
        map.put("version", VERSION);
        map.put("state", this.enablementManager.getEnablementString());
        map.put("suggested_update_frequency", this.parsertime);
        map.put("max_bytes_to_send", Integer.toString(-1));
        return map;
    }

    private String getThreadReport() {
        String report;
        if (this.enablementManager.isEnabled(CAPABILITY_THREAD_SUBSYSTEM) && !Util.isHardRealTimeVM()) {
            String threads = EMPTY_STRING;
            long[] threadIDs = this.threadBean.getAllThreadIds();
            ThreadInfo[] infos = null;
            long timestamp = System.currentTimeMillis();
            try {
                infos = this.threadBean.getThreadInfo(threadIDs, this.isObjectMonitorUsageSupported, this.isSynchronizerUsageSupported);
            }
            catch (NoSuchMethodError e) {
                infos = this.threadBean.getThreadInfo(threadIDs);
            }
            catch (InternalError e) {
                if (e.getMessage().contains("JVM_GetThreadStateValues")) {
                    return EMPTY_STRING;
                }
                throw e;
            }
            StringBuffer buffer = new StringBuffer();
            int totalElements = 0;
            for (ThreadInfo info : infos) {
                if (info == null) continue;
                String name = info.getThreadName();
                Thread.State state = info.getThreadState();
                String monitorNames = EMPTY_STRING;
                int ownedMonitors = 0;
                String lockSynchronizers = EMPTY_STRING;
                int ownedLockSynchronizers = 0;
                try {
                    MonitorInfo[] monitors = info.getLockedMonitors();
                    ownedMonitors = monitors.length;
                    StringBuffer sb = new StringBuffer();
                    for (MonitorInfo monitor : monitors) {
                        if (monitor != null) {
                            sb.append(monitor.getClassName().length());
                            sb.append(DELIMITER);
                            sb.append(monitor.getClassName());
                            sb.append(monitor.getIdentityHashCode());
                            sb.append(DELIMITER);
                            sb.append(monitor.getLockedStackDepth());
                            sb.append(DELIMITER);
                            continue;
                        }
                        --ownedMonitors;
                    }
                    monitorNames = sb.toString();
                    LockInfo[] locks = info.getLockedSynchronizers();
                    ownedLockSynchronizers = locks.length;
                    sb = new StringBuffer();
                    for (LockInfo lock : locks) {
                        sb.append(lock.getClassName().length());
                        sb.append(DELIMITER);
                        sb.append(lock.getClassName());
                        sb.append(lock.getIdentityHashCode());
                        sb.append(DELIMITER);
                    }
                    lockSynchronizers = sb.toString();
                }
                catch (NoSuchMethodError e) {
                    // empty catch block
                }
                String contendedMonitor = EMPTY_STRING;
                contendedMonitor = info.getLockName();
                if (contendedMonitor == null) {
                    contendedMonitor = EMPTY_STRING;
                }
                String stackInfo = EMPTY_STRING;
                int stackElements = 0;
                StackTraceElement[] stack = info.getStackTrace();
                StringBuffer buf = new StringBuffer();
                for (StackTraceElement element : stack) {
                    String className = element.getClassName();
                    String fileName = element.getFileName();
                    if (fileName == null) {
                        fileName = EMPTY_STRING;
                    }
                    String methodName = element.getMethodName();
                    int lineNumber = element.getLineNumber();
                    buf.append(className.length()).append(DELIMITER).append(className).append(methodName.length()).append(DELIMITER).append(methodName).append(fileName.length()).append(DELIMITER).append(fileName).append(lineNumber).append(DELIMITER);
                    ++stackElements;
                }
                stackInfo = buf.toString();
                totalElements = 6 + ownedMonitors * 2 + 1 + stackElements * 2 + 1;
                buffer.append(START_THREAD_REPORT);
                buffer.append(REPORT_VERSION);
                buffer.append(DELIMITER).append(timestamp);
                buffer.append(DELIMITER).append(threadIDs.length);
                buffer.append(DELIMITER).append(totalElements);
                buffer.append(DELIMITER).append(name.length());
                buffer.append(DELIMITER);
                buffer.append(name);
                buffer.append(state.toString().length());
                buffer.append(DELIMITER);
                buffer.append(state.toString());
                buffer.append(stackElements);
                buffer.append(DELIMITER);
                if (stackElements > 0) {
                    buffer.append(stackInfo);
                }
                buffer.append(ownedMonitors);
                buffer.append(DELIMITER);
                if (ownedMonitors > 0) {
                    buffer.append(monitorNames);
                }
                buffer.append(ownedLockSynchronizers);
                buffer.append(DELIMITER);
                if (ownedLockSynchronizers > 0) {
                    buffer.append(lockSynchronizers);
                }
                buffer.append(contendedMonitor.length());
                buffer.append(DELIMITER);
                buffer.append(contendedMonitor);
                buffer.append(NEW_LINE);
            }
            threads = buffer.toString();
            report = threads != null ? threads : EMPTY_STRING;
        } else {
            report = EMPTY_STRING;
        }
        return report;
    }

    @Override
    public byte[] getJMXData() {
        try {
            return this.getThreadReport().getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            return this.getThreadReport().getBytes();
        }
    }

    @Override
    public void resetData() {
    }

    @Override
    public void modify(String command, String ... params) {
        block7: {
            block8: {
                block6: {
                    if (!command.toLowerCase().equals("on")) break block6;
                    if (params == null) break block7;
                    for (String param : params) {
                        if (!CAPABILITY_THREAD_SUBSYSTEM.equals(param) || this.dataProviderActive && this.enablementManager.isEnabled(param)) continue;
                        this.providerInitialisation();
                        this.dataProviderActive = true;
                        this.enablementManager.enable(param);
                    }
                    break block7;
                }
                if (!command.toLowerCase().equals("off")) break block8;
                if (params == null) break block7;
                for (String param : params) {
                    if (!CAPABILITY_THREAD_SUBSYSTEM.equals(param)) continue;
                    this.enablementManager.disable(param);
                }
                break block7;
            }
            if (command.equalsIgnoreCase(SET_STACK_DEPTH) && params != null) {
                for (String param : params) {
                    try {
                        int depth;
                        stackDepth = depth = new Integer(param).intValue();
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private int getStackDepth() {
        return stackDepth;
    }

    private void providerInitialisation() {
        this.threadBean = ManagementFactory.getThreadMXBean();
        try {
            this.isObjectMonitorUsageSupported = this.threadBean.isObjectMonitorUsageSupported();
            this.isSynchronizerUsageSupported = this.threadBean.isSynchronizerUsageSupported();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    @Override
    public void restartProvider() {
    }

    @Override
    public void headlessFileInitialise() {
    }
}

