/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.agent.dataproviders.memory;

import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.DataCollectionLevel;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.DataProvider;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.DataProviderConstants;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.capabilities.EnablementManager;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.HealthCenter;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.HealthCenterOptionHandler;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryDataProvider
implements DataProvider,
DataProviderConstants {
    public static final String CAPABILITY_MEMORY_SUBSYSTEM = "memory_subsystem";
    private static final String VERSION = "1.0";
    private static String PARSERTIME = "5";
    private static final String COMMA = ",";
    private static final String EQUALS = "=";
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final String EMPTY_REPORT = "";
    protected final HealthCenterOptionHandler handler;
    private boolean dataProviderActive = false;
    static EnablementManager enablementManager = new EnablementManager("MemorySource", null);

    private native long getProcessPhysicalMemorySizeImpl();

    private native long getProcessPrivateMemorySizeImpl();

    private native long getProcessVirtualMemorySizeImpl();

    private native long getFreePhysicalMemorySizeImpl();

    private long getPhysicalMemorySizeImpl() {
        Class[] noparams = new Class[]{};
        long result = -1L;
        if (!System.getProperty("java.vm.vendor").contains("IBM")) {
            try {
                Class<?> sunBeanClass = Class.forName("com.sun.management.OperatingSystemMXBean");
                OperatingSystemMXBean sunBean = ManagementFactory.getOperatingSystemMXBean();
                Method sunMethod = sunBeanClass.getDeclaredMethod("getTotalPhysicalMemorySize", noparams);
                Long sunResult = (Long)sunMethod.invoke((Object)sunBean, (Object[])null);
                if (sunResult != null) {
                    result = sunResult;
                }
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        } else if (System.getProperty("java.vm.vendor").contains("IBM")) {
            try {
                Class<?> ibmBeanClass = Class.forName("com.ibm.lang.management.OperatingSystemMXBean");
                OperatingSystemMXBean ibmBean = ManagementFactory.getOperatingSystemMXBean();
                Method ibmMethod = ibmBeanClass.getDeclaredMethod("getTotalPhysicalMemory", noparams);
                Long ibmResult = (Long)ibmMethod.invoke((Object)ibmBean, (Object[])null);
                if (ibmResult != null) {
                    result = ibmResult;
                }
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
        return result;
    }

    public MemoryDataProvider(HealthCenterOptionHandler handler) {
        this.handler = handler;
        DataCollectionLevel level = handler.getDataCollectionLevel();
        enablementManager.setLevel(handler.getDataCollectionLevel());
        if (level.ordinal() > DataCollectionLevel.OFF.ordinal()) {
            this.providerInitialisation();
            this.dataProviderActive = true;
        }
    }

    @Override
    public synchronized void startSession() {
        if (!this.dataProviderActive) {
            enablementManager.setLevel(DataCollectionLevel.FULL);
            if (enablementManager.isEnabled(CAPABILITY_MEMORY_SUBSYSTEM)) {
                this.providerInitialisation();
                this.dataProviderActive = true;
            }
        }
    }

    @Override
    public boolean isDataSupported() {
        boolean available = true;
        String osName = System.getProperty("os.name");
        if ("i5/OS".equals(osName) || "OS/400".equals(osName)) {
            available = false;
        }
        return available;
    }

    private String getMemoryInformation() {
        String memoryReport = null;
        if (enablementManager.isEnabled(CAPABILITY_MEMORY_SUBSYSTEM)) {
            try {
                memoryReport = "physicalmemory=" + this.getProcessPhysicalMemorySizeImpl() + COMMA + "privatememory" + EQUALS + this.getProcessPrivateMemorySizeImpl() + COMMA + "virtualmemory" + EQUALS + this.getProcessVirtualMemorySizeImpl() + COMMA + "freephysicalmemory" + EQUALS + this.getFreePhysicalMemorySizeImpl() + COMMA + "totalphysicalmemory" + EQUALS + this.getPhysicalMemorySizeImpl();
            }
            catch (UnsatisfiedLinkError e) {
                System.err.println(e.getLocalizedMessage());
            }
        } else {
            memoryReport = EMPTY_REPORT;
        }
        memoryReport = "MemorySource," + System.currentTimeMillis() + COMMA + memoryReport + NEW_LINE;
        if (HealthCenter.isDebug) {
            System.out.println("memoryReport is " + memoryReport);
        }
        return memoryReport;
    }

    @Override
    public byte[] getJMXData() {
        if (HealthCenter.isDebug) {
            System.out.println("returning getMemoryInformation");
        }
        try {
            return this.getMemoryInformation().getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            return this.getMemoryInformation().getBytes();
        }
    }

    @Override
    public void resetData() {
    }

    @Override
    public void modify(String command, String ... params) {
        block2: {
            block3: {
                if (params == null) break block2;
                if (!command.toLowerCase().equals("on")) break block3;
                for (String param : params) {
                    enablementManager.enable(param);
                }
                break block2;
            }
            if (!command.toLowerCase().equals("off")) break block2;
            for (String param : params) {
                enablementManager.disable(param);
            }
        }
    }

    private void providerInitialisation() {
    }

    @Override
    public Map<String, String> getLiveSourceDetails() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", "MemorySource");
        map.put("version", VERSION);
        map.put("state", enablementManager.getEnablementString());
        map.put("suggested_update_frequency", PARSERTIME);
        map.put("max_bytes_to_send", Integer.toString(-1));
        return map;
    }

    @Override
    public void restartProvider() {
    }

    @Override
    public void headlessFileInitialise() {
    }
}

