/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.agent.dataproviders.memory;

import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.DataCollectionLevel;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.DataProvider;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.DataProviderConstants;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.ProviderModificationException;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.capabilities.EnablementManager;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.memory.MemoryDataProvider;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.AgentLogFactory;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.HealthCenter;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.HealthCenterOptionHandler;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryCounterDataProvider
implements DataProvider,
DataProviderConstants {
    protected final HealthCenterOptionHandler handler;
    private EnablementManager enablementManager;
    private boolean dataProviderActive = false;
    private static final String VERSION = "1.0";
    private static String PARSERTIME = "5";
    private Logger logger = AgentLogFactory.setUpLogging(this.getClass());
    public static final String CAPABILITY_MEMORY_SUBSYSTEM = "memory_subsystem";
    private static final String NEW_LINE = "\n";

    private native String getMemoryCounters();

    private static native boolean isSupported();

    public MemoryCounterDataProvider(HealthCenterOptionHandler handler) {
        this.handler = handler;
        DataCollectionLevel level = handler.getDataCollectionLevel();
        this.enablementManager = new EnablementManager("MemoryCountersSource", handler.getDataCollectionLevel());
        if (level.ordinal() > DataCollectionLevel.OFF.ordinal()) {
            this.dataProviderActive = true;
        }
    }

    @Override
    public byte[] getJMXData() {
        String finalMemoryCounters;
        if (HealthCenter.isDebug) {
            System.out.println("returning getMemoryCounters");
        }
        if (MemoryDataProvider.enablementManager.isEnabled(CAPABILITY_MEMORY_SUBSYSTEM)) {
            Calendar now = Calendar.getInstance();
            String time = "time stamp=" + Long.toString(now.getTimeInMillis());
            String memoryCounters = this.getMemoryCounters();
            finalMemoryCounters = "smc\n" + time + NEW_LINE + memoryCounters + "emc" + NEW_LINE;
        } else {
            finalMemoryCounters = "";
        }
        try {
            return finalMemoryCounters.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            return finalMemoryCounters.getBytes();
        }
    }

    @Override
    public Map<String, String> getLiveSourceDetails() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", "MemoryCountersSource");
        map.put("version", VERSION);
        map.put("state", this.enablementManager.getEnablementString());
        map.put("suggested_update_frequency", PARSERTIME);
        map.put("max_bytes_to_send", Integer.toString(-1));
        return map;
    }

    @Override
    public boolean isDataSupported() {
        boolean isSupported = false;
        try {
            isSupported = MemoryCounterDataProvider.isSupported();
        }
        catch (UnsatisfiedLinkError e) {
            this.logger.fine(e.toString());
        }
        return isSupported;
    }

    @Override
    public void modify(String command, String ... params) throws ProviderModificationException {
        block2: {
            block3: {
                if (params == null) break block2;
                if (!command.toLowerCase().equals("on")) break block3;
                for (String param : params) {
                    this.enablementManager.enable(param);
                }
                break block2;
            }
            if (!command.toLowerCase().equals("off")) break block2;
            for (String param : params) {
                this.enablementManager.disable(param);
            }
        }
    }

    @Override
    public void resetData() {
    }

    @Override
    public void restartProvider() {
    }

    @Override
    public void startSession() {
        if (!this.dataProviderActive) {
            this.enablementManager.setLevel(DataCollectionLevel.FULL);
            if (MemoryDataProvider.enablementManager.isEnabled(CAPABILITY_MEMORY_SUBSYSTEM)) {
                this.dataProviderActive = true;
            }
        }
    }

    @Override
    public void headlessFileInitialise() {
    }
}

