/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.agent.dataproviders.environment;

import com.ibm.java.diagnostics.healthcenter.agent.VmDump;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.DataCollectionLevel;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.DataProvider;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.DataProviderConstants;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.capabilities.EnablementManager;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.environment.UlimitChecker;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.AgentLogFactory;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.HealthCenter;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.HealthCenterOptionHandler;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.security.Security;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvironmentDataProvider
implements DataProvider,
DataProviderConstants {
    public static final String CAPABILITY_ULIMITS = "ulimits";
    public static final String CAPABILITY_GENERAL = "general_properties";
    public static final String CAPABILITY_SYSTEM_PROPERTIES = "system_properties";
    public static final String CAPABILITY_ENVIRONMENT_VARIABLES = "environment_variables";
    public static final String CAPABILITY_COMMAND_LINE = "command_line";
    public static final String CAPABILITY_ENVIRONMENT_SUBSYSTEM = "environment_subsystem";
    private static final String EQUALS = "=";
    private static final String HEAPDUMP = "heapdump";
    private static final String SYSDUMP = "systemdump";
    private static final String JAVADUMP = "javadump";
    private static final String TRUE = "true";
    private static final String cacheTTL = "networkaddress.cache.ttl";
    private static final String negativeCacheTTL = "networkaddress.cache.negative.ttl";
    private static final String[] securityProps = new String[]{"networkaddress.cache.ttl", "networkaddress.cache.negative.ttl"};
    public static final String ARGUMENT_SEPARATOR = "@@@";
    private static final String NEWLINE = "\n";
    private final Logger logger;
    private static String VERSION = "1.0";
    public static final String TAG = "EnvironmentSource";
    private static String PARSERTIME = "1200";
    private final int processId;
    protected final HealthCenterOptionHandler handler;
    private boolean dataProviderActive = false;
    private EnablementManager enablementManager;

    public EnvironmentDataProvider(int pid, HealthCenterOptionHandler handler) {
        this.handler = handler;
        this.enablementManager = new EnablementManager(TAG, handler.getDataCollectionLevel());
        DataCollectionLevel level = handler.getDataCollectionLevel();
        if (level.ordinal() > DataCollectionLevel.OFF.ordinal()) {
            this.providerInitialisation();
            this.dataProviderActive = true;
        }
        this.processId = pid;
        this.logger = AgentLogFactory.setUpLogging(this.getClass());
    }

    @Override
    public boolean isDataSupported() {
        return true;
    }

    @Override
    public byte[] getJMXData() {
        Properties properties = this.populateProperties();
        if (properties.size() > 0) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            PrintStream pSW = null;
            try {
                pSW = new PrintStream((OutputStream)out, true, "UTF8");
            }
            catch (UnsupportedEncodingException e1) {
                System.err.println(e1.toString());
                return new byte[0];
            }
            try {
                pSW.println("#EnvironmentSource");
                for (String string : properties.keySet()) {
                    String values = properties.getProperty(string);
                    pSW.println(string + EQUALS + values);
                }
                out.flush();
                return out.toByteArray();
            }
            catch (IOException e) {
                System.err.println(e.toString());
                return new byte[0];
            }
        }
        return new byte[0];
    }

    private Properties populateProperties() {
        Properties properties = new Properties();
        if (this.enablementManager.isEnabled(CAPABILITY_ENVIRONMENT_SUBSYSTEM)) {
            this.reportCommandLine(properties);
            this.reportLauncherProperties(properties);
            this.reportSystemProperties(properties);
            this.reportEnvironmentVariables(properties);
            this.reportSecurityProperties(properties);
            this.reportUlimit(properties);
            this.reportDumpOptions(properties);
        } else {
            properties.put(CAPABILITY_ENVIRONMENT_SUBSYSTEM, "disabled");
        }
        return properties;
    }

    private void reportSecurityProperties(Properties properties) {
        for (String prop : securityProps) {
            String result = Security.getProperty(prop);
            if (result == null) {
                result = "";
            }
            properties.put("security." + prop, result);
        }
    }

    private void reportUlimit(Properties properties) {
        new UlimitChecker().writeProperties(properties);
    }

    private void reportSystemProperties(Properties properties) {
        Properties systemProperties;
        int restarts = 0;
        boolean succeeded = false;
        while (!succeeded && restarts < 10) {
            systemProperties = System.getProperties();
            Iterator<Map.Entry<Object, Object>> entries = systemProperties.entrySet().iterator();
            try {
                while (entries.hasNext()) {
                    Map.Entry<Object, Object> entry = entries.next();
                    properties.put("system." + entry.getKey(), entry.getValue());
                }
                succeeded = true;
            }
            catch (ConcurrentModificationException e) {
                this.logger.fine(e.toString());
                ++restarts;
            }
        }
        if (!succeeded) {
            systemProperties = System.getProperties();
            Enumeration<Object> keys = systemProperties.keys();
            while (keys.hasMoreElements()) {
                try {
                    Object key = keys.nextElement();
                    properties.put("system." + key, systemProperties.get(key));
                }
                catch (NoSuchElementException e) {
                    this.logger.fine(e.toString());
                }
            }
            succeeded = true;
        }
    }

    private void reportEnvironmentVariables(Properties properties) {
        Map<String, String> variables = System.getenv();
        for (Map.Entry<String, String> entry : variables.entrySet()) {
            properties.put("environment." + entry.getKey(), entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportLauncherProperties(Properties properties) {
        File launcherProperties;
        this.reportAgentVersion(properties);
        properties.put("pid", String.valueOf(this.processId));
        properties.put("number.of.processors", String.valueOf(Runtime.getRuntime().availableProcessors()));
        properties.put("maximum.memory", String.valueOf(Runtime.getRuntime().maxMemory()));
        String javaHomeLocation = System.getProperty("java.home");
        File javaHome = new File(javaHomeLocation);
        File bin = new File(javaHome, "bin");
        if (bin.exists() && (launcherProperties = new File(bin, "launcher.properties")).exists()) {
            FileInputStream inStream = null;
            try {
                inStream = new FileInputStream(launcherProperties);
                Properties variables = new Properties();
                variables.load(inStream);
                for (Map.Entry<Object, Object> entry : variables.entrySet()) {
                    Object value = entry.getValue();
                    if (value == null) continue;
                    properties.put("launcher." + entry.getKey(), value);
                }
            }
            catch (IOException e) {
                this.logger.warning(e.toString());
            }
            finally {
                if (inStream != null) {
                    try {
                        ((InputStream)inStream).close();
                    }
                    catch (IOException e) {
                        this.logger.warning(e.toString());
                    }
                }
            }
        }
    }

    private void reportCommandLine(Properties properties) {
        List<String> arguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
        StringBuffer flattenedList = new StringBuffer();
        Iterator<String> it = arguments.iterator();
        while (it.hasNext()) {
            flattenedList.append(it.next());
            if (!it.hasNext()) continue;
            flattenedList.append(ARGUMENT_SEPARATOR);
        }
        properties.put("command.line.arguments", flattenedList.toString());
    }

    private void reportAgentVersion(Properties properties) {
        properties.put("jar.version", "2.2.1.20140513");
        String nativeVersion = HealthCenter.getLibraryVersion();
        if (nativeVersion != null) {
            properties.put("native.library.date", nativeVersion);
        }
    }

    private void reportDumpOptions(Properties properties) {
        String dumpOptions = VmDump.queryVmDumpOptions();
        if (dumpOptions != null) {
            String[] optionsArray = dumpOptions.split(NEWLINE);
            StringBuffer flattenedList = new StringBuffer();
            for (int i = 0; i < optionsArray.length; ++i) {
                if (i != 0) {
                    flattenedList.append(ARGUMENT_SEPARATOR);
                }
                flattenedList.append(optionsArray[i]);
            }
            properties.put("dump.options", flattenedList.toString());
        }
    }

    @Override
    public Map<String, String> getLiveSourceDetails() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", TAG);
        map.put("state", this.enablementManager.getEnablementString());
        map.put("version", VERSION);
        map.put("suggested_update_frequency", PARSERTIME);
        map.put("max_bytes_to_send", Integer.toString(-1));
        return map;
    }

    @Override
    public void resetData() {
    }

    @Override
    public synchronized void startSession() {
        if (!this.dataProviderActive) {
            this.enablementManager.setLevel(DataCollectionLevel.FULL);
            this.providerInitialisation();
            this.dataProviderActive = true;
        }
    }

    @Override
    public void modify(String command, String ... params) {
        block11: {
            block13: {
                block12: {
                    if (params == null) break block11;
                    if (!command.toLowerCase().equals("on")) break block12;
                    for (String param : params) {
                        this.enablementManager.enable(param);
                    }
                    break block11;
                }
                if (!command.toLowerCase().equals("off")) break block13;
                for (String param : params) {
                    this.enablementManager.disable(param);
                }
                break block11;
            }
            if (!command.toLowerCase().equals("set") || params == null) break block11;
            for (String param : params) {
                Method dumpMethod;
                Class<?> dumpClass;
                Class[] noparams;
                String[] keyValuePair = param.split(EQUALS, 2);
                if (keyValuePair.length != 2) continue;
                if (keyValuePair[0].equals(HEAPDUMP) && keyValuePair[1].equals(TRUE)) {
                    if (!System.getProperty("java.vm.vendor").contains("IBM")) continue;
                    try {
                        noparams = new Class[]{};
                        dumpClass = Class.forName("com.ibm.jvm.Dump");
                        dumpMethod = dumpClass.getDeclaredMethod("HeapDump", noparams);
                        dumpMethod.invoke(null, (Object[])null);
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                    }
                    continue;
                }
                if (keyValuePair[0].equals(SYSDUMP) && keyValuePair[1].equals(TRUE)) {
                    if (!System.getProperty("java.vm.vendor").contains("IBM")) continue;
                    try {
                        noparams = new Class[]{};
                        dumpClass = Class.forName("com.ibm.jvm.Dump");
                        dumpMethod = dumpClass.getDeclaredMethod("SystemDump", noparams);
                        dumpMethod.invoke(null, (Object[])null);
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                    }
                    continue;
                }
                if (!keyValuePair[0].equals(JAVADUMP) || !keyValuePair[1].equals(TRUE) || !System.getProperty("java.vm.vendor").contains("IBM")) continue;
                try {
                    noparams = new Class[]{};
                    dumpClass = Class.forName("com.ibm.jvm.Dump");
                    dumpMethod = dumpClass.getDeclaredMethod("JavaDump", noparams);
                    dumpMethod.invoke(null, (Object[])null);
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
            }
        }
    }

    private void providerInitialisation() {
    }

    @Override
    public void restartProvider() {
    }

    @Override
    public void headlessFileInitialise() {
    }
}

