/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.agent.dataproviders.cpu;

import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.DataCollectionLevel;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.DataProvider;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.DataProviderConstants;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.Util;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.capabilities.EnablementManager;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.HealthCenterOptionHandler;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CpuDataProvider
implements DataProvider,
DataProviderConstants {
    public static final String CAPABILITY_CPU_SUBSYSTEM = "cpu_subsystem";
    private static final String EMPTY_STRING = "";
    private static final String NEWLINE = System.getProperty("line.separator");
    private static String VERSION = "1.0";
    public static final String TAG = "CpuSource";
    private static final String DELIMITER = "@#";
    private static final String EYECATCHER = "startCPU";
    private String parsertime = "2";
    private boolean hasMethods = true;
    private Object osBean = null;
    protected final HealthCenterOptionHandler handler;
    private boolean dataProviderActive = false;
    private EnablementManager enablementManager;

    public CpuDataProvider(HealthCenterOptionHandler handler) {
        this.handler = handler;
        this.enablementManager = new EnablementManager(TAG, handler.getDataCollectionLevel());
        DataCollectionLevel level = handler.getDataCollectionLevel();
        if (level.ordinal() > DataCollectionLevel.OFF.ordinal()) {
            this.providerInitialisation();
            this.dataProviderActive = true;
        }
    }

    @Override
    public synchronized void startSession() {
        if (!this.dataProviderActive) {
            this.enablementManager.setLevel(DataCollectionLevel.FULL);
            if (this.enablementManager.isEnabled(CAPABILITY_CPU_SUBSYSTEM)) {
                this.providerInitialisation();
                this.dataProviderActive = true;
            }
        }
    }

    @Override
    public boolean isDataSupported() {
        return true;
    }

    @Override
    public Map<String, String> getLiveSourceDetails() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", TAG);
        map.put("version", VERSION);
        map.put("state", this.enablementManager.getEnablementString());
        map.put("suggested_update_frequency", this.parsertime);
        map.put("max_bytes_to_send", Integer.toString(-1));
        return map;
    }

    private String getCpuReport() {
        String report = EMPTY_STRING;
        if (this.enablementManager.isEnabled(CAPABILITY_CPU_SUBSYSTEM) && !Util.isZOS() && this.hasMethods) {
            Double processCPULoad = new Double(-1.0);
            Double systemCPULoad = new Double(-1.0);
            this.osBean = ManagementFactory.getOperatingSystemMXBean();
            try {
                Class<?> myClass = this.osBean.getClass();
                Method myMethod = null;
                try {
                    myMethod = myClass.getMethod("getProcessCpuLoad", new Class[0]);
                    myMethod.setAccessible(true);
                    if (myMethod != null) {
                        processCPULoad = (Double)myMethod.invoke(this.osBean, new Object[0]);
                    }
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
                try {
                    myMethod = myClass.getMethod("getSystemCpuLoad", new Class[0]);
                    myMethod.setAccessible(true);
                    if (myMethod != null) {
                        systemCPULoad = (Double)myMethod.invoke(this.osBean, new Object[0]);
                    }
                }
                catch (NoSuchMethodException e) {
                    this.hasMethods = false;
                }
                if (processCPULoad == -1.0 && systemCPULoad == -1.0) {
                    return report;
                }
                report = "startCPU@#" + System.currentTimeMillis() + DELIMITER + processCPULoad.toString() + DELIMITER + systemCPULoad.toString() + NEWLINE;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof UnsatisfiedLinkError) {
                    this.hasMethods = false;
                } else {
                    e.printStackTrace();
                }
            }
            catch (UnsatisfiedLinkError e) {
                // empty catch block
            }
        }
        return report;
    }

    @Override
    public byte[] getJMXData() {
        try {
            return this.getCpuReport().getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            return this.getCpuReport().getBytes();
        }
    }

    @Override
    public void resetData() {
    }

    @Override
    public void modify(String command, String ... params) {
        block4: {
            block3: {
                if (!command.toLowerCase().equals("on")) break block3;
                if (params == null) break block4;
                for (String param : params) {
                    if (!CAPABILITY_CPU_SUBSYSTEM.equals(param) || this.dataProviderActive && this.enablementManager.isEnabled(param)) continue;
                    this.providerInitialisation();
                    this.dataProviderActive = true;
                    this.enablementManager.enable(param);
                }
                break block4;
            }
            if (command.toLowerCase().equals("off") && params != null) {
                for (String param : params) {
                    if (!CAPABILITY_CPU_SUBSYSTEM.equals(param)) continue;
                    this.enablementManager.disable(param);
                }
            }
        }
    }

    private void providerInitialisation() {
        if (!System.getProperty("java.vm.vendor").contains("IBM")) {
            try {
                Class<?> myClass = Class.forName("com.sun.management.OperatingSystemMXBean");
                this.osBean = ManagementFactory.getOperatingSystemMXBean();
            }
            catch (ClassNotFoundException e) {}
        } else if (System.getProperty("java.vm.vendor").contains("IBM")) {
            try {
                Class<?> myClass = Class.forName("com.ibm.lang.management.OperatingSystemMXBean");
                this.osBean = ManagementFactory.getOperatingSystemMXBean();
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    @Override
    public void restartProvider() {
    }

    @Override
    public void headlessFileInitialise() {
    }
}

