/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.agent.dataproviders.classhistogram;

import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.DataCollectionLevel;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.DataProvider;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.DataProviderConstants;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.capabilities.EnablementManager;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.HealthCenter;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.HealthCenterOptionHandler;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassHistogramProvider
implements DataProvider,
DataProviderConstants {
    public static final String CAPABILITY_CLASSHISTOGRAM_SUBSYSTEM = "classhistogram_subsystem";
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final String REPORT_TIME_EYECATCHER = "reportTime,";
    private static final String HISTOGRAM_REPORT = "classhistogramreport,";
    private static final String REPORT_COMPLETE = "reportcomplete";
    private static String VERSION = "1.0";
    public static final String TAG = "ClassHistogramSource";
    private static String PARSERTIME = Integer.toString(Integer.MAX_VALUE);
    protected final HealthCenterOptionHandler handler;
    private boolean dataProviderActive = false;
    private EnablementManager enablementManager;
    private static Object nativeCallLock = new Object();

    public ClassHistogramProvider(HealthCenterOptionHandler handler) {
        this.handler = handler;
        DataCollectionLevel level = handler.getDataCollectionLevel();
        this.enablementManager = new EnablementManager(TAG, handler.getDataCollectionLevel());
        if (level.ordinal() > DataCollectionLevel.OFF.ordinal()) {
            this.providerInitialisation();
            this.dataProviderActive = true;
        }
    }

    @Override
    public synchronized void startSession() {
        if (!this.dataProviderActive) {
            this.enablementManager.setLevel(DataCollectionLevel.FULL);
            if (this.enablementManager.isEnabled(CAPABILITY_CLASSHISTOGRAM_SUBSYSTEM)) {
                this.providerInitialisation();
                this.dataProviderActive = true;
            }
        }
    }

    @Override
    public boolean isDataSupported() {
        return true;
    }

    @Override
    public Map<String, String> getLiveSourceDetails() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", TAG);
        map.put("version", VERSION);
        map.put("state", this.enablementManager.getEnablementString());
        map.put("suggested_update_frequency", PARSERTIME);
        map.put("max_bytes_to_send", Integer.toString(-1));
        return map;
    }

    private native String getClassHistogram();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getClassHistogramReport() {
        String chReport;
        if (this.enablementManager.isEnabled(CAPABILITY_CLASSHISTOGRAM_SUBSYSTEM)) {
            Object object = nativeCallLock;
            synchronized (object) {
                chReport = this.getClassHistogram();
            }
        } else {
            chReport = REPORT_COMPLETE;
        }
        return "classhistogramreport,reportTime," + System.currentTimeMillis() + NEWLINE + chReport;
    }

    @Override
    public byte[] getJMXData() {
        if (HealthCenter.isDebug) {
            System.out.println("returning getClassHistogram");
        }
        try {
            return this.getClassHistogramReport().getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            return this.getClassHistogramReport().getBytes();
        }
    }

    @Override
    public void resetData() {
    }

    @Override
    public void modify(String command, String ... params) {
    }

    private void providerInitialisation() {
    }

    @Override
    public void restartProvider() {
    }

    @Override
    public void headlessFileInitialise() {
    }
}

