/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.agent.dataproviders.capabilities;

import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.DataCollectionLevel;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.capabilities.Messages;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.AgentLogFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnablementManager {
    private static final String NEWLINE = "\n";
    private static final String EQUALS = "=";
    private static final String LOW_SUFFIX = ".low";
    private static final Logger TRACE = AgentLogFactory.setUpLogging(EnablementManager.class);
    private Map<String, String> properties = new LinkedHashMap<String, String>();
    private DataCollectionLevel level;
    private String tag = null;

    public EnablementManager(String tag, DataCollectionLevel level) {
        this.level = level;
        this.tag = tag;
        this.loadConfigurations(level, tag);
    }

    private void loadConfigurations(DataCollectionLevel level, String tag) {
        this.loadConfiguration(tag);
        if (DataCollectionLevel.LOW == level) {
            this.loadConfiguration(tag + LOW_SUFFIX);
        }
    }

    public void setLevel(DataCollectionLevel level) {
        this.level = level;
        this.properties.clear();
        this.loadConfiguration(this.tag);
        if (DataCollectionLevel.LOW == level) {
            this.loadConfiguration(this.tag + LOW_SUFFIX);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfiguration(String tag) {
        InputStream inStream = null;
        String name = tag + "Configuration.properties";
        try {
            BufferedReader reader;
            SearchOrder order = SearchOrder.LOCAL_DIR;
            while (order != SearchOrder.ABORT && inStream == null) {
                switch (order) {
                    case LOCAL_DIR: {
                        File cwdFile = new File(name);
                        if (cwdFile.exists() && cwdFile.canRead()) {
                            inStream = new FileInputStream(cwdFile);
                            break;
                        }
                        order = SearchOrder.SYS_PROP;
                        break;
                    }
                    case SYS_PROP: {
                        String value = System.getProperty("com.ibm.java.diagnostics.healthcenter.config");
                        if (value != null) {
                            File configHome = new File(value);
                            File configFile = new File(configHome, name);
                            if (configFile.exists() && configFile.canRead()) {
                                inStream = new FileInputStream(configFile);
                                String message = Messages.getString("EnablementManager.config.file.override");
                                String formatted = MessageFormat.format(message, configFile.getAbsolutePath());
                                TRACE.info(formatted);
                                break;
                            }
                            order = SearchOrder.CLASSPATH;
                            break;
                        }
                        order = SearchOrder.CLASSPATH;
                        break;
                    }
                    case CLASSPATH: {
                        File javaHome = new File(System.getProperty("java.home"));
                        File javaHomeFile = new File(javaHome, name);
                        inStream = javaHomeFile.exists() && javaHomeFile.canRead() ? new FileInputStream(javaHomeFile) : EnablementManager.class.getResourceAsStream(name);
                        order = SearchOrder.ABORT;
                        break;
                    }
                    case ABORT: {
                        inStream = null;
                    }
                }
            }
            if (inStream != null && inStream.available() > 0 && !this.loadStream(reader = new BufferedReader(new InputStreamReader(inStream)))) {
                reader = new BufferedReader(new InputStreamReader(inStream, "UTF8"));
                this.loadStream(reader);
            }
        }
        catch (IOException e) {
            String message = Messages.getString("EnablementManager.could.not.find.config.file");
            String formatted = MessageFormat.format(message, name);
            TRACE.warning(formatted);
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    TRACE.warning(e.toString());
                }
            }
        }
    }

    private boolean loadStream(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        boolean errorInLine = false;
        while (line != null) {
            if (line.length() > 0 && !line.startsWith("#")) {
                String[] bits = line.split(EQUALS);
                if (bits.length == 2) {
                    if (this.level == DataCollectionLevel.OFF) {
                        this.properties.put(bits[0].trim(), DataCollectionLevel.OFF.name());
                    } else {
                        this.properties.put(bits[0].trim(), bits[1].trim());
                    }
                } else {
                    errorInLine = true;
                    TRACE.fine(MessageFormat.format(Messages.getString("EnablementManager.could.not.parse.line"), line));
                }
            }
            line = reader.readLine();
        }
        return errorInLine;
    }

    public boolean isEnabled(String name) {
        return "on".equals(this.properties.get(name));
    }

    public void enable(String name) {
        this.properties.put(name, "on");
    }

    public void disable(String name) {
        this.properties.put(name, "off");
    }

    public Set<Map.Entry<String, String>> getAllEntries() {
        return new HashSet<Map.Entry<String, String>>(this.properties.entrySet());
    }

    public void addOverrides(String sourceName) {
        this.loadConfigurations(this.level, sourceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEnablementString() {
        StringBuffer string = new StringBuffer();
        EnablementManager enablementManager = this;
        synchronized (enablementManager) {
            for (Map.Entry<String, String> entry : this.properties.entrySet()) {
                string.append(entry.getKey());
                string.append(EQUALS);
                string.append(entry.getValue());
                string.append(NEWLINE);
            }
        }
        return string.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum SearchOrder {
        LOCAL_DIR,
        SYS_PROP,
        CLASSPATH,
        ABORT;

    }
}

