/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.agent.dataproviders;

import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.DataCollectionLevel;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.Messages;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.ProviderModificationException;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.TraceDataProvider;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.Util;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.AgentInfo;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.HealthCenter;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.HealthCenterOptionHandler;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.TraceCommandParser;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TraceFileDataProvider
extends TraceDataProvider {
    private static String TRACESOURCE_SCOOPING_VERSION = "1.0";
    private static final String TAG = "TRACEFileSource";
    private File traceFileToRead;
    private long bytesRead = 0L;

    public TraceFileDataProvider(int pid, HealthCenterOptionHandler handler, AgentInfo info) {
        super(pid, handler, info);
    }

    @Override
    public boolean isDataSupported() {
        boolean available = false;
        File traceFile = this.getTraceFileToRead();
        if (traceFile != null) {
            available = true;
        } else if (HealthCenter.isDebug) {
            System.out.println(Messages.getString("TraceDataProvider.trace.file.not.available"));
        }
        return available;
    }

    protected File getTraceFileToRead() {
        String[] vmargs;
        if (this.traceFileToRead == null && (vmargs = this.handler.getVMArgs()) != null) {
            this.traceFileToRead = TraceCommandParser.getTraceOutputFile(vmargs, this._processID);
        }
        return this.traceFileToRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized byte[] getJMXData() {
        byte[] bufferToReturn;
        int cachedHeaderCorrection = 0;
        File traceFile = this.getTraceFileToRead();
        if (traceFile != null) {
            byte[] buf = new byte[]{};
            try {
                long fileSize = traceFile.length();
                if (HealthCenter.isDebug) {
                    System.out.println(MessageFormat.format("File size of trace file is {0}", fileSize));
                }
                long bytesAvailableToSend = fileSize - this.bytesRead;
                int _numBytesToTransmit = (int)Math.min(bytesAvailableToSend, (long)this.maxSendBytes);
                if (HealthCenter.isDebug) {
                    System.out.println(MessageFormat.format("Max bytes to send: {0} , sending back: {1} bytes", this.maxSendBytes, _numBytesToTransmit));
                }
                buf = new byte[_numBytesToTransmit];
                FileInputStream in = new FileInputStream(traceFile);
                BufferedInputStream bin = new BufferedInputStream(in);
                try {
                    long bytesActuallySkipped = bin.skip(this.bytesRead);
                    if (HealthCenter.isDebug) {
                        System.out.println(MessageFormat.format("_numBytesToTransmit is {0}", _numBytesToTransmit));
                        if (bytesActuallySkipped != this.bytesRead) {
                            System.out.println("Expected to skip " + this.bytesRead + " bytes but actually skipped " + bytesActuallySkipped + " bytes in " + traceFile.getAbsolutePath());
                        }
                    }
                    int bytesActuallyRead = bin.read(buf, 0, _numBytesToTransmit);
                    if (HealthCenter.isDebug && bytesActuallyRead != _numBytesToTransmit) {
                        System.out.println("Expected to read " + _numBytesToTransmit + " but actually read " + bytesActuallyRead + " bytes in " + traceFile.getAbsolutePath());
                    }
                }
                finally {
                    bin.close();
                    in.close();
                }
                if (this.traceFileHeader == null) {
                    if (buf.length > 0) {
                        this.initialiseTraceFileHeader(buf);
                        this.maxSendBytes = this.maxSendBytes / this.traceBufferSize * this.traceBufferSize;
                    }
                } else if (this.needTraceHeader) {
                    cachedHeaderCorrection = this.sizeOfHeader;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            if (this.needTraceHeader) {
                if (this.traceFileHeader != null) {
                    this.needTraceHeader = false;
                    int numberOfCompleteBuffers = buf != null ? (buf.length - this.sizeOfHeader) / this.traceBufferSize : 0;
                    int sizeToSendBack = numberOfCompleteBuffers * this.traceBufferSize + this.sizeOfHeader;
                    bufferToReturn = new byte[sizeToSendBack];
                    if (cachedHeaderCorrection > 0) {
                        System.arraycopy(this.traceFileHeader, 0, bufferToReturn, 0, this.sizeOfHeader);
                        System.arraycopy(buf, 0, bufferToReturn, this.sizeOfHeader, numberOfCompleteBuffers * this.traceBufferSize);
                    } else {
                        System.arraycopy(buf, 0, bufferToReturn, 0, sizeToSendBack);
                    }
                } else {
                    bufferToReturn = new byte[]{};
                }
            } else {
                int numberOfCompleteBuffers = buf.length / this.traceBufferSize;
                int sizeToSendBack = numberOfCompleteBuffers * this.traceBufferSize;
                if (sizeToSendBack != buf.length) {
                    bufferToReturn = new byte[sizeToSendBack];
                    System.arraycopy(buf, 0, bufferToReturn, 0, sizeToSendBack);
                } else {
                    bufferToReturn = buf;
                }
            }
        } else {
            bufferToReturn = new byte[]{};
        }
        this.bytesRead += (long)(bufferToReturn.length - cachedHeaderCorrection);
        return bufferToReturn;
    }

    @Override
    protected void enableGCTracePoint(String tracePoint) throws ProviderModificationException {
        this.enableNormalTracePoint(tracePoint);
    }

    @Override
    protected void disableGCTracePoint(String tracePoint) throws ProviderModificationException {
        this.disableNormalTracePoint(tracePoint);
    }

    @Override
    protected boolean setNoDynamicProperties(HealthCenterOptionHandler handler) {
        int rc = 0;
        boolean nodynamic = false;
        if (Util.isRealTimeVM() && !handler.isDynamicOverride()) {
            try {
                Class[] paramString = new Class[]{String.class};
                Class<?> traceClass = Class.forName("com.ibm.jvm.Trace");
                Constructor<?> traceConstruct = traceClass.getDeclaredConstructors()[0];
                traceConstruct.setAccessible(true);
                Object traceObj = traceConstruct.newInstance(new Object[0]);
                Method traceMethod = traceClass.getDeclaredMethod("set", paramString);
                rc = (Integer)traceMethod.invoke(traceObj, "buffers=nodynamic");
                if (rc != 0) {
                    if (HealthCenter.isDebug) {
                        System.out.println(MessageFormat.format("failed to set buffers=nodynamic (rc={0})", rc));
                    }
                } else {
                    nodynamic = true;
                }
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
        return nodynamic;
    }

    @Override
    public Map<String, String> getLiveSourceDetails() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", this.getSourceName());
        map.put("version", TRACESOURCE_SCOOPING_VERSION);
        map.put("suggested_update_frequency", "5");
        map.put("state", this.getEnabledTracePointsString());
        if (this.traceFileHeader != null) {
            map.put("max_bytes_to_send", Integer.toString(this.maxSendBytes));
        } else {
            map.put("max_bytes_to_send", Integer.toString(10));
        }
        map.put("size_of_header", Integer.toString(this.sizeOfHeader));
        map.put("complete_chunks_data", Boolean.TRUE.toString());
        return map;
    }

    @Override
    protected String getSourceName() {
        return TAG;
    }

    @Override
    protected void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void disableProviderSpecificTracePoints() {
        block9: {
            DataCollectionLevel level = this.handler.getDataCollectionLevel();
            if (level.ordinal() == DataCollectionLevel.OFF.ordinal() && this.handler.shouldDisableDefaultTrace()) {
                try {
                    TraceFileDataProvider traceFileDataProvider = this;
                    synchronized (traceFileDataProvider) {
                        int rc = 0;
                        try {
                            Class[] paramString = new Class[]{String.class};
                            Class<?> traceClass = Class.forName("com.ibm.jvm.Trace");
                            Constructor<?> traceConstruct = traceClass.getDeclaredConstructors()[0];
                            traceConstruct.setAccessible(true);
                            Object traceObj = traceConstruct.newInstance(new Object[0]);
                            Method traceMethod = traceClass.getDeclaredMethod("set", paramString);
                            rc = (Integer)traceMethod.invoke(traceObj, "maximal=none");
                            if (rc != 0) {
                                throw new ProviderModificationException(Messages.getString("TraceDataProvider.exception.disabling.default.trace"));
                            }
                        }
                        catch (Exception e) {
                            throw new ProviderModificationException(e);
                        }
                    }
                }
                catch (ProviderModificationException e) {
                    if (!HealthCenter.isDebug) break block9;
                    System.out.println(e);
                }
            }
        }
    }

    @Override
    public void restartProvider() {
    }

    @Override
    public void headlessFileInitialise() {
    }
}

