/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.agent.dataproviders;

import com.ibm.java.diagnostics.healthcenter.agent.VmDump;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.DataCollectionLevel;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.DataProvider;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.Messages;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.ProviderModificationException;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.Util;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.capabilities.EnablementManager;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.methoddictionary.MethodDictionaryDataProvider;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.AgentInfo;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.AgentLogFactory;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.HealthCenterOptionHandler;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.MessageFormat;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class TraceDataProvider
implements DataProvider {
    public static final String LOW_ALLOCATION_THRESHOLD = "lowallocationthreshold";
    public static final String HIGH_ALLOCATION_THRESHOLD = "highallocationthreshold";
    public static final String STACKTRACEDEPTH = "stacktracedepth";
    public static final String TRIGGER_STACK_TRACE_ON = "stacktrace.on";
    public static final String TRIGGER_STACK_TRACE_OFF = "stacktrace.off";
    public static final String STACK_TRACE_TRIGGER_SUFFIX = "_stacktrace.trigger";
    public static final String VERBOSE_GC = "verbose.gc";
    public static final String VERBOSE_GC_FILE_NAME = "verbosegc_";
    public static final String VERBOSE_GC_FILE_SUFFIX = ".log";
    public static final String VERBOSE_GC_FILE_NAME_INFO = "verbosegcfilename";
    public static final String VERBOSE_GC_AVAILABLE = "verbose.gc.available";
    public static final String ALLOCATION_SAMPLING_AVAILABLE = "allocation.sampling.available";
    public static final String ALLOCATION_THRESHOLD_AVAILABLE = "allocation.threshold.available";
    protected static final String CAPABILITY_CLASSES_SUBSYSTEM = "classes_subsystem";
    protected static final String CAPABILITY_GC_SUBSYSTEM = "gc_subsystem";
    protected static final String CAPABILITY_PROFILING_SUBSYSTEM = "profiling_subsystem";
    protected static final String CAPABILITY_IO_SUBSYSTEM = "io_subsystem";
    protected static final String CAPABILITY_JIT_SUBSYSTEM = "jit_subsystem";
    private static final String[] DUMP_POINTS = new String[]{"j9dmp.4", "j9dmp.7", "j9dmp.9", "j9dmp.10"};
    private static final String DATA_PROVIDER_PARENT_NAME = "TRACESource";
    private static final String J9JIT_18 = "j9jit.18";
    private static final String J9JIT_17 = "j9jit.17";
    private static final String J9JIT_16 = "j9jit.16";
    private static final String J9JIT_15 = "j9jit.15";
    protected static final String J9MM_DOT = "j9mm.";
    protected static final String J9DMP_DOT = "j9dmp.";
    private static final String MAXIMAL = "maximal";
    private static final String EXCEPTION = "exception";
    protected static final String PARSERTIME = "5";
    protected final Logger logger;
    protected int maxSendBytes = 100000;
    protected static final int BYTES_PER_LONG = 8;
    private static final int BIG_ENDIAN_SIG = 305419896;
    private static final int LITTLE_ENDIAN_SIG = 2018915346;
    private static final Pattern ENTRYEXIT_PATTERN = Pattern.compile("(j9.*)\\.entryexit");
    protected final HealthCenterOptionHandler handler;
    private boolean dataProviderActive = false;
    protected byte[] traceFileHeader = null;
    protected int traceBufferSize = 1;
    protected boolean needTraceHeader = true;
    protected int sizeOfHeader = 0;
    protected int _processID = 0;
    protected EnablementManager enablementManager;
    private boolean allocationThresholdInitialized = false;
    private boolean stackDepthSet = false;
    private AgentInfo agentInfo;
    protected static final String SET_ALLOCATION_THRESHOLD_TRACEPOINT = "j9mm.231";
    protected static final String ALLOCATION_THRESHOLD_TRACEPOINT = "j9mm.234";
    protected static final String OOL_ALLOCATION_TRACEPOINT = "j9mm.395";
    private static final String STACKDEPTH_COMMAND = "stackdepth=";
    private static final String EMPTY_STRING = "";
    private static final String EQUALS = "=";
    public static final Object AGENT_INFO_UPDATE = "agent.info.update";

    private static native boolean isVerboseGCSubscribtionAvailable();

    private static native boolean registerVerboseGCSubscriber(String var0);

    private static native boolean deregisterVerboseGCSubscriber();

    public TraceDataProvider(int pid, HealthCenterOptionHandler handler, AgentInfo info) {
        this.handler = handler;
        this._processID = pid;
        this.agentInfo = info;
        this.logger = AgentLogFactory.setUpLogging(this.getClass());
        DataCollectionLevel level = handler.getDataCollectionLevel();
        this.enablementManager = this.constructEnablementManager(level);
        if (level.ordinal() > DataCollectionLevel.OFF.ordinal()) {
            this.providerInitialisation(this.enablementManager);
            this.dataProviderActive = true;
        }
        this.setCapabilities();
    }

    private void setCapabilities() {
        try {
            if (TraceDataProvider.isVerboseGCSubscribtionAvailable()) {
                this.enablementManager.enable("capability.verbose.gc.available");
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
        if (this.gcTracepointAvailableInThisVM(395)) {
            this.enablementManager.enable("capability.allocation.sampling.available");
        }
        if (this.tracePointExistsInThisVM(ALLOCATION_THRESHOLD_TRACEPOINT)) {
            this.enablementManager.enable("capability.allocation.threshold.available");
        }
    }

    protected abstract void init();

    protected abstract void disableProviderSpecificTracePoints();

    private void initializeTracePoints(EnablementManager enablementManager) {
        this.setNoDynamicProperties(this.handler);
        for (Map.Entry<String, String> entry : enablementManager.getAllEntries()) {
            String verb = entry.getValue();
            String keyName = entry.getKey();
            if (keyName.endsWith(STACK_TRACE_TRIGGER_SUFFIX) || keyName.startsWith("capability.")) continue;
            try {
                this.modify(verb, keyName);
            }
            catch (ProviderModificationException e) {
                System.out.println(MessageFormat.format(Messages.getString("TraceDataProvider.could.not.disable"), keyName, e.toString()));
            }
        }
        this.disableProviderSpecificTracePoints();
        this.enableDumpTracePoints();
    }

    private void enableDumpTracePoints() {
        for (String point : DUMP_POINTS) {
            try {
                this.modify("on", point);
            }
            catch (ProviderModificationException e) {
                e.printStackTrace();
            }
        }
    }

    private EnablementManager constructEnablementManager(DataCollectionLevel level) {
        EnablementManager manager = new EnablementManager(DATA_PROVIDER_PARENT_NAME, level);
        manager.addOverrides(this.getSourceName());
        return manager;
    }

    protected abstract boolean setNoDynamicProperties(HealthCenterOptionHandler var1);

    private boolean jitTracepointAvailableInThisVM() {
        return Util.is27VMOrLater();
    }

    private boolean j9ShrTracePointAvailableInThisVM() {
        if (Util.getJavaLevel() == 5) {
            return false;
        }
        return Util.getJavaLevel() != 6 || Util.getServiceRefreshNumber() >= 8;
    }

    private boolean profilingTracepointAvailableInThisVM() {
        return Util.getJavaLevel() != 5 || Util.getServiceRefreshNumber() >= 8;
    }

    private boolean isDumpTPavailable(String tp) {
        if ("j9dmp.4".equals(tp)) {
            return true;
        }
        if ("j9dmp.7".equals(tp)) {
            return this.isDumpStartedTPAvailabledInVM();
        }
        if ("j9dmp.9".equals(tp) || "j9dmp.10".equals(tp)) {
            return Util.j9DmpTrcAvailable();
        }
        return false;
    }

    private boolean isDumpStartedTPAvailabledInVM() {
        if (Util.getJavaLevel() == 5 && Util.getServiceRefreshNumber() < 10) {
            return false;
        }
        return Util.getJavaLevel() != 6 || Util.getServiceRefreshNumber() >= 5;
    }

    private boolean JavaTracePointsAvailableInVM() {
        return Util.getJavaLevel() != 5 || Util.getServiceRefreshNumber() >= 10;
    }

    private boolean gcTracepointAvailableInThisVM(int tpNumber) {
        if (tpNumber <= 139 && tpNumber >= 131 ? Util.getJavaLevel() == 5 && Util.getServiceRefreshNumber() < 9 : (tpNumber == 383 || tpNumber == 384 || tpNumber == 395 || tpNumber >= 345 && tpNumber <= 348 || tpNumber >= 463 && tpNumber <= 475) && Util.getVMVersion() < 2.6f) {
            return false;
        }
        return tpNumber != 560 || Util.getJavaLevel() >= 7 && (Util.getJavaLevel() != 7 || Util.getServiceRefreshNumber() >= 4);
    }

    public synchronized void startSession() {
        if (!this.dataProviderActive) {
            this.enablementManager.setLevel(DataCollectionLevel.FULL);
            this.providerInitialisation(this.enablementManager);
            this.dataProviderActive = true;
        }
        this.needTraceHeader = true;
    }

    protected void initialiseTraceFileHeader(byte[] array) {
        int length = 0;
        try {
            ByteBuffer buffer = ByteBuffer.wrap(array);
            buffer.getInt();
            length = buffer.getInt();
            buffer.getInt();
            buffer.getInt();
            this.traceBufferSize = buffer.getInt();
            int endianSignature = buffer.getInt();
            switch (endianSignature) {
                case 305419896: {
                    buffer.order(ByteOrder.BIG_ENDIAN);
                    break;
                }
                case 2018915346: {
                    buffer.order(ByteOrder.LITTLE_ENDIAN);
                    length = TraceDataProvider.convertEndian(length);
                    this.traceBufferSize = TraceDataProvider.convertEndian(this.traceBufferSize);
                    break;
                }
                default: {
                    System.out.println(Messages.getString("TraceDataProvider.invalid.endian.signature"));
                    break;
                }
            }
        }
        catch (BufferUnderflowException e) {
            e.printStackTrace();
        }
        if (this.traceBufferSize > this.maxSendBytes) {
            this.maxSendBytes = this.traceBufferSize;
        }
        if (length > 0) {
            this.traceFileHeader = new byte[length];
            System.arraycopy(array, 0, this.traceFileHeader, 0, length);
        }
        this.sizeOfHeader = this.traceFileHeader.length;
    }

    protected static final int convertEndian(int in) {
        return in >>> 24 | in << 24 | in << 8 & 0xFF0000 | in >> 8 & 0xFF00;
    }

    public void resetData() {
    }

    public void modify(String command, String ... params) throws ProviderModificationException {
        if (command.toLowerCase().equals("on")) {
            if (params != null) {
                for (String trace : params) {
                    boolean enabled;
                    if (trace.endsWith("subsystem")) {
                        for (Subsystem subsystem : Subsystem.values()) {
                            if (!trace.equals(subsystem.getSubsystemName())) continue;
                            this.enableSubsystem(subsystem);
                        }
                        continue;
                    }
                    if (trace.endsWith(STACK_TRACE_TRIGGER_SUFFIX)) {
                        this.enableStackTraceTrigger(trace.substring(0, trace.lastIndexOf(STACK_TRACE_TRIGGER_SUFFIX)));
                        continue;
                    }
                    if (trace.startsWith("capability.")) continue;
                    if (trace.equals(VERBOSE_GC)) {
                        this.handleVerboseGCSetting("on");
                        continue;
                    }
                    Matcher matcher = ENTRYEXIT_PATTERN.matcher(trace);
                    if (matcher.matches()) {
                        String component = matcher.group(1);
                        enabled = this.enableEntryAndExitTrace(component);
                    } else {
                        enabled = this.enableTracePoint(trace);
                    }
                    if (enabled) {
                        this.enablementManager.enable(trace);
                        continue;
                    }
                    this.enablementManager.disable(trace);
                }
            }
        } else if (command.toLowerCase().equals("off")) {
            if (params != null) {
                for (String trace : params) {
                    if (trace.endsWith("subsystem")) {
                        for (Subsystem subsystem : Subsystem.values()) {
                            if (!trace.equals(subsystem.getSubsystemName())) continue;
                            this.disableSubsystem(subsystem);
                        }
                        continue;
                    }
                    if (trace.endsWith(STACK_TRACE_TRIGGER_SUFFIX)) {
                        this.disableStackTraceTrigger(trace.substring(0, trace.lastIndexOf(STACK_TRACE_TRIGGER_SUFFIX)));
                        continue;
                    }
                    if (trace.startsWith("capability.")) continue;
                    if (trace.equals(VERBOSE_GC)) {
                        this.handleVerboseGCSetting("off");
                        continue;
                    }
                    Matcher matcher = ENTRYEXIT_PATTERN.matcher(trace);
                    if (matcher.matches()) {
                        String component = matcher.group(1);
                        this.disableEntryAndExitTrace(component);
                    } else {
                        this.disableTracePoint(trace);
                    }
                    this.enablementManager.disable(trace);
                }
            }
        } else if (command.toLowerCase().equals("set")) {
            this.handleSet(command, params);
        }
    }

    private void handleSet(String command, String ... params) throws ProviderModificationException {
        if (params != null) {
            String lowThreshold = null;
            String highThreshold = null;
            for (String param : params) {
                String[] keyValuePair = param.split(EQUALS, 2);
                if (keyValuePair.length != 2) continue;
                if (keyValuePair[0].equals(STACKTRACEDEPTH)) {
                    this.setStackTraceDepth(keyValuePair[1]);
                    continue;
                }
                if (keyValuePair[0].equals(TRIGGER_STACK_TRACE_ON)) {
                    this.enableStackTraceTrigger(keyValuePair[1]);
                    continue;
                }
                if (keyValuePair[0].equals(TRIGGER_STACK_TRACE_OFF)) {
                    this.disableStackTraceTrigger(keyValuePair[1]);
                    continue;
                }
                if (keyValuePair[0].equals(LOW_ALLOCATION_THRESHOLD)) {
                    lowThreshold = keyValuePair[1];
                    continue;
                }
                if (keyValuePair[0].equals(HIGH_ALLOCATION_THRESHOLD)) {
                    highThreshold = keyValuePair[1];
                    continue;
                }
                if (!keyValuePair[0].equals(VERBOSE_GC)) continue;
                this.handleVerboseGCSetting(keyValuePair[1]);
            }
            if (lowThreshold != null) {
                this.setAllocationThresholds(lowThreshold, highThreshold);
            }
        }
    }

    private void handleVerboseGCSetting(String value) {
        if (value.equals("on")) {
            String vgcFileNamePrefix;
            String outputDirectory = this.getWriteableDirectory();
            if (outputDirectory == null) {
                System.out.println(Messages.getString("TraceDataProvider.no.writeable.directory.for.vgc"));
                return;
            }
            String vgcFileName = vgcFileNamePrefix = VERBOSE_GC_FILE_NAME + this._processID + "_";
            int suffix = 0;
            boolean fileAvailable = false;
            File vgcFile = null;
            while (!fileAvailable) {
                vgcFileName = vgcFileNamePrefix + suffix++ + VERBOSE_GC_FILE_SUFFIX;
                vgcFile = new File(outputDirectory, vgcFileName);
                if (vgcFile.exists()) continue;
                fileAvailable = true;
                break;
            }
            boolean rc = false;
            try {
                rc = TraceDataProvider.registerVerboseGCSubscriber(vgcFile.getCanonicalPath());
            }
            catch (Throwable e) {
                System.err.println(e.getLocalizedMessage());
                rc = false;
            }
            if (rc) {
                this.enablementManager.enable(VERBOSE_GC);
                if (this.agentInfo != null) {
                    this.agentInfo.addInfo(VERBOSE_GC_FILE_NAME_INFO, vgcFile.getAbsolutePath());
                }
            }
        } else {
            try {
                TraceDataProvider.deregisterVerboseGCSubscriber();
            }
            catch (Throwable e) {
                System.err.println(e.getLocalizedMessage());
            }
            this.agentInfo.addInfo(VERBOSE_GC_FILE_NAME_INFO, null);
            this.enablementManager.disable(VERBOSE_GC);
        }
    }

    private String getWriteableDirectory() {
        String dir = this.handler.getOutputDirectory();
        if (dir != null && dir.length() == 0) {
            dir = null;
        }
        return Util.findWriteableDirectory(dir);
    }

    private void enableSubsystem(Subsystem subsystem) throws ProviderModificationException {
        assert (subsystem != null);
        String[] tracepoints = subsystem.getTracepoints();
        this.modify("on", tracepoints);
        this.enablementManager.enable(subsystem.getSubsystemName());
    }

    private void disableSubsystem(Subsystem subsystem) throws ProviderModificationException {
        assert (subsystem != null);
        String[] tracepoints = subsystem.getTracepoints();
        this.modify("off", tracepoints);
        this.enablementManager.disable(subsystem.getSubsystemName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean enableEntryAndExitTrace(String component) throws ProviderModificationException {
        TraceDataProvider traceDataProvider = this;
        synchronized (traceDataProvider) {
            Method traceMethod;
            Object traceObj;
            Constructor<?> traceConstruct;
            Class<?> traceClass;
            Class[] paramString;
            int rc = 0;
            try {
                paramString = new Class[]{String.class};
                traceClass = Class.forName("com.ibm.jvm.Trace");
                traceConstruct = traceClass.getDeclaredConstructors()[0];
                traceConstruct.setAccessible(true);
                traceObj = traceConstruct.newInstance(new Object[0]);
                traceMethod = traceClass.getDeclaredMethod("set", paramString);
                rc = (Integer)traceMethod.invoke(traceObj, MessageFormat.format("{0}={1}'{'entry'}'", MAXIMAL, component));
                if (rc != 0) {
                    throw new ProviderModificationException(MessageFormat.format(Messages.getString("TraceDataProvider.exception.disabling.component"), component));
                }
            }
            catch (Exception e) {
                throw new ProviderModificationException(MessageFormat.format(Messages.getString("TraceDataProvider.exception.disabling.component"), component) + e.getMessage());
            }
            try {
                paramString = new Class[]{String.class};
                traceClass = Class.forName("com.ibm.jvm.Trace");
                traceConstruct = traceClass.getDeclaredConstructors()[0];
                traceConstruct.setAccessible(true);
                traceObj = traceConstruct.newInstance(new Object[0]);
                traceMethod = traceClass.getDeclaredMethod("set", paramString);
                rc = (Integer)traceMethod.invoke(traceObj, MessageFormat.format("{0}={1}'{'exit'}'", MAXIMAL, component));
                if (rc != 0) {
                    throw new ProviderModificationException(MessageFormat.format(Messages.getString("TraceDataProvider.exception.disabling.component"), component));
                }
            }
            catch (Exception e) {
                throw new ProviderModificationException(MessageFormat.format(Messages.getString("TraceDataProvider.exception.disabling.component"), component) + e.getMessage());
            }
        }
        return true;
    }

    private boolean enableTracePoint(String tp) throws ProviderModificationException {
        boolean tracePointExists = this.tracePointExistsInThisVM(tp);
        if (tracePointExists) {
            if (tp.startsWith(J9MM_DOT)) {
                this.enableGCTracePoint(tp);
            } else {
                this.enableNormalTracePoint(tp);
            }
            if (tp.equals(ALLOCATION_THRESHOLD_TRACEPOINT)) {
                this.enableStackTraceTrigger(tp);
            } else if (tp.equals(SET_ALLOCATION_THRESHOLD_TRACEPOINT)) {
                this.enableAllocationThreshold();
            }
        }
        return tracePointExists;
    }

    private boolean tracePointExistsInThisVM(String tp) {
        boolean isJITTracePoint = "j9jit.1".equals(tp) || "j9jit.20".equals(tp) || "j9jit.21".equals(tp) || "j9jit.22".equals(tp) || "j9jit.23".equals(tp) || "j9jit.24".equals(tp) || "j9jit.28".equals(tp) || "j9jit.29".equals(tp);
        boolean jitOK = !isJITTracePoint || this.jitTracepointAvailableInThisVM();
        boolean isj9ShrTracePoint = "j9shr.1326".equals(tp);
        boolean isj9ShrOK = !isj9ShrTracePoint || this.j9ShrTracePointAvailableInThisVM();
        boolean isProfilingTracePoint = J9JIT_15.equals(tp) || J9JIT_16.equals(tp) || J9JIT_17.equals(tp) || J9JIT_18.equals(tp);
        boolean isLOATracePoint = SET_ALLOCATION_THRESHOLD_TRACEPOINT.equals(tp) || ALLOCATION_THRESHOLD_TRACEPOINT.equals(tp);
        boolean profilingOK = !isProfilingTracePoint || this.profilingTracepointAvailableInThisVM();
        boolean loaOK = !isLOATracePoint || Util.vmHasLOATracePoints();
        boolean isDumpTracePointOK = !tp.startsWith(J9DMP_DOT) || this.isDumpTPavailable(tp);
        boolean isJavaTracePoint = "java.315".equals(tp) || "java.316".equals(tp) || "java.317".equals(tp) || "java.318".equals(tp) || "java.319".equals(tp) || "java.320".equals(tp) || "java.321".equals(tp) || "java.322".equals(tp) || "java.323".equals(tp);
        boolean javaTracePointsOK = !isJavaTracePoint || this.JavaTracePointsAvailableInVM();
        boolean gcOK = true;
        boolean realtimeOK = true;
        if (tp.startsWith(J9MM_DOT)) {
            int number = Integer.parseInt(tp.substring(J9MM_DOT.length()));
            realtimeOK = Util.isOkConsideringRealtime(number);
            gcOK = this.gcTracepointAvailableInThisVM(number);
        }
        boolean methodDictionaryAvailable = false;
        if (tp.equals("j9vm.333") && this.handler.getDataCollectionLevel().ordinal() != DataCollectionLevel.HEADLESS.ordinal()) {
            methodDictionaryAvailable = new MethodDictionaryDataProvider(this.handler).isDataSupported();
        }
        boolean tracePointExists = realtimeOK && profilingOK && loaOK && !methodDictionaryAvailable && gcOK && isDumpTracePointOK && javaTracePointsOK && jitOK && isj9ShrOK;
        return tracePointExists;
    }

    private void disableTracePoint(String tracePoint) throws ProviderModificationException {
        boolean tracePointExists = this.tracePointExistsInThisVM(tracePoint);
        if (tracePointExists) {
            if (tracePoint.startsWith(J9MM_DOT)) {
                this.disableGCTracePoint(tracePoint);
            } else {
                this.disableNormalTracePoint(tracePoint);
            }
        }
    }

    protected String getEnabledTracePointsString() {
        return this.enablementManager.getEnablementString();
    }

    protected void disableExceptionTracePoint(String tp) throws ProviderModificationException {
        this.sendDisableCommandToVM(tp, EXCEPTION);
    }

    protected void enableExceptionTracePoint(String tp) throws ProviderModificationException {
        this.sendEnableCommandToVM(tp, EXCEPTION);
    }

    protected void disableNormalTracePoint(String tp) throws ProviderModificationException {
        this.sendDisableCommandToVM(tp, MAXIMAL);
    }

    protected void enableNormalTracePoint(String tp) throws ProviderModificationException {
        this.sendEnableCommandToVM(tp, MAXIMAL);
    }

    protected abstract void enableGCTracePoint(String var1) throws ProviderModificationException;

    protected abstract void disableGCTracePoint(String var1) throws ProviderModificationException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disableEntryAndExitTrace(String component) throws ProviderModificationException {
        TraceDataProvider traceDataProvider = this;
        synchronized (traceDataProvider) {
            Method traceMethod;
            Object traceObj;
            Constructor<?> traceConstruct;
            Class<?> traceClass;
            Class[] paramString;
            int rc = 0;
            try {
                paramString = new Class[]{String.class};
                traceClass = Class.forName("com.ibm.jvm.Trace");
                traceConstruct = traceClass.getDeclaredConstructors()[0];
                traceConstruct.setAccessible(true);
                traceObj = traceConstruct.newInstance(new Object[0]);
                traceMethod = traceClass.getDeclaredMethod("set", paramString);
                rc = (Integer)traceMethod.invoke(traceObj, MessageFormat.format("{0}=!{1}'{'entry'}'", MAXIMAL, component));
                if (rc != 0) {
                    throw new ProviderModificationException(MessageFormat.format(Messages.getString("TraceDataProvider.exception.disabling.component"), component));
                }
            }
            catch (Exception e) {
                throw new ProviderModificationException(MessageFormat.format(Messages.getString("TraceDataProvider.exception.disabling.component"), component) + e.getMessage());
            }
            try {
                paramString = new Class[]{String.class};
                traceClass = Class.forName("com.ibm.jvm.Trace");
                traceConstruct = traceClass.getDeclaredConstructors()[0];
                traceConstruct.setAccessible(true);
                traceObj = traceConstruct.newInstance(new Object[0]);
                traceMethod = traceClass.getDeclaredMethod("set", paramString);
                rc = (Integer)traceMethod.invoke(traceObj, MessageFormat.format("{0}=!{1}'{'exit'}'", MAXIMAL, component));
                if (rc != 0) {
                    throw new ProviderModificationException(MessageFormat.format(Messages.getString("TraceDataProvider.exception.disabling.component"), component));
                }
            }
            catch (Exception e) {
                throw new ProviderModificationException(MessageFormat.format(Messages.getString("TraceDataProvider.exception.disabling.component"), component) + e.getMessage());
            }
        }
    }

    private void setStackTraceDepth(String stackDepth) throws ProviderModificationException {
        try {
            Integer.parseInt(stackDepth);
            int rc = 0;
            try {
                Class[] paramString = new Class[]{String.class};
                Class<?> traceClass = Class.forName("com.ibm.jvm.Trace");
                Constructor<?> traceConstruct = traceClass.getDeclaredConstructors()[0];
                traceConstruct.setAccessible(true);
                Object traceObj = traceConstruct.newInstance(new Object[0]);
                Method traceMethod = traceClass.getDeclaredMethod("set", paramString);
                rc = (Integer)traceMethod.invoke(traceObj, STACKDEPTH_COMMAND + stackDepth);
                if (rc != 0) {
                    throw new ProviderModificationException(Messages.getString("TraceDataProvider.exception.setting.trigger.stackdepth"));
                }
                this.stackDepthSet = true;
            }
            catch (Exception e) {
                throw new ProviderModificationException(Messages.getString("TraceDataProvider.exception.setting.trigger.stackdepth") + e.getMessage());
            }
        }
        catch (NumberFormatException e) {
            throw new ProviderModificationException(Messages.getString("TraceDataProvider.exception.setting.trigger.stackdepth") + e.getMessage());
        }
    }

    private void enableStackTraceTrigger(String tp) throws ProviderModificationException {
        if (!this.tracePointExistsInThisVM(tp)) {
            return;
        }
        if (!this.stackDepthSet && this.handler != null) {
            this.setStackTraceDepth(this.handler.getStackTraceDepth());
        }
        tp = tp.trim().toLowerCase();
        int rc = 0;
        try {
            Class[] paramString = new Class[]{String.class};
            Class<?> traceClass = Class.forName("com.ibm.jvm.Trace");
            Constructor<?> traceConstruct = traceClass.getDeclaredConstructors()[0];
            traceConstruct.setAccessible(true);
            Object traceObj = traceConstruct.newInstance(new Object[0]);
            Method traceMethod = traceClass.getDeclaredMethod("set", paramString);
            rc = (Integer)traceMethod.invoke(traceObj, MessageFormat.format("trigger=tpnid'{'{0},jstacktrace'}'", tp));
            if (rc != 0) {
                System.out.println(MessageFormat.format(Messages.getString("TraceDataProvider.exception.enabling.trigger"), tp));
                this.enablementManager.disable(tp + STACK_TRACE_TRIGGER_SUFFIX);
            } else {
                this.enablementManager.enable(tp + STACK_TRACE_TRIGGER_SUFFIX);
            }
        }
        catch (Exception e) {
            throw new ProviderModificationException(MessageFormat.format(Messages.getString("TraceDataProvider.exception.enabling.trigger"), tp) + e.getMessage());
        }
    }

    private void disableStackTraceTrigger(String tp) throws ProviderModificationException {
        if (!this.tracePointExistsInThisVM(tp)) {
            return;
        }
        tp = tp.trim().toLowerCase();
        int rc = 0;
        try {
            Class[] paramString = new Class[]{String.class};
            Class<?> traceClass = Class.forName("com.ibm.jvm.Trace");
            Constructor<?> traceConstruct = traceClass.getDeclaredConstructors()[0];
            traceConstruct.setAccessible(true);
            Object traceObj = traceConstruct.newInstance(new Object[0]);
            Method traceMethod = traceClass.getDeclaredMethod("set", paramString);
            rc = (Integer)traceMethod.invoke(traceObj, MessageFormat.format("trigger=!tpnid'{'{0},jstacktrace'}'", tp));
            if (rc != 0) {
                System.out.println(MessageFormat.format(Messages.getString("TraceDataProvider.exception.disabling.trigger"), tp));
            }
            this.enablementManager.disable(tp + STACK_TRACE_TRIGGER_SUFFIX);
        }
        catch (Exception e) {
            throw new ProviderModificationException(MessageFormat.format(Messages.getString("TraceDataProvider.exception.disabling.trigger"), tp) + e.getMessage());
        }
    }

    private void setAllocationThresholds(String low, String high) {
        VmDump.setAllocationThresholdTrigger(low, high);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendDisableCommandToVM(String tp, String buffer) throws ProviderModificationException {
        tp = tp.trim().toLowerCase();
        TraceDataProvider traceDataProvider = this;
        synchronized (traceDataProvider) {
            int rc = 0;
            try {
                Class[] paramString = new Class[]{String.class};
                Class<?> traceClass = Class.forName("com.ibm.jvm.Trace");
                Constructor<?> traceConstruct = traceClass.getDeclaredConstructors()[0];
                traceConstruct.setAccessible(true);
                Object traceObj = traceConstruct.newInstance(new Object[0]);
                Method traceMethod = traceClass.getDeclaredMethod("set", paramString);
                rc = (Integer)traceMethod.invoke(traceObj, MessageFormat.format("{0}=!tpnid'{'{1}'}'", buffer, tp));
                if (rc != 0) {
                    throw new ProviderModificationException(MessageFormat.format(Messages.getString("TraceDataProvider.exception.disabling"), tp));
                }
            }
            catch (Exception e) {
                throw new ProviderModificationException(MessageFormat.format(Messages.getString("TraceDataProvider.exception.disabling"), tp) + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendEnableCommandToVM(String tp, String buffer) throws ProviderModificationException {
        tp = tp.trim().toLowerCase();
        TraceDataProvider traceDataProvider = this;
        synchronized (traceDataProvider) {
            int rc = 0;
            try {
                Class[] paramString = new Class[]{String.class};
                Class<?> traceClass = Class.forName("com.ibm.jvm.Trace");
                Constructor<?> traceConstruct = traceClass.getDeclaredConstructors()[0];
                traceConstruct.setAccessible(true);
                Object traceObj = traceConstruct.newInstance(new Object[0]);
                Method traceMethod = traceClass.getDeclaredMethod("set", paramString);
                rc = (Integer)traceMethod.invoke(traceObj, MessageFormat.format("{0}=tpnid'{'{1}'}'", buffer, tp));
                if (rc != 0) {
                    throw new ProviderModificationException(MessageFormat.format(Messages.getString("TraceDataProvider.exception.enabling"), tp));
                }
            }
            catch (Exception e) {
                throw new ProviderModificationException(MessageFormat.format(Messages.getString("TraceDataProvider.exception.enabling"), tp) + e.getMessage());
            }
        }
    }

    private void enableAllocationThreshold() {
        if (this.allocationThresholdInitialized) {
            return;
        }
        String lowThreshold = null;
        String highThreshold = null;
        if (this.handler != null) {
            lowThreshold = this.handler.getLowAllocationThreshold();
            highThreshold = this.handler.getHighAllocationThreshold();
            if (lowThreshold != null && !lowThreshold.equals(EMPTY_STRING)) {
                this.setAllocationThresholds(lowThreshold, highThreshold);
            } else {
                VmDump.resetAllocationThresholdsToCurrent();
            }
        }
        this.allocationThresholdInitialized = true;
    }

    private void providerInitialisation(EnablementManager enablementManager) {
        this.init();
        if (this.isDataSupported()) {
            String traceCommand = "none=all,maximal=mt";
            try {
                Class[] paramString = new Class[]{String.class};
                Class<?> traceClass = Class.forName("com.ibm.jvm.Trace");
                Constructor<?> traceConstruct = traceClass.getDeclaredConstructors()[0];
                traceConstruct.setAccessible(true);
                Object traceObj = traceConstruct.newInstance(new Object[0]);
                Method traceMethod = traceClass.getDeclaredMethod("set", paramString);
                traceMethod.invoke(traceObj, traceCommand);
                this.initializeTracePoints(enablementManager);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    protected abstract String getSourceName();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Subsystem {
        CLASSES("classes_subsystem", new String[]{"j9bcu.1", "j9shr.51", "j9bcverify.14", "j9bcverify.18"}),
        GC("gc_subsystem", new String[]{"j9mm.1", "j9mm.2", "j9mm.50", "j9mm.51", "j9mm.52", "j9mm.53", "j9mm.54", "j9mm.55", "j9mm.56", "j9mm.57", "j9mm.58", "j9mm.59", "j9mm.60", "j9mm.64", "j9mm.65", "j9mm.68", "j9mm.69", "j9mm.71", "j9mm.72", "j9mm.73", "j9mm.74", "j9mm.75", "j9mm.85", "j9mm.86", "j9mm.90", "j9mm.91", "j9mm.94", "j9mm.131", "j9mm.132", "j9mm.133", "j9mm.134", "j9mm.135", "j9mm.136", "j9mm.137", "j9mm.138", "j9mm.139", "j9mm.231", "j9mm.234", "j9mm.279", "j9mm.280", "j9mm.281", "j9mm.282", "j9jit.2", "j9jit.4", "j9jit.5", "j9jit.6", "j9jit.9", "j9jit.11", "j9jit.12", "j9jit.18", "j9mm.383", "j9mm.384", "j9mm.345", "j9mm.346", "j9mm.347", "j9mm.348", "j9mm.463", "j9mm.464", "j9mm.467", "j9mm.468", "j9mm.469", "j9mm.470", "j9mm.560", "j9mm.474", "j9mm.475", "j9mm.395", "j9mm.285", "j9mm.286"}),
        PROFILING("profiling_subsystem", new String[]{"j9vm.333", "j9jit.15", "j9jit.16", "j9jit.17", "j9jit.18"}),
        JIT("jit_subsystem", new String[]{"j9jit.1", "j9jit.20", "j9jit.21", "j9jit.22", "j9jit.23", "j9jit.24", "j9jit.28", "j9jit.29"}),
        IO("io_subsystem", new String[]{"IO.100", "IO.101", "IO.102", "IO.103", "IO.104", "IO.105", "IO.106", "IO.107", "IO.108", "JAVA.315", "JAVA.316", "JAVA.317", "JAVA.318", "JAVA.319", "JAVA.320", "JAVA.321", "JAVA.322", "JAVA.323", "j9scar.35", "j9scar.36", "j9scar.37", "j9scar.38", "j9scar.136", "j9scar.137", "j9scar.138", "j9scar.139", "j9scar.140"});

        private final String name;
        private final String[] tracepoints;

        private Subsystem(String name, String[] tracepoints) {
            this.name = name;
            this.tracepoints = tracepoints;
        }

        public String getSubsystemName() {
            return this.name;
        }

        public String[] getTracepoints() {
            return this.tracepoints;
        }
    }
}

