/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.agent.dataproviders;

import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.DataCollectionLevel;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.DataProvider;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.DataProviderConstants;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.capabilities.EnablementManager;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.HealthCenter;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.HealthCenterOptionHandler;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JLADataProvider
implements DataProvider,
DataProviderConstants {
    public static final String CAPABILITY_LOCKING_SUBSYSTEM = "locking_subsystem";
    private static final String COMMA = ",";
    private static final String REPORT_TIME_EYECATCHER = "reportTime,";
    private static final String REPORT_COMPLETE = "reportcomplete";
    private static String VERSION = "1.0";
    public static final String TAG = "JLASource";
    private static String PARSERTIME = "120";
    protected final HealthCenterOptionHandler handler;
    private boolean dataProviderActive = false;
    private EnablementManager enablementManager;

    public JLADataProvider(HealthCenterOptionHandler handler) {
        this.handler = handler;
        DataCollectionLevel level = handler.getDataCollectionLevel();
        this.enablementManager = new EnablementManager(TAG, handler.getDataCollectionLevel());
        if (level.ordinal() > DataCollectionLevel.OFF.ordinal()) {
            this.providerInitialisation();
            this.dataProviderActive = true;
        }
    }

    @Override
    public synchronized void startSession() {
        if (!this.dataProviderActive) {
            this.enablementManager.setLevel(DataCollectionLevel.FULL);
            if (this.enablementManager.isEnabled(CAPABILITY_LOCKING_SUBSYSTEM)) {
                this.providerInitialisation();
                this.dataProviderActive = true;
            }
        }
    }

    public void startNativeJLA() {
        try {
            this.startJLA();
        }
        catch (UnsatisfiedLinkError e) {
            System.err.println(e.getLocalizedMessage());
        }
    }

    public void stopNativeJLA() {
        try {
            this.stopJLA();
        }
        catch (UnsatisfiedLinkError e) {
            System.err.println(e.getLocalizedMessage());
        }
    }

    @Override
    public boolean isDataSupported() {
        boolean available = false;
        try {
            if (this.reportJLA() != null) {
                available = true;
            }
        }
        catch (Throwable e) {
            System.err.println("Lock Analysis is not available: " + e);
            available = false;
        }
        return available;
    }

    @Override
    public Map<String, String> getLiveSourceDetails() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", TAG);
        map.put("version", VERSION);
        map.put("state", this.enablementManager.getEnablementString());
        map.put("suggested_update_frequency", PARSERTIME);
        map.put("max_bytes_to_send", Integer.toString(-1));
        return map;
    }

    private native void startJLA();

    private native void stopJLA();

    private native String reportJLA();

    private String getLockingReport() {
        String jlaReport = this.enablementManager.isEnabled(CAPABILITY_LOCKING_SUBSYSTEM) ? this.reportJLA() : REPORT_COMPLETE;
        return REPORT_TIME_EYECATCHER + System.currentTimeMillis() + COMMA + jlaReport;
    }

    @Override
    public byte[] getJMXData() {
        if (HealthCenter.isDebug) {
            System.out.println("returning reportNativeJLA");
        }
        try {
            return this.getLockingReport().getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            return this.getLockingReport().getBytes();
        }
    }

    @Override
    public void resetData() {
        this.startJLA();
    }

    @Override
    public void modify(String command, String ... params) {
        block4: {
            block3: {
                if (!command.toLowerCase().equals("on")) break block3;
                if (params == null) break block4;
                for (String param : params) {
                    if (!CAPABILITY_LOCKING_SUBSYSTEM.equals(param) || this.dataProviderActive && this.enablementManager.isEnabled(param)) continue;
                    this.providerInitialisation();
                    this.dataProviderActive = true;
                    this.enablementManager.enable(param);
                }
                break block4;
            }
            if (command.toLowerCase().equals("off") && params != null) {
                for (String param : params) {
                    if (!CAPABILITY_LOCKING_SUBSYSTEM.equals(param)) continue;
                    this.stopNativeJLA();
                    this.enablementManager.disable(param);
                }
            }
        }
    }

    private void providerInitialisation() {
        this.startNativeJLA();
    }

    @Override
    public void restartProvider() {
    }

    @Override
    public void headlessFileInitialise() {
    }
}

