/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.agent;

public class VmDump {
    private static final String ALLOCATION_EVENT_DUMP_SILENT = "silent:";
    private static final String ALLOCATION_EVENT_DUMP_OPTIONS = "events=allocation,filter=#";
    public static final String ALLOCATION_FILTER_SIZE_SEPARATOR = "..";
    private static final String EMPTY_STRING = "";
    private static final String MAX_32_BIT_THRESHOLD_VALUE = "4294967295";
    private static final String MAX_64_BIT_THRESHOLD_VALUE = "18446744073709551615";
    private static String maxThreshold = "4294967295";
    private static boolean is64bit = false;
    private static String bitmode;
    private static final String bitmode64 = "64";
    private static final String COM_IBM_VM_BITMODE = "com.ibm.vm.bitmode";

    private static native int setVmDump(String var0);

    private static native String queryVmDump();

    private static native int resetVmDump();

    public static int setVmDumpOptions(String options) {
        try {
            return VmDump.setVmDump(options);
        }
        catch (UnsatisfiedLinkError e) {
            System.err.println(e.getLocalizedMessage());
            return 0;
        }
    }

    public static String queryVmDumpOptions() {
        try {
            return VmDump.queryVmDump();
        }
        catch (UnsatisfiedLinkError e) {
            System.err.println(e.getLocalizedMessage());
            return null;
        }
    }

    public static int resetVmDumpOptions() {
        try {
            return VmDump.resetVmDump();
        }
        catch (UnsatisfiedLinkError e) {
            System.err.println(e.getLocalizedMessage());
            return 0;
        }
    }

    private static int setAllocationThresholds(String thresholds, boolean force) {
        String currentThresholds = VmDump.getAllocationThresholds();
        if (!force && currentThresholds != null && currentThresholds.equals(thresholds)) {
            return 0;
        }
        String command = "silent:events=allocation,filter=#" + thresholds;
        VmDump.resetVmDump();
        int rc = VmDump.setVmDumpOptions(command);
        if (rc != 0 && currentThresholds != null) {
            command = "silent:events=allocation,filter=#" + currentThresholds;
            VmDump.resetVmDump();
            VmDump.setVmDumpOptions(command);
        }
        return rc;
    }

    public static int setAllocationThresholdTrigger(String lowThreshold, String highThreshold) {
        if (bitmode == null && bitmode64.equals(bitmode = System.getProperty(COM_IBM_VM_BITMODE))) {
            is64bit = true;
            maxThreshold = MAX_64_BIT_THRESHOLD_VALUE;
        }
        String threshold = lowThreshold == null ? EMPTY_STRING : lowThreshold.trim();
        String high = highThreshold == null ? EMPTY_STRING : highThreshold.trim();
        if (threshold.equals(EMPTY_STRING)) {
            threshold = maxThreshold;
            high = maxThreshold;
        }
        if (!high.equals(EMPTY_STRING)) {
            threshold = threshold + ALLOCATION_FILTER_SIZE_SEPARATOR;
            threshold = threshold + high;
        }
        int rc = VmDump.setAllocationThresholds(threshold, false);
        return rc;
    }

    public static String getAllocationThresholds() {
        int index;
        String threshold = null;
        String dumpOptions = VmDump.queryVmDumpOptions();
        if (dumpOptions != null && (index = dumpOptions.lastIndexOf(ALLOCATION_EVENT_DUMP_OPTIONS)) >= 0) {
            String optionString = dumpOptions.substring(index + ALLOCATION_EVENT_DUMP_OPTIONS.length());
            threshold = optionString.substring(0, optionString.indexOf(","));
        }
        return threshold;
    }

    public static void resetAllocationThresholdsToCurrent() {
        String currentThresholds = VmDump.getAllocationThresholds();
        if (currentThresholds != null) {
            VmDump.setAllocationThresholds(currentThresholds, true);
        }
    }
}

