/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmskeystore;

import com.ibm.security.cmskeystore.Buffer;
import com.ibm.security.cmskeystore.BufferFactory$BufferImpl;
import com.ibm.security.cmskeystore.ByteSequenceInputStream;
import com.ibm.security.cmskeystore.ByteSequenceInputStreamFactory;
import com.ibm.security.cmskeystore.IntableByteSequence;
import com.ibm.security.cmskeystore.IntableByteSequenceFactory;
import com.ibm.security.sequence.bytes.ByteSequence;
import com.ibm.security.sequence.bytes.ByteSequenceFactory;
import java.io.IOException;
import java.io.InputStream;

final class BufferFactory {
    private BufferFactory() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public static Buffer newBuffer(InputStream inputStream) throws NullPointerException, IOException {
        ByteSequence byteSequence;
        if (inputStream == null) {
            throw new NullPointerException();
        }
        ByteSequenceInputStream byteSequenceInputStream = ByteSequenceInputStreamFactory.newByteSequenceInputStream();
        ByteSequence byteSequence2 = byteSequenceInputStream.getByteSequence(inputStream, 4);
        if (byteSequence2 == null) {
            return null;
        }
        IntableByteSequence intableByteSequence = IntableByteSequenceFactory.newIntableByteSequence(byteSequence2);
        int n = intableByteSequence.toInt();
        if (n < 1) {
            byteSequence = ByteSequenceFactory.newByteSequence(new byte[0]);
        } else {
            byteSequence2 = byteSequenceInputStream.getByteSequence(inputStream, n);
            if (byteSequence2 == null) {
                return null;
            }
            byteSequence = byteSequence2;
        }
        return new BufferFactory$BufferImpl(intableByteSequence, byteSequence);
    }

    public static Buffer newBufferWithLatestRecID(InputStream inputStream, int n) throws NullPointerException, IOException {
        ByteSequence byteSequence;
        if (inputStream == null) {
            throw new NullPointerException();
        }
        ByteSequenceInputStream byteSequenceInputStream = ByteSequenceInputStreamFactory.newByteSequenceInputStream();
        int n2 = 6;
        ByteSequence byteSequence2 = byteSequenceInputStream.getByteSequence(inputStream, 4);
        if (byteSequence2 == null) {
            return null;
        }
        IntableByteSequence intableByteSequence = IntableByteSequenceFactory.newIntableByteSequence(byteSequence2);
        int n3 = intableByteSequence.toInt();
        if (n3 < 1) {
            byteSequence = ByteSequenceFactory.newByteSequence(new byte[0]);
        } else {
            byteSequence2 = byteSequenceInputStream.getByteSequence(inputStream, n3);
            if (byteSequence2 == null) {
                return null;
            }
            if (byteSequence2.get(6) == n) {
                byteSequence = byteSequence2;
            } else {
                InputStream inputStream2 = byteSequence2.getInputStream();
                byte[] byArray = BufferFactory.getBytes(inputStream2, n3);
                if (byArray == null) {
                    return null;
                }
                byArray[6] = (byte)n;
                byteSequence = ByteSequenceFactory.newByteSequence(byArray);
                inputStream2.close();
            }
        }
        return new BufferFactory$BufferImpl(intableByteSequence, byteSequence);
    }

    private static byte[] getBytes(InputStream inputStream, int n) throws NullPointerException, IOException {
        int n2;
        int n3;
        byte[] byArray = new byte[n];
        for (n2 = 0; (n3 = inputStream.read(byArray, n2, n - n2)) != -1 && n2 < n; n2 += n3) {
        }
        if (n2 < n) {
            return null;
        }
        return byArray;
    }
}

