/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.util;

import com.ibm.security.util.AbstractAlgorithmConstraints;
import com.ibm.security.util.AlgorithmDecomposer;
import java.security.AlgorithmParameters;
import java.security.CryptoPrimitive;
import java.security.Key;
import java.util.Set;

public class LegacyAlgorithmConstraints
extends AbstractAlgorithmConstraints {
    public static final String PROPERTY_TLS_LEGACY_ALGS = "jdk.tls.legacyAlgorithms";
    private final Set<String> legacyAlgorithms;

    public LegacyAlgorithmConstraints(String propertyName, AlgorithmDecomposer decomposer) {
        super(decomposer);
        this.legacyAlgorithms = LegacyAlgorithmConstraints.getAlgorithms(propertyName);
    }

    @Override
    public final boolean permits(Set<CryptoPrimitive> primitives, String algorithm, AlgorithmParameters parameters) {
        return LegacyAlgorithmConstraints.checkAlgorithm(this.legacyAlgorithms, algorithm, this.decomposer);
    }

    @Override
    public final boolean permits(Set<CryptoPrimitive> primitives, Key key) {
        return true;
    }

    @Override
    public final boolean permits(Set<CryptoPrimitive> primitives, String algorithm, Key key, AlgorithmParameters parameters) {
        return LegacyAlgorithmConstraints.checkAlgorithm(this.legacyAlgorithms, algorithm, this.decomposer);
    }
}

