/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.tools;

import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.pkcs8.EncryptedPrivateKeyInfo;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.pkcsutil.PKCSAttribute;
import com.ibm.security.pkcsutil.PKCSAttributes;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.tools.CertAndKeyGen;
import com.ibm.security.x509.X500Name;
import java.io.FileOutputStream;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;

public class genEPKI {
    public static void main(String[] argv) {
        char[] passwd = "password".toCharArray();
        String fileprefix = "genEPKI";
        String privkeyfile = fileprefix + ".epki";
        String certfile = fileprefix + ".cert";
        String pkifile = fileprefix + ".pki";
        String digest = "MD5";
        String alg = "DES";
        if (argv.length != 0) {
            if (argv.length == 1) {
                passwd = argv[0].toCharArray();
            } else if (argv.length == 2) {
                digest = argv[0];
                alg = argv[1];
            } else if (argv.length == 3) {
                digest = argv[0];
                alg = argv[1];
                passwd = argv[2].toCharArray();
            } else {
                System.out.println("Usage: genEPKI [<digest> <cipher>] [<password>]");
                System.out.println("        <digest> is the digest to use in the encryption (default - MD5)");
                System.out.println("        <cipher> is the cipher to use in the encryption (default - DES)");
                System.out.println("        <password> is the password to use in the encryption (default - \"password\")");
                System.exit(1);
            }
        }
        HexDumpEncoder hd = new HexDumpEncoder();
        try {
            System.out.println("Generating an EncryptedPrivateKeyInfo and dumping it to file " + privkeyfile);
            CertAndKeyGen certAndKey = new CertAndKeyGen("RSA", "MD5withRSA");
            certAndKey.generate(512);
            X500Name name = new X500Name("Java User", "JavaSec", "IBM", "US");
            X509Certificate cert = certAndKey.getSelfCertificate(name, 3600L);
            PrivateKey pk = certAndKey.getPrivateKey();
            PrivateKeyInfo pki = (PrivateKeyInfo)pk;
            String[] values = new String[]{"user1", "user2", "user3", "user4"};
            PKCSAttribute attr1 = new PKCSAttribute(PKCSOID.UNSTRUCTURED_NAME_OID, values);
            PKCSAttribute attr2 = new PKCSAttribute(PKCSOID.CHALLENGE_PASSWORD_OID, (Object)"ThisIsAChallengePassword");
            PKCSAttribute[] attrs = new PKCSAttribute[]{attr1, attr2};
            PKCSAttributes attributes = new PKCSAttributes(attrs);
            pki = pki.addAttributes(attributes);
            System.out.println("Writing the certificate to file " + certfile);
            byte[] certBytes = cert.getEncoded();
            FileOutputStream fos = new FileOutputStream(certfile);
            fos.write(certBytes);
            fos.close();
            System.out.println("Writing the original private key to file " + pkifile);
            pki.write(pkifile, false);
            System.out.println("Encrypting private key with " + digest + " and " + alg);
            EncryptedPrivateKeyInfo epki = new EncryptedPrivateKeyInfo(passwd, pki, digest, alg);
            epki.write(privkeyfile, false);
        }
        catch (Exception e) {
            System.out.println("ERROR: " + e.toString());
            e.printStackTrace();
        }
    }
}

