/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.certclient;

import com.ibm.misc.Debug;
import com.ibm.security.certclient.PkEeCertReqTransaction;
import com.ibm.security.certclient.PkEeFactory;
import com.ibm.security.certclient.base.PkActiveSource;
import com.ibm.security.certclient.base.PkAttrs;
import com.ibm.security.certclient.base.PkCertRepEvent;
import com.ibm.security.certclient.base.PkCertReqEvent;
import com.ibm.security.certclient.base.PkConfReqEvent;
import com.ibm.security.certclient.base.PkConstants;
import com.ibm.security.certclient.base.PkException;
import com.ibm.security.certclient.base.PkInitReqEvent;
import com.ibm.security.certclient.base.PkNLSConstants;
import com.ibm.security.certclient.base.PkPipe;
import com.ibm.security.certclient.base.PkRejectionException;
import com.ibm.security.certclient.beans.PkEeXMgr;
import com.ibm.security.certclient.beans.PkTcpClient;
import com.ibm.security.certclient.util.JPKI;
import com.ibm.security.certclient.util.PkCASetUp;
import com.ibm.security.certclient.util.PkCertUtils;
import com.ibm.security.certclient.util.PkConnector;
import com.ibm.security.cmp.PKIHeader;
import com.ibm.security.cmp.PKIMessage;
import com.ibm.security.pkcs10.CertificationRequest;
import com.ibm.security.pkcs10.CertificationRequestInfo;
import com.ibm.security.pkcsutil.PKCSAttribute;
import com.ibm.security.pkcsutil.PKCSAttributes;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.x509.CertificateExtensions;
import com.ibm.security.x509.ExtKeyUsageExtension;
import com.ibm.security.x509.KeyUsageExtension;
import com.ibm.security.x509.SubjectAlternativeNameExtension;
import com.ibm.security.x509.SubjectKeyIdentifierExtension;
import com.ibm.security.x509.X500Name;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public final class PkEeCertReqFactory
extends PkEeFactory
implements PkConstants {
    private PkEeCertReqFactory() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public static PkEeCertReqTransaction newCertRequest(int n, String string, int n2, boolean bl, boolean bl2, List<String> list, List<String> list2, List<String> list3, String string2, String string3, String string4) throws PkException {
        String string5 = bl ? "RSA" : "DSA";
        String string6 = "SHA1withRSA";
        if (!bl) {
            string6 = "SHA1withDSA";
        }
        return new CertRequestImpl(n, string, n2, string5, string6, bl2, list, list2, list3, string2, string3, string4);
    }

    public static PkEeCertReqTransaction newCertRequest(int n, String string, int n2, String string2, String string3, boolean bl, List<String> list, List<String> list2, List<String> list3, String string4, String string5, String string6) throws PkException {
        return new CertRequestImpl(n, string, n2, string2, string3, bl, list, list2, list3, string4, string5, string6);
    }

    @Deprecated
    public static PkEeCertReqTransaction newCertRequest(int n, String string, int n2, boolean bl, boolean bl2, List<String> list, List<String> list2, List<String> list3, String string2, String string3, String string4, KeyPair keyPair) throws PkException {
        String string5 = bl ? "RSA" : "DSA";
        String string6 = "SHA1withRSA";
        if (!bl) {
            string6 = "SHA1withDSA";
        }
        return new CertRequestImpl(n, string, n2, string5, string6, bl2, list, list2, list3, string2, string3, string4, keyPair);
    }

    public static PkEeCertReqTransaction newCertRequest(int n, String string, int n2, String string2, String string3, boolean bl, List<String> list, List<String> list2, List<String> list3, String string4, String string5, String string6, KeyPair keyPair) throws PkException {
        return new CertRequestImpl(n, string, n2, string2, string3, bl, list, list2, list3, string4, string5, string6, keyPair);
    }

    @Deprecated
    public static PkEeCertReqTransaction newCertRequest(String string, String string2, String string3, String string4) throws PkException {
        return new CertRequestImpl(string, string2, string3, string4);
    }

    private static final class CertRequestImpl
    implements PkEeCertReqTransaction {
        private static Debug debug = Debug.getInstance((String)"keycertmanage");
        private final Object className = this.toString();
        private PkEe ee = new PkEe();
        private boolean eeRun = false;

        CertRequestImpl(int n, String string, int n2, String string2, String string3, boolean bl, List<String> list, List<String> list2, List<String> list3, String string4, String string5, String string6) throws PkException {
            this.ee.setKeyType(string2);
            this.ee.setKeySize(n);
            this.ee.setSignatureAlgorithm(string3);
            this.ee.setSubject(string);
            this.ee.setValidity(n2);
            this.ee.setkIdform(bl);
            this.ee.setSubjectAltNames(list);
            this.ee.setKeyUsage(list2);
            this.ee.setExtKeyUsage(list3);
            this.ee.setIafile(string4);
            this.ee.setRevoPwd(string5);
            this.ee.setCa_Dn(string6);
            this.ee.setCaPort(PkEeFactory.caPort);
            this.ee.setCaDn(PkEeFactory.caDn);
        }

        CertRequestImpl(int n, String string, int n2, String string2, String string3, boolean bl, List<String> list, List<String> list2, List<String> list3, String string4, String string5, String string6, KeyPair keyPair) throws PkException {
            this.ee.setKeyType(string2);
            this.ee.setKeySize(n);
            this.ee.setSignatureAlgorithm(string3);
            this.ee.setSubject(string);
            this.ee.setValidity(n2);
            this.ee.setkIdform(bl);
            this.ee.setSubjectAltNames(list);
            this.ee.setKeyUsage(list2);
            this.ee.setExtKeyUsage(list3);
            this.ee.setIafile(string4);
            this.ee.setRevoPwd(string5);
            this.ee.setKeyPair(keyPair);
            this.ee.setCa_Dn(string6);
            this.ee.setCaPort(PkEeFactory.caPort);
            this.ee.setCaDn(PkEeFactory.caDn);
        }

        @Deprecated
        CertRequestImpl(String string, String string2, String string3, String string4) throws PkException {
            this.ee.setSubject(string);
            this.ee.setIafile(string2);
            this.ee.setRevoPwd(string3);
            this.ee.setCa_Dn(string4);
            this.ee.setKeySize(1024);
            this.ee.setValidity(365);
            this.ee.setKeyType("RSA");
            this.ee.setSignatureAlgorithm("SHA1withRSA");
            this.ee.setkIdform(false);
            this.ee.setCaPort(PkEeFactory.caPort);
            this.ee.setCaDn(PkEeFactory.caDn);
        }

        @Override
        public void setKeyType(String string) {
            this.ee.setKeyType(string);
        }

        @Override
        public void setKeySize(int n) throws PkException {
            this.ee.setKeySize(n);
        }

        @Override
        public void setValidity(int n) throws PkException {
            this.ee.setValidity(n);
        }

        @Override
        public void setSubjectKeyIdShort(boolean bl) {
            this.ee.setkIdform(bl);
        }

        @Override
        public void setSubjectAltNames(List<String> list) {
            this.ee.setSubjectAltNamesClear(list);
        }

        @Override
        public void addKeyUsage(List<String> list) {
            this.ee.addKeyUsage(list);
        }

        @Override
        public void addExtKeyUsage(List<String> list) {
            this.ee.addExtKeyUsage(list);
        }

        @Override
        public void actionRequest() throws PkException {
            this.runRequest();
        }

        @Override
        public PrivateKey getPrivateKey() {
            if (this.eeRun || this.ee.getPriKey() != null) {
                return this.ee.getPriKey();
            }
            return null;
        }

        @Override
        public PublicKey getPublicKey() {
            if (this.eeRun || this.ee.getPubKey() != null) {
                return this.ee.getPubKey();
            }
            return null;
        }

        @Override
        public KeyPair getKeyPair() {
            if (this.eeRun || this.ee.getKeyPair() != null) {
                return this.ee.getKeyPair();
            }
            return null;
        }

        @Override
        public X509Certificate getSignedCert() {
            if (this.eeRun) {
                return this.ee.getSignedCert();
            }
            return null;
        }

        @Override
        public X509Certificate[] getCertificateChain() {
            if (this.eeRun) {
                return this.ee.getCertificateChain();
            }
            return null;
        }

        @Override
        public void storeNewEntry(String string, String string2) throws PkException {
            if (!this.eeRun) {
                if (debug != null) {
                    debug.text(1L, this.className, "storeNewEntry", "Signed certificate not created");
                }
                throw new PkRejectionException(PkNLSConstants.EE_MISSING_CERTIFICATE);
            }
            this.ee.keyStore(PkEeFactory.keyStoreType, PkEeFactory.keystoreFilename, PkEeFactory.keystorePwd);
            this.ee.storeEntry(string, string2);
        }

        @Override
        public byte[] getPKCS10CertReq() throws PkRejectionException {
            try {
                PKCSAttribute pKCSAttribute;
                KeyUsageExtension keyUsageExtension;
                PkAttrs pkAttrs = this.ee.getAttributes();
                X500Name x500Name = (X500Name)pkAttrs.get("x509.info.subject").getValue();
                PublicKey publicKey = (PublicKey)pkAttrs.get("x509.info.key").getValue();
                String string = (String)pkAttrs.get("cert.oper.PROVIDER").getValue();
                String string2 = this.ee.signatureAlgorithm;
                CertificateExtensions certificateExtensions = new CertificateExtensions();
                if (pkAttrs.has("x509.info.extensions.KeyUsage")) {
                    keyUsageExtension = (KeyUsageExtension)pkAttrs.get("x509.info.extensions.KeyUsage").getValue();
                    certificateExtensions.set("x509.info.extensions.KeyUsage", (Object)keyUsageExtension);
                }
                if (pkAttrs.has("x509.info.extensions.ExtKeyUsage")) {
                    keyUsageExtension = (ExtKeyUsageExtension)pkAttrs.get("x509.info.extensions.ExtKeyUsage").getValue();
                    certificateExtensions.set("x509.info.extensions.ExtKeyUsage", (Object)keyUsageExtension);
                }
                if (pkAttrs.has("x509.info.extensions.SubjectAlternativeName")) {
                    keyUsageExtension = (SubjectAlternativeNameExtension)pkAttrs.get("x509.info.extensions.SubjectAlternativeName").getValue();
                    certificateExtensions.set("x509.info.extensions.SubjectAlternativeName", (Object)keyUsageExtension);
                }
                if (pkAttrs.has("x509.info.extensions.SubjectKeyIdentifier")) {
                    keyUsageExtension = (SubjectKeyIdentifierExtension)pkAttrs.get("x509.info.extensions.SubjectKeyIdentifier").getValue();
                    certificateExtensions.set("x509.info.extensions.SubjectKeyIdentifier", (Object)keyUsageExtension);
                }
                keyUsageExtension = new DerOutputStream();
                certificateExtensions.encode((OutputStream)keyUsageExtension, true);
                PKCSAttributes pKCSAttributes = null;
                if (keyUsageExtension.size() > 0) {
                    pKCSAttribute = new PKCSAttribute(PKCSOID.EXTENSION_REQUEST_OID, (Object)certificateExtensions);
                    pKCSAttributes = new PKCSAttributes(new PKCSAttribute[]{pKCSAttribute});
                }
                pKCSAttribute = new CertificationRequestInfo(x500Name, publicKey, pKCSAttributes, string);
                CertificationRequest certificationRequest = new CertificationRequest((CertificationRequestInfo)pKCSAttribute, this.ee.getPriKey(), string2, string);
                return certificationRequest.encode();
            }
            catch (IOException iOException) {
                if (debug != null) {
                    debug.exception(4L, this.className, "getPKCS10CertReq", (Throwable)iOException);
                }
                throw new PkRejectionException(PkNLSConstants.CREATE_PKCS10_FROM_CERTREQ_FAILED, iOException);
            }
            catch (CertificateException certificateException) {
                if (debug != null) {
                    debug.exception(4L, this.className, "getPKCS10CertReq", (Throwable)certificateException);
                }
                throw new PkRejectionException(PkNLSConstants.CREATE_PKCS10_FROM_CERTREQ_FAILED, certificateException);
            }
            catch (PKCSException pKCSException) {
                if (debug != null) {
                    debug.exception(4L, this.className, "getPKCS10CertReq", (Throwable)pKCSException);
                }
                throw new PkRejectionException(PkNLSConstants.CREATE_PKCS10_FROM_CERTREQ_FAILED, pKCSException);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                if (debug != null) {
                    debug.exception(4L, this.className, "getPKCS10CertReq", (Throwable)noSuchAlgorithmException);
                }
                throw new PkRejectionException(PkNLSConstants.CREATE_PKCS10_FROM_CERTREQ_FAILED, noSuchAlgorithmException);
            }
        }

        private void runRequest() throws PkException {
            try {
                String string = this.ee.getCaDn();
                int n = this.ee.getCaPort();
                if (debug != null) {
                    debug.text(1L, this.className, "runRequest", "CARA_HOST={0}", (Object)string);
                    debug.text(1L, this.className, "runRequest", "RA_CMP_PORT={0}", (Object)new Integer(n));
                }
                this.ee.readIAFile();
                PkTcpClient pkTcpClient = new PkTcpClient(string, n, PkEeFactory.getCmpFmt(), 1);
                PkConnector.connect((PkActiveSource)this.ee, new PkPipe[]{new PkEeXMgr(), pkTcpClient}).run();
                if (this.ee.getRunFailed()) {
                    throw this.ee.getRunException();
                }
                this.eeRun = true;
            }
            catch (Exception exception) {
                if (debug != null) {
                    debug.exception(4L, this.className, "runRequest()", (Throwable)exception);
                }
                throw new PkException(exception);
            }
        }
    }

    static final class PkEe
    extends PkActiveSource
    implements PkConstants {
        private String subject;
        private String refNumber;
        private String passPhrase;
        private String iafile;
        private String revoPwd;
        private String CaDn;
        private int caPort;
        private String ca_Dn;
        private KeyStore kstore;
        private int keySize;
        private int numValidDays;
        private String keyType;
        private String signatureAlgorithm;
        private boolean iskIdShortForm;
        private ArrayList<String> keyUsage = new ArrayList(10);
        private ArrayList<String> extKeyUsage = new ArrayList(10);
        private ArrayList<String> subjectAltNames = new ArrayList(5);
        private Exception runException = null;
        private boolean runFailed = false;
        private KeyPair keyPair = null;
        private PrivateKey priKey = null;
        private PublicKey pubKey = null;
        private PkAttrs attributes = null;
        private X509Certificate signedCert = null;
        private X509Certificate[] certificateChain = null;
        private static Debug debug = Debug.getInstance((String)"keycertmanage");
        private final Object className = this.toString();

        protected PkEe() {
            if (debug != null) {
                debug.text(1L, (Object)this.className.toString(), "PkEe", "Started End-Entity");
            }
        }

        protected boolean getRunFailed() {
            return this.runFailed;
        }

        protected Exception getRunException() {
            return this.runException;
        }

        protected void setSubject(String string) throws PkException {
            this.subject = string;
        }

        protected void setRevoPwd(String string) {
            this.revoPwd = string;
        }

        protected void setrefNumber(String string) {
            this.refNumber = string;
        }

        protected void setpassPhrase(String string) {
            this.passPhrase = string;
        }

        protected void setIafile(String string) throws PkException {
            this.iafile = string;
        }

        protected void setCa_Dn(String string) {
            this.ca_Dn = string != null && string.length() != 0 ? string : PkEeFactory.getCA_DN();
        }

        protected void setCaDn(String string) {
            this.CaDn = string != null && string.length() != 0 ? string : PkEeFactory.getCaDn();
        }

        protected void setCaPort(int n) {
            this.caPort = n != 0 ? n : PkEeFactory.caPort;
        }

        protected void setKeySize(int n) throws PkException {
            if ("DSA".equalsIgnoreCase(this.keyType) ? n != 512 && n != 1024 && n != 2048 : ("EC".equalsIgnoreCase(this.keyType) ? n != 192 && n != 224 && n != 256 && n != 384 && n != 521 : ("EdDSA".equalsIgnoreCase(this.keyType) ? n != 255 && n != 448 : "RSA".equalsIgnoreCase(this.keyType) && n < 512))) {
                throw new PkRejectionException(PkNLSConstants.INVALID_KEY_SIZE + n);
            }
            this.keySize = n;
        }

        protected void setValidity(int n) throws PkException {
            if (n <= 0) {
                throw new PkRejectionException(PkNLSConstants.CERT_BAD_CERT_VALIDITY + n);
            }
            this.numValidDays = n;
        }

        protected void setKeyType(String string) {
            this.keyType = string;
        }

        protected void setSignatureAlgorithm(String string) throws PkException {
            boolean bl = false;
            if ("RSA".equalsIgnoreCase(this.keyType)) {
                if (string.indexOf("RSA") < 0) {
                    bl = true;
                }
            } else if ("DSA".equalsIgnoreCase(this.keyType)) {
                if (string.indexOf("DSA") < 0) {
                    bl = true;
                }
            } else if ("EC".equalsIgnoreCase(this.keyType)) {
                if (string.indexOf("EC") < 0) {
                    bl = true;
                }
            } else if ("EdDSA".equalsIgnoreCase(this.keyType) && string.indexOf("EdDSA") < 0) {
                bl = true;
            }
            if (bl) {
                throw new PkRejectionException(PkNLSConstants.INCORRECT_SIGNATURE_ALGORITHM + string);
            }
            this.signatureAlgorithm = string;
        }

        protected void setkIdform(boolean bl) {
            this.iskIdShortForm = bl;
        }

        protected void setKeyUsage(List<String> list) {
            if (list != null && list.size() > 0) {
                this.keyUsage.addAll(list);
            }
        }

        protected void setKeyPair(KeyPair keyPair) {
            if (keyPair != null) {
                this.keyPair = keyPair;
                this.pubKey = keyPair.getPublic();
                this.priKey = keyPair.getPrivate();
            }
        }

        protected void addKeyUsage(List<String> list) {
            if (list != null && list.size() > 0) {
                for (String string : list) {
                    if (this.keyUsage.contains(string)) continue;
                    this.keyUsage.add(string);
                }
            }
        }

        protected void setExtKeyUsage(List<String> list) {
            if (list != null && list.size() > 0) {
                this.extKeyUsage.addAll(list);
            }
        }

        protected void addExtKeyUsage(List<String> list) {
            if (list != null && list.size() > 0) {
                for (String string : list) {
                    if (this.extKeyUsage.contains(string)) continue;
                    this.extKeyUsage.add(string);
                }
            }
        }

        protected void setSubjectAltNames(List<String> list) {
            if (list != null && list.size() > 0) {
                this.subjectAltNames = new ArrayList<String>(list);
            }
        }

        protected void setSubjectAltNamesClear(List<String> list) {
            this.subjectAltNames = list != null && list.size() > 0 ? new ArrayList<String>(list) : new ArrayList(4);
        }

        protected KeyPair getKeyPair() {
            return this.keyPair;
        }

        protected PublicKey getPubKey() {
            return this.pubKey;
        }

        protected PrivateKey getPriKey() {
            return this.priKey;
        }

        protected X509Certificate getSignedCert() {
            return this.signedCert;
        }

        protected X509Certificate[] getCertificateChain() {
            return this.certificateChain;
        }

        protected PkAttrs getAttributes() throws PkRejectionException {
            this.attributes = this.getAttrs();
            return this.attributes;
        }

        protected String getCa_Dn() {
            return this.ca_Dn;
        }

        protected int getCaPort() {
            return this.caPort;
        }

        protected String getCaDn() {
            return this.CaDn;
        }

        protected void storeEntry(String string, String string2) throws PkException {
            try {
                Certificate[] certificateArray = new X509Certificate[]{this.signedCert};
                this.kstore.setKeyEntry(string, this.priKey, string2.toCharArray(), certificateArray);
                FileOutputStream fileOutputStream = new FileOutputStream(PkEeFactory.keystoreFilename);
                fileOutputStream = new FileOutputStream(PkEeFactory.keystoreFilename);
                this.kstore.store(fileOutputStream, PkEeFactory.keystorePwd);
                fileOutputStream.close();
            }
            catch (Exception exception) {
                if (debug != null) {
                    debug.exception(4L, this.className, "storeEntry", (Throwable)exception);
                }
                throw new PkException(PkNLSConstants.EE_INVALID_CONFIG_KEYSTORE, exception);
            }
        }

        protected PkAttrs getAttrs() throws PkRejectionException {
            String string = this.subject;
            String string2 = this.getCa_Dn();
            String string3 = this.refNumber;
            String string4 = this.passPhrase;
            String string5 = new Long(new Date().getTime()).toString();
            long l = (long)this.numValidDays * 24L * 60L * 60L * 1000L;
            String string6 = new Long(l).toString();
            if (debug != null) {
                debug.text(1L, this.className, "makeCertReq", "issuedCertValidity {0}", (Object)string6);
            }
            PkAttrs pkAttrs = new PkAttrs();
            Key[] keyArray = null;
            if (this.keyPair == null) {
                if (debug != null) {
                    debug.text(1L, this.className, "getAttrs", "keyPair is null");
                }
                try {
                    keyArray = PkCertUtils.generateKeyPair(this.keyType, this.keySize, null);
                    this.pubKey = (PublicKey)keyArray[0];
                    this.priKey = (PrivateKey)keyArray[1];
                }
                catch (Exception exception) {
                    if (debug != null) {
                        debug.exception(4L, this.className, "getAttrs", (Throwable)exception);
                    }
                    throw new PkRejectionException(PkNLSConstants.KEY_PAIR_CREATION_FAILED, exception);
                }
            }
            JPKI jPKI = new JPKI();
            String[] stringArray = new String[]{string, string2, "3", string3, string4, string5, string6};
            try {
                String[] stringArray2 = null;
                String[] stringArray3 = null;
                String[] stringArray4 = null;
                this.subjectAltNames.trimToSize();
                this.keyUsage.trimToSize();
                this.extKeyUsage.trimToSize();
                if (this.subjectAltNames.size() > 0) {
                    stringArray2 = this.subjectAltNames.toArray(new String[0]);
                }
                if (this.keyUsage.size() > 0) {
                    stringArray3 = this.keyUsage.toArray(new String[0]);
                }
                if (this.extKeyUsage.size() > 0) {
                    stringArray4 = this.extKeyUsage.toArray(new String[0]);
                }
                pkAttrs = jPKI.initialCertRequest(stringArray, stringArray2, stringArray3, stringArray4, this.pubKey, this.priKey, this.signatureAlgorithm);
                SubjectKeyIdentifierExtension subjectKeyIdentifierExtension = null;
                byte[] byArray = PkCASetUp.computeKID(this.pubKey, this.iskIdShortForm);
                subjectKeyIdentifierExtension = new SubjectKeyIdentifierExtension(byArray);
                pkAttrs.repOrAdd("x509.info.extensions.SubjectKeyIdentifier", 3, subjectKeyIdentifierExtension);
            }
            catch (Exception exception) {
                if (debug != null) {
                    debug.exception(4L, this.className, "getAttrs", (Throwable)exception);
                }
                throw new PkRejectionException(PkNLSConstants.CREATE_CERTREQ_FAILED, exception);
            }
            return pkAttrs;
        }

        @Override
        public void run() {
            PkInitReqEvent pkInitReqEvent;
            PkCertRepEvent pkCertRepEvent = null;
            this.runFailed = false;
            this.runException = null;
            try {
                if (this.attributes == null) {
                    this.attributes = this.getAttrs();
                }
                pkInitReqEvent = new PkInitReqEvent(this, null, this.attributes);
                pkCertRepEvent = this.propagate((PkCertReqEvent)pkInitReqEvent);
            }
            catch (Exception exception) {
                this.runFailed = true;
                this.runException = exception;
                if (debug != null) {
                    debug.exception(4L, this.className, "PkEe.run", (Throwable)exception);
                }
                return;
            }
            this.signedCert = (X509Certificate)pkCertRepEvent.getCert();
            this.certificateChain = pkCertRepEvent.getCertificateChain();
            if (debug != null) {
                debug.text(1L, this.className, "PkEe.run", "propagated cert-request");
            }
            pkInitReqEvent = (PKIMessage)pkCertRepEvent.getMsg();
            PKIHeader pKIHeader = pkInitReqEvent.getHeader();
            Object[] objectArray = new Object[]{pKIHeader, this.passPhrase, this.refNumber, this.revoPwd};
            JPKI jPKI = new JPKI();
            try {
                PkConfReqEvent pkConfReqEvent = new PkConfReqEvent(this, null, jPKI.confRequest(objectArray, null));
                this.propagate(pkConfReqEvent);
            }
            catch (Exception exception) {
                this.runFailed = true;
                this.runException = exception;
                if (debug != null) {
                    debug.exception(4L, this.className, "PkEe.run", (Throwable)exception);
                }
                return;
            }
            if (debug != null) {
                debug.text(1L, this.className, "PkEe.run", "propagated conf-request");
            }
        }

        protected void keyStore(String string, String string2, char[] cArray) throws PkException {
            FileInputStream fileInputStream = null;
            this.kstore = null;
            if (cArray == null) {
                if (debug != null) {
                    debug.text(4L, this.className, "keyStore", "password cannot be null");
                }
                throw new PkException(PkNLSConstants.EE_INVALID_CONFIG_KEYSTORE);
            }
            try {
                this.kstore = KeyStore.getInstance(string, PkEeFactory.getProvider());
                try {
                    fileInputStream = new FileInputStream(string2);
                    this.kstore.load(fileInputStream, cArray);
                    fileInputStream.close();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.kstore.load(null, cArray);
                    FileOutputStream fileOutputStream = new FileOutputStream(string2);
                    this.kstore.store(fileOutputStream, cArray);
                    fileOutputStream.close();
                }
            }
            catch (GeneralSecurityException generalSecurityException) {
                if (debug != null) {
                    debug.exception(4L, this.className, "keyStore", (Throwable)generalSecurityException);
                }
                throw new PkException(generalSecurityException);
            }
            catch (IOException iOException) {
                if (debug != null) {
                    debug.exception(4L, this.className, "keyStore", (Throwable)iOException);
                }
                throw new PkException(iOException);
            }
            catch (Exception exception) {
                if (debug != null) {
                    debug.exception(4L, this.className, "keyStore", (Throwable)exception);
                }
                throw new PkException(exception);
            }
        }

        private void readIAFile() throws PkException {
            File file;
            String string = this.iafile;
            if (string == null) {
                if (debug != null) {
                    debug.text(1L, this.className, "readIAFile", "iafile cannot be null");
                }
                throw new PkException(PkNLSConstants.IA_FILE_FORMAT_FAILURE);
            }
            try {
                file = new File(string);
            }
            catch (NullPointerException nullPointerException) {
                if (debug != null) {
                    debug.exception(4L, this.className, "readIAFile", (Throwable)nullPointerException);
                }
                throw new PkException("", nullPointerException);
            }
            if (file.exists()) {
                try {
                    if (debug != null) {
                        debug.text(1L, this.className, "makeCertReq", "file found now processing");
                    }
                    BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
                    String string2 = bufferedReader.readLine();
                    this.refNumber = new String(string2);
                    this.passPhrase = new String(bufferedReader.readLine());
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    if (debug != null) {
                        debug.exception(4L, this.className, "readIAFile:" + string, (Throwable)exception);
                    }
                    throw new PkException("" + string, exception);
                }
            } else {
                if (debug != null) {
                    debug.text(4L, this.className, "readIAFile", PkNLSConstants.IA_FILE_FORMAT_FAILURE);
                }
                throw new PkException(PkNLSConstants.IA_FILE_FORMAT_FAILURE);
            }
        }
    }
}

