/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal.dom;

import com.ibm.misc.Debug;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.crypto.XMLCryptoContext;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class Utils {
    private static final Debug debug = Debug.getInstance((String)"xmldsigri");
    private static final String SECVAL_PROP_NAME = "org.jcp.xml.dsig.secureValidation";
    private static final boolean SECVAL_SYSPROP_SET;
    private static final boolean SECVAL_SYSPROP;

    private Utils() {
    }

    public static byte[] readBytesFromStream(InputStream is) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            int read;
            byte[] buf = new byte[1024];
            while ((read = is.read(buf)) != -1) {
                baos.write(buf, 0, read);
                if (read >= 1024) continue;
                break;
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    static Set<Node> toNodeSet(Iterator<?> i) {
        HashSet<Node> nodeSet = new HashSet<Node>();
        while (i.hasNext()) {
            Node n = (Node)i.next();
            nodeSet.add(n);
            if (n.getNodeType() != 1) continue;
            NamedNodeMap nnm = n.getAttributes();
            int length = nnm.getLength();
            for (int j = 0; j < length; ++j) {
                nodeSet.add(nnm.item(j));
            }
        }
        return nodeSet;
    }

    public static String parseIdFromSameDocumentURI(String uri) {
        if (uri.length() == 0) {
            return null;
        }
        String id = uri.substring(1);
        if (id.startsWith("xpointer(id(")) {
            int i1 = id.indexOf(39);
            int i2 = id.indexOf(39, i1 + 1);
            if (i1 >= 0 && i2 >= 0) {
                id = id.substring(i1 + 1, i2);
            }
        }
        return id;
    }

    public static boolean sameDocumentURI(String uri) {
        return uri != null && (uri.length() == 0 || uri.charAt(0) == '#');
    }

    private static String privilegedGetProperty(String theProp) {
        if (System.getSecurityManager() == null) {
            return System.getProperty(theProp);
        }
        return AccessController.doPrivileged(() -> System.getProperty(theProp));
    }

    static boolean secureValidation(XMLCryptoContext xc) {
        if (SECVAL_SYSPROP_SET) {
            return SECVAL_SYSPROP;
        }
        if (xc == null) {
            return false;
        }
        return Utils.getBoolean(xc, SECVAL_PROP_NAME);
    }

    private static boolean getBoolean(XMLCryptoContext xc, String name) {
        Boolean value = (Boolean)xc.getProperty(name);
        return value != null && value != false;
    }

    static {
        String sysProp = Utils.privilegedGetProperty(SECVAL_PROP_NAME);
        SECVAL_SYSPROP_SET = sysProp != null;
        SECVAL_SYSPROP = Boolean.parseBoolean(sysProp);
        if (SECVAL_SYSPROP_SET && !SECVAL_SYSPROP && debug != null) {
            System.out.println("DOMSignatureMethod.java:  verify():  Secure validation mode disabled");
        }
    }
}

