/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal.dom;

import com.ibm.misc.Debug;
import com.sun.org.apache.xml.internal.security.algorithms.implementations.SignatureBaseRSA;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureException;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import ibm.security.internal.spec.RSAPSSParameterSpec;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.XMLSignContext;
import javax.xml.crypto.dsig.XMLValidateContext;
import javax.xml.crypto.dsig.spec.SignatureMethodParameterSpec;
import org.jcp.xml.dsig.internal.SignerOutputStream;
import org.jcp.xml.dsig.internal.dom.AbstractDOMSignatureMethod;
import org.jcp.xml.dsig.internal.dom.DOMSignedInfo;
import org.jcp.xml.dsig.internal.dom.DOMUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public abstract class DOMRSAPSSSignatureMethod
extends AbstractDOMSignatureMethod {
    private static final String DOM_SIGNATURE_PROVIDER = "org.jcp.xml.dsig.internal.dom.SignatureProvider";
    private static final Debug debug = Debug.getInstance((String)"xmldsigri");
    private final SignatureMethodParameterSpec params;
    private Signature signature;
    static final String RSA_PSS = "http://www.w3.org/2007/05/xmldsig-more#rsa-pss";
    private static final RSAPSSParameterSpec DEFAULT_PSS_SPEC = new RSAPSSParameterSpec(new PSSParameterSpec("SHA-256", "MGF1", new MGF1ParameterSpec("SHA-256"), 32, 1));
    private PSSParameterSpec spec;
    public static final String _TAG_MGF = "MaskGenerationFunction";

    DOMRSAPSSSignatureMethod(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        if (params != null && !(params instanceof SignatureMethodParameterSpec)) {
            throw new InvalidAlgorithmParameterException("params must be of type SignatureMethodParameterSpec");
        }
        if (params == null) {
            params = DEFAULT_PSS_SPEC;
        }
        this.checkParams((SignatureMethodParameterSpec)params);
        this.params = (SignatureMethodParameterSpec)params;
    }

    DOMRSAPSSSignatureMethod(Element smElem) throws MarshalException {
        Element paramsElem = DOMUtils.getFirstChildElement(smElem);
        this.params = paramsElem != null ? this.unmarshalParams(paramsElem) : DEFAULT_PSS_SPEC;
        try {
            this.checkParams(this.params);
        }
        catch (InvalidAlgorithmParameterException iape) {
            throw new MarshalException(iape);
        }
    }

    @Override
    void checkParams(SignatureMethodParameterSpec params) throws InvalidAlgorithmParameterException {
        if (!(params instanceof RSAPSSParameterSpec)) {
            throw new InvalidAlgorithmParameterException("params must be of type RSAPSSParameterSpec");
        }
        this.spec = ((RSAPSSParameterSpec)params).getPSSParameterSpec();
        if (debug != null) {
            System.out.println("DOMRSAPSSSignatureMethod.java:  verify():  Setting RSAPSSParameterSpec to:   " + params.toString());
        }
    }

    @Override
    public final AlgorithmParameterSpec getParameterSpec() {
        return this.params;
    }

    @Override
    void marshalParams(Element parent, String prefix) throws MarshalException {
        Element rsaPssParamsElement;
        block11: {
            SignatureBaseRSA.SignatureRSASSAPSS.DigestAlgorithm digestAlgorithm;
            Document ownerDoc = DOMUtils.getOwnerDocument(parent);
            rsaPssParamsElement = ownerDoc.createElementNS("http://www.w3.org/2007/05/xmldsig-more#", "pss:RSAPSSParams");
            rsaPssParamsElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:pss", "http://www.w3.org/2007/05/xmldsig-more#");
            try {
                digestAlgorithm = SignatureBaseRSA.SignatureRSASSAPSS.DigestAlgorithm.fromDigestAlgorithm(this.spec.getDigestAlgorithm());
                String xmlDigestAlgorithm = digestAlgorithm.getXmlDigestAlgorithm();
                if (!xmlDigestAlgorithm.equals("http://www.w3.org/2001/04/xmlenc#sha256")) {
                    Element digestMethodElement = DOMUtils.createElement(rsaPssParamsElement.getOwnerDocument(), "DigestMethod", "http://www.w3.org/2000/09/xmldsig#", prefix);
                    digestMethodElement.setAttributeNS(null, "Algorithm", xmlDigestAlgorithm);
                    rsaPssParamsElement.appendChild(digestMethodElement);
                }
                if (this.spec.getSaltLength() != digestAlgorithm.getSaltLength()) {
                    Element saltLengthElement = rsaPssParamsElement.getOwnerDocument().createElementNS("http://www.w3.org/2007/05/xmldsig-more#", "pss:SaltLength");
                    Text saltLengthText = rsaPssParamsElement.getOwnerDocument().createTextNode(String.valueOf(this.spec.getSaltLength()));
                    saltLengthElement.appendChild(saltLengthText);
                    rsaPssParamsElement.appendChild(saltLengthElement);
                }
            }
            catch (XMLSignatureException | DOMException e) {
                throw new MarshalException("Invalid digest name supplied: " + this.spec.getDigestAlgorithm());
            }
            if (!this.spec.getMGFAlgorithm().equals("MGF1")) {
                throw new MarshalException("Unsupported MGF algorithm supplied: " + this.spec.getMGFAlgorithm());
            }
            MGF1ParameterSpec mgfSpec = (MGF1ParameterSpec)this.spec.getMGFParameters();
            try {
                SignatureBaseRSA.SignatureRSASSAPSS.DigestAlgorithm mgfDigestAlgorithm = SignatureBaseRSA.SignatureRSASSAPSS.DigestAlgorithm.fromDigestAlgorithm(mgfSpec.getDigestAlgorithm());
                if (mgfDigestAlgorithm == digestAlgorithm) break block11;
                Element mgfElement = rsaPssParamsElement.getOwnerDocument().createElementNS("http://www.w3.org/2007/05/xmldsig-more#", "pss:MaskGenerationFunction");
                try {
                    mgfElement.setAttributeNS(null, "Algorithm", "http://www.w3.org/2007/05/xmldsig-more#MGF1");
                }
                catch (DOMException e) {
                    throw new MarshalException("Should not happen");
                }
                Element mgfDigestMethodElement = DOMUtils.createElement(rsaPssParamsElement.getOwnerDocument(), "DigestMethod", "http://www.w3.org/2000/09/xmldsig#", prefix);
                String xmlDigestAlgorithm = mgfDigestAlgorithm.getXmlDigestAlgorithm();
                mgfDigestMethodElement.setAttributeNS(null, "Algorithm", xmlDigestAlgorithm);
                mgfElement.appendChild(mgfDigestMethodElement);
                rsaPssParamsElement.appendChild(mgfElement);
            }
            catch (XMLSignatureException | DOMException e) {
                throw new MarshalException("Invalid digest name supplied: " + mgfSpec.getDigestAlgorithm());
            }
        }
        if (this.spec.getTrailerField() != 1) {
            Element trailerFieldElement = rsaPssParamsElement.getOwnerDocument().createElementNS("http://www.w3.org/2007/05/xmldsig-more#", "pss:TrailerField");
            Text trailerFieldText = rsaPssParamsElement.getOwnerDocument().createTextNode(String.valueOf(this.spec.getTrailerField()));
            trailerFieldElement.appendChild(trailerFieldText);
            rsaPssParamsElement.appendChild(trailerFieldElement);
        }
        if (rsaPssParamsElement.hasChildNodes()) {
            parent.appendChild(rsaPssParamsElement);
        }
    }

    private static SignatureBaseRSA.SignatureRSASSAPSS.DigestAlgorithm validateDigestAlgorithm(String input) throws MarshalException {
        try {
            return SignatureBaseRSA.SignatureRSASSAPSS.DigestAlgorithm.fromXmlDigestAlgorithm(input);
        }
        catch (XMLSignatureException e) {
            throw new MarshalException("Invalid digest algorithm supplied: " + input);
        }
    }

    @Override
    SignatureMethodParameterSpec unmarshalParams(Element paramsElem) throws MarshalException {
        if (paramsElem != null) {
            int trailerField;
            int saltLength;
            SignatureBaseRSA.SignatureRSASSAPSS.DigestAlgorithm digestAlgorithm;
            Element saltLengthNode = XMLUtils.selectNode(paramsElem.getFirstChild(), "http://www.w3.org/2007/05/xmldsig-more#", "SaltLength", 0);
            Element trailerFieldNode = XMLUtils.selectNode(paramsElem.getFirstChild(), "http://www.w3.org/2007/05/xmldsig-more#", "TrailerField", 0);
            Element digestAlgorithmNode = XMLUtils.selectDsNode(paramsElem.getFirstChild(), "DigestMethod", 0);
            Element mgfNode = XMLUtils.selectNode(paramsElem.getFirstChild(), "http://www.w3.org/2007/05/xmldsig-more#", _TAG_MGF, 0);
            SignatureBaseRSA.SignatureRSASSAPSS.DigestAlgorithm mgfDigestAlgorithm = digestAlgorithm = digestAlgorithmNode != null ? DOMRSAPSSSignatureMethod.validateDigestAlgorithm(digestAlgorithmNode.getAttribute("Algorithm")) : SignatureBaseRSA.SignatureRSASSAPSS.DigestAlgorithm.SHA256;
            if (mgfNode != null) {
                String mgfAlgorithm = mgfNode.getAttribute("Algorithm");
                if (!mgfAlgorithm.equals("http://www.w3.org/2007/05/xmldsig-more#MGF1")) {
                    throw new MarshalException("Unknown MGF algorithm: " + mgfAlgorithm);
                }
                Element mgfDigestAlgorithmNode = XMLUtils.selectDsNode(mgfNode.getFirstChild(), "DigestMethod", 0);
                if (mgfDigestAlgorithmNode != null) {
                    mgfDigestAlgorithm = DOMRSAPSSSignatureMethod.validateDigestAlgorithm(mgfDigestAlgorithmNode.getAttribute("Algorithm"));
                }
            }
            try {
                saltLength = saltLengthNode == null ? digestAlgorithm.getSaltLength() : Integer.parseUnsignedInt(saltLengthNode.getTextContent());
            }
            catch (NumberFormatException ex) {
                throw new MarshalException("Invalid salt length supplied: " + saltLengthNode.getTextContent());
            }
            try {
                trailerField = trailerFieldNode == null ? 1 : Integer.parseUnsignedInt(trailerFieldNode.getTextContent());
            }
            catch (NumberFormatException ex) {
                throw new MarshalException("Invalid trailer field supplied: " + trailerFieldNode.getTextContent());
            }
            return new RSAPSSParameterSpec(new PSSParameterSpec(digestAlgorithm.getDigestAlgorithm(), "MGF1", new MGF1ParameterSpec(mgfDigestAlgorithm.getDigestAlgorithm()), saltLength, trailerField));
        }
        return DEFAULT_PSS_SPEC;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    boolean verify(Key key, SignedInfo si, byte[] sig, XMLValidateContext context) throws InvalidKeyException, SignatureException, javax.xml.crypto.dsig.XMLSignatureException {
        if (key == null) throw new NullPointerException();
        if (si == null) throw new NullPointerException();
        if (sig == null) {
            throw new NullPointerException();
        }
        if (!(key instanceof PublicKey)) {
            throw new InvalidKeyException("key must be PublicKey");
        }
        if (this.signature == null) {
            try {
                Provider p = (Provider)context.getProperty(DOM_SIGNATURE_PROVIDER);
                this.signature = p == null ? Signature.getInstance(this.getJCAAlgorithm()) : Signature.getInstance(this.getJCAAlgorithm(), p);
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new javax.xml.crypto.dsig.XMLSignatureException(nsae);
            }
        }
        this.signature.initVerify((PublicKey)key);
        try {
            this.signature.setParameter(this.spec);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new javax.xml.crypto.dsig.XMLSignatureException(e);
        }
        if (debug != null) {
            System.out.println("DOMRSAPSSSignatureMethod.java:  verify():  Signature provider:      " + this.signature.getProvider());
            System.out.println("DOMRSAPSSSignatureMethod.java:  verify():  Verifying with key:      " + key);
            System.out.println("DOMRSAPSSSignatureMethod.java:  verify():  JCA Algorithm:           " + this.getJCAAlgorithm());
            System.out.println("DOMRSAPSSSignatureMethod.java:  verify():  Signature Bytes length:  " + sig.length);
        }
        try (SignerOutputStream outputStream = new SignerOutputStream(this.signature);){
            ((DOMSignedInfo)si).canonicalize(context, outputStream);
            boolean bl = this.signature.verify(sig);
            return bl;
        }
        catch (IOException ioe) {
            throw new javax.xml.crypto.dsig.XMLSignatureException(ioe);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    byte[] sign(Key key, SignedInfo si, XMLSignContext context) throws InvalidKeyException, javax.xml.crypto.dsig.XMLSignatureException {
        if (key == null) throw new NullPointerException();
        if (si == null) {
            throw new NullPointerException();
        }
        if (!(key instanceof PrivateKey)) {
            throw new InvalidKeyException("key must be PrivateKey");
        }
        if (this.signature == null) {
            try {
                Provider p = (Provider)context.getProperty(DOM_SIGNATURE_PROVIDER);
                this.signature = p == null ? Signature.getInstance(this.getJCAAlgorithm()) : Signature.getInstance(this.getJCAAlgorithm(), p);
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new javax.xml.crypto.dsig.XMLSignatureException(nsae);
            }
        }
        this.signature.initSign((PrivateKey)key);
        try {
            this.signature.setParameter(this.spec);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new javax.xml.crypto.dsig.XMLSignatureException(e);
        }
        if (debug != null) {
            System.out.println("DOMRSAPSSSignatureMethod.java:  verify():  Signature provider:  " + this.signature.getProvider());
            System.out.println("DOMRSAPSSSignatureMethod.java:  verify():  JCA Algorithm:       " + this.getJCAAlgorithm());
        }
        try (SignerOutputStream outputStream = new SignerOutputStream(this.signature);){
            ((DOMSignedInfo)si).canonicalize(context, outputStream);
            byte[] byArray = this.signature.sign();
            return byArray;
        }
        catch (IOException | SignatureException e) {
            throw new javax.xml.crypto.dsig.XMLSignatureException(e);
        }
    }

    @Override
    boolean paramsEqual(AlgorithmParameterSpec spec) {
        return this.getParameterSpec().equals(spec);
    }

    static final class RSAPSS
    extends DOMRSAPSSSignatureMethod {
        RSAPSS(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
            super(params);
        }

        RSAPSS(Element dmElem) throws MarshalException {
            super(dmElem);
        }

        @Override
        public String getAlgorithm() {
            return DOMRSAPSSSignatureMethod.RSA_PSS;
        }

        @Override
        String getJCAAlgorithm() {
            return "RSASSA-PSS";
        }

        @Override
        AbstractDOMSignatureMethod.Type getAlgorithmType() {
            return AbstractDOMSignatureMethod.Type.RSA;
        }
    }
}

