/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcp.channel.impl;

import com.ibm.nws.ejs.ras.Tr;
import com.ibm.nws.ejs.ras.TraceComponent;
import com.ibm.nws.ffdc.FFDCFilter;
import com.ibm.ws.tcp.channel.impl.ChannelTermination;
import com.ibm.ws.tcp.channel.impl.NioTCPChannel;
import com.ibm.ws.tcp.channel.impl.TCPChannel;
import com.ibm.ws.tcp.channel.impl.TCPChannelConfiguration;
import com.ibm.ws.tcp.channel.impl.TCPChannelDiagnosticModule;
import com.ibm.ws.tcp.channel.impl.TCPFactoryConfiguration;
import com.ibm.wsspi.channel.Channel;
import com.ibm.wsspi.channel.base.ConnectorChannelFactory;
import com.ibm.wsspi.channel.framework.ChannelData;
import com.ibm.wsspi.channel.framework.ChannelFactoryData;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import com.ibm.wsspi.channel.framework.exception.ChannelFactoryException;
import com.ibm.wsspi.channel.ws390.CrossRegionSharable;
import com.ibm.wsspi.runtime.ThreadPool;
import com.ibm.wsspi.runtime.ThreadPoolAlreadyKnownException;
import com.ibm.wsspi.runtime.ThreadPoolRepository;
import com.ibm.wsspi.runtime.ThreadPoolRepositoryManager;
import com.ibm.wsspi.tcp.channel.TCPConnectionContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class TCPChannelFactory
extends ConnectorChannelFactory
implements CrossRegionSharable {
    private Class appSideClass = null;
    private static TCPChannelFactory thisRef = null;
    private ThreadPoolRepository threadPoolSource = null;
    static final TraceComponent tc = Tr.register(TCPChannelFactory.class, "TCPChannel", "com.ibm.ws.tcp.channel.resources.tcpchannelmessages");
    private Hashtable terminationList = new Hashtable();
    private ChannelTermination oChannelTermination = null;
    private static String commClassName = null;
    private static Class commClass = null;

    public TCPChannelFactory() {
        this.appSideClass = TCPConnectionContext.class;
    }

    public boolean isSharable(Map map) {
        return false;
    }

    public void init(ChannelFactoryData channelFactoryData) throws ChannelFactoryException {
        thisRef = this;
        TCPChannelDiagnosticModule.instance();
        this.threadPoolSource = ThreadPoolRepositoryManager.getThreadPoolRepository();
        new TCPFactoryConfiguration(channelFactoryData.getProperties());
        commClassName = TCPFactoryConfiguration.getCommClass();
        if (commClassName != null) {
            LoadReturn loadReturn;
            PrivilegedAction privilegedAction;
            boolean bl = false;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader != null) {
                privilegedAction = new StartPrivilegedThread(commClassName, classLoader);
                loadReturn = (LoadReturn)AccessController.doPrivileged(privilegedAction);
                if (loadReturn.ex == null) {
                    commClass = loadReturn.cs;
                    bl = true;
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "load of CommClass: " + TCPFactoryConfiguration.getCommClass() + " using context class loader failed with exception " + loadReturn.ex.getMessage());
                    }
                    FFDCFilter.processException((Throwable)loadReturn.ex, "com.ibm.ws.tcp.channel.impl.TCPChannelFactory", "132", this);
                }
            }
            if (!bl) {
                privilegedAction = new StartPrivilegedThread2(commClassName);
                loadReturn = (LoadReturn)AccessController.doPrivileged(privilegedAction);
                if (loadReturn.ex == null) {
                    commClass = loadReturn.cs;
                    bl = true;
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "load of CommClass: " + TCPFactoryConfiguration.getCommClass() + " using default class loader failed with exception " + loadReturn.ex.getMessage());
                    }
                    FFDCFilter.processException((Throwable)loadReturn.ex, "com.ibm.ws.tcp.channel.impl.TCPChannelFactory", "144", this);
                }
            }
        }
    }

    public void updateProperties(Map map) {
        this.commonProperties = map;
        try {
            new TCPFactoryConfiguration(map);
        }
        catch (ChannelFactoryException channelFactoryException) {
            Tr.debug(tc, "Unable to consume property updates");
        }
    }

    protected static TCPChannelFactory getRef() {
        return thisRef;
    }

    protected Channel createChannel(ChannelData channelData) throws ChannelException {
        boolean bl;
        TCPChannel tCPChannel;
        TCPChannelConfiguration tCPChannelConfiguration;
        block10: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "createChannel");
            }
            tCPChannelConfiguration = new TCPChannelConfiguration(channelData);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                tCPChannelConfiguration.outputConfigToTrace();
            }
            tCPChannel = null;
            bl = false;
            if (!tCPChannelConfiguration.isNIOOnly() && commClass != null) {
                try {
                    tCPChannel = (TCPChannel)commClass.newInstance();
                    this.oChannelTermination = tCPChannel.setup(channelData, tCPChannelConfiguration, this);
                    if (this.oChannelTermination != null) {
                        this.terminationList.put(commClassName, this.oChannelTermination);
                    }
                    bl = true;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "using CommClass: " + commClass);
                    }
                }
                catch (Exception exception) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block10;
                    Tr.debug(tc, "Exception trying to instantiate CommClass: " + exception);
                }
            }
        }
        if (!bl) {
            tCPChannel = new NioTCPChannel();
            this.oChannelTermination = tCPChannel.setup(channelData, tCPChannelConfiguration, this);
            if (this.oChannelTermination != null) {
                this.terminationList.put("NioTCPChannel", this.oChannelTermination);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "createChannel");
        }
        return tCPChannel;
    }

    public Class getApplicationInterface() {
        return this.appSideClass;
    }

    public void destroy() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "destroy");
        }
        ChannelTermination channelTermination = null;
        Set set = this.terminationList.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            channelTermination = (ChannelTermination)this.terminationList.get(k);
            if (channelTermination == null) continue;
            channelTermination.terminate();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "destroy");
        }
    }

    protected ThreadPool createNewThreadPool(String string, int n) {
        ThreadPool threadPool = null;
        try {
            threadPool = this.threadPoolSource.createThreadPool(string, n, n);
        }
        catch (ThreadPoolAlreadyKnownException threadPoolAlreadyKnownException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "createThreadPool threw ThreadPoolAlreadyKnownException: " + threadPoolAlreadyKnownException);
            }
            FFDCFilter.processException((Throwable)threadPoolAlreadyKnownException, "com.ibm.ws.tcp.channel.impl.TCPChannelFactory", "290", this);
        }
        return threadPool;
    }

    class StartPrivilegedThread2
    implements PrivilegedAction {
        String name = null;

        public StartPrivilegedThread2(String string) {
            this.name = string;
        }

        public Object run() {
            LoadReturn loadReturn = new LoadReturn();
            try {
                loadReturn.cs = Class.forName(this.name);
            }
            catch (Exception exception) {
                loadReturn.ex = exception;
            }
            return loadReturn;
        }
    }

    class StartPrivilegedThread
    implements PrivilegedAction {
        String name = null;
        ClassLoader cl = null;

        public StartPrivilegedThread(String string, ClassLoader classLoader) {
            this.name = string;
            this.cl = classLoader;
        }

        public Object run() {
            LoadReturn loadReturn = new LoadReturn();
            try {
                loadReturn.cs = this.cl.loadClass(this.name);
            }
            catch (Exception exception) {
                loadReturn.ex = exception;
            }
            return loadReturn;
        }
    }

    public class LoadReturn {
        public Exception ex = null;
        public Class cs = null;
    }
}

