/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.util;

import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException$ExceptionReason;
import com.ibm.gsk.ikeyman.util.Debug;
import com.ibm.gsk.ikeyman.util.KeymanSettings$Setting;
import com.ibm.gsk.ikeyman.util.LogFileFilter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclEntryPermission;
import java.nio.file.attribute.AclEntryType;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.PosixFilePermissions;
import java.nio.file.attribute.UserPrincipal;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FilePermissions {
    static Set ownerPermissions = null;
    static Set groupPermissions = null;
    static Set othersPermissions = null;
    static String permissions = KeymanSettings$Setting.DefaulFileCreatePermission.getString().toLowerCase();

    public static void setFilePermissions(File file) throws KeyManagerException {
        if (!permissions.equals("") && file.exists()) {
            try {
                Files.setPosixFilePermissions(file.toPath(), PosixFilePermissions.fromString(permissions));
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
            }
            catch (NoSuchMethodError noSuchMethodError) {
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                if (permissions.startsWith("rw")) {
                    try {
                        FilePermissions.initACLsFromString(permissions);
                        FilePermissions.setACL(file.toPath(), permissions);
                    }
                    catch (IOException iOException) {
                        throw new KeyManagerException(KeyManagerException$ExceptionReason.UNSUPPORTED_CALLBACK, new String[]{iOException.getMessage()});
                    }
                }
                Debug.log("Unsupported or invalid permissions setting: " + permissions, new Object[0]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new KeyManagerException(KeyManagerException$ExceptionReason.UNSUPPORTED_CALLBACK, new String[]{"Wrong permission string: " + permissions + ", permissions must be in format: rwxrwxrwx"});
            }
            catch (IOException iOException) {
                throw new KeyManagerException(KeyManagerException$ExceptionReason.UNSUPPORTED_CALLBACK, new String[]{iOException.getMessage()});
            }
        }
    }

    public static void setFilePermissions(String string) throws KeyManagerException {
        FilePermissions.setFilePermissions(new File(string));
    }

    public static void setLogFilePermissions() {
        String[] stringArray;
        File file = new File(Debug.getCurrentDir());
        for (String string : stringArray = file.list(new LogFileFilter())) {
            try {
                FilePermissions.setFilePermissions(new File(string));
            }
            catch (KeyManagerException keyManagerException) {
                // empty catch block
            }
        }
    }

    private static void setACL(Path path, String string) throws IOException {
        FilePermissions.setOwnerACL(path, string);
    }

    private static void setOwnerACL(Path path, String string) throws IOException {
        UserPrincipal userPrincipal = path.getFileSystem().getUserPrincipalLookupService().lookupPrincipalByName(System.getProperty("user.name", "unknown"));
        AclFileAttributeView aclFileAttributeView = Files.getFileAttributeView(path, AclFileAttributeView.class, new LinkOption[0]);
        AclEntry aclEntry = AclEntry.newBuilder().setType(AclEntryType.ALLOW).setPrincipal(userPrincipal).setPermissions(ownerPermissions).build();
        List<AclEntry> list = aclFileAttributeView.getAcl();
        list.clear();
        list.add(aclEntry);
        aclFileAttributeView.setAcl(list);
    }

    private static void initACLsFromString(String string) {
        if (ownerPermissions != null) {
            return;
        }
        char[] cArray = string.toCharArray();
        ownerPermissions = new HashSet();
        if (cArray.length > 0 && cArray[0] == 'r') {
            ownerPermissions.add(AclEntryPermission.READ_ACL);
            ownerPermissions.add(AclEntryPermission.READ_DATA);
            ownerPermissions.add(AclEntryPermission.READ_ATTRIBUTES);
            ownerPermissions.add(AclEntryPermission.READ_NAMED_ATTRS);
        }
        if (cArray.length > 1 && cArray[1] == 'w') {
            ownerPermissions.add(AclEntryPermission.APPEND_DATA);
            ownerPermissions.add(AclEntryPermission.DELETE);
            ownerPermissions.add(AclEntryPermission.SYNCHRONIZE);
            ownerPermissions.add(AclEntryPermission.WRITE_ACL);
            ownerPermissions.add(AclEntryPermission.WRITE_ATTRIBUTES);
            ownerPermissions.add(AclEntryPermission.WRITE_NAMED_ATTRS);
            ownerPermissions.add(AclEntryPermission.WRITE_OWNER);
            ownerPermissions.add(AclEntryPermission.WRITE_DATA);
        }
        if (cArray.length > 2 && cArray[2] == 'x') {
            ownerPermissions.add(AclEntryPermission.EXECUTE);
        }
        groupPermissions = new HashSet();
        if (cArray.length > 3 && cArray[3] == 'r') {
            groupPermissions.add(AclEntryPermission.READ_ACL);
            groupPermissions.add(AclEntryPermission.READ_DATA);
            groupPermissions.add(AclEntryPermission.READ_ATTRIBUTES);
            groupPermissions.add(AclEntryPermission.READ_NAMED_ATTRS);
        }
        if (cArray.length > 4 && cArray[4] == 'w') {
            groupPermissions.add(AclEntryPermission.APPEND_DATA);
            groupPermissions.add(AclEntryPermission.DELETE);
            groupPermissions.add(AclEntryPermission.SYNCHRONIZE);
            groupPermissions.add(AclEntryPermission.WRITE_ACL);
            groupPermissions.add(AclEntryPermission.WRITE_ATTRIBUTES);
            groupPermissions.add(AclEntryPermission.WRITE_NAMED_ATTRS);
            groupPermissions.add(AclEntryPermission.WRITE_OWNER);
            groupPermissions.add(AclEntryPermission.WRITE_DATA);
        }
        if (cArray.length > 5 && cArray[5] == 'x') {
            groupPermissions.add(AclEntryPermission.EXECUTE);
        }
        othersPermissions = new HashSet();
        if (cArray.length > 6 && cArray[6] == 'r') {
            othersPermissions.add(AclEntryPermission.READ_ACL);
            othersPermissions.add(AclEntryPermission.READ_DATA);
            othersPermissions.add(AclEntryPermission.READ_ATTRIBUTES);
            othersPermissions.add(AclEntryPermission.READ_NAMED_ATTRS);
        }
        if (cArray.length > 7 && cArray[7] == 'w') {
            othersPermissions.add(AclEntryPermission.APPEND_DATA);
            othersPermissions.add(AclEntryPermission.DELETE);
            othersPermissions.add(AclEntryPermission.SYNCHRONIZE);
            othersPermissions.add(AclEntryPermission.WRITE_ACL);
            othersPermissions.add(AclEntryPermission.WRITE_ATTRIBUTES);
            othersPermissions.add(AclEntryPermission.WRITE_NAMED_ATTRS);
            othersPermissions.add(AclEntryPermission.WRITE_OWNER);
            othersPermissions.add(AclEntryPermission.WRITE_DATA);
        }
        if (cArray.length > 8 && cArray[8] == 'x') {
            othersPermissions.add(AclEntryPermission.EXECUTE);
        }
    }

    public static void main(String[] stringArray) {
        String string = System.getProperty("os.name");
        String string2 = null;
        string2 = string.startsWith("Windows") ? "C:/ikeymantest.txt" : "/ikeymantest.txt";
        System.out.println("====== Creating File: " + string2 + " =========");
        File file = new File(string2);
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(new FileOutputStream(file));
            outputStreamWriter.write("========Test String=====");
            ((Writer)outputStreamWriter).close();
            FilePermissions.setFilePermissions(file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (KeyManagerException keyManagerException) {
            keyManagerException.printStackTrace();
        }
        System.out.println("====== All done =========");
    }
}

