/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.gui;

import com.ibm.gsk.ikeyman.gui.CenteredDialog$1;
import com.ibm.gsk.ikeyman.gui.GUIConstants$Actions;
import com.ibm.gsk.ikeyman.gui.GUIConstants$DialogResult;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JDialog;
import javax.swing.JMenu;

public abstract class CenteredDialog
extends JDialog
implements ActionListener,
ContainerListener {
    private GUIConstants$DialogResult result = GUIConstants$DialogResult.Cancel;
    private KeyListener keyListener = new CenteredDialog$1(this);

    public CenteredDialog(Frame frame) {
        super(frame);
        this.getContentPane().addContainerListener(this);
    }

    public CenteredDialog(Frame frame, String string) {
        super(frame, string);
        this.getContentPane().addContainerListener(this);
    }

    protected void setDialogResult(GUIConstants$DialogResult gUIConstants$DialogResult) {
        this.result = gUIConstants$DialogResult;
    }

    protected GUIConstants$DialogResult getDialogResult() {
        return this.result;
    }

    protected void centerToParent() {
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getParent().getSize();
        Point point = this.getParent().getLocation();
        int n = Math.max(0, point.x + (dimension2.width - dimension.width) / 2);
        int n2 = Math.max(0, point.y + (dimension2.height - dimension.height) / 2);
        this.setLocation(n, n2);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals(GUIConstants$Actions.OK.toString())) {
            this.okHandler();
        } else if (actionEvent.getActionCommand().equals(GUIConstants$Actions.Cancel.toString())) {
            this.cancelHandler();
        } else if (actionEvent.getActionCommand().equals(GUIConstants$Actions.Reset.toString())) {
            this.resetHandler();
        }
    }

    private void cancelHandler() {
        this.result = GUIConstants$DialogResult.Cancel;
        this.setVisible(false);
    }

    protected abstract void okHandler();

    protected abstract void resetHandler();

    public void componentAdded(ContainerEvent containerEvent) {
        containerEvent.getComponent().addKeyListener(this.keyListener);
    }

    public void componentRemoved(ContainerEvent containerEvent) {
        containerEvent.getComponent().removeKeyListener(this.keyListener);
    }

    public void setContentPane(Container container) {
        this.getContentPane().removeContainerListener(this);
        container.addContainerListener(this);
        ArrayList arrayList = new ArrayList();
        CenteredDialog.getAllComponents(container, arrayList);
        for (Component component : arrayList) {
            component.addKeyListener(this.keyListener);
        }
        super.setContentPane(container);
    }

    private static void getAllComponents(Component component, Collection collection) {
        block3: {
            block2: {
                collection.add(component);
                if (!(component instanceof JMenu)) break block2;
                for (Component component2 : ((JMenu)component).getMenuComponents()) {
                    CenteredDialog.getAllComponents(component2, collection);
                }
                break block3;
            }
            if (!(component instanceof Container)) break block3;
            for (Component component3 : ((Container)component).getComponents()) {
                CenteredDialog.getAllComponents(component3, collection);
            }
        }
    }

    static void access$000(CenteredDialog centeredDialog) {
        centeredDialog.cancelHandler();
    }
}

