/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.certrequest.cmscertrequest;

import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.BadFileTypeException;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.BadMagicNumberException;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.BadRecordFlagException;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.BadVersionNumberException;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.FileHeader;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.FileHeaderFactory;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.RequestDatabase;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.RequestDatabaseFactory$RequestDatabaseImpl;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.RequestRecord;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.RequestRecordFactory;
import com.ibm.gsk.ikeyman.sequence.SequenceFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;

final class RequestDatabaseFactory {
    private RequestDatabaseFactory() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public static RequestDatabase newRequestDatabase(InputStream inputStream) throws NullPointerException, BadMagicNumberException, BadVersionNumberException, BadFileTypeException, BadRecordFlagException, IOException {
        if (inputStream == null) {
            throw new NullPointerException();
        }
        FileHeader fileHeader = FileHeaderFactory.newFileHeader(inputStream);
        if (fileHeader == null) {
            return null;
        }
        LinkedList<RequestRecord> linkedList = new LinkedList<RequestRecord>();
        int n = fileHeader.getRecordsAllocated().toInt();
        for (int i = 0; i < n; ++i) {
            RequestRecord requestRecord = RequestRecordFactory.newRequestRecord(inputStream, fileHeader.getFixedRecordLength().toInt());
            if (requestRecord == null) {
                return null;
            }
            linkedList.add(requestRecord);
        }
        return new RequestDatabaseFactory$RequestDatabaseImpl(fileHeader, SequenceFactory.newSequence(linkedList));
    }
}

