/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.certrequest.cmscertrequest;

import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.FileHeader;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.FileHeaderHashGenerator;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.FileHeaderHashGeneratorFactory$1;
import com.ibm.gsk.ikeyman.sequence.bytes.ByteSequence;
import com.ibm.gsk.ikeyman.sequence.bytes.ByteSequenceFactory;
import com.ibm.gsk.ikeyman.sequence.bytes.ByteSequenceIterator;
import com.ibm.security.cmskeystore.NonPrintableAsciiPBEKey;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.KeySpec;
import javax.crypto.Mac;
import javax.crypto.spec.PBEKeySpec;

final class FileHeaderHashGeneratorFactory$FileHeaderHashGeneratorV4Impl
implements FileHeaderHashGenerator {
    private FileHeaderHashGeneratorFactory$FileHeaderHashGeneratorV4Impl() {
    }

    public ByteSequence generateHash(FileHeader fileHeader, String string) throws NullPointerException, NoSuchAlgorithmException {
        if (fileHeader == null || string == null) {
            throw new NullPointerException();
        }
        Mac mac = Mac.getInstance("HmacSHA1");
        try {
            mac.init((Key)new NonPrintableAsciiPBEKey((KeySpec)new PBEKeySpec(string.toCharArray())));
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new RuntimeException(invalidKeyException);
        }
        ByteSequenceIterator byteSequenceIterator = fileHeader.getMagicNumber().getIterator();
        while (byteSequenceIterator.hasNextByte()) {
            mac.update(byteSequenceIterator.getNextByte());
        }
        byteSequenceIterator = fileHeader.getMajorVersionNumber().getIterator();
        while (byteSequenceIterator.hasNextByte()) {
            mac.update(byteSequenceIterator.getNextByte());
        }
        byteSequenceIterator = fileHeader.getMinorVersionNumber().getIterator();
        while (byteSequenceIterator.hasNextByte()) {
            mac.update(byteSequenceIterator.getNextByte());
        }
        byteSequenceIterator = fileHeader.getPasswordExpirationTime().getIterator();
        while (byteSequenceIterator.hasNextByte()) {
            mac.update(byteSequenceIterator.getNextByte());
        }
        byteSequenceIterator = fileHeader.getFileType().getIterator();
        while (byteSequenceIterator.hasNextByte()) {
            mac.update(byteSequenceIterator.getNextByte());
        }
        byteSequenceIterator = fileHeader.getFixedRecordLength().getIterator();
        while (byteSequenceIterator.hasNextByte()) {
            mac.update(byteSequenceIterator.getNextByte());
        }
        byteSequenceIterator = fileHeader.getRecordsAllocated().getIterator();
        while (byteSequenceIterator.hasNextByte()) {
            mac.update(byteSequenceIterator.getNextByte());
        }
        byteSequenceIterator = fileHeader.getFileLabel().getIterator();
        while (byteSequenceIterator.hasNextByte()) {
            mac.update(byteSequenceIterator.getNextByte());
        }
        byte[] byArray = mac.doFinal();
        return ByteSequenceFactory.newByteSequence(byArray);
    }

    FileHeaderHashGeneratorFactory$FileHeaderHashGeneratorV4Impl(FileHeaderHashGeneratorFactory$1 fileHeaderHashGeneratorFactory$1) {
        this();
    }
}

