/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.transform.stax;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.Source;

public class StAXSource
implements Source {
    public static final String FEATURE = "http://javax.xml.transform.stax.StAXSource/feature";
    private XMLEventReader fEventReader;
    private XMLStreamReader fStreamReader;
    private String fSystemId;

    public StAXSource(XMLEventReader xMLEventReader) throws XMLStreamException {
        if (xMLEventReader == null) {
            throw new IllegalArgumentException("XMLEventReader parameter cannot be null.");
        }
        XMLEvent xMLEvent = xMLEventReader.peek();
        int n = xMLEvent.getEventType();
        if (n != 7 && n != 1) {
            throw new IllegalStateException("XMLEventReader must be in the START_DOCUMENT or START_ELEMENT state.");
        }
        this.fEventReader = xMLEventReader;
        this.fSystemId = xMLEvent.getLocation().getSystemId();
    }

    public StAXSource(XMLStreamReader xMLStreamReader) {
        if (xMLStreamReader == null) {
            throw new IllegalArgumentException("XMLStreamReader parameter cannot be null.");
        }
        int n = xMLStreamReader.getEventType();
        if (n != 7 && n != 1) {
            throw new IllegalStateException("XMLStreamReader must be in the START_DOCUMENT or START_ELEMENT state.");
        }
        this.fStreamReader = xMLStreamReader;
        this.fSystemId = this.fStreamReader.getLocation().getSystemId();
    }

    public XMLEventReader getXMLEventReader() {
        return this.fEventReader;
    }

    public XMLStreamReader getXMLStreamReader() {
        return this.fStreamReader;
    }

    @Override
    public void setSystemId(String string) {
        throw new UnsupportedOperationException("setSystemId(String) cannot be called on a StAXSource.");
    }

    @Override
    public String getSystemId() {
        return this.fSystemId;
    }
}

