/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.optimizers;

import com.ibm.xylem.Binding;
import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Function;
import com.ibm.xylem.IBinding;
import com.ibm.xylem.INewNameGenerator;
import com.ibm.xylem.ISpecialForm;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.Logger;
import com.ibm.xylem.Module;
import com.ibm.xylem.Optimizer;
import com.ibm.xylem.Program;
import com.ibm.xylem.ReductionHelper;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.annot.PedanticAnormalForm;
import com.ibm.xylem.builders.LetChainBuilder;
import com.ibm.xylem.instructions.BeginInstruction;
import com.ibm.xylem.instructions.ChooseInstruction;
import com.ibm.xylem.instructions.ConstructorInstantiationInstruction;
import com.ibm.xylem.instructions.FunctionCallInstruction;
import com.ibm.xylem.instructions.IdentifierInstruction;
import com.ibm.xylem.instructions.LambdaInstruction;
import com.ibm.xylem.instructions.LetInstruction;
import com.ibm.xylem.instructions.LiteralInstruction;
import com.ibm.xylem.instructions.MatchInstruction;
import com.ibm.xylem.instructions.StreamInstruction;
import com.ibm.xylem.optimizers.FindFreeVariables;
import com.ibm.xylem.optimizers.LetChainClusterizer;
import com.ibm.xylem.optimizers.OptimizerUtilities;
import com.ibm.xylem.optimizers.OrderLetChains;
import com.ibm.xylem.optimizers.ReducedForm;
import com.ibm.xylem.types.AbstractDataType;
import com.ibm.xylem.types.NamedType;
import com.ibm.xylem.types.StreamType;
import com.ibm.xylem.utils.XylemError;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class SplitFunctions
extends FindFreeVariables {
    static Logger s_logger = Logger.getInstance(SplitFunctions.class);
    private Candidate m_best = new Candidate();
    private int m_total;
    private InformationCollector m_info = new InformationCollector();
    private Module m_program;
    private int m_splitSize;
    private boolean m_orderSafeSplit = false;
    public static final int DEFAULT_SPLIT_SIZE = 7500;
    public static final int MAX_PARAMS = 200;
    private static final boolean FORBID_PSES = false;
    private PedanticAnormalForm m_pedantic = new PedanticAnormalForm();
    private int s_suspiciouslyBadCandidates = 0;

    public SplitFunctions(Module module, boolean bl) {
        this(module, 7500);
        this.m_orderSafeSplit = bl;
    }

    public SplitFunctions(Module module, int n) {
        this.m_program = module;
        this.m_splitSize = n;
    }

    public void splitOnce(Function function, int n) {
        this.prepareFunction(function);
        this.collectInfo(function);
        s_logger.debug("forcing split of " + function.getName() + " at " + this.m_total);
        this.findCandidate(function);
        if (this.m_best.score < 5.0) {
            s_logger.error("no split candidate for " + function.getName() + " best was score=" + this.m_best.score + " size=" + this.m_best.size + " / " + this.m_total);
            Program.dumpXylemFunctions(new Function[]{function}, null, "badsplit");
            throw new RuntimeException();
        }
        if (this.m_best.score < 30.0) {
            s_logger.warn("suspiciously bad split candidate for " + function.getName() + " score=" + this.m_best.score + " size=" + this.m_best.size + " / " + this.m_total);
        }
        this.split(function, n);
        SplitFunctions.cleanUp(function);
    }

    @Override
    public void optimizeFunction(Function function) {
        this.prepareFunction(function);
        while (true) {
            this.collectInfo(function);
            this.findCandidate(function);
            if (this.m_total < this.m_splitSize) {
                s_logger.debug("function " + function.getName() + " OK at " + this.m_total);
                SplitFunctions.cleanUp(function);
                return;
            }
            if (this.m_best.score < 5.0) {
                s_logger.error("no split candidate for " + function.getName() + " best was score=" + this.m_best.score + " size=" + this.m_best.size + " / " + this.m_total);
                SplitFunctions.cleanUp(function);
                return;
            }
            if (this.m_best.score < 30.0) {
                s_logger.warn("suspiciously bad split candidate for " + function.getName() + " score=" + this.m_best.score + " size=" + this.m_best.size + " / " + this.m_total);
            }
            this.split(function, 1);
        }
    }

    private void prepareFunction(Function function) {
        new PreSplitter().optimizeFunction(function);
        this.m_pedantic.optimizeFunction(function);
        if (this.m_orderSafeSplit) {
            new OrderLetChains().orderFunction(function);
        } else {
            new LetChainClusterizer().optimizeFunction(function);
        }
    }

    private static void cleanUp(Function function) {
    }

    private void collectInfo(Function function) {
        this.m_best.clear();
        this.m_total = this.m_info.collectInfo(function);
    }

    private void findCandidate(Function function) {
        super.optimizeFunction(function);
    }

    @Override
    protected Instruction optimizeStep(Instruction instruction, Instruction instruction2, int n) {
        boolean bl;
        Object object;
        int n2;
        double d;
        this.addVars(instruction, instruction2, n);
        if (instruction2 instanceof LetInstruction && this.isSplitCandidate(instruction2, instruction, this.getCurrentFunction(), this.getFreeVars()) && this.m_best.compare(d = this.score(instruction, n2 = this.m_info.getSizeInfo(object = ((LetInstruction)instruction2).getVariable(), bl = n == 0), this.m_total, this.getFreeVars()))) {
            this.m_best.set(instruction, (LetInstruction)instruction2, n, this.getFreeVars(), bl, d, n2);
        }
        this.removeVars(instruction, instruction2, n);
        return instruction;
    }

    protected double score(Instruction instruction, int n, int n2, Set set) {
        double d = 1.0 * (double)n / (double)(++n2);
        double d2 = (double)set.size() / 200.0;
        return (4.0 * d - 4.0 * d * d - d2 * d2) * 100.0;
    }

    protected int size(Instruction instruction, TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        if (instruction instanceof LiteralInstruction || instruction instanceof IdentifierInstruction || instruction instanceof StreamInstruction && ((StreamInstruction)instruction).isString()) {
            return -1;
        }
        if (instruction instanceof StreamInstruction) {
            int n = 4;
            for (int i = 0; i < instruction.getChildInstructionCount(); ++i) {
                Instruction instruction2 = instruction.getChildInstruction(i);
                if (instruction2 instanceof LiteralInstruction) {
                    ++n;
                }
                if (instruction2.getType(typeEnvironment, bindingEnvironment) instanceof StreamType) {
                    n += 4;
                    continue;
                }
                n += 2;
            }
            return -n;
        }
        if (instruction instanceof ConstructorInstantiationInstruction) {
            return -(4 + 4 * instruction.getChildInstructionCount());
        }
        int n = 2;
        if (instruction instanceof LambdaInstruction) {
            n += 2 * SplitFunctions.findFreeVariables(instruction).size();
        }
        if (instruction instanceof MatchInstruction || instruction instanceof ChooseInstruction) {
            n += 4;
        }
        if (instruction instanceof MatchInstruction) {
            n += 2 * ((MatchInstruction)instruction).getMatches().length;
        }
        if (instruction instanceof ISpecialForm) {
            ISpecialForm iSpecialForm = (ISpecialForm)((Object)instruction);
            for (int i = 0; i < instruction.getChildInstructionCount(); ++i) {
                IBinding[] iBindingArray = iSpecialForm.getChildInstructionBindings(i);
                if (iBindingArray == null) continue;
                n += 2 * iBindingArray.length;
            }
        }
        return n;
    }

    protected boolean isSplitCandidate(Instruction instruction, Instruction instruction2, Function function, Set set) {
        if (instruction2 instanceof FunctionCallInstruction) {
            return false;
        }
        if (instruction2 instanceof LetInstruction && ((LetInstruction)instruction2).getBody() instanceof IdentifierInstruction && ((LetInstruction)instruction2).getValue() instanceof FunctionCallInstruction) {
            return false;
        }
        for (Object e : set) {
            Type type = new IdentifierInstruction(e).getType(function.getTypeEnvironment(), function.getBindingEnvironment());
            if (!((type = StreamType.makeAtomicType(type)) instanceof NamedType)) continue;
            AbstractDataType abstractDataType = ((NamedType)type).resolveNameToADT(function.getTypeEnvironment());
        }
        return true;
    }

    private void split(Function function, int n) {
        if (this.m_best.n == null) {
            throw new XylemError("ERR_SYSTEM", "function split point not found");
        }
        s_logger.debug("splitting " + (this.m_best.isValue ? "value" : "body") + " score=" + this.m_best.score + " size=" + this.m_best.size + " / " + this.m_total + "\n   " + function.getName());
        if (this.m_orderSafeSplit) {
            ArrayList arrayList = OrderLetChains.OrderedFreeVariables.findFreeVariables(this.m_best.n);
            this.split(this.m_best.n, arrayList, this.m_best.parent, this.m_best.parentIndex, function, this.m_program, n);
        } else {
            this.split(this.m_best.n, this.m_best.freeVars, this.m_best.parent, this.m_best.parentIndex, function, this.m_program, n);
        }
    }

    private void split(Instruction instruction, Collection collection, Instruction instruction2, int n, Function function, Module module, int n2) {
        Object object;
        Object object2;
        ReducedForm.Check.check(function);
        Object[] objectArray = collection.toArray();
        ArrayList<IdentifierInstruction> arrayList = new ArrayList<IdentifierInstruction>(objectArray.length);
        ArrayList<Binding> arrayList2 = new ArrayList<Binding>(objectArray.length);
        HashMap hashMap = new HashMap();
        INewNameGenerator iNewNameGenerator = new INewNameGenerator(){
            private int m_count;

            @Override
            public Object getNewName() {
                return new Integer(this.m_count++);
            }
        };
        HashMap<Object, IdentifierInstruction> hashMap2 = new HashMap<Object, IdentifierInstruction>();
        Type type = instruction.getType(function.getTypeEnvironment(), function.getBindingEnvironment());
        for (int i = 0; i < objectArray.length; ++i) {
            object2 = iNewNameGenerator.getNewName();
            hashMap2.put(objectArray[i], new IdentifierInstruction(object2));
            object = new IdentifierInstruction(objectArray[i]);
            arrayList.add((IdentifierInstruction)object);
            Type type2 = ((Instruction)object).getType(function.getTypeEnvironment(), function.getBindingEnvironment());
            Type type3 = StreamType.makeAtomicType(type2);
            if (type2 == null) {
                throw new XylemError("ERR_SYSTEM", "?" + objectArray[i]);
            }
            arrayList2.add(new Binding(object2, type2));
        }
        String string = function.getName() + "$split$" + ReductionHelper.generateIntermediateIdentifier2();
        object2 = new FunctionCallInstruction(string, arrayList);
        instruction = instruction.cloneWithoutTypeInformation().assignNewNames(hashMap2, iNewNameGenerator);
        object = new Function(string, arrayList2.toArray(new Binding[0]), instruction);
        module.addFunction((Function)object);
        SplitFunctions.cleanUp((Function)object);
        instruction2.setChildInstruction(n, (Instruction)object2);
        try {
            ((Function)object).typeCheckReduced(module, new LinkedList());
        }
        catch (Exception exception) {
            s_logger.error("TCE in new function " + object, exception);
            throw new RuntimeException();
        }
        try {
            function.typeCheckReduced(module, new LinkedList());
        }
        catch (Exception exception) {
            s_logger.error("TCE in modified enclosing function " + function, exception);
            throw new RuntimeException();
        }
        ReducedForm.Check.check(function);
        ReducedForm.Check.check((Function)object);
        while (n2 > 1) {
            --n2;
            this.collectInfo(function);
            if (this.m_total > this.m_splitSize) {
                this.findCandidate(function);
                if (this.m_best.score < 5.0) {
                    s_logger.error("no split candidate for " + function.getName() + " best was score=" + this.m_best.score + " size=" + this.m_best.size + " / " + this.m_total);
                    Program.dumpXylemFunctions(new Function[]{function}, null, "badsplit");
                    throw new RuntimeException();
                }
                if (this.m_best.score < 30.0) {
                    s_logger.warn("suspiciously bad split candidate for " + function.getName() + " score=" + this.m_best.score + " size=" + this.m_best.size + " / " + this.m_total);
                }
                this.split(function, n2);
            }
            this.collectInfo((Function)object);
            if (this.m_total <= this.m_splitSize) continue;
            this.findCandidate((Function)object);
            if (this.m_best.score < 5.0) {
                s_logger.error("no split candidate for " + ((Function)object).getName() + " best was score=" + this.m_best.score + " size=" + this.m_best.size + " / " + this.m_total);
                Program.dumpXylemFunctions(new Function[]{object}, null, "badsplit");
                throw new RuntimeException();
            }
            if (this.m_best.score < 30.0) {
                s_logger.warn("suspiciously bad split candidate for " + ((Function)object).getName() + " score=" + this.m_best.score + " size=" + this.m_best.size + " / " + this.m_total);
            }
            this.split((Function)object, n2);
        }
    }

    private static class PreSplitter
    extends Optimizer {
        final int CHUNK = 500;

        private PreSplitter() {
        }

        Instruction preSplitBegin(Instruction instruction, Instruction instruction2, int n) {
            if (instruction.getChildInstructionCount() > 500) {
                LinkedList<Instruction> linkedList = new LinkedList<Instruction>(Arrays.asList(((BeginInstruction)instruction).getOperands()));
                Instruction instruction3 = linkedList.removeLast();
                while (!linkedList.isEmpty()) {
                    int n2 = linkedList.size() - 500;
                    if (n2 < 0) {
                        n2 = 0;
                    }
                    List list = linkedList.subList(n2, linkedList.size());
                    ArrayList<Instruction> arrayList = new ArrayList<Instruction>(list);
                    arrayList.add(instruction3);
                    instruction3 = new BeginInstruction(arrayList.toArray(new Instruction[0]));
                    list.clear();
                }
                instruction3.typeCheckReduced(this.getCurrentFunction().getTypeEnvironment(), this.getCurrentFunction().getBindingEnvironment(), new LinkedList());
                return instruction3;
            }
            return instruction;
        }

        Instruction preSplitMatch(Instruction instruction, Instruction instruction2, int n) {
            if (instruction.getChildInstructionCount() > 1000) {
                MatchInstruction matchInstruction = (MatchInstruction)instruction;
                Instruction instruction3 = ((MatchInstruction)instruction).getDefault();
                ArrayList<MatchInstruction.Match> arrayList = new ArrayList<MatchInstruction.Match>(Arrays.asList(((MatchInstruction)instruction).getMatches()));
                while (!arrayList.isEmpty()) {
                    int n2 = arrayList.size() - 500;
                    if (n2 < 0) {
                        n2 = 0;
                    }
                    List list = arrayList.subList(n2, arrayList.size());
                    instruction3 = new MatchInstruction(matchInstruction.getToMatch(), list, instruction3);
                    list.clear();
                }
                instruction3.typeCheckReduced(this.getCurrentFunction().getTypeEnvironment(), this.getCurrentFunction().getBindingEnvironment(), new LinkedList());
                return instruction3;
            }
            return instruction;
        }

        Instruction preSplitLetStream(Instruction instruction, Instruction instruction2, int n) {
            StreamInstruction streamInstruction = (StreamInstruction)((LetInstruction)instruction).getValue();
            if (streamInstruction instanceof StreamInstruction && !streamInstruction.isString() && streamInstruction.getChildInstructionCount() > 501) {
                StreamInstruction streamInstruction2 = streamInstruction;
                LetChainBuilder letChainBuilder = new LetChainBuilder();
                while (streamInstruction2.getChildInstructionCount() > 500) {
                    List<Instruction> list = Arrays.asList(streamInstruction2.getElements());
                    ArrayList<Instruction> arrayList = new ArrayList<Instruction>();
                    for (int i = 0; i < list.size(); i += 500) {
                        int n2 = i + 500;
                        n2 = n2 > list.size() ? list.size() : n2;
                        ArrayList<Instruction> arrayList2 = new ArrayList<Instruction>(list.subList(i, n2));
                        arrayList.add(letChainBuilder.bind(new StreamInstruction(streamInstruction2.getElementType(), arrayList2)));
                    }
                    streamInstruction2 = new StreamInstruction(streamInstruction2.getElementType(), arrayList);
                }
                ((LetInstruction)instruction).setValue(streamInstruction2);
                instruction = letChainBuilder.packageUp(instruction);
                instruction.typeCheckReduced(this.getCurrentFunction().getTypeEnvironment(), this.getCurrentFunction().getBindingEnvironment(), new LinkedList());
            }
            return instruction;
        }

        @Override
        protected Instruction optimizeStep(Instruction instruction, Instruction instruction2, int n) {
            if (instruction instanceof BeginInstruction) {
                return this.preSplitBegin(instruction, instruction2, n);
            }
            if (instruction instanceof LetInstruction && ((LetInstruction)instruction).getValue() instanceof StreamInstruction) {
                return this.preSplitLetStream(instruction, instruction2, n);
            }
            return instruction;
        }
    }

    private static class Candidate {
        private Instruction n = null;
        private LetInstruction parent = null;
        private int parentIndex = -1;
        private Set freeVars = new HashSet();
        private boolean isValue = false;
        private double score = 0.0;
        private int size = 0;

        private Candidate() {
        }

        public boolean compare(double d) {
            return this.score < d;
        }

        public void clear() {
            this.n = null;
            this.parent = null;
            this.parentIndex = -1;
            this.freeVars = new HashSet();
            this.isValue = false;
            this.score = 0.0;
            this.size = 0;
        }

        public void set(Instruction instruction, LetInstruction letInstruction, int n, Set set, boolean bl, double d, int n2) {
            this.n = instruction;
            this.parent = letInstruction;
            this.parentIndex = n;
            this.freeVars.clear();
            this.freeVars.addAll(set);
            this.isValue = bl;
            this.score = d;
            this.size = n2;
        }
    }

    private class InformationCollector {
        private HashMap m_valueSizes = new HashMap();
        private HashMap m_bodySizes = new HashMap();
        private HashMap m_beginSizes = new HashMap();

        private InformationCollector() {
        }

        public int collectInfo(Function function) {
            this.m_bodySizes.clear();
            this.m_valueSizes.clear();
            return this.collectSize(function.getBody(), function.getTypeEnvironment(), function.getBindingEnvironment());
        }

        public int collectSize(Instruction instruction, TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
            if (!(instruction instanceof LetInstruction)) {
                int n = SplitFunctions.this.size(instruction, typeEnvironment, bindingEnvironment);
                if (n < 0) {
                    n = -n;
                } else {
                    for (int i = 0; i < instruction.getChildInstructionCount(); ++i) {
                        n += this.collectSize(instruction.getChildInstruction(i), typeEnvironment, bindingEnvironment);
                    }
                }
                return n;
            }
            Instruction instruction2 = instruction;
            LinkedList linkedList = new LinkedList();
            int n = this.collectSize(OptimizerUtilities.skipLets(instruction, linkedList), typeEnvironment, bindingEnvironment);
            LetInstruction[] letInstructionArray = linkedList.toArray(new LetInstruction[0]);
            for (int i = letInstructionArray.length - 1; i >= 0; --i) {
                int n2 = this.collectSize(letInstructionArray[i].getValue(), typeEnvironment, bindingEnvironment);
                this.m_valueSizes.put(letInstructionArray[i].getVariable(), new Integer(n2));
                this.m_bodySizes.put(letInstructionArray[i].getVariable(), new Integer(n));
                n += n2;
            }
            return n;
        }

        public int getSizeInfo(Object object, boolean bl) {
            if (bl) {
                return (Integer)this.m_valueSizes.get(object);
            }
            return (Integer)this.m_bodySizes.get(object);
        }
    }
}

