/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.instructions;

import com.ibm.xtq.bcel.generic.InstructionConstants;
import com.ibm.xtq.bcel.generic.InstructionHandle;
import com.ibm.xtq.bcel.generic.InstructionList;
import com.ibm.xtq.bcel.generic.MethodGen;
import com.ibm.xtq.bcel.generic.ObjectType;
import com.ibm.xylem.Binding;
import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Function;
import com.ibm.xylem.FunctionInstantiation;
import com.ibm.xylem.IBinding;
import com.ibm.xylem.IDebuggerInterceptor;
import com.ibm.xylem.INewNameGenerator;
import com.ibm.xylem.ISpecialForm;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.PrettyPrinter;
import com.ibm.xylem.ReadObjectFileHelper;
import com.ibm.xylem.ReductionHelper;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeCheckException;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.WriteObjectFileHelper;
import com.ibm.xylem.codegen.ClosureGenerationUtilities;
import com.ibm.xylem.codegen.CodeGenerationTracker;
import com.ibm.xylem.codegen.ConventionalGenerationState;
import com.ibm.xylem.codegen.DataFlowCodeGenerationHelper;
import com.ibm.xylem.codegen.GenerationState;
import com.ibm.xylem.codegen.LambdaFunctionGenerationStyle;
import com.ibm.xylem.codegen.LazyAdditionGenerationState;
import com.ibm.xylem.codegen.bcel.BCELCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.ClassGenerationHelper;
import com.ibm.xylem.codegen.bcel.InstructionListBuilder;
import com.ibm.xylem.instructions.FunctionCallInstruction;
import com.ibm.xylem.instructions.IdentifierInstruction;
import com.ibm.xylem.instructions.LiteralInstruction;
import com.ibm.xylem.interpreter.Closure;
import com.ibm.xylem.interpreter.Debugger;
import com.ibm.xylem.interpreter.Environment;
import com.ibm.xylem.optimizers.FindFreeVariables;
import com.ibm.xylem.types.LambdaType;
import com.ibm.xylem.utils.XylemError;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LambdaInstruction
extends Instruction
implements ISpecialForm {
    protected Binding[] m_parameters;
    protected Instruction m_body;
    protected boolean m_isPure = true;

    public LambdaInstruction() {
    }

    public LambdaInstruction(Instruction instruction, Binding[] bindingArray, boolean bl) {
        this.m_body = instruction;
        this.m_parameters = bindingArray;
        this.m_isPure = bl;
    }

    @Override
    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        Type[] typeArray = new Type[this.m_parameters.length];
        for (int i = 0; i < this.m_parameters.length; ++i) {
            typeArray[i] = this.m_parameters[i].getBindingType();
        }
        return new LambdaType(typeArray, this.m_body.getType(typeEnvironment, bindingEnvironment), this.m_isPure);
    }

    public LambdaFunctionGenerationStyle computeGenerationStyle(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, HashSet hashSet) {
        TypeEnvironment typeEnvironment = codeGenerationTracker.m_typeEnvironment;
        BindingEnvironment bindingEnvironment = codeGenerationTracker.m_bindingEnvironment;
        return this.computeGenerationStyle(dataFlowCodeGenerationHelper, typeEnvironment, bindingEnvironment, codeGenerationTracker, hashSet);
    }

    public LambdaFunctionGenerationStyle computeGenerationStyle(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, Function function) {
        TypeEnvironment typeEnvironment = function.getTypeEnvironment();
        BindingEnvironment bindingEnvironment = function.getBindingEnvironment();
        return this.computeGenerationStyle(dataFlowCodeGenerationHelper, typeEnvironment, bindingEnvironment, null, new HashSet());
    }

    protected LambdaFunctionGenerationStyle computeGenerationStyle(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, CodeGenerationTracker codeGenerationTracker, HashSet hashSet) {
        this.m_body.accumulateFreeBindings(hashSet, bindingEnvironment);
        for (int i = 0; i < this.m_parameters.length; ++i) {
            hashSet.remove(this.m_parameters[i]);
        }
        FunctionCallInstruction functionCallInstruction = (FunctionCallInstruction)this.m_body;
        LambdaType lambdaType = (LambdaType)this.getType(typeEnvironment, bindingEnvironment).resolveType(typeEnvironment);
        Function function = typeEnvironment.getModule().getFunction(functionCallInstruction.getFunction());
        IBinding[] iBindingArray = new IBinding[this.m_parameters.length];
        LiteralInstruction[] literalInstructionArray = new LiteralInstruction[functionCallInstruction.m_parameters.length];
        List list = ClosureGenerationUtilities.determineClosureFunctionCallFreeBindings(functionCallInstruction, (Set)hashSet, typeEnvironment, bindingEnvironment, codeGenerationTracker, dataFlowCodeGenerationHelper);
        LambdaFunctionGenerationStyle lambdaFunctionGenerationStyle = new LambdaFunctionGenerationStyle(function, list, lambdaType, iBindingArray, literalInstructionArray);
        for (int i = 0; i < functionCallInstruction.m_parameters.length; ++i) {
            Instruction instruction = functionCallInstruction.m_parameters[i];
            if (instruction instanceof IdentifierInstruction) {
                IBinding iBinding = ((IdentifierInstruction)instruction).getBinding(bindingEnvironment);
                Binding binding = function.m_parameters[i];
                for (int j = 0; j < this.m_parameters.length; ++j) {
                    if (iBinding != this.m_parameters[j]) continue;
                    iBindingArray[j] = binding;
                }
                continue;
            }
            literalInstructionArray[i] = (LiteralInstruction)instruction;
        }
        return lambdaFunctionGenerationStyle;
    }

    @Override
    public String generateCodeBasedOnDataFlow(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, boolean bl) {
        TypeEnvironment typeEnvironment = codeGenerationTracker.m_typeEnvironment;
        codeGenerationTracker.generateFreeBindings(this, dataFlowCodeGenerationHelper);
        if (this.m_body instanceof FunctionCallInstruction) {
            String string2 = dataFlowCodeGenerationHelper.generateNewLocalVariableName(string);
            LambdaType lambdaType = (LambdaType)codeGenerationTracker.resolveType(this);
            FunctionCallInstruction functionCallInstruction = (FunctionCallInstruction)this.m_body;
            HashSet hashSet = new HashSet();
            for (int i = 0; i < this.m_parameters.length; ++i) {
                codeGenerationTracker.registerExtantBinding(this.m_parameters[i], this.m_parameters[i].getName().toString());
            }
            LambdaFunctionGenerationStyle lambdaFunctionGenerationStyle = this.computeGenerationStyle(dataFlowCodeGenerationHelper, codeGenerationTracker, hashSet);
            dataFlowCodeGenerationHelper.append("final " + lambdaType.getImplementationName(dataFlowCodeGenerationHelper) + " " + string2 + " = new " + dataFlowCodeGenerationHelper.getClassName() + "." + lambdaFunctionGenerationStyle.generateClassName(dataFlowCodeGenerationHelper) + "(");
            ClosureGenerationUtilities.generateClosureFunctionCallParameters(functionCallInstruction, hashSet, codeGenerationTracker, dataFlowCodeGenerationHelper);
            dataFlowCodeGenerationHelper.append(");\n");
            dataFlowCodeGenerationHelper.requestFunctionGeneration(lambdaFunctionGenerationStyle);
            return string2;
        }
        s_logger.warn("LambdaInstruction: Non-optimized codegen in use (LambdaOptmizer off)");
        String string3 = dataFlowCodeGenerationHelper.generateNewLocalVariableName(string);
        LambdaType lambdaType = (LambdaType)this.getType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment).resolveType(codeGenerationTracker.m_typeEnvironment);
        String string4 = lambdaType.getImplementationName(dataFlowCodeGenerationHelper);
        StringBuffer stringBuffer = new StringBuffer();
        CodeGenerationTracker codeGenerationTracker2 = codeGenerationTracker.cloneBranch();
        FunctionInstantiation.generateParamSpecs(dataFlowCodeGenerationHelper, stringBuffer, codeGenerationTracker2, lambdaType.getElementTypes(), this.m_parameters);
        dataFlowCodeGenerationHelper.append("final " + string4 + " " + string3 + " = new " + string4 + "() {\n" + "public " + lambdaType.getReturnType().getImplementationName(dataFlowCodeGenerationHelper) + " invoke(" + stringBuffer + ") {\n");
        HashSet hashSet = new HashSet();
        this.m_body.accumulateNonLiteralFreeBindings(hashSet, codeGenerationTracker.m_bindingEnvironment);
        for (int i = 0; i < this.m_parameters.length; ++i) {
            hashSet.remove(this.m_parameters[i]);
        }
        String string5 = this.m_body.generateCodeBasedOnDataFlow(dataFlowCodeGenerationHelper, codeGenerationTracker2, null, false);
        dataFlowCodeGenerationHelper.append("return " + string5 + ";\n}\n");
        ClosureGenerationUtilities.generateClosureInitSuffix(string4, hashSet, codeGenerationTracker, dataFlowCodeGenerationHelper, true);
        return string3;
    }

    @Override
    public void generateCode(BCELCodeGenerationHelper bCELCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, InstructionHandle instructionHandle, InstructionListBuilder instructionListBuilder) {
        TypeEnvironment typeEnvironment = codeGenerationTracker.m_typeEnvironment;
        LambdaType lambdaType = (LambdaType)this.getType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment).resolveType(codeGenerationTracker.m_typeEnvironment);
        codeGenerationTracker.generateFreeBindings(this, bCELCodeGenerationHelper, instructionListBuilder, null);
        if (this.m_body instanceof FunctionCallInstruction) {
            int n;
            HashSet hashSet = new HashSet();
            BindingEnvironment bindingEnvironment = codeGenerationTracker.m_bindingEnvironment;
            this.m_body.accumulateFreeBindings(hashSet, bindingEnvironment);
            for (int i = 0; i < this.m_parameters.length; ++i) {
                hashSet.remove(this.m_parameters[i]);
            }
            FunctionCallInstruction functionCallInstruction = (FunctionCallInstruction)this.m_body;
            LambdaType lambdaType2 = (LambdaType)this.getType(typeEnvironment, bindingEnvironment).resolveType(typeEnvironment);
            Function function = typeEnvironment.getModule().getFunction(functionCallInstruction.getFunction());
            IBinding[] iBindingArray = new IBinding[this.m_parameters.length];
            LiteralInstruction[] literalInstructionArray = new LiteralInstruction[functionCallInstruction.m_parameters.length];
            ArrayList<ObjectType> arrayList = new ArrayList<ObjectType>();
            ArrayList arrayList2 = new ArrayList();
            if (bCELCodeGenerationHelper.getSettings().isMakeAllMethodsStatic()) {
                arrayList.add(new ObjectType(bCELCodeGenerationHelper.getClassName()));
            }
            List list = ClosureGenerationUtilities.determineClosureFunctionCallFreeBindings(functionCallInstruction, hashSet, codeGenerationTracker, bCELCodeGenerationHelper, arrayList, arrayList2);
            LambdaFunctionGenerationStyle lambdaFunctionGenerationStyle = new LambdaFunctionGenerationStyle(function, list, lambdaType2, iBindingArray, literalInstructionArray);
            String string2 = bCELCodeGenerationHelper.getClassName() + "$" + lambdaFunctionGenerationStyle.generateClassName(bCELCodeGenerationHelper);
            instructionListBuilder.appendNew(string2);
            instructionListBuilder.appendDUP();
            if (bCELCodeGenerationHelper.getSettings().isMakeAllMethodsStatic()) {
                instructionListBuilder.appendThis();
            }
            for (IBinding iBinding : arrayList2) {
                codeGenerationTracker.generateConventionally(iBinding, bCELCodeGenerationHelper, null, instructionListBuilder);
            }
            for (n = 0; n < this.m_parameters.length; ++n) {
                iBindingArray[n] = this.m_parameters[n];
            }
            for (n = 0; n < functionCallInstruction.m_parameters.length; ++n) {
                Instruction instruction = functionCallInstruction.m_parameters[n];
                if (instruction instanceof IdentifierInstruction) {
                    IBinding iBinding = ((IdentifierInstruction)instruction).getBinding(bindingEnvironment);
                    Binding binding = function.m_parameters[n];
                    for (int i = 0; i < this.m_parameters.length; ++i) {
                        if (iBinding != this.m_parameters[i]) continue;
                        iBindingArray[i] = binding;
                    }
                    continue;
                }
                literalInstructionArray[n] = (LiteralInstruction)instruction;
            }
            com.ibm.xtq.bcel.generic.Type[] typeArray = new com.ibm.xtq.bcel.generic.Type[arrayList.size()];
            arrayList.toArray(typeArray);
            instructionListBuilder.appendInvokeConstructor(string2, typeArray);
            bCELCodeGenerationHelper.requestFunctionGeneration(lambdaFunctionGenerationStyle);
        } else {
            Object object;
            Object object2;
            Object object32;
            Object object4;
            s_logger.warn("LambdaInstruction: Non-optimized codegen in use (LambdaOptmizer off)");
            CodeGenerationTracker codeGenerationTracker2 = codeGenerationTracker.cloneBranch();
            int n = 1;
            for (int i = 0; i < this.m_parameters.length; ++i) {
                object4 = this.m_parameters[i].getBindingType().getImplementationType(bCELCodeGenerationHelper);
                codeGenerationTracker2.registerExtantBinding(this.m_parameters[i], n, (com.ibm.xtq.bcel.generic.Type)object4);
                codeGenerationTracker2.allocateRegister((com.ibm.xtq.bcel.generic.Type)object4);
                n += ((com.ibm.xtq.bcel.generic.Type)object4).getSize();
            }
            String string3 = bCELCodeGenerationHelper.generateInnerClassName();
            object4 = bCELCodeGenerationHelper.makeClassGenerationHelper(string3, lambdaType.getImplementationName(bCELCodeGenerationHelper));
            Type[] typeArray = lambdaType.getElementTypes();
            com.ibm.xtq.bcel.generic.Type[] typeArray2 = new com.ibm.xtq.bcel.generic.Type[typeArray.length];
            for (int i = 0; i < typeArray.length; ++i) {
                typeArray2[i] = typeArray[i].getImplementationType(bCELCodeGenerationHelper);
            }
            HashSet hashSet = new HashSet();
            this.m_body.accumulateFreeBindings(hashSet, codeGenerationTracker.m_bindingEnvironment);
            for (int i = 0; i < this.m_parameters.length; ++i) {
                hashSet.remove(this.m_parameters[i]);
            }
            for (Object object32 : hashSet) {
                if (object32.getLet() != null && object32.getLet().getValue() instanceof LiteralInstruction) {
                    object2 = new ConventionalGenerationState((IBinding)object32, object32.getLet().getValue(), -1);
                    codeGenerationTracker2.registerBinding((IBinding)object32, (GenerationState)object2);
                    continue;
                }
                object2 = new InstructionList();
                ((InstructionList)object2).append(InstructionConstants.ALOAD_0);
                object = ((ConventionalGenerationState)codeGenerationTracker.getGenerationState((IBinding)object32)).getRegisterType();
                ((InstructionList)object2).append(((ClassGenerationHelper)object4).m_if.createFieldAccess(string3, "m_" + object32.getName(), (com.ibm.xtq.bcel.generic.Type)object, (short)180));
                codeGenerationTracker2.registerBinding((IBinding)object32, new LazyAdditionGenerationState((IBinding)object32, (InstructionList)object2, (com.ibm.xtq.bcel.generic.Type)object));
            }
            object32 = new InstructionList();
            object2 = new MethodGen(1, lambdaType.getReturnType().getImplementationType(bCELCodeGenerationHelper), typeArray2, null, "invoke", string3, (InstructionList)object32, ((ClassGenerationHelper)object4).m_cpg);
            object = new InstructionListBuilder(bCELCodeGenerationHelper, (InstructionList)object32, (ClassGenerationHelper)object4, (MethodGen)object2);
            ((InstructionListBuilder)object).useStaticThisField();
            this.m_body.generateCode(bCELCodeGenerationHelper, codeGenerationTracker2, null, null, (InstructionListBuilder)object);
            ((InstructionListBuilder)object).appendReturn(codeGenerationTracker.resolveType(this.m_body));
            ClosureGenerationUtilities.generateClosureInitSuffix(hashSet, codeGenerationTracker, bCELCodeGenerationHelper, (InstructionListBuilder)object, instructionListBuilder);
            bCELCodeGenerationHelper.addMethodToClass((MethodGen)object2, (ClassGenerationHelper)object4);
            bCELCodeGenerationHelper.completeClassGeneration((ClassGenerationHelper)object4);
        }
    }

    @Override
    public Instruction assignNewNames(Map map, INewNameGenerator iNewNameGenerator) {
        Binding[] bindingArray = new Binding[this.m_parameters.length];
        for (int i = 0; i < this.m_parameters.length; ++i) {
            Object object = iNewNameGenerator.getNewName();
            map.put(this.m_parameters[i].getName(), new IdentifierInstruction(object));
            bindingArray[i] = new Binding(object, this.m_parameters[i].getBindingType(), this);
        }
        return new LambdaInstruction(this.m_body.assignNewNames(map, iNewNameGenerator), bindingArray, this.m_isPure);
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        Binding[] bindingArray = new Binding[this.m_parameters.length];
        for (int i = 0; i < bindingArray.length; ++i) {
            bindingArray[i] = new Binding(this.m_parameters[i].getName(), this.m_parameters[i].getBindingType(), this);
        }
        LambdaInstruction lambdaInstruction = new LambdaInstruction(this.m_body.cloneWithoutTypeInformation(), bindingArray, this.m_isPure);
        return lambdaInstruction;
    }

    @Override
    public Instruction cloneShallow() {
        Binding[] bindingArray = new Binding[this.m_parameters.length];
        for (int i = 0; i < bindingArray.length; ++i) {
            bindingArray[i] = new Binding(this.m_parameters[i].getName(), this.m_parameters[i].getBindingType(), this);
        }
        return new LambdaInstruction(this.m_body, bindingArray, this.m_isPure);
    }

    @Override
    public Object evaluate(Environment environment, Function function, IDebuggerInterceptor iDebuggerInterceptor, boolean bl) {
        Object object;
        Object object2;
        if (null != iDebuggerInterceptor) {
            iDebuggerInterceptor.enter(this, environment, function);
        }
        BindingEnvironment bindingEnvironment = this.evaluateBindingEnvironment(function);
        Set set = FindFreeVariables.findFreeVariables(this);
        Iterator iterator = set.iterator();
        int n = 0;
        IBinding[] iBindingArray = new IBinding[set.size()];
        Object[] objectArray = new Object[set.size()];
        while (iterator.hasNext()) {
            object2 = iterator.next();
            object = bindingEnvironment.getVariableBinding(object2);
            iBindingArray[n] = object;
            objectArray[n++] = environment.lookupBinding((IBinding)object);
        }
        object2 = new Closure(iBindingArray, objectArray, function, this.m_body, this.m_parameters, this.m_sourceFilename, this.m_sourceLineNumber);
        object = object2;
        return Debugger.leave(iDebuggerInterceptor, this, environment, function, object);
    }

    public Instruction getBody() {
        return this.m_body;
    }

    public void setBody(Instruction instruction) {
        this.m_body = instruction;
    }

    @Override
    public String innerToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("lambda (");
        for (int i = 0; i < this.m_parameters.length; ++i) {
            if (i != 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(this.m_parameters[i].getName());
        }
        return stringBuffer + ")";
    }

    @Override
    public void toString(PrettyPrinter prettyPrinter, int n) {
        prettyPrinter.printFormOpen("lambda", n);
        prettyPrinter.print(" (");
        for (int i = 0; i < this.m_parameters.length; ++i) {
            prettyPrinter.printIdentifier(this.m_parameters[i].getName(), n + 2);
            Type type = this.m_parameters[i].getBindingType();
            if (type == null) continue;
            prettyPrinter.print("@");
            prettyPrinter.print(type.prettyPrint());
        }
        prettyPrinter.print(")");
        this.m_body.toString(prettyPrinter, n + 1);
        prettyPrinter.print(")");
    }

    @Override
    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        super.doDefaultTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
        Type[] typeArray = new Type[this.m_parameters.length];
        BindingEnvironment bindingEnvironment2 = new BindingEnvironment(bindingEnvironment);
        for (int i = 0; i < this.m_parameters.length; ++i) {
            typeArray[i] = this.m_parameters[i].getBindingType();
            bindingEnvironment2.setVariableBinding(this.m_parameters[i]);
        }
        return this.setCachedType(new LambdaType(typeArray, this.m_body.typeCheck(typeEnvironment, bindingEnvironment2, linkedList), this.m_isPure));
    }

    @Override
    public void generateReducedForm(ReductionHelper reductionHelper, Instruction[] instructionArray, BindingEnvironment bindingEnvironment) {
        LambdaInstruction lambdaInstruction = this;
        ReductionHelper reductionHelper2 = (ReductionHelper)reductionHelper.clone();
        this.m_bindingEnvironment = null;
        for (int i = 0; i < this.m_parameters.length; ++i) {
            reductionHelper2.upgradeBinding(this.m_parameters[i]);
            bindingEnvironment.setVariableBinding(this.m_parameters[i]);
        }
        lambdaInstruction.m_body = reductionHelper2.reduce(this.m_body, bindingEnvironment);
        instructionArray[0] = lambdaInstruction;
    }

    @Override
    public int getChildInstructionCount() {
        return 1;
    }

    @Override
    public Instruction getChildInstruction(int n) {
        return n == 0 ? this.m_body : null;
    }

    @Override
    public void setChildInstruction(int n, Instruction instruction) {
        if (n == 0) {
            this.m_body = instruction;
        }
    }

    @Override
    public void accumulateNonLiteralFreeBindings(Set set, BindingEnvironment bindingEnvironment) {
        super.accumulateNonLiteralFreeBindings(set, bindingEnvironment);
        for (int i = 0; i < this.m_parameters.length; ++i) {
            set.remove(this.m_parameters[i]);
        }
        if (set.contains(this)) {
            throw new XylemError("ERR_SYSTEM", "Lambda has binding to itself!");
        }
    }

    @Override
    public void accumulateFreeBindings(Set set, BindingEnvironment bindingEnvironment) {
        super.accumulateFreeBindings(set, bindingEnvironment);
        for (int i = 0; i < this.m_parameters.length; ++i) {
            set.remove(this.m_parameters[i]);
        }
    }

    @Override
    public void read(ReadObjectFileHelper readObjectFileHelper, BindingEnvironment bindingEnvironment) throws Exception {
        this.m_body = readObjectFileHelper.readInstruction(bindingEnvironment);
        this.m_isPure = readObjectFileHelper.readBoolean();
        this.m_parameters = readObjectFileHelper.readTypeSpecificBindingSet(this);
    }

    @Override
    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        writeObjectFileHelper.writeInstruction(this.m_body);
        writeObjectFileHelper.writeBoolean(this.m_isPure);
        writeObjectFileHelper.writeTypeSpecificBindingSet(this.m_parameters);
    }

    @Override
    public void typeCheckReduced(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) {
        Type[] typeArray = new Type[this.m_parameters.length];
        for (int i = 0; i < this.m_parameters.length; ++i) {
            typeArray[i] = this.m_parameters[i].getBindingType();
            bindingEnvironment.setVariableBinding(this.m_parameters[i]);
        }
        super.typeCheckReduced(typeEnvironment, bindingEnvironment, linkedList);
    }

    @Override
    public Type getTypeParameter(int n) {
        return this.m_parameters[n].getBindingType();
    }

    @Override
    public int getTypeParameterCount() {
        return this.m_parameters.length;
    }

    @Override
    public void setTypeParameter(int n, Type type) {
        this.m_parameters[n].setType(type);
    }

    @Override
    public boolean isChildInstructionBody(int n) {
        return true;
    }

    @Override
    public IBinding[] getChildInstructionBindings(int n) {
        return this.m_parameters;
    }

    public List getBindings() {
        ArrayList<Binding> arrayList = new ArrayList<Binding>();
        arrayList.addAll(Arrays.asList(this.m_parameters));
        return arrayList;
    }

    public Binding[] getParameters() {
        return this.m_parameters;
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        LambdaInstruction lambdaInstruction = (LambdaInstruction)object;
        int n = this.m_parameters.length;
        if (lambdaInstruction.m_parameters.length != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (lambdaInstruction.m_parameters[i].getName().equals(this.m_parameters[i].getName())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isChildInstructionInTailPosition(int n) {
        return false;
    }
}

