/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.bcel.generic;

import com.ibm.xtq.bcel.classfile.ClassFormatException;
import com.ibm.xtq.bcel.classfile.Utility;
import com.ibm.xtq.bcel.generic.ArrayType;
import com.ibm.xtq.bcel.generic.BasicType;
import com.ibm.xtq.bcel.generic.ObjectType;
import com.ibm.xtq.bcel.generic.TypeConstants;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;

public abstract class Type
implements Serializable,
TypeConstants {
    protected byte type;
    protected String signature;
    private static int consumed_chars = 0;

    protected Type(byte t, String s) {
        this.type = t;
        this.signature = s;
    }

    public String getSignature() {
        return this.signature;
    }

    public byte getType() {
        return this.type;
    }

    public int getSize() {
        switch (this.type) {
            case 7: 
            case 11: {
                return 2;
            }
            case 12: {
                return 0;
            }
        }
        return 1;
    }

    public String toString() {
        return this.equals(TypeConstants.NULL) || this.type >= 15 ? this.signature : Utility.signatureToString(this.signature, false);
    }

    public static String getMethodSignature(Type return_type, Type[] arg_types) {
        StringBuffer buf = new StringBuffer("(");
        int length = arg_types == null ? 0 : arg_types.length;
        for (int i = 0; i < length; ++i) {
            buf.append(arg_types[i].getSignature());
        }
        buf.append(')');
        buf.append(return_type.getSignature());
        return buf.toString();
    }

    public static final Type getType(String signature) throws StringIndexOutOfBoundsException {
        byte type = Utility.typeOfSignature(signature);
        if (type <= 12) {
            consumed_chars = 1;
            return BasicType.getType(type);
        }
        if (type == 13) {
            int dim = 0;
            while (signature.charAt(++dim) == '[') {
            }
            Type t = Type.getType(signature.substring(dim));
            consumed_chars += dim;
            return new ArrayType(t, dim);
        }
        int index = signature.indexOf(59);
        if (index < 0) {
            throw new ClassFormatException("Invalid signature: " + signature);
        }
        consumed_chars = index + 1;
        return new ObjectType(signature.substring(1, index).replace('/', '.'));
    }

    public static Type getReturnType(String signature) {
        try {
            int index = signature.lastIndexOf(41) + 1;
            return Type.getType(signature.substring(index));
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new ClassFormatException("Invalid method signature: " + signature);
        }
    }

    public static Type[] getArgumentTypes(String signature) {
        ArrayList<Type> vec = new ArrayList<Type>();
        try {
            if (signature.charAt(0) != '(') {
                throw new ClassFormatException("Invalid method signature: " + signature);
            }
            int index = 1;
            while (signature.charAt(index) != ')') {
                vec.add(Type.getType(signature.substring(index)));
                index += consumed_chars;
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new ClassFormatException("Invalid method signature: " + signature);
        }
        Type[] types = new Type[vec.size()];
        vec.toArray(types);
        return types;
    }

    public static Type getType(Class cl) {
        if (cl == null) {
            throw new IllegalArgumentException("Class must not be null");
        }
        if (cl.isArray()) {
            return Type.getType(cl.getName());
        }
        if (cl.isPrimitive()) {
            if (cl == Integer.TYPE) {
                return TypeConstants.INT;
            }
            if (cl == Void.TYPE) {
                return TypeConstants.VOID;
            }
            if (cl == Double.TYPE) {
                return TypeConstants.DOUBLE;
            }
            if (cl == Float.TYPE) {
                return TypeConstants.FLOAT;
            }
            if (cl == Boolean.TYPE) {
                return TypeConstants.BOOLEAN;
            }
            if (cl == Byte.TYPE) {
                return TypeConstants.BYTE;
            }
            if (cl == Short.TYPE) {
                return TypeConstants.SHORT;
            }
            if (cl == Byte.TYPE) {
                return TypeConstants.BYTE;
            }
            if (cl == Long.TYPE) {
                return TypeConstants.LONG;
            }
            if (cl == Character.TYPE) {
                return TypeConstants.CHAR;
            }
            throw new IllegalStateException("Ooops, what primitive type is " + cl);
        }
        return new ObjectType(cl.getName());
    }

    public static String getSignature(Method meth) {
        StringBuffer sb = new StringBuffer("(");
        Class<?>[] params = meth.getParameterTypes();
        for (int j = 0; j < params.length; ++j) {
            sb.append(Type.getType(params[j]).getSignature());
        }
        sb.append(")");
        sb.append(Type.getType(meth.getReturnType()).getSignature());
        return sb.toString();
    }
}

