/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.api.util.encoding;

import com.ibm.xml.xlxp.api.util.IOExceptionWrapper;
import com.ibm.xml.xlxp.api.util.encoding.ByteStreamDataSource;
import com.ibm.xml.xlxp.api.util.encoding.DataSourceFactory;
import com.ibm.xml.xlxp.api.util.encoding.EncodingSupport;
import com.ibm.xml.xlxp.scan.util.CharConversionError;
import com.ibm.xml.xlxp.scan.util.DataBuffer;
import com.ibm.xml.xlxp.scan.util.ParsedEntity;
import java.io.IOException;
import java.io.InputStream;

final class Windows125xEncodingSupport
implements EncodingSupport {
    public static final int CP1250 = 0;
    public static final int CP1251 = 1;
    public static final int CP1252 = 2;
    public static final int CP1253 = 3;
    public static final int CP1254 = 4;
    public static final int CP1255 = 5;
    public static final int CP1256 = 6;
    public static final int CP1257 = 7;
    public static final int CP1258 = 8;
    private static final int ENCODINGS_COUNT = 9;
    protected char[] fCharMap;
    private static EncodingSupport[] fgSingletons;

    public static EncodingSupport getInstance(int n) {
        EncodingSupport encodingSupport;
        if (n < 0 || n > 8) {
            return null;
        }
        if (fgSingletons == null) {
            fgSingletons = new EncodingSupport[9];
        } else if (fgSingletons[n] != null) {
            return fgSingletons[n];
        }
        switch (n) {
            case 0: {
                encodingSupport = CP1250Mappings.createEncodingSupport();
                break;
            }
            case 1: {
                encodingSupport = CP1251Mappings.createEncodingSupport();
                break;
            }
            case 2: {
                encodingSupport = CP1252Mappings.createEncodingSupport();
                break;
            }
            case 3: {
                encodingSupport = CP1253Mappings.createEncodingSupport();
                break;
            }
            case 4: {
                encodingSupport = CP1254Mappings.createEncodingSupport();
                break;
            }
            case 5: {
                encodingSupport = CP1255Mappings.createEncodingSupport();
                break;
            }
            case 6: {
                encodingSupport = CP1256Mappings.createEncodingSupport();
                break;
            }
            case 7: {
                encodingSupport = CP1257Mappings.createEncodingSupport();
                break;
            }
            case 8: {
                encodingSupport = CP1258Mappings.createEncodingSupport();
                break;
            }
            default: {
                return null;
            }
        }
        Windows125xEncodingSupport.fgSingletons[n] = encodingSupport;
        return encodingSupport;
    }

    @Override
    public CharConversionError loadFromByteStream(ParsedEntity parsedEntity, InputStream inputStream, String string, boolean bl, boolean bl2, DataSourceFactory dataSourceFactory) {
        ByteStreamDataSource byteStreamDataSource = dataSourceFactory.allocateByteStreamDataSource();
        byteStreamDataSource.checkAvailable = bl2;
        byteStreamDataSource.setByteStream(inputStream, this, bl);
        return byteStreamDataSource.load(parsedEntity);
    }

    @Override
    public CharConversionError load(ByteStreamDataSource byteStreamDataSource, DataBuffer dataBuffer) {
        byte[] byArray = dataBuffer.bytes;
        int n = 0;
        try {
            int n2 = byteStreamDataSource.bufferLength - 1 - byteStreamDataSource.byteOffset;
            while (byteStreamDataSource.stream != null) {
                int n3 = 0;
                n2 = byteStreamDataSource.bufferLength - byteStreamDataSource.byteOffset;
                if (n2 > 0 && (n3 = byteStreamDataSource.stream.read(byteStreamDataSource.byteBuffer, byteStreamDataSource.byteOffset, n2)) == -1) {
                    byteStreamDataSource.stream.close();
                    byteStreamDataSource.stream = null;
                } else {
                    n3 += byteStreamDataSource.byteOffset;
                    byteStreamDataSource.byteOffset = 0;
                    while (byteStreamDataSource.byteOffset < n3 && n + 4 < byteStreamDataSource.bufferLength) {
                        char c = this.fCharMap[byteStreamDataSource.byteBuffer[byteStreamDataSource.byteOffset] & 0xFF];
                        ++byteStreamDataSource.byteOffset;
                        if (c < '\u0080') {
                            byArray[n] = (byte)c;
                            ++n;
                            continue;
                        }
                        if (c < '\u0800') {
                            byArray[n] = (byte)(0xC0 | c >> 6);
                            byArray[++n] = (byte)(0x80 | 0x3F & c);
                            ++n;
                            continue;
                        }
                        byArray[n] = (byte)(0xE0 | c >> 12);
                        byArray[++n] = (byte)(0x80 | 0x3F & c >> 6);
                        byArray[++n] = (byte)(0x80 | 0x3F & c);
                        ++n;
                    }
                    if (byteStreamDataSource.byteOffset < n3) {
                        System.arraycopy(byteStreamDataSource.byteBuffer, byteStreamDataSource.byteOffset, byteStreamDataSource.byteBuffer, 0, n3 -= byteStreamDataSource.byteOffset);
                        byteStreamDataSource.byteOffset = n3;
                    } else {
                        byteStreamDataSource.byteOffset = 0;
                    }
                    if (n + 4 < byteStreamDataSource.bufferLength) continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            throw new IOExceptionWrapper(iOException);
        }
        dataBuffer.endOffset = n;
        return null;
    }

    protected Windows125xEncodingSupport(char[] cArray) {
        this.fCharMap = cArray;
    }

    static final class CP1258Mappings {
        static final char[] fgCharMap = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u007f', '\u20ac', '\ufffd', '\u201a', '\u0192', '\u201e', '\u2026', '\u2020', '\u2021', '\u02c6', '\u2030', '\ufffd', '\u2039', '\u0152', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\u2018', '\u2019', '\u201c', '\u201d', '\u2022', '\u2013', '\u2014', '\u02dc', '\u2122', '\ufffd', '\u203a', '\u0153', '\ufffd', '\ufffd', '\u0178', '\u00a0', '\u00a1', '\u00a2', '\u00a3', '\u00a4', '\u00a5', '\u00a6', '\u00a7', '\u00a8', '\u00a9', '\u00aa', '\u00ab', '\u00ac', '\u00ad', '\u00ae', '\u00af', '\u00b0', '\u00b1', '\u00b2', '\u00b3', '\u00b4', '\u00b5', '\u00b6', '\u00b7', '\u00b8', '\u00b9', '\u00ba', '\u00bb', '\u00bc', '\u00bd', '\u00be', '\u00bf', '\u00c0', '\u00c1', '\u00c2', '\u0102', '\u00c4', '\u00c5', '\u00c6', '\u00c7', '\u00c8', '\u00c9', '\u00ca', '\u00cb', '\u0300', '\u00cd', '\u00ce', '\u00cf', '\u0110', '\u00d1', '\u0309', '\u00d3', '\u00d4', '\u01a0', '\u00d6', '\u00d7', '\u00d8', '\u00d9', '\u00da', '\u00db', '\u00dc', '\u01af', '\u0303', '\u00df', '\u00e0', '\u00e1', '\u00e2', '\u0103', '\u00e4', '\u00e5', '\u00e6', '\u00e7', '\u00e8', '\u00e9', '\u00ea', '\u00eb', '\u0301', '\u00ed', '\u00ee', '\u00ef', '\u0111', '\u00f1', '\u0323', '\u00f3', '\u00f4', '\u01a1', '\u00f6', '\u00f7', '\u00f8', '\u00f9', '\u00fa', '\u00fb', '\u00fc', '\u01b0', '\u20ab', '\u00ff'};

        CP1258Mappings() {
        }

        static EncodingSupport createEncodingSupport() {
            return new Windows125xEncodingSupport(fgCharMap);
        }
    }

    static final class CP1257Mappings {
        static final char[] fgCharMap = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u007f', '\u20ac', '\ufffd', '\u201a', '\ufffd', '\u201e', '\u2026', '\u2020', '\u2021', '\ufffd', '\u2030', '\ufffd', '\u2039', '\ufffd', '\u00a8', '\u02c7', '\u00b8', '\ufffd', '\u2018', '\u2019', '\u201c', '\u201d', '\u2022', '\u2013', '\u2014', '\ufffd', '\u2122', '\ufffd', '\u203a', '\ufffd', '\u00af', '\u02db', '\ufffd', '\u00a0', '\ufffd', '\u00a2', '\u00a3', '\u00a4', '\ufffd', '\u00a6', '\u00a7', '\u00d8', '\u00a9', '\u0156', '\u00ab', '\u00ac', '\u00ad', '\u00ae', '\u00c6', '\u00b0', '\u00b1', '\u00b2', '\u00b3', '\u00b4', '\u00b5', '\u00b6', '\u00b7', '\u00f8', '\u00b9', '\u0157', '\u00bb', '\u00bc', '\u00bd', '\u00be', '\u00e6', '\u0104', '\u012e', '\u0100', '\u0106', '\u00c4', '\u00c5', '\u0118', '\u0112', '\u010c', '\u00c9', '\u0179', '\u0116', '\u0122', '\u0136', '\u012a', '\u013b', '\u0160', '\u0143', '\u0145', '\u00d3', '\u014c', '\u00d5', '\u00d6', '\u00d7', '\u0172', '\u0141', '\u015a', '\u016a', '\u00dc', '\u017b', '\u017d', '\u00df', '\u0105', '\u012f', '\u0101', '\u0107', '\u00e4', '\u00e5', '\u0119', '\u0113', '\u010d', '\u00e9', '\u017a', '\u0117', '\u0123', '\u0137', '\u012b', '\u013c', '\u0161', '\u0144', '\u0146', '\u00f3', '\u014d', '\u00f5', '\u00f6', '\u00f7', '\u0173', '\u0142', '\u015b', '\u016b', '\u00fc', '\u017c', '\u017e', '\u02d9'};

        CP1257Mappings() {
        }

        static EncodingSupport createEncodingSupport() {
            return new Windows125xEncodingSupport(fgCharMap);
        }
    }

    static final class CP1256Mappings {
        static final char[] fgCharMap = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u007f', '\u20ac', '\u067e', '\u201a', '\u0192', '\u201e', '\u2026', '\u2020', '\u2021', '\u02c6', '\u2030', '\u0679', '\u2039', '\u0152', '\u0686', '\u0698', '\u0688', '\u06af', '\u2018', '\u2019', '\u201c', '\u201d', '\u2022', '\u2013', '\u2014', '\u06a9', '\u2122', '\u0691', '\u203a', '\u0153', '\u200c', '\u200d', '\u06ba', '\u00a0', '\u060c', '\u00a2', '\u00a3', '\u00a4', '\u00a5', '\u00a6', '\u00a7', '\u00a8', '\u00a9', '\u06be', '\u00ab', '\u00ac', '\u00ad', '\u00ae', '\u00af', '\u00b0', '\u00b1', '\u00b2', '\u00b3', '\u00b4', '\u00b5', '\u00b6', '\u00b7', '\u00b8', '\u00b9', '\u061b', '\u00bb', '\u00bc', '\u00bd', '\u00be', '\u061f', '\u06c1', '\u0621', '\u0622', '\u0623', '\u0624', '\u0625', '\u0626', '\u0627', '\u0628', '\u0629', '\u062a', '\u062b', '\u062c', '\u062d', '\u062e', '\u062f', '\u0630', '\u0631', '\u0632', '\u0633', '\u0634', '\u0635', '\u0636', '\u00d7', '\u0637', '\u0638', '\u0639', '\u063a', '\u0640', '\u0641', '\u0642', '\u0643', '\u00e0', '\u0644', '\u00e2', '\u0645', '\u0646', '\u0647', '\u0648', '\u00e7', '\u00e8', '\u00e9', '\u00ea', '\u00eb', '\u0649', '\u064a', '\u00ee', '\u00ef', '\u064b', '\u064c', '\u064d', '\u064e', '\u00f4', '\u064f', '\u0650', '\u00f7', '\u0651', '\u00f9', '\u0652', '\u00fb', '\u00fc', '\u200e', '\u200f', '\u06d2'};

        CP1256Mappings() {
        }

        static EncodingSupport createEncodingSupport() {
            return new Windows125xEncodingSupport(fgCharMap);
        }
    }

    static final class CP1255Mappings {
        static final char[] fgCharMap = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u007f', '\u20ac', '\ufffd', '\u201a', '\u0192', '\u201e', '\u2026', '\u2020', '\u2021', '\u02c6', '\u2030', '\ufffd', '\u2039', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\u2018', '\u2019', '\u201c', '\u201d', '\u2022', '\u2013', '\u2014', '\u02dc', '\u2122', '\ufffd', '\u203a', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\u00a0', '\u00a1', '\u00a2', '\u00a3', '\u20aa', '\u00a5', '\u00a6', '\u00a7', '\u00a8', '\u00a9', '\u00d7', '\u00ab', '\u00ac', '\u00ad', '\u00ae', '\u00af', '\u00b0', '\u00b1', '\u00b2', '\u00b3', '\u00b4', '\u00b5', '\u00b6', '\u00b7', '\u00b8', '\u00b9', '\u00f7', '\u00bb', '\u00bc', '\u00bd', '\u00be', '\u00bf', '\u05b0', '\u05b1', '\u05b2', '\u05b3', '\u05b4', '\u05b5', '\u05b6', '\u05b7', '\u05b8', '\u05b9', '\ufffd', '\u05bb', '\u05bc', '\u05bd', '\u05be', '\u05bf', '\u05c0', '\u05c1', '\u05c2', '\u05c3', '\u05f0', '\u05f1', '\u05f2', '\u05f3', '\u05f4', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\u05d0', '\u05d1', '\u05d2', '\u05d3', '\u05d4', '\u05d5', '\u05d6', '\u05d7', '\u05d8', '\u05d9', '\u05da', '\u05db', '\u05dc', '\u05dd', '\u05de', '\u05df', '\u05e0', '\u05e1', '\u05e2', '\u05e3', '\u05e4', '\u05e5', '\u05e6', '\u05e7', '\u05e8', '\u05e9', '\u05ea', '\ufffd', '\ufffd', '\u200e', '\u200f', '\ufffd'};

        CP1255Mappings() {
        }

        static EncodingSupport createEncodingSupport() {
            return new Windows125xEncodingSupport(fgCharMap);
        }
    }

    static final class CP1254Mappings {
        static final char[] fgCharMap = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u007f', '\u20ac', '\ufffd', '\u201a', '\u0192', '\u201e', '\u2026', '\u2020', '\u2021', '\u02c6', '\u2030', '\u0160', '\u2039', '\u0152', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\u2018', '\u2019', '\u201c', '\u201d', '\u2022', '\u2013', '\u2014', '\u02dc', '\u2122', '\u0161', '\u203a', '\u0153', '\ufffd', '\ufffd', '\u0178', '\u00a0', '\u00a1', '\u00a2', '\u00a3', '\u00a4', '\u00a5', '\u00a6', '\u00a7', '\u00a8', '\u00a9', '\u00aa', '\u00ab', '\u00ac', '\u00ad', '\u00ae', '\u00af', '\u00b0', '\u00b1', '\u00b2', '\u00b3', '\u00b4', '\u00b5', '\u00b6', '\u00b7', '\u00b8', '\u00b9', '\u00ba', '\u00bb', '\u00bc', '\u00bd', '\u00be', '\u00bf', '\u00c0', '\u00c1', '\u00c2', '\u00c3', '\u00c4', '\u00c5', '\u00c6', '\u00c7', '\u00c8', '\u00c9', '\u00ca', '\u00cb', '\u00cc', '\u00cd', '\u00ce', '\u00cf', '\u011e', '\u00d1', '\u00d2', '\u00d3', '\u00d4', '\u00d5', '\u00d6', '\u00d7', '\u00d8', '\u00d9', '\u00da', '\u00db', '\u00dc', '\u0130', '\u015e', '\u00df', '\u00e0', '\u00e1', '\u00e2', '\u00e3', '\u00e4', '\u00e5', '\u00e6', '\u00e7', '\u00e8', '\u00e9', '\u00ea', '\u00eb', '\u00ec', '\u00ed', '\u00ee', '\u00ef', '\u011f', '\u00f1', '\u00f2', '\u00f3', '\u00f4', '\u00f5', '\u00f6', '\u00f7', '\u00f8', '\u00f9', '\u00fa', '\u00fb', '\u00fc', '\u0131', '\u015f', '\u00ff'};

        CP1254Mappings() {
        }

        static EncodingSupport createEncodingSupport() {
            return new Windows125xEncodingSupport(fgCharMap);
        }
    }

    static final class CP1253Mappings {
        static final char[] fgCharMap = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u007f', '\u20ac', '\ufffd', '\u201a', '\u0192', '\u201e', '\u2026', '\u2020', '\u2021', '\ufffd', '\u2030', '\ufffd', '\u2039', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\u2018', '\u2019', '\u201c', '\u201d', '\u2022', '\u2013', '\u2014', '\ufffd', '\u2122', '\ufffd', '\u203a', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\u00a0', '\u0385', '\u0386', '\u00a3', '\u00a4', '\u00a5', '\u00a6', '\u00a7', '\u00a8', '\u00a9', '\ufffd', '\u00ab', '\u00ac', '\u00ad', '\u00ae', '\u2015', '\u00b0', '\u00b1', '\u00b2', '\u00b3', '\u0384', '\u00b5', '\u00b6', '\u00b7', '\u0388', '\u0389', '\u038a', '\u00bb', '\u038c', '\u00bd', '\u038e', '\u038f', '\u0390', '\u0391', '\u0392', '\u0393', '\u0394', '\u0395', '\u0396', '\u0397', '\u0398', '\u0399', '\u039a', '\u039b', '\u039c', '\u039d', '\u039e', '\u039f', '\u03a0', '\u03a1', '\ufffd', '\u03a3', '\u03a4', '\u03a5', '\u03a6', '\u03a7', '\u03a8', '\u03a9', '\u03aa', '\u03ab', '\u03ac', '\u03ad', '\u03ae', '\u03af', '\u03b0', '\u03b1', '\u03b2', '\u03b3', '\u03b4', '\u03b5', '\u03b6', '\u03b7', '\u03b8', '\u03b9', '\u03ba', '\u03bb', '\u03bc', '\u03bd', '\u03be', '\u03bf', '\u03c0', '\u03c1', '\u03c2', '\u03c3', '\u03c4', '\u03c5', '\u03c6', '\u03c7', '\u03c8', '\u03c9', '\u03ca', '\u03cb', '\u03cc', '\u03cd', '\u03ce', '\ufffd'};

        CP1253Mappings() {
        }

        static EncodingSupport createEncodingSupport() {
            return new Windows125xEncodingSupport(fgCharMap);
        }
    }

    static final class CP1252Mappings {
        static final char[] fgCharMap = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u007f', '\u20ac', '\ufffd', '\u201a', '\u0192', '\u201e', '\u2026', '\u2020', '\u2021', '\u02c6', '\u2030', '\u0160', '\u2039', '\u0152', '\ufffd', '\u017d', '\ufffd', '\ufffd', '\u2018', '\u2019', '\u201c', '\u201d', '\u2022', '\u2013', '\u2014', '\u02dc', '\u2122', '\u0161', '\u203a', '\u0153', '\ufffd', '\u017e', '\u0178', '\u00a0', '\u00a1', '\u00a2', '\u00a3', '\u00a4', '\u00a5', '\u00a6', '\u00a7', '\u00a8', '\u00a9', '\u00aa', '\u00ab', '\u00ac', '\u00ad', '\u00ae', '\u00af', '\u00b0', '\u00b1', '\u00b2', '\u00b3', '\u00b4', '\u00b5', '\u00b6', '\u00b7', '\u00b8', '\u00b9', '\u00ba', '\u00bb', '\u00bc', '\u00bd', '\u00be', '\u00bf', '\u00c0', '\u00c1', '\u00c2', '\u00c3', '\u00c4', '\u00c5', '\u00c6', '\u00c7', '\u00c8', '\u00c9', '\u00ca', '\u00cb', '\u00cc', '\u00cd', '\u00ce', '\u00cf', '\u00d0', '\u00d1', '\u00d2', '\u00d3', '\u00d4', '\u00d5', '\u00d6', '\u00d7', '\u00d8', '\u00d9', '\u00da', '\u00db', '\u00dc', '\u00dd', '\u00de', '\u00df', '\u00e0', '\u00e1', '\u00e2', '\u00e3', '\u00e4', '\u00e5', '\u00e6', '\u00e7', '\u00e8', '\u00e9', '\u00ea', '\u00eb', '\u00ec', '\u00ed', '\u00ee', '\u00ef', '\u00f0', '\u00f1', '\u00f2', '\u00f3', '\u00f4', '\u00f5', '\u00f6', '\u00f7', '\u00f8', '\u00f9', '\u00fa', '\u00fb', '\u00fc', '\u00fd', '\u00fe', '\u00ff'};

        CP1252Mappings() {
        }

        static EncodingSupport createEncodingSupport() {
            return new Windows125xEncodingSupport(fgCharMap);
        }
    }

    static final class CP1251Mappings {
        static final char[] fgCharMap = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u007f', '\u0402', '\u0403', '\u201a', '\u0453', '\u201e', '\u2026', '\u2020', '\u2021', '\u20ac', '\u2030', '\u0409', '\u2039', '\u040a', '\u040c', '\u040b', '\u040f', '\u0452', '\u2018', '\u2019', '\u201c', '\u201d', '\u2022', '\u2013', '\u2014', '\ufffd', '\u2122', '\u0459', '\u203a', '\u045a', '\u045c', '\u045b', '\u045f', '\u00a0', '\u040e', '\u045e', '\u0408', '\u00a4', '\u0490', '\u00a6', '\u00a7', '\u0401', '\u00a9', '\u0404', '\u00ab', '\u00ac', '\u00ad', '\u00ae', '\u0407', '\u00b0', '\u00b1', '\u0406', '\u0456', '\u0491', '\u00b5', '\u00b6', '\u00b7', '\u0451', '\u2116', '\u0454', '\u00bb', '\u0458', '\u0405', '\u0455', '\u0457', '\u0410', '\u0411', '\u0412', '\u0413', '\u0414', '\u0415', '\u0416', '\u0417', '\u0418', '\u0419', '\u041a', '\u041b', '\u041c', '\u041d', '\u041e', '\u041f', '\u0420', '\u0421', '\u0422', '\u0423', '\u0424', '\u0425', '\u0426', '\u0427', '\u0428', '\u0429', '\u042a', '\u042b', '\u042c', '\u042d', '\u042e', '\u042f', '\u0430', '\u0431', '\u0432', '\u0433', '\u0434', '\u0435', '\u0436', '\u0437', '\u0438', '\u0439', '\u043a', '\u043b', '\u043c', '\u043d', '\u043e', '\u043f', '\u0440', '\u0441', '\u0442', '\u0443', '\u0444', '\u0445', '\u0446', '\u0447', '\u0448', '\u0449', '\u044a', '\u044b', '\u044c', '\u044d', '\u044e', '\u044f'};

        CP1251Mappings() {
        }

        static EncodingSupport createEncodingSupport() {
            return new Windows125xEncodingSupport(fgCharMap);
        }
    }

    static final class CP1250Mappings {
        static final char[] fgCharMap = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u007f', '\u20ac', '\ufffd', '\u201a', '\ufffd', '\u201e', '\u2026', '\u2020', '\u2021', '\ufffd', '\u2030', '\u0160', '\u2039', '\u015a', '\u0164', '\u017d', '\u0179', '\ufffd', '\u2018', '\u2019', '\u201c', '\u201d', '\u2022', '\u2013', '\u2014', '\ufffd', '\u2122', '\u0161', '\u203a', '\u015b', '\u0165', '\u017e', '\u017a', '\u00a0', '\u02c7', '\u02d8', '\u0141', '\u00a4', '\u0104', '\u00a6', '\u00a7', '\u00a8', '\u00a9', '\u015e', '\u00ab', '\u00ac', '\u00ad', '\u00ae', '\u017b', '\u00b0', '\u00b1', '\u02db', '\u0142', '\u00b4', '\u00b5', '\u00b6', '\u00b7', '\u00b8', '\u0105', '\u015f', '\u00bb', '\u013d', '\u02dd', '\u013e', '\u017c', '\u0154', '\u00c1', '\u00c2', '\u0102', '\u00c4', '\u0139', '\u0106', '\u00c7', '\u010c', '\u00c9', '\u0118', '\u00cb', '\u011a', '\u00cd', '\u00ce', '\u010e', '\u0110', '\u0143', '\u0147', '\u00d3', '\u00d4', '\u0150', '\u00d6', '\u00d7', '\u0158', '\u016e', '\u00da', '\u0170', '\u00dc', '\u00dd', '\u0162', '\u00df', '\u0155', '\u00e1', '\u00e2', '\u0103', '\u00e4', '\u013a', '\u0107', '\u00e7', '\u010d', '\u00e9', '\u0119', '\u00eb', '\u011b', '\u00ed', '\u00ee', '\u010f', '\u0111', '\u0144', '\u0148', '\u00f3', '\u00f4', '\u0151', '\u00f6', '\u00f7', '\u0159', '\u016f', '\u00fa', '\u0171', '\u00fc', '\u00fd', '\u0163', '\u02d9'};

        CP1250Mappings() {
        }

        static EncodingSupport createEncodingSupport() {
            return new Windows125xEncodingSupport(fgCharMap);
        }
    }
}

