/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.api.util;

import com.ibm.xml.xlxp.api.util.SimpleDataBufferFactory;
import com.ibm.xml.xlxp.api.util.SimpleScannerHelper;
import com.ibm.xml.xlxp.scan.DTDScannerHelper;
import com.ibm.xml.xlxp.scan.DocumentEntityScanner;
import com.ibm.xml.xlxp.scan.util.DTDGrammar;
import com.ibm.xml.xlxp.scan.util.DataBufferFactory;
import com.ibm.xml.xlxp.scan.util.QName;
import com.ibm.xml.xlxp.scan.util.SymbolTable;
import com.ibm.xml.xlxp.scan.util.XMLString;

public class SimpleDTDScannerHelper
extends SimpleScannerHelper
implements DTDScannerHelper {
    protected XMLString fRootElementType;
    protected XMLString fPublicID;
    protected XMLString fSystemID;
    protected boolean fInternalSubset;
    private DTDGrammar fDTDGrammar;
    private boolean[] fInElementContentStack;

    protected SimpleDTDScannerHelper() {
        this(new DocumentEntityScanner(), (DataBufferFactory)new SimpleDataBufferFactory(), true);
    }

    protected SimpleDTDScannerHelper(DocumentEntityScanner documentEntityScanner, DataBufferFactory dataBufferFactory, boolean bl) {
        this(documentEntityScanner, dataBufferFactory, null, bl);
    }

    protected SimpleDTDScannerHelper(DocumentEntityScanner documentEntityScanner, DataBufferFactory dataBufferFactory, SymbolTable symbolTable) {
        this(documentEntityScanner, dataBufferFactory, symbolTable, true);
    }

    protected SimpleDTDScannerHelper(DocumentEntityScanner documentEntityScanner, DataBufferFactory dataBufferFactory, SymbolTable symbolTable, boolean bl) {
        super(documentEntityScanner, dataBufferFactory, symbolTable, false);
        if (bl) {
            this.initializeLocals();
        }
    }

    @Override
    protected void initializeLocals() {
        super.initializeLocals();
        this.fInElementContentStack = new boolean[16];
        this.fRootElementType = new XMLString();
        this.fPublicID = new XMLString();
        this.fSystemID = new XMLString();
    }

    @Override
    public void reset(boolean bl) {
        if (this.fRootElementType.firstBuffer != null) {
            this.fRootElementType.clear();
        }
        if (this.fPublicID.firstBuffer != null) {
            this.fPublicID.clear();
        }
        if (this.fSystemID.firstBuffer != null) {
            this.fSystemID.clear();
        }
        super.reset(bl);
    }

    @Override
    public void dropBufferReferences() {
        if ((this.fCleanupFlags & 0x100) != 0) {
            if (this.fRootElementType.firstBuffer != null) {
                this.fRootElementType.clear();
            }
            if (this.fPublicID.firstBuffer != null) {
                this.fPublicID.clear();
            }
            if (this.fSystemID.firstBuffer != null) {
                this.fSystemID.clear();
            }
            this.fCleanupFlags &= 0xFFFFFEFF;
            if (this.fCleanupFlags == 0) {
                return;
            }
        }
        super.dropBufferReferences();
    }

    @Override
    public void setGrammar(DTDGrammar dTDGrammar) {
        this.fDTDGrammar = dTDGrammar;
    }

    @Override
    protected void pushElement(QName qName) {
        if (this.fDTDGrammar != null && this.fDTDGrammar.hasElementContentElements()) {
            this.fInElementContent = this.pushInElementContent(this.fDTDGrammar.hasElementContent(qName.handle));
        }
        super.pushElement(qName);
    }

    @Override
    public QName popElement() {
        QName qName = super.popElement();
        if (this.fDTDGrammar != null && this.fDTDGrammar.hasElementContentElements()) {
            this.fInElementContent = this.popInElementContent();
        }
        return qName;
    }

    protected boolean pushInElementContent(boolean bl) {
        if (this.fElementDepth == this.fInElementContentStack.length) {
            boolean[] blArray = new boolean[this.fElementDepth << 1];
            System.arraycopy(this.fInElementContentStack, 0, blArray, 0, this.fElementDepth);
            this.fInElementContentStack = blArray;
        }
        this.fInElementContentStack[this.fElementDepth] = this.fInElementContent;
        return bl;
    }

    protected boolean popInElementContent() {
        boolean bl = this.fInElementContentStack[this.fElementDepth];
        return bl;
    }

    @Override
    public boolean produceDoctypeEvent(boolean bl) {
        this.setInternalSubset(bl);
        this.moveToStringBuffer(this.fRootElementType);
        if (this.fPublicID != null && this.fPublicID.firstBuffer != null) {
            this.moveToStringBuffer(this.fPublicID);
        }
        if (this.fSystemID != null && this.fSystemID.firstBuffer != null) {
            this.moveToStringBuffer(this.fSystemID);
        }
        return true;
    }

    @Override
    public boolean produceEntityReferenceEvent() {
        this.setCurrentNSContext();
        this.fCleanupFlags |= 0x200;
        return true;
    }

    @Override
    public XMLString rootElementTypeToProduce() {
        return this.fRootElementType;
    }

    @Override
    public XMLString publicIDToProduce() {
        return this.fPublicID;
    }

    @Override
    public XMLString systemIDToProduce() {
        return this.fSystemID;
    }

    protected void setInternalSubset(boolean bl) {
        this.fInternalSubset = bl;
    }
}

