/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.api.stax.events;

import com.ibm.xml.xlxp.api.stax.events.XMLEventImpl;
import com.ibm.xml.xlxp.api.stax.msg.StAXMessageProvider;
import java.io.IOException;
import java.io.Writer;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;

public final class CharactersImpl
extends XMLEventImpl
implements Characters {
    private final String fData;
    private Boolean fIsWhiteSpace;

    public CharactersImpl(String string) {
        this(string, null);
    }

    public CharactersImpl(String string, Location location) {
        this(string, 4, location);
    }

    public CharactersImpl(String string, int n) {
        this(string, n, null);
    }

    public CharactersImpl(String string, int n, Location location) {
        super(n, location);
        this.fData = string;
    }

    @Override
    public String getData() {
        return this.fData;
    }

    @Override
    public boolean isWhiteSpace() {
        Boolean bl = this.fIsWhiteSpace;
        if (bl == null) {
            int n = this.fData != null ? this.fData.length() : 0;
            bl = n == 0 ? Boolean.FALSE : Boolean.TRUE;
            for (int i = n - 1; i >= 0; --i) {
                char c = this.fData.charAt(i);
                if (c == ' ' || c == '\n' || c == '\t' || c == '\r') continue;
                bl = Boolean.FALSE;
                break;
            }
            this.fIsWhiteSpace = bl;
        }
        return bl == Boolean.TRUE;
    }

    @Override
    public void writeAsEncodedUnicode(Writer writer) throws XMLStreamException {
        try {
            if (this.isCData()) {
                writer.write("<![CDATA[");
                writer.write(this.fData);
                writer.write("]]>");
            } else if (this.isIgnorableWhiteSpace()) {
                writer.write(CharactersImpl.escape(this.fData, 4));
            } else {
                writer.write(CharactersImpl.escape(this.fData, 4));
            }
        }
        catch (IOException iOException) {
            StAXMessageProvider.throwXMLStreamException(iOException);
        }
    }
}

