/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.jaxp.util;

import com.ibm.xml.jaxp.util.HashtableAdapter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.Map;

public final class HashtableFactory {
    private static final boolean USE_STANDARD_HASHTABLE = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            try {
                return Boolean.getBoolean("com.ibm.xml.jaxp.util.HashtableFactory.useStandardHashtable") ? Boolean.TRUE : Boolean.FALSE;
            }
            catch (SecurityException securityException) {
                return Boolean.FALSE;
            }
        }
    });

    public static Hashtable newHashtable() {
        if (USE_STANDARD_HASHTABLE) {
            return new Hashtable();
        }
        return new HashtableAdapter();
    }

    public static Hashtable newHashtable(int n) {
        if (USE_STANDARD_HASHTABLE) {
            return new Hashtable(n);
        }
        return new HashtableAdapter(n);
    }

    public static Hashtable newHashtable(int n, float f) {
        if (USE_STANDARD_HASHTABLE) {
            return new Hashtable(n, f);
        }
        return new HashtableAdapter(n, f);
    }

    public static Hashtable newHashtable(Map map) {
        if (USE_STANDARD_HASHTABLE) {
            return new Hashtable(map);
        }
        return new HashtableAdapter(map);
    }

    public static boolean isUsingStandardHashtable() {
        return USE_STANDARD_HASHTABLE;
    }

    private HashtableFactory() {
    }
}

