/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.jaxp.util;

import com.ibm.xml.jaxp.util.SecuritySupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;

public final class ExternalResourceHelper {
    private static final String FILE_PROTOCOL = "file";
    private static final String JAR_PROTOCOL_PLUS_COLON = "jar:";
    private static final String PROTOCOL_LIST_SEPARATOR = ",";
    private static Properties jaxpProperties = null;
    private static long lastModified = -1L;
    private static final String ACCESS_EXTERNAL_DTD_SYS_PROPERTY = "javax.xml.accessExternalDTD";
    private static final String ACCESS_EXTERNAL_SCHEMA_SYS_PROPERTY = "javax.xml.accessExternalSchema";
    private static final String ACCESS_EXTERNAL_STYLESHEET_SYS_PROPERTY = "javax.xml.accessExternalStylesheet";

    private ExternalResourceHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setValidatorProperty(String string, ProtocolValidator protocolValidator) {
        Object object;
        try {
            String string2 = SecuritySupport.getSystemProperty(string);
            if (string2 != null) {
                protocolValidator.setAllowedProtocols(string2);
                return;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        boolean bl = false;
        File file = null;
        try {
            object = SecuritySupport.getSystemProperty("java.home");
            String string3 = (String)object + File.separator + "lib" + File.separator + "jaxp.properties";
            file = new File(string3);
            bl = SecuritySupport.getFileExists(file);
        }
        catch (SecurityException securityException) {
            lastModified = -1L;
            jaxpProperties = null;
        }
        object = ExternalResourceHelper.class;
        synchronized (ExternalResourceHelper.class) {
            boolean bl2 = false;
            FileInputStream fileInputStream = null;
            try {
                if (lastModified >= 0L) {
                    if (bl && lastModified < (lastModified = SecuritySupport.getLastModified(file))) {
                        bl2 = true;
                    } else if (!bl) {
                        lastModified = -1L;
                        jaxpProperties = null;
                    }
                } else if (bl) {
                    bl2 = true;
                    lastModified = SecuritySupport.getLastModified(file);
                }
                if (bl2) {
                    jaxpProperties = new Properties();
                    fileInputStream = SecuritySupport.getFileInputStream(file);
                    jaxpProperties.load(fileInputStream);
                }
            }
            catch (Exception exception) {
                lastModified = -1L;
                jaxpProperties = null;
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            // ** MonitorExit[var4_6] (shouldn't be in output)
            if (jaxpProperties != null && (object = jaxpProperties.getProperty(string)) != null) {
                protocolValidator.setAllowedProtocols((String)object);
                return;
            }
            protocolValidator.setAllowedProtocols("all");
            return;
        }
    }

    public static boolean isSupportAvailable() {
        return true;
    }

    public static ProtocolValidator getDTDProtocolValidator(ProtocolValidatorErrorHandler protocolValidatorErrorHandler) {
        ProtocolValidator protocolValidator = new ProtocolValidator(ACCESS_EXTERNAL_DTD_SYS_PROPERTY);
        protocolValidator.setProtocolValidatorHandler(protocolValidatorErrorHandler);
        ExternalResourceHelper.setValidatorProperty(ACCESS_EXTERNAL_DTD_SYS_PROPERTY, protocolValidator);
        return protocolValidator;
    }

    public static ProtocolValidator getXMLSchemaProtocolValidator(ProtocolValidatorErrorHandler protocolValidatorErrorHandler) {
        ProtocolValidator protocolValidator = new ProtocolValidator(ACCESS_EXTERNAL_SCHEMA_SYS_PROPERTY);
        protocolValidator.setProtocolValidatorHandler(protocolValidatorErrorHandler);
        ExternalResourceHelper.setValidatorProperty(ACCESS_EXTERNAL_SCHEMA_SYS_PROPERTY, protocolValidator);
        return protocolValidator;
    }

    public static ProtocolValidator getStylesheetProtocolValidator(ProtocolValidatorErrorHandler protocolValidatorErrorHandler) {
        ProtocolValidator protocolValidator = new ProtocolValidator(ACCESS_EXTERNAL_STYLESHEET_SYS_PROPERTY);
        protocolValidator.setProtocolValidatorHandler(protocolValidatorErrorHandler);
        ExternalResourceHelper.setValidatorProperty(ACCESS_EXTERNAL_STYLESHEET_SYS_PROPERTY, protocolValidator);
        return protocolValidator;
    }

    public static interface ProtocolValidatorErrorHandler {
        public void reportError(String var1, String var2, String[] var3);
    }

    public static final class ProtocolValidator {
        private final String type;
        private ProtocolValidatorErrorHandler handler;
        private String[] allowedProtocols;
        private boolean allAllowed;
        private boolean fileAllowed;

        protected ProtocolValidator(String string) {
            this.type = string;
        }

        public boolean allowsAll() {
            return this.allAllowed;
        }

        public boolean validate(String string) {
            int n;
            if (this.allowsAll() || string == null) {
                return true;
            }
            String string2 = string.toLowerCase(Locale.ENGLISH);
            int n2 = string2.length();
            for (n = 0; n < this.allowedProtocols.length; ++n) {
                String string3 = this.allowedProtocols[n];
                int n3 = string3.length();
                if (n2 <= n3 || !string2.startsWith(string3) || string2.charAt(n3) != ':') continue;
                return true;
            }
            n = string.indexOf(58);
            if (this.fileAllowed) {
                char c;
                if (n == -1) {
                    return true;
                }
                if (n == 1 && (c = string2.charAt(0)) >= 'a' && c <= 'z') {
                    return true;
                }
            }
            if (this.handler != null) {
                String string4 = n >= 0 ? string.substring(0, n) : string;
                this.handler.reportError(string, string4, (String[])this.allowedProtocols.clone());
            }
            return false;
        }

        public void setProtocolValidatorHandler(ProtocolValidatorErrorHandler protocolValidatorErrorHandler) {
            this.handler = protocolValidatorErrorHandler;
        }

        public void setAllowedProtocols(String string) {
            if (string == null) {
                ExternalResourceHelper.setValidatorProperty(this.type, this);
                return;
            }
            if (string.equals("all")) {
                this.allAllowed = true;
                this.fileAllowed = true;
                this.allowedProtocols = null;
                return;
            }
            this.allAllowed = false;
            this.fileAllowed = false;
            ArrayList<String> arrayList = new ArrayList<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ExternalResourceHelper.PROTOCOL_LIST_SEPARATOR);
            while (stringTokenizer.hasMoreTokens()) {
                boolean bl;
                int n;
                String string2 = stringTokenizer.nextToken();
                int n2 = string2.length();
                int n3 = n2;
                for (n = 0; n < n3 && Character.isSpaceChar(string2.charAt(n)); ++n) {
                }
                while (n < n3 && Character.isSpaceChar(string2.charAt(n3 - 1))) {
                    --n3;
                }
                if (n != 0 || n3 != n2) {
                    string2 = string2.substring(n, n3);
                }
                if (!(bl = ProtocolValidator.checkProtocolValue(string2 = string2.toLowerCase(Locale.ENGLISH)))) continue;
                arrayList.add(string2);
                if (!ExternalResourceHelper.FILE_PROTOCOL.equals(string2)) continue;
                this.fileAllowed = true;
            }
            this.allowedProtocols = arrayList.toArray(new String[arrayList.size()]);
        }

        public String getAllowedProtocols() {
            if (this.allowsAll()) {
                return "all";
            }
            if (this.allowedProtocols.length == 0) {
                return "";
            }
            if (this.allowedProtocols.length == 1) {
                return this.allowedProtocols[0];
            }
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            for (int i = 0; i < this.allowedProtocols.length; ++i) {
                String string = this.allowedProtocols[i];
                stringBuffer.append(string);
                if (n < this.allowedProtocols.length - 1) {
                    stringBuffer.append(',');
                }
                ++n;
            }
            return stringBuffer.toString();
        }

        private static boolean checkProtocolValue(String string) {
            if (string.startsWith(ExternalResourceHelper.JAR_PROTOCOL_PLUS_COLON)) {
                string = string.substring(ExternalResourceHelper.JAR_PROTOCOL_PLUS_COLON.length());
            }
            return ProtocolValidator.checkScheme(string);
        }

        private static boolean checkScheme(String string) {
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                if (Character.isLetterOrDigit(string.charAt(i)) || Character.isSpaceChar(string.charAt(i)) || string.charAt(i) == '+' || string.charAt(i) == '-' || string.charAt(i) == '.') continue;
                return false;
            }
            return true;
        }
    }
}

