/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.ECNamedCurve;
import com.ibm.crypto.provider.ECPrivateKey;
import com.ibm.crypto.provider.ECPublicKey;
import com.ibm.crypto.provider.ECUtils;
import com.ibm.crypto.provider.PrimeCurve;
import com.ibm.crypto.provider.PrimeField;
import com.ibm.crypto.provider.be;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.InvalidParameterSpecException;

public final class ECKeyPairGenerator
extends KeyPairGeneratorSpi {
    private int a = 256;
    SecureRandom b = null;
    ECParameterSpec c;
    private static final String[] z;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void initialize(int n2, SecureRandom secureRandom) {
        if (n2 < 192 || n2 > 521 || n2 != 192 && n2 != 224 && n2 != 256 && n2 != 384 && n2 != 521) {
            throw new InvalidParameterException(z[0]);
        }
        this.a = n2;
        this.b = secureRandom;
        this.c = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec instanceof ECParameterSpec) {
            this.c = ECUtils.getPrimeParameterSpec((ECParameterSpec)algorithmParameterSpec);
            this.b = secureRandom;
            this.a = this.c.getCurve().getField().getFieldSize();
            return;
        }
        if (!(algorithmParameterSpec instanceof ECGenParameterSpec)) {
            throw new InvalidAlgorithmParameterException(z[2]);
        }
        this.c = ECNamedCurve.getECParameterSpec(((ECGenParameterSpec)algorithmParameterSpec).getName());
        if (this.c == null) {
            throw new InvalidAlgorithmParameterException(z[3]);
        }
        this.b = secureRandom;
        this.a = this.c.getCurve().getField().getFieldSize();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public KeyPair generateKeyPair() {
        if (this.b == null) {
            this.b = null;
            try {
                this.b = SecureRandom.getInstance(z[1]);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                this.b = new SecureRandom();
            }
        }
        if (this.c == null) {
            this.a();
        }
        int n2 = this.c.getCurve().getField().getFieldSize();
        BigInteger bigInteger = new BigInteger(n2, this.b);
        bigInteger = bigInteger.abs();
        while (bigInteger.compareTo(this.c.getOrder()) != -1) {
            bigInteger = new BigInteger(n2, this.b);
            bigInteger = bigInteger.abs();
        }
        try {
            PrimeCurve primeCurve = ECUtils.getPrimeCurve(this.c.getCurve());
            ECPoint eCPoint = primeCurve.multiply(((PrimeField)primeCurve.getField()).bigIntegerTointernal(bigInteger), primeCurve.toEllipticPoint(this.c.getGenerator())).getAffine();
            ECPublicKey eCPublicKey = new ECPublicKey(eCPoint, this.c);
            ECPrivateKey eCPrivateKey = new ECPrivateKey(bigInteger, this.c, eCPublicKey);
            return new KeyPair(eCPublicKey, eCPrivateKey);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new ProviderException(invalidKeyException.getMessage());
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new ProviderException(invalidParameterSpecException.getMessage());
        }
    }

    private void a() {
        switch (this.a) {
            case 192: {
                PrimeField primeField = ECUtils.getField(192, be.a, true);
                Object var2_6 = null;
                PrimeCurve primeCurve = ECUtils.getCurve(primeField, be.E.mod(be.a), be.c, 1);
                this.c = new ECParameterSpec(primeCurve, be.f, be.b, 1);
                break;
            }
            case 224: {
                PrimeField primeField = ECUtils.getField(224, be.g, true);
                Object var2_7 = null;
                PrimeCurve primeCurve = ECUtils.getCurve(primeField, be.E.mod(be.g), be.i, 1);
                this.c = new ECParameterSpec(primeCurve, be.l, be.h, 1);
                break;
            }
            case 256: {
                PrimeField primeField = ECUtils.getField(256, be.m, true);
                Object var2_8 = null;
                PrimeCurve primeCurve = ECUtils.getCurve(primeField, be.E.mod(be.m), be.o, 1);
                this.c = new ECParameterSpec(primeCurve, be.r, be.n, 1);
                break;
            }
            case 384: {
                PrimeField primeField = ECUtils.getField(384, be.s, true);
                Object var2_9 = null;
                PrimeCurve primeCurve = ECUtils.getCurve(primeField, be.E.mod(be.s), be.u, 1);
                this.c = new ECParameterSpec(primeCurve, be.x, be.t, 1);
                break;
            }
            case 521: {
                PrimeField primeField = ECUtils.getField(521, be.y, true);
                Object var2_10 = null;
                PrimeCurve primeCurve = ECUtils.getCurve(primeField, be.E.mod(be.y), be.A, 1);
                this.c = new ECParameterSpec(primeCurve, be.D, be.z, 1);
            }
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[4];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "?IF\u0011~OHF\u0006~OVZ\u000foOYJ\\t\u0001^\u000f\u0013}U\u001b\u001eE)C\u001b\u001dN/C\u001b\u001dI-C\u001b\u001cD/C\u001b\u001aN*";
        int n3 = -1;
        block11: while (true) {
            char[] cArray;
            block15: {
                int n4;
                int n5;
                block14: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block14;
                    n5 = n5;
                    if (n5 <= n4) break block15;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 111;
                            break;
                        }
                        case 1: {
                            n6 = 59;
                            break;
                        }
                        case 2: {
                            n6 = 47;
                            break;
                        }
                        case 3: {
                            n6 = 124;
                            break;
                        }
                        default: {
                            n6 = 27;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "&yb/~\fN]\u0019I\u000eUK\u0013v";
                    n3 = 0;
                    continue block11;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "?Z]\u001dv\u001c\u001bB\th\u001b\u001bM\u0019;\u0006U\\\bz\u0001XJ\\t\t\u001bj?K\u000eIN\u0011~\u001b^]/k\nX\u000f\u0013iO~l;~\u0001kN\u000ez\u0002^[\u0019i<KJ\u001f";
                    n3 = 1;
                    continue block11;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = ",N]\n~OUN\u0011~OU@\b;\u001d^L\u0013|\u0001RU\u0019\u007fOT]\\u\u0000O\u000f\u000fn\u001fK@\u000eo\n_";
                    n3 = 2;
                    continue block11;
                }
                case 2: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

