/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.DHParameterGenerator;
import com.ibm.crypto.provider.DHPrivateKey;
import com.ibm.crypto.provider.DHPublicKey;
import com.ibm.crypto.provider.DSAParameterGenerator;
import com.ibm.crypto.provider.IBMJCE;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.DHGenParameterSpec;
import javax.crypto.spec.DHParameterSpec;

public final class DHKeyPairGenerator
extends KeyPairGeneratorSpi {
    private DHParameterSpec a;
    private int b = 2048;
    private int c;
    private SecureRandom d;
    private static final String[] z;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void initialize(int n2, SecureRandom secureRandom) {
        if (n2 >= 256 && n2 <= 2048 && n2 % 64 == 0) {
            this.b = n2;
            this.c = 0;
            this.d = secureRandom;
            this.a = null;
            return;
        }
        throw new InvalidParameterException(z[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof DHParameterSpec)) {
            throw new InvalidAlgorithmParameterException(z[4]);
        }
        this.a = (DHParameterSpec)algorithmParameterSpec;
        this.b = this.a.getP().bitLength();
        if (this.b < 256 || this.b > 2048 || this.b % 64 != 0) {
            throw new InvalidAlgorithmParameterException(z[2]);
        }
        this.c = this.a.getL();
        this.d = secureRandom;
        if (this.c != 0 && this.c > this.b) {
            throw new InvalidAlgorithmParameterException(z[3]);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public KeyPair generateKeyPair() {
        Object object;
        Object object2;
        Object object3;
        if (this.d == null) {
            try {
                this.d = SecureRandom.getInstance(z[1], IBMJCE.getInstance());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        if (this.c <= 0) {
            this.c = this.b >> 1;
            if (this.c < 384) {
                this.c = 384;
            }
        }
        if (this.a == null) {
            switch (this.b) {
                case 512: {
                    this.a = new DHParameterSpec(DSAParameterGenerator.d, DSAParameterGenerator.f);
                    break;
                }
                case 768: {
                    this.a = new DHParameterSpec(DSAParameterGenerator.g, DSAParameterGenerator.i);
                    break;
                }
                case 1024: {
                    this.a = new DHParameterSpec(DSAParameterGenerator.j, DSAParameterGenerator.l);
                    break;
                }
                case 2048: {
                    this.a = new DHParameterSpec(DSAParameterGenerator.m, DSAParameterGenerator.o);
                    break;
                }
                default: {
                    try {
                        object3 = new DHGenParameterSpec(this.b, this.c);
                        object2 = new DHParameterGenerator();
                        ((DHParameterGenerator)object2).engineInit((AlgorithmParameterSpec)object3, this.d);
                        object = ((DHParameterGenerator)object2).engineGenerateParameters();
                        this.a = ((AlgorithmParameters)object).getParameterSpec(DHParameterSpec.class);
                        break;
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception.getMessage());
                    }
                }
            }
        }
        object3 = this.a.getP();
        object2 = this.a.getG();
        BigInteger bigInteger = ((BigInteger)object3).subtract(BigInteger.valueOf(2L));
        while (((BigInteger)(object = new BigInteger(this.c, this.d))).compareTo(BigInteger.ONE) < 0 || ((BigInteger)object).compareTo(bigInteger) > 0 || ((BigInteger)object).bitLength() != this.c) {
        }
        BigInteger bigInteger2 = ((BigInteger)object2).modPow((BigInteger)object, (BigInteger)object3);
        try {
            DHPublicKey dHPublicKey = new DHPublicKey(bigInteger2, (BigInteger)object3, (BigInteger)object2, this.c);
            DHPrivateKey dHPrivateKey = new DHPrivateKey((BigInteger)object, (BigInteger)object3, (BigInteger)object2, this.c);
            return new KeyPair(dHPublicKey, dHPrivateKey);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new RuntimeException(invalidKeyException.getMessage());
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[5];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "Q\u0004Y\u001dU`\u0004\u0000\u0003Ii\u0015\u0000\fY:\fU\u0002Hs\u0011L\u000b\u001cu\u0007\u0000X\b6AA\u0000X:\u0002A\u0000\u001cu\u000fL\u0017\u001ch\u0000N\tY:\u0007R\u0001Q:S\u0015X\u001cn\u000e\u0000\\\f.Y\u0000FUt\u0002L\u001bOs\u0017EG";
        int n3 = -1;
        block12: while (true) {
            char[] cArray;
            block16: {
                int n4;
                int n5;
                block15: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block15;
                    n5 = n5;
                    if (n5 <= n4) break block16;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 26;
                            break;
                        }
                        case 1: {
                            n6 = 97;
                            break;
                        }
                        case 2: {
                            n6 = 32;
                            break;
                        }
                        case 3: {
                            n6 = 110;
                            break;
                        }
                        default: {
                            n6 = 60;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "S#m=Yy\u0014R\u000bn{\u000fD\u0001Q";
                    n3 = 0;
                    continue block12;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "J\u0013I\u0003Y:\u0012I\u0014Y:\fU\u001dH:\u0003ENQo\rT\u0007Lv\u0004\u0000\u0001Z:W\u0014B\u001c{\u000fDN_{\u000f\u0000\u0001Rv\u0018\u0000\u001c]t\u0006ENZh\u000eMN\u000e/W\u0000\u001aS:S\u0010Z\u0004:II\u0000_v\u0014S\u0007J\u007fH";
                    n3 = 1;
                    continue block12;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "_\u0019P\u0001R\u007f\u000fTNOs\u001bENQo\u0012TNRu\u0015\u0000\fY:\rA\u001c[\u007f\u0013\u0000\u001aT{\u000f\u0000\u0003S~\u0014L\u001bO:\u0012I\u0014Y";
                    n3 = 2;
                    continue block12;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "S\u000fA\u001eLh\u000eP\u001cU{\u0015ENL{\u0013A\u0003Yn\u0004RNHc\u0011E";
                    n3 = 3;
                    continue block12;
                }
                case 3: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

