/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc.dom;

import com.ibm.misc.BASE64Decoder;
import com.ibm.misc.BASE64Encoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.interfaces.RSAKey;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class Utils {
    private Utils() {
    }

    public static byte[] base64Decode(String text) throws IOException {
        StringTokenizer tokenizer = new StringTokenizer(text, " \n\r\t", false);
        StringBuffer buf = new StringBuffer(text.length());
        while (tokenizer.hasMoreElements()) {
            buf.append(tokenizer.nextToken());
        }
        return new BASE64Decoder().decodeBuffer(buf.toString());
    }

    public static String base64Encode(byte[] bytes) {
        return new BASE64Encoder().encode(bytes);
    }

    public static String base64EncodeNoWhite(byte[] bytes) {
        String text = Utils.base64Encode(bytes);
        StringTokenizer tokenizer = new StringTokenizer(text, " \n\r\t", false);
        StringBuffer buf = new StringBuffer(text.length());
        while (tokenizer.hasMoreElements()) {
            buf.append(tokenizer.nextToken());
        }
        return buf.toString();
    }

    public static byte[] readBytesFromStream(InputStream is) throws IOException {
        int read;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while ((read = is.read(buf)) != -1) {
            baos.write(buf, 0, read);
            if (read >= 1024) continue;
            break;
        }
        return baos.toByteArray();
    }

    static Set toNodeSet(Iterator i) {
        HashSet<Node> nodeSet = new HashSet<Node>();
        while (i.hasNext()) {
            Node n = (Node)i.next();
            nodeSet.add(n);
            if (n.getNodeType() != 1) continue;
            NamedNodeMap nnm = n.getAttributes();
            for (int j = 0; j < nnm.getLength(); ++j) {
                nodeSet.add(nnm.item(j));
            }
        }
        return nodeSet;
    }

    public static String parseIdFromSameDocumentURI(String uri) {
        if (uri.length() == 0) {
            return null;
        }
        String id = uri.substring(1);
        if (id != null && id.startsWith("xpointer(id(")) {
            int i1 = id.indexOf(39);
            int i2 = id.indexOf(39, i1 + 1);
            id = id.substring(i1 + 1, i2);
        }
        return id;
    }

    public static boolean sameDocumentURI(String uri) {
        return uri != null && (uri.length() == 0 || uri.startsWith("#"));
    }

    public static boolean compareArray(byte[] a, byte[] b) {
        if (a == null && b != null) {
            return false;
        }
        if (b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public static String mapAlgorithm(String uri) {
        if (uri.equals("http://www.w3.org/2001/04/xmlenc#aes128-cbc")) {
            return "AES";
        }
        if (uri.equals("http://www.w3.org/2001/04/xmlenc#aes192-cbc")) {
            return "AES";
        }
        if (uri.equals("http://www.w3.org/2001/04/xmlenc#aes256-cbc")) {
            return "AES";
        }
        if (uri.equals("http://www.w3.org/2001/04/xmlenc#kw-aes128")) {
            return "AES";
        }
        if (uri.equals("http://www.w3.org/2001/04/xmlenc#kw-aes192")) {
            return "AES";
        }
        if (uri.equals("http://www.w3.org/2001/04/xmlenc#kw-aes256")) {
            return "AES";
        }
        if (uri.equals("http://www.w3.org/2001/04/xmlenc#kw-tripledes")) {
            return "TripleDES";
        }
        if (uri.equals("http://www.w3.org/2001/04/xmlenc#tripledes-cbc")) {
            return "TripleDES";
        }
        if (uri.equals("http://www.w3.org/2001/04/xmlenc#rsa-1_5") || uri.equals("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p")) {
            return "RSA";
        }
        return null;
    }

    public static void checkKeySize(Integer keysizeInt, RSAKey key) throws InvalidKeyException {
        int keysize = keysizeInt;
        int bitLen = key.getModulus().bitLength();
        if (bitLen != keysize && (bitLen < keysize ? keysize - bitLen >= 8 : bitLen > keysize && bitLen - keysize >= 8)) {
            throw new InvalidKeyException("Keysize doesn't match the specified keysize of EncryptionMethod");
        }
    }
}

