/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channel.framework.internals.impl;

import com.ibm.nws.ejs.ras.Tr;
import com.ibm.nws.ejs.ras.TraceComponent;
import com.ibm.nws.ffdc.FFDCFilter;
import com.ibm.ws.channel.framework.internals.DiscriminationAlgorithm;
import com.ibm.ws.channel.framework.internals.DiscriminationGroup;
import com.ibm.ws.channel.framework.internals.InboundVirtualConnection;
import com.ibm.ws.channel.framework.internals.impl.DiscriminatorNode;
import com.ibm.ws.channel.framework.internals.impl.FailureDiscriminatorAlgorithm;
import com.ibm.ws.channel.framework.internals.impl.MultiDiscriminatorAlgorithm;
import com.ibm.ws.channel.framework.internals.impl.SingleDiscriminatorAlgorithm;
import com.ibm.wsspi.channel.Channel;
import com.ibm.wsspi.channel.ConnectionLink;
import com.ibm.wsspi.channel.Discriminator;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.channel.framework.exception.DiscriminationProcessException;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

public class DiscriminationProcessImpl
implements DiscriminationGroup {
    private static final TraceComponent tc = Tr.register(DiscriminationProcessImpl.class, "ChannelFramework", "com.ibm.ws.channel.resources.channelframeworkservice");
    private Class discriminantClass;
    private DiscriminationAlgorithm discriminationAlgorithm = null;
    private int status = 2;
    private static final int STARTED = 1;
    private static final int STOPPED = 2;
    private static Object indexLock = new Object();
    private static int masterIndex = 0;
    private int myIndex;
    private String name = null;
    private DiscriminatorNode discriminators;
    private List discAL = null;
    private Channel[] channelList = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiscriminationProcessImpl(Class clazz, String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "discClass=" + clazz + ", channelName=" + string);
        }
        this.discriminators = null;
        this.discAL = new ArrayList(0);
        this.discriminantClass = clazz;
        this.discriminationAlgorithm = new FailureDiscriminatorAlgorithm();
        this.status = 2;
        this.name = string;
        Object object = indexLock;
        synchronized (object) {
            this.myIndex = masterIndex++;
        }
    }

    public DiscriminationProcessImpl(Class clazz, DiscriminationGroup discriminationGroup) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "discClass=" + clazz + ", DiscriminatorGroup=" + discriminationGroup);
        }
        this.discriminators = null;
        this.discAL = new ArrayList(0);
        this.discriminantClass = clazz;
        this.discriminationAlgorithm = new FailureDiscriminatorAlgorithm();
        this.status = 2;
        this.name = discriminationGroup.getChannelName();
        DiscriminatorNode discriminatorNode = (DiscriminatorNode)discriminationGroup.getDiscriminatorNodes();
        this.buildDiscriminatorNodes(discriminatorNode);
    }

    private void buildDiscriminatorNodes(DiscriminatorNode discriminatorNode) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildDiscriminatorNodes");
        }
        if (discriminatorNode == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "null discriminator node");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "buildDiscriminatorNodes");
            }
            return;
        }
        DiscriminatorNode discriminatorNode2 = null;
        DiscriminatorNode discriminatorNode3 = null;
        this.discriminators = new DiscriminatorNode(discriminatorNode.disc, discriminatorNode.weight, null, null);
        this.discAL.add(discriminatorNode.disc);
        Channel channel = discriminatorNode.disc.getChannel();
        this.addChannel(channel);
        discriminatorNode2 = this.discriminators;
        discriminatorNode3 = this.discriminators;
        while (discriminatorNode.next != null) {
            discriminatorNode = discriminatorNode.next;
            discriminatorNode3.next = discriminatorNode2 = new DiscriminatorNode(discriminatorNode.disc, discriminatorNode.weight, null, discriminatorNode3);
            discriminatorNode3 = discriminatorNode2;
            this.discAL.add(discriminatorNode.disc);
            channel = discriminatorNode.disc.getChannel();
            this.addChannel(channel);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildDiscriminatorNodes");
        }
    }

    public int discriminate(VirtualConnection virtualConnection, Object object, ConnectionLink connectionLink) throws DiscriminationProcessException {
        InboundVirtualConnection inboundVirtualConnection = (InboundVirtualConnection)virtualConnection;
        if (this.discriminationAlgorithm == null) {
            DiscriminationProcessException discriminationProcessException = new DiscriminationProcessException("No Discriminators in this group or the group was not properly started");
            FFDCFilter.processException(discriminationProcessException, "com.ibm.ws.channel.framework.internals.impl.DiscriminationProcessImpl.discriminate", "202", this, new Object[]{inboundVirtualConnection});
            throw discriminationProcessException;
        }
        return this.discriminationAlgorithm.discriminate(inboundVirtualConnection, object, connectionLink);
    }

    public int discriminate(VirtualConnection virtualConnection, ConnectionLink connectionLink, String string) {
        Channel channel = null;
        String string2 = null;
        String string3 = string + "_CFINTERNAL_CHILD_";
        int n = 0;
        for (int i = 0; this.channelList != null && i < this.channelList.length; ++i) {
            channel = this.channelList[i];
            string2 = channel.getName();
            if (string2 == null || !string2.startsWith(string3)) continue;
            ConnectionLink connectionLink2 = channel.getConnectionLink(virtualConnection);
            connectionLink.setApplicationCallback(connectionLink2);
            connectionLink2.setDeviceLink(connectionLink);
            n = 1;
            break;
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void addDiscriminator(Discriminator discriminator, int n) throws DiscriminationProcessException {
        block13: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "addDiscriminator");
            }
            if (this.status == 1) {
                DiscriminationProcessException discriminationProcessException = new DiscriminationProcessException("Should not add to DiscriminationGroup while started!");
                FFDCFilter.processException(discriminationProcessException, "com.ibm.ws.channel.framework.internals.impl.DiscriminationProcessImpl.addDiscriminator", "239", this, new Object[]{discriminator});
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "addDiscriminator");
                }
                throw discriminationProcessException;
            }
            if (n < 0) {
                DiscriminationProcessException discriminationProcessException = new DiscriminationProcessException("Invalid weight for discriminator, " + n);
                FFDCFilter.processException(discriminationProcessException, "com.ibm.ws.channel.framework.internals.impl.DiscriminationProcessImpl.addDiscriminator", "260", this, new Object[]{new Long(n)});
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "addDiscriminator");
                }
                throw discriminationProcessException;
            }
            if (!this.discAL.contains(discriminator)) {
                if (discriminator.getDiscriminatoryDataType().isAssignableFrom(this.discriminantClass)) {
                    if (discriminator.getChannel() == null || discriminator.getChannel().getName() == null) {
                        DiscriminationProcessException discriminationProcessException = new DiscriminationProcessException("Discriminator does not have channel or its channel has no name");
                        FFDCFilter.processException(discriminationProcessException, "com.ibm.ws.channel.framework.internals.impl.DiscriminationProcessImpl.addDiscriminator", "273", this, new Object[]{discriminator});
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "addDiscriminator");
                        }
                        throw discriminationProcessException;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Add discriminator " + discriminator.getChannel().getName() + " weight " + n);
                    }
                    this.addDiscriminatorNode(new DiscriminatorNode(discriminator, n));
                    this.discAL.add(discriminator);
                    Channel channel = discriminator.getChannel();
                    this.addChannel(channel);
                    break block13;
                } else {
                    ClassCastException classCastException = new ClassCastException();
                    FFDCFilter.processException(classCastException, "com.ibm.ws.channel.framework.internals.impl.DiscriminationProcessImpl.addDiscriminator", "292", this, new Object[]{discriminator});
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "addDiscriminator");
                    }
                    throw classCastException;
                }
            }
            Tr.debug(tc, "Same discriminator added twice?");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addDiscriminator");
        }
    }

    public boolean containsDiscriminator(Discriminator discriminator) {
        return this.discAL.contains(discriminator);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Discriminators:\n");
        DiscriminatorNode discriminatorNode = this.discriminators;
        while (null != discriminatorNode) {
            stringBuffer.append("\t" + discriminatorNode.disc.getChannel().getName() + " weight=" + discriminatorNode.disc.getWeight());
            discriminatorNode = discriminatorNode.next;
        }
        return stringBuffer.toString();
    }

    private void addDiscriminatorNode(DiscriminatorNode discriminatorNode) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addDiscriminatorNode, weight=" + discriminatorNode.weight);
        }
        if (this.discriminators == null) {
            this.discriminators = discriminatorNode;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "addDiscriminatorNode");
            }
            return;
        }
        DiscriminatorNode discriminatorNode2 = this.discriminators;
        if (discriminatorNode2.weight > discriminatorNode.weight) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding disc first in list");
            }
            discriminatorNode2.prev = discriminatorNode;
            discriminatorNode.next = discriminatorNode2;
            this.discriminators = discriminatorNode;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "addDiscriminatorNode");
            }
            return;
        }
        DiscriminatorNode discriminatorNode3 = this.discriminators;
        while (discriminatorNode2.next != null) {
            discriminatorNode3 = discriminatorNode2;
            discriminatorNode2 = discriminatorNode2.next;
            if (discriminatorNode2.weight <= discriminatorNode.weight) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding disc before " + discriminatorNode2.disc.getChannel().getName());
            }
            discriminatorNode2.prev = discriminatorNode;
            discriminatorNode.next = discriminatorNode2;
            discriminatorNode3.next = discriminatorNode;
            discriminatorNode.prev = discriminatorNode3;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "addDiscriminatorNode");
            }
            return;
        }
        discriminatorNode2.next = discriminatorNode;
        discriminatorNode.prev = discriminatorNode2;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addDiscriminatorNode");
        }
    }

    public void removeDiscriminator(Discriminator discriminator) throws DiscriminationProcessException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeDiscriminator");
        }
        if (this.status == 1) {
            DiscriminationProcessException discriminationProcessException = new DiscriminationProcessException("Should not remove form DiscriminationGroup while started!");
            FFDCFilter.processException(discriminationProcessException, "com.ibm.ws.channel.framework.internals.impl.DiscriminationProcessImpl.removeDiscriminator", "401", this, new Object[]{discriminator});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "removeDiscriminator");
            }
            throw discriminationProcessException;
        }
        if (!this.discAL.remove(discriminator)) {
            NoSuchElementException noSuchElementException = new NoSuchElementException("Discriminator does not exist, " + discriminator.getChannel().getName());
            FFDCFilter.processException(noSuchElementException, "com.ibm.ws.channel.framework.internals.impl.DiscriminationProcessImpl.removeDiscriminator", "410", this, new Object[]{discriminator});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "removeDiscriminator");
            }
            throw noSuchElementException;
        }
        String string = discriminator.getChannel().getName();
        if (this.channelList == null) {
            NoSuchElementException noSuchElementException = new NoSuchElementException("No Channel's exist, " + discriminator.getChannel().getName());
            FFDCFilter.processException(noSuchElementException, "com.ibm.ws.channel.framework.internals.impl.DiscriminationProcessImpl.removeDiscriminator", "422", this, new Object[]{discriminator});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "removeDiscriminator");
            }
            throw noSuchElementException;
        }
        Channel[] channelArray = this.channelList;
        this.channelList = new Channel[channelArray.length - 1];
        int n = 0;
        for (int i = 0; i < channelArray.length; ++i) {
            String string2 = channelArray[i].getName();
            if (string2 != null && !string2.equals(string)) {
                if (n >= channelArray.length) {
                    NoSuchElementException noSuchElementException = new NoSuchElementException("Channel does not exist, " + discriminator.getChannel().getName());
                    FFDCFilter.processException(noSuchElementException, "com.ibm.ws.channel.framework.internals.impl.DiscriminationProcessImpl.removeDiscriminator", "440", this, new Object[]{discriminator});
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "removeDiscriminator");
                    }
                    throw noSuchElementException;
                }
                this.channelList[n++] = channelArray[i];
                continue;
            }
            if (string != null) continue;
            DiscriminationProcessException discriminationProcessException = new DiscriminationProcessException("Channel does not have a name associated with it, " + channelArray[i]);
            FFDCFilter.processException(discriminationProcessException, "com.ibm.ws.channel.framework.internals.impl.DiscriminationProcessImpl.removeDiscriminator", "454", this, new Object[]{channelArray[i]});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "removeDiscriminator");
            }
            throw discriminationProcessException;
        }
        this.removeDiscriminatorNode(discriminator);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeDiscriminator");
        }
    }

    private void removeDiscriminatorNode(Discriminator discriminator) throws DiscriminationProcessException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeDiscriminatorNode");
        }
        if (discriminator == null) {
            DiscriminationProcessException discriminationProcessException = new DiscriminationProcessException("Can't remove a null discriminator");
            FFDCFilter.processException(discriminationProcessException, "com.ibm.ws.channel.framework.internals.impl.DiscriminationProcessImpl.removeDiscriminatorNode", "484", this, new Object[]{discriminator});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "removeDiscriminatorNode");
            }
            throw discriminationProcessException;
        }
        if (this.discriminators.disc.equals(discriminator)) {
            this.discriminators = this.discriminators.next;
            if (this.discriminators != null) {
                this.discriminators.prev = null;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "removeDiscriminatorNode");
            }
            return;
        }
        DiscriminatorNode discriminatorNode = this.discriminators.next;
        DiscriminatorNode discriminatorNode2 = this.discriminators;
        while (discriminatorNode.next != null) {
            if (discriminatorNode.disc.equals(discriminator)) {
                discriminatorNode.next.prev = discriminatorNode2;
                discriminatorNode2.next = discriminatorNode.next;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "removeDiscriminatorNode");
                }
                return;
            }
            discriminatorNode2 = discriminatorNode;
            discriminatorNode = discriminatorNode.next;
        }
        if (discriminatorNode.disc.equals(discriminator)) {
            discriminatorNode2.next = null;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "removeDiscriminatorNode");
            }
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeDiscriminatorNode");
        }
        throw new NoSuchElementException();
    }

    public List getDiscriminators() {
        return this.discAL;
    }

    public Object getDiscriminatorNodes() {
        return this.discriminators;
    }

    public DiscriminationAlgorithm getDiscriminationAlgorithm() {
        return this.discriminationAlgorithm;
    }

    public void setDiscriminationAlgorithm(DiscriminationAlgorithm discriminationAlgorithm) {
        this.discriminationAlgorithm = discriminationAlgorithm;
    }

    public void destroy() {
    }

    public void start() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "start");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Started discriminator list " + this.discAL + "with size" + this.discAL.size());
        }
        if (this.discAL.size() > 1) {
            this.rebuildDiscriminatorList();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "multiple discriminators");
            }
            this.discriminationAlgorithm = new MultiDiscriminatorAlgorithm(this, this.name);
        } else if (this.discAL.size() == 1) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "single discriminator");
            }
            this.discriminationAlgorithm = new SingleDiscriminatorAlgorithm(this, this.name);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "no discriminators");
            }
            this.discriminationAlgorithm = new FailureDiscriminatorAlgorithm();
        }
        this.status = 1;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "start");
        }
    }

    public String getChannelName() {
        return this.name;
    }

    private void rebuildDiscriminatorList() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "rebuildArrayList");
        }
        this.discAL.clear();
        DiscriminatorNode discriminatorNode = this.discriminators;
        this.discAL.add(discriminatorNode.disc);
        discriminatorNode = discriminatorNode.next;
        while (discriminatorNode != null) {
            this.discAL.add(discriminatorNode.disc);
            discriminatorNode = discriminatorNode.next;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "rebuildArrayList");
        }
    }

    public int compareTo(Object object) {
        if (object == null || !(object instanceof DiscriminationProcessImpl)) {
            return -1;
        }
        return ((DiscriminationProcessImpl)object).getIndex() - this.myIndex;
    }

    int getIndex() {
        return this.myIndex;
    }

    private void addChannel(Channel channel) {
        if (this.channelList == null) {
            this.channelList = new Channel[1];
            this.channelList[0] = channel;
        } else {
            Channel[] channelArray = this.channelList;
            this.channelList = new Channel[channelArray.length + 1];
            System.arraycopy(channelArray, 0, this.channelList, 0, channelArray.length);
            this.channelList[channelArray.length] = channel;
        }
    }
}

