/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.plus.provider.icc;

import com.ibm.crypto.plus.provider.Poly1305Constants;
import com.ibm.crypto.plus.provider.icc.ByteArrayOutputDelay;
import com.ibm.crypto.plus.provider.icc.ICCContext;
import com.ibm.crypto.plus.provider.icc.ICCException;
import com.ibm.crypto.plus.provider.icc.NativeInterface;
import com.ibm.crypto.plus.provider.icc.Padding;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;

public final class Poly1305Cipher
implements Poly1305Constants {
    private ICCContext a;
    private long b;
    private boolean c = false;
    private boolean d = true;
    private Padding e = null;
    private int f = 0;
    private int g = 0;
    private int h = 0;
    private int i = 0;
    private boolean j = false;
    private byte[] k = null;
    private byte[] l = null;
    private ByteArrayOutputDelay m = null;
    private static final String n;
    private static final String[] z;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Poly1305Cipher getInstance(ICCContext iCCContext, String string, Padding padding) throws ICCException {
        if (iCCContext == null) {
            throw new IllegalArgumentException(z[16]);
        }
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException(z[18]);
        }
        if (padding == null) {
            throw new IllegalArgumentException(z[17]);
        }
        return new Poly1305Cipher(iCCContext, string, padding);
    }

    private Poly1305Cipher(ICCContext iCCContext, String string, Padding padding) throws ICCException {
        this.a = iCCContext;
        this.b = NativeInterface.POLY1305CIPHER_create(iCCContext.getId(), string);
        this.e = padding;
    }

    public synchronized void initCipherEncrypt(byte[] byArray, byte[] byArray2) throws ICCException {
        this.a(true, byArray, byArray2);
    }

    public synchronized void initCipherDecrypt(byte[] byArray, byte[] byArray2) throws ICCException {
        this.a(false, byArray, byArray2);
        this.m = new ByteArrayOutputDelay(16);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a(boolean bl, byte[] byArray, byte[] byArray2) throws ICCException {
        if (byArray == null || byArray.length == 0) {
            throw new IllegalArgumentException(z[14]);
        }
        if (byArray.length < this.getKeyLength()) {
            throw new IllegalArgumentException(z[12]);
        }
        if (byArray2 != null && byArray2.length < this.getIVLength()) {
            throw new IllegalArgumentException(z[15]);
        }
        if (this.b == 0L) {
            throw new ICCException(z[13]);
        }
        NativeInterface.POLY1305CIPHER_init(this.a.getId(), this.b, bl ? 1 : 0, byArray, byArray2);
        NativeInterface.POLY1305CIPHER_setPadding(this.a.getId(), this.b, this.e.getId());
        this.d = bl;
        this.f = 0;
        this.j = false;
        if (byArray != this.k) {
            if (this.k != null) {
                Arrays.fill(this.k, (byte)0);
            }
            this.k = (byte[])byArray.clone();
        }
        if (byArray2 != this.l) {
            this.l = byArray2 == null ? null : (byte[])byArray2.clone();
        }
        this.c = true;
    }

    public synchronized int getOutputSize(int n2, boolean bl, int n3) {
        if (n2 < 0) {
            return 0;
        }
        int n4 = this.f + n2;
        if (bl) {
            return n4 + n3;
        }
        int n5 = n4 < n3 ? 0 : n4 - n3;
        return n5;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized int getBlockSize() throws ICCException {
        if (this.g == 0) {
            if (this.b == 0L) {
                throw new ICCException(z[0]);
            }
            this.g = NativeInterface.POLY1305CIPHER_getBlockSize(this.a.getId(), this.b);
        }
        return this.g;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized int getKeyLength() throws ICCException {
        if (this.h == 0) {
            if (this.b == 0L) {
                throw new ICCException(z[2]);
            }
            this.h = NativeInterface.POLY1305CIPHER_getKeyLength(this.a.getId(), this.b);
        }
        return this.h;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized int getIVLength() throws ICCException {
        if (this.i == 0) {
            if (this.b == 0L) {
                throw new ICCException(z[1]);
            }
            this.i = NativeInterface.POLY1305CIPHER_getIVLength(this.a.getId(), this.b);
        }
        return this.i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized int update(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws IllegalStateException, ShortBufferException, ICCException {
        int n5;
        block38: {
            n5 = 0;
            if (!this.c) {
                throw new IllegalStateException(z[24]);
            }
            if (this.j) {
                this.a(this.d, this.k, this.l);
                this.j = false;
            }
            if (n3 == 0) {
                return n5;
            }
            if (byArray == null || n3 < 0 || n2 < 0 || n2 + n3 > byArray.length) {
                throw new IllegalArgumentException(z[21]);
            }
            if (byArray2 != null && (n4 < 0 || n4 > byArray2.length)) {
                throw new IllegalArgumentException(z[23]);
            }
            int n6 = n3;
            if (!this.d) {
                n6 -= this.m.getByteDelay();
            }
            if (byArray2 != null && byArray2.length != 0 && byArray2.length - n4 < n6) {
                throw new ShortBufferException(z[22] + n6 + z[19]);
            }
            byte[] byArray3 = null;
            if (byArray == byArray2 && (n2 == n4 || n2 < n4 && n4 < (n2 = n3) || n2 > n4 && n2 < n4 + n6)) {
                byArray3 = new byte[n3];
                System.arraycopy(byArray, n2, byArray3, 0, n3);
                byArray = byArray3;
                n2 = 0;
            }
            try {
                if (this.b == 0L) {
                    throw new ICCException(z[20]);
                }
                if (this.d) {
                    n5 = NativeInterface.POLY1305CIPHER_encryptUpdate(this.a.getId(), this.b, byArray, n2, n3, byArray2, n4);
                    break block38;
                }
                if (null != byArray2) {
                    byte[] byArray4 = this.a(byArray, n2, n3);
                    n5 = NativeInterface.POLY1305CIPHER_decryptUpdate(this.a.getId(), this.b, byArray4, 0, byArray4.length, byArray2, n4);
                } else {
                    n5 = NativeInterface.POLY1305CIPHER_decryptUpdate(this.a.getId(), this.b, byArray, n2, n3, byArray2, n4);
                }
            }
            finally {
                if (byArray3 != null && this.d) {
                    Arrays.fill(byArray3, (byte)0);
                }
            }
        }
        this.f += n3 - n5;
        return n5;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized int doFinal(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws IllegalStateException, ShortBufferException, IllegalBlockSizeException, BadPaddingException, ICCException {
        byte[] byArray3 = new byte[16];
        byte[] byArray4 = null;
        int n5 = 0;
        int n6 = 0;
        if (!this.c) {
            throw new IllegalStateException(z[9]);
        }
        if (this.j) {
            this.a(this.d, this.k, this.l);
            this.j = false;
        }
        if (n3 != 0 && (byArray == null || n3 < 0 || n2 < 0 || n2 + n3 > byArray.length)) {
            throw new IllegalArgumentException(z[10]);
        }
        if (!this.d) {
            byArray = this.b(byArray, n2, n3);
            n2 = 0;
            n3 = byArray.length;
            if (byArray3 == null && (byArray == null || n3 < 16)) {
                throw new IllegalArgumentException(z[6]);
            }
            if (n3 > 16) {
                n5 = n3 - 16;
                byArray4 = new byte[n5];
            }
        }
        if (this.d && (byArray2 == null || n4 < 0 || n4 > byArray2.length)) {
            throw new IllegalArgumentException(z[7]);
        }
        if ((!this.d || this.e.isPadding(0)) && (n3 + this.f) % this.getBlockSize() != 0) {
            throw new IllegalBlockSizeException(z[8]);
        }
        int n7 = this.getOutputSize(n3, this.d, 16);
        if (!this.d) {
            n7 -= 16;
        }
        if (byArray2.length - n4 < n7) {
            throw new ShortBufferException(z[5] + n7 + z[3]);
        }
        byte[] byArray5 = null;
        if (byArray == byArray2 && (n2 == n4 || n2 < n4 && n4 < (n2 = n3) || n2 > n4 && n2 < n4 + n7)) {
            byArray5 = new byte[n3];
            System.arraycopy(byArray, n2, byArray5, 0, n3);
            byArray = byArray5;
            n2 = 0;
        }
        try {
            if (this.b == 0L) {
                throw new ICCException(z[4]);
            }
            if (this.d) {
                n6 = NativeInterface.POLY1305CIPHER_encryptFinal(this.a.getId(), this.b, byArray, n2, n3, byArray2, n4, byArray3);
                System.arraycopy(byArray3, 0, byArray2, n6 + n4, 16);
                n6 += 16;
            } else {
                System.arraycopy(byArray, n3 - 16, byArray3, 0, 16);
                if (byArray4 != null) {
                    System.arraycopy(byArray, 0, byArray4, 0, n5);
                }
                n6 = NativeInterface.POLY1305CIPHER_decryptFinal(this.a.getId(), this.b, byArray4, n2, n5, byArray2, n4, byArray3);
            }
        }
        catch (ICCException iCCException) {
            if (iCCException.getCode() == 3) {
                throw new BadPaddingException(z[11]);
            }
            throw iCCException;
        }
        finally {
            if (byArray5 != null && this.d) {
                Arrays.fill(byArray5, (byte)0);
            }
        }
        this.f = 0;
        this.j = true;
        return n6;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized void finalize() throws Throwable {
        try {
            if (this.b == 0L) return;
            NativeInterface.POLY1305CIPHER_delete(this.a.getId(), this.b);
            this.b = 0L;
            return;
        }
        finally {
            if (this.k != null) {
                Arrays.fill(this.k, (byte)0);
                this.k = null;
            }
            super.finalize();
        }
    }

    protected static boolean a(long l2) {
        boolean bl = l2 != 0L;
        return bl;
    }

    protected byte[] a(byte[] byArray, int n2, int n3) {
        return this.m.write(byArray, n2, n3);
    }

    protected byte[] b(byte[] byArray, int n2, int n3) {
        byte[] byArray2 = this.m.flush();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray2.length + n3);
        byteArrayOutputStream.write(byArray2, 0, byArray2.length);
        if (null != byArray) {
            byteArrayOutputStream.write(byArray, n2, n3);
        }
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[25];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "q\u00137\u0004;@Z\u000e\b;\\\u000e.\n7W\bg\u0005-\u0012\u0014(\u0018~D\u001b+\u0005:";
        int n3 = 24;
        block33: while (true) {
            char[] cArray;
            block37: {
                int n4;
                int n5;
                block36: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block36;
                    n5 = n5;
                    if (n5 <= n4) break block37;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 50;
                            break;
                        }
                        case 1: {
                            n6 = 122;
                            break;
                        }
                        case 2: {
                            n6 = 71;
                            break;
                        }
                        case 3: {
                            n6 = 108;
                            break;
                        }
                        default: {
                            n6 = 94;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                case 24: {
                    n = string.intern();
                    string2 = "q\u00137\u0004;@Z\u000e\b;\\\u000e.\n7W\bg\u0005-\u0012\u0014(\u0018~D\u001b+\u0005:";
                    n3 = -1;
                    continue block33;
                }
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "q\u00137\u0004;@Z\u000e\b;\\\u000e.\n7W\bg\u0005-\u0012\u0014(\u0018~D\u001b+\u0005:";
                    n3 = 0;
                    continue block33;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "q\u00137\u0004;@Z\u000e\b;\\\u000e.\n7W\bg\u0005-\u0012\u0014(\u0018~D\u001b+\u0005:";
                    n3 = 1;
                    continue block33;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "\u0012\u0018>\u0018;AZ+\u00030U";
                    n3 = 2;
                    continue block33;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "q\u00137\u0004;@Z\u000e\b;\\\u000e.\n7W\bg\u0005-\u0012\u0014(\u0018~D\u001b+\u0005:";
                    n3 = 3;
                    continue block33;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "}\u000f3\u001c+FZ%\u00198T\u001f5L3G\t3L<WZo\r*\u0012\u0016\"\r-FSg";
                    n3 = 4;
                    continue block33;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "\u007f\u00134\u001f7\\\u001dg\u0018?UZ(\u0002~V\u001f$\u001e'B\u000eg\n7\\\u001b+";
                    n3 = 5;
                    continue block33;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "}\u000f3\u001c+FZ5\r0U\u001fg\u0005-\u0012\u0013)\u001a?^\u0013#";
                    n3 = 6;
                    continue block33;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "\u007f\u001f4\u001f?U\u001fg\u0001+A\u000eg\u000e;\u0012\u001bg\u0001+^\u000e.\u001c2WZ(\n~F\u0012\"L<^\u0015$\u0007~A\u0013=\t~E\u00133\u00041G\u000eg\u001c?V\u001e.\u00029";
                    n3 = 7;
                    continue block33;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "q\u00137\u0004;@Z)\u0003*\u0012\u0013)\u0005*[\u001b+\u0005$W\u001e";
                    n3 = 8;
                    continue block33;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "{\u00147\u0019*\u0012\b&\u00029WZ.\u001f~[\u00141\r2[\u001e";
                    n3 = 9;
                    continue block33;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "g\u0014\"\u0014.W\u00193\t:\u0012\n&\b:[\u0014 ";
                    n3 = 10;
                    continue block33;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "Y\u001f>L7AZ3\u0004;\u0012\r5\u00030UZ4\u0005$W";
                    n3 = 11;
                    continue block33;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "q\u00137\u0004;@Z\u000e\b;\\\u000e.\n7W\bg\u0005-\u0012\u0014(\u0018~D\u001b+\u0005:";
                    n3 = 12;
                    continue block33;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "Y\u001f>L7AZ)\u00192^U\"\u0001.F\u0003";
                    n3 = 13;
                    continue block33;
                }
                case 13: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 15;
                    string2 = "{,g\u0005-\u0012\u000e/\t~E\b(\u00029\u0012\t.\u0016;";
                    n3 = 14;
                    continue block33;
                }
                case 14: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 16;
                    string2 = "Q\u0015)\u0018;J\u000eg\u0005-\u0012\u00142\u00002";
                    n3 = 15;
                    continue block33;
                }
                case 15: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 17;
                    string2 = "B\u001b#\b7\\\u001dg\u0005-\u0012\u00142\u00002";
                    n3 = 16;
                    continue block33;
                }
                case 16: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 18;
                    string2 = "Q\u00137\u0004;@4&\u0001;\u0012\u00134L0G\u0016+C;_\n3\u0015";
                    n3 = 17;
                    continue block33;
                }
                case 17: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 19;
                    string2 = "\u0012\u0018>\u0018;AZ+\u00030U";
                    n3 = 18;
                    continue block33;
                }
                case 18: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 20;
                    string2 = "q\u00137\u0004;@Z\u000e\b;\\\u000e.\n7W\bg\u0005-\u0012\u0014(\u0018~D\u001b+\u0005:";
                    n3 = 19;
                    continue block33;
                }
                case 19: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 21;
                    string2 = "{\u00147\u0019*\u0012\b&\u00029WZ.\u001f~[\u00141\r2[\u001e";
                    n3 = 20;
                    continue block33;
                }
                case 20: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 22;
                    string2 = "}\u000f3\u001c+FZ%\u00198T\u001f5L3G\t3L<WZo\r*\u0012\u0016\"\r-FSg";
                    n3 = 21;
                    continue block33;
                }
                case 21: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 23;
                    string2 = "}\u000f3\u001c+FZ5\r0U\u001fg\u0005-\u0012\u0013)\u001a?^\u0013#";
                    n3 = 22;
                    continue block33;
                }
                case 22: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 24;
                    string2 = "q\u00137\u0004;@Z)\u0003*\u0012\u0013)\u0005*[\u001b+\u0005$W\u001e";
                    n3 = 23;
                    continue block33;
                }
                case 23: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

