/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.plus.provider;

import com.ibm.crypto.plus.provider.IBMJCEPlusProvider;
import com.ibm.crypto.plus.provider.icc.XECKey;
import com.ibm.security.util.BitArray;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.X509Key;
import ibm.security.internal.interfaces.EdECPublicKey;
import ibm.security.internal.spec.EdECPoint;
import ibm.security.internal.spec.NamedParameterSpec;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyRep;
import java.util.Arrays;

public final class EdDSAPublicKeyImpl
extends X509Key
implements EdECPublicKey {
    private static final long serialVersionUID = 1L;
    private EdECPoint point;
    private IBMJCEPlusProvider provider = null;
    private NamedParameterSpec paramSpec;
    private transient XECKey xecKey = null;
    private static final String[] z;

    private void a(NamedParameterSpec.CURVE cURVE) throws Exception {
        byte[] byArray = this.xecKey.getPublicKeyBytes();
        this.setKey(new BitArray(byArray.length * 8, byArray));
        this.paramSpec = new NamedParameterSpec(cURVE);
        byte by = byArray[byArray.length - 1];
        int n2 = byArray.length - 1;
        byArray[n2] = (byte)(byArray[n2] & 0x7F);
        boolean bl = (by & 0x80) != 0;
        boolean bl2 = bl;
        EdDSAPublicKeyImpl.b(byArray);
        BigInteger bigInteger = new BigInteger(1, byArray);
        this.point = new EdECPoint(bl2, bigInteger);
    }

    public EdDSAPublicKeyImpl(IBMJCEPlusProvider iBMJCEPlusProvider, XECKey xECKey, NamedParameterSpec.CURVE cURVE) throws InvalidKeyException {
        if (iBMJCEPlusProvider == null) {
            throw new InvalidKeyException(z[10]);
        }
        if (xECKey == null) {
            throw new InvalidKeyException(z[9]);
        }
        this.provider = iBMJCEPlusProvider;
        this.xecKey = xECKey;
        try {
            this.algid = XECKey.getAlgId(cURVE);
            this.a(cURVE);
        }
        catch (Exception exception) {
            InvalidKeyException invalidKeyException = new InvalidKeyException(z[11]);
            iBMJCEPlusProvider.a(invalidKeyException, (Throwable)exception);
            throw invalidKeyException;
        }
    }

    public EdDSAPublicKeyImpl(IBMJCEPlusProvider iBMJCEPlusProvider, NamedParameterSpec namedParameterSpec, EdECPoint edECPoint) throws InvalidKeyException {
        if (iBMJCEPlusProvider == null) {
            throw new InvalidKeyException(z[5]);
        }
        this.paramSpec = namedParameterSpec;
        this.point = edECPoint;
        try {
            this.algid = XECKey.getAlgId(namedParameterSpec.getCurve());
            byte[] byArray = edECPoint.getY().toByteArray();
            EdDSAPublicKeyImpl.b(byArray);
            byArray = Arrays.copyOf(byArray, NamedParameterSpec.getPublicCurveSize((NamedParameterSpec.CURVE)namedParameterSpec.getCurve()));
            int n2 = edECPoint.isXOdd() ? 128 : 0;
            byte by = (byte)n2;
            int n3 = byArray.length - 1;
            byArray[n3] = (byte)(byArray[n3] | by);
            this.setKey(new BitArray(byArray.length * 8, byArray));
            byte[] byArray2 = this.b();
            byte[] byArray3 = this.a(byArray2);
            this.xecKey = XECKey.createPublicKey(iBMJCEPlusProvider.a(), byArray3);
        }
        catch (Exception exception) {
            InvalidKeyException invalidKeyException = new InvalidKeyException(z[4]);
            iBMJCEPlusProvider.a(invalidKeyException, (Throwable)exception);
            throw invalidKeyException;
        }
        this.a(namedParameterSpec);
    }

    public EdDSAPublicKeyImpl(IBMJCEPlusProvider iBMJCEPlusProvider, byte[] byArray) throws InvalidKeyException {
        if (iBMJCEPlusProvider == null) {
            throw new InvalidKeyException(z[1]);
        }
        this.provider = iBMJCEPlusProvider;
        this.decode(byArray);
        try {
            byte[] byArray2 = this.getKey().toByteArray();
            byte by = byArray2[byArray2.length - 1];
            int n2 = byArray2.length - 1;
            byArray2[n2] = (byte)(byArray2[n2] & 0x7F);
            boolean bl = (by & 0x80) != 0;
            boolean bl2 = bl;
            EdDSAPublicKeyImpl.b(byArray2);
            BigInteger bigInteger = new BigInteger(1, byArray2);
            this.point = new EdECPoint(bl2, bigInteger);
            byte[] byArray3 = this.b();
            this.xecKey = XECKey.createPublicKey(iBMJCEPlusProvider.a(), byArray3);
        }
        catch (Exception exception) {
            InvalidKeyException invalidKeyException = new InvalidKeyException(z[0]);
            iBMJCEPlusProvider.a(invalidKeyException, (Throwable)exception);
            throw invalidKeyException;
        }
        this.a(this.paramSpec);
    }

    private byte[] a(byte[] byArray) throws IOException {
        DerInputStream derInputStream = new DerInputStream(byArray);
        DerValue[] derValueArray = derInputStream.getSequence(2);
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        ObjectIdentifier objectIdentifier = this.a(derValueArray[0].toDerInputStream(), derOutputStream2);
        derOutputStream.write((byte)48, derOutputStream2.toByteArray());
        if (derValueArray.length <= 1) {
            throw new IOException(z[2]);
        }
        Object object = derValueArray[1].getBitString();
        derOutputStream.putBitString(object);
        object = new DerOutputStream();
        object.write((byte)48, derOutputStream);
        return object.toByteArray();
    }

    void a(NamedParameterSpec namedParameterSpec) throws InvalidKeyException {
        if (NamedParameterSpec.getPublicCurveSize((NamedParameterSpec.CURVE)namedParameterSpec.getCurve()) * 8 != this.getKey().length()) {
            throw new InvalidKeyException(z[6] + NamedParameterSpec.getPublicCurveSize((NamedParameterSpec.CURVE)namedParameterSpec.getCurve()));
        }
    }

    public byte[] getEncodedPoint() {
        return this.getKey().toByteArray();
    }

    public EdECPoint getPoint() {
        return this.point;
    }

    public NamedParameterSpec getParams() {
        return this.paramSpec;
    }

    public String getAlgorithm() {
        return z[3];
    }

    XECKey a() {
        return this.xecKey;
    }

    private ObjectIdentifier a(DerInputStream derInputStream, DerOutputStream derOutputStream) throws IOException {
        ObjectIdentifier objectIdentifier = derInputStream.getOID();
        XECKey.checkOid(objectIdentifier);
        NamedParameterSpec.CURVE cURVE = XECKey.getCurve(objectIdentifier, null);
        if (derOutputStream != null) {
            derOutputStream.putOID(objectIdentifier);
        }
        this.paramSpec = new NamedParameterSpec(cURVE);
        return objectIdentifier;
    }

    private byte[] b() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        DerOutputStream derOutputStream3 = new DerOutputStream();
        derOutputStream3.putOID(this.algid.getOID());
        derOutputStream.write((byte)48, derOutputStream3.toByteArray());
        derOutputStream.putBitString(this.key);
        derOutputStream2.write((byte)48, derOutputStream);
        return derOutputStream2.toByteArray();
    }

    public byte[] getEncoded() {
        try {
            NamedParameterSpec.CURVE cURVE = this.paramSpec.getCurve();
            if (this.encodedKey == null) {
                this.encodedKey = this.a(super.getEncoded());
            }
            return (byte[])this.encodedKey.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void decode(byte[] byArray) throws InvalidKeyException {
        try {
            this.encodedKey = (byte[])byArray.clone();
            DerInputStream derInputStream = new DerInputStream(byArray);
            DerValue[] derValueArray = derInputStream.getSequence(2);
            if (derValueArray.length < 2) {
                throw new InvalidKeyException(z[8]);
            }
            DerInputStream derInputStream2 = derValueArray[0].toDerInputStream();
            ObjectIdentifier objectIdentifier = this.a(derInputStream2, null);
            this.algid = XECKey.getAlgId(this.paramSpec.getCurve());
            this.key = derValueArray[1].getBitString();
        }
        catch (Exception exception) {
            throw new InvalidKeyException(z[7]);
        }
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new KeyRep(KeyRep.Type.PUBLIC, this.getAlgorithm(), this.getFormat(), this.getEncoded());
    }

    private static void b(byte[] byArray) throws IOException {
        for (int i2 = 0; i2 < byArray.length / 2; ++i2) {
            byte by = byArray[i2];
            byArray[i2] = byArray[byArray.length - 1 - i2];
            byArray[byArray.length - 1 - i2] = by;
        }
    }

    private static void a(byte[] byArray, int n2, int n3) {
        byte by = byArray[n2];
        byArray[n2] = byArray[n3];
        byArray[n3] = by;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[12];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "-xk%X\u000f9v&\u001d\bkg(I\u000e9G-y8X\"9H\tuk*\u001d\u0000|{";
        int n3 = -1;
        block19: while (true) {
            char[] cArray;
            block23: {
                int n4;
                int n5;
                block22: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block22;
                    n5 = n5;
                    if (n5 <= n4) break block23;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 107;
                            break;
                        }
                        case 1: {
                            n6 = 25;
                            break;
                        }
                        case 2: {
                            n6 = 2;
                            break;
                        }
                        case 3: {
                            n6 = 73;
                            break;
                        }
                        default: {
                            n6 = 61;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\u001bkm?T\u000f|pi^\nwl&IK{giS\u001eun";
                    n3 = 0;
                    continue block19;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "/\\PiN\u000ehw,S\b|\"-R\u000ej\"'R\u001f9a&S\u001fxk'\u001d\u001bl`%T\b9i,D";
                    n3 = 1;
                    continue block19;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = ".}F\u001a|";
                    n3 = 2;
                    continue block19;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "-xk%X\u000f9v&\u001d\bkg(I\u000e9G-y8X\"9H\tuk*\u001d\u0000|{";
                    n3 = 3;
                    continue block19;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "\u001bkm?T\u000f|pi^\nwl&IK{giS\u001eun";
                    n3 = 4;
                    continue block19;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "\u0000|{iQ\u000ewe=UKtw:IK{gi";
                    n3 = 5;
                    continue block19;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = " |{iY\u0004|qiS\u0004m\"(M\u001b|c;\u001d\u001fv\"+XKx\"\fY/JCiV\u000e`";
                    n3 = 6;
                    continue block19;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = " |{iY\u0004|qiS\u0004m\"(M\u001b|c;\u001d\u001fv\"+XKx\"\fY/JCiV\u000e`";
                    n3 = 7;
                    continue block19;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "\u0013|a\u0002X\u00129a(S\u0005vvi_\u000e9l<Q\u0007";
                    n3 = 8;
                    continue block19;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "\u001bkm?T\u000f|pi^\nwl&IK{giS\u001eun";
                    n3 = 9;
                    continue block19;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "-xk%X\u000f9v&\u001d\bkg(I\u000e9Z\f~Kiw+Q\u0002z\"\"X\u0012";
                    n3 = 10;
                    continue block19;
                }
                case 10: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

