/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.xdg;

import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

class MimeGlob2File {
    private String filePath;
    private Map fileExtToMime;

    MimeGlob2File(String string) {
        this.filePath = string;
    }

    private void initIfNecessary() {
        File file;
        if (this.fileExtToMime == null) {
            this.fileExtToMime = new HashMap();
        }
        if ((file = new File(this.filePath)).exists()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                String string = bufferedReader.readLine();
                while (string != null) {
                    this.parseLine(string);
                    string = bufferedReader.readLine();
                }
            }
            catch (IOException iOException) {
                Trace.ignored(iOException);
            }
        } else {
            Trace.println("globs2 doesn't exist, path == " + this.filePath, TraceLevel.TEMP);
        }
    }

    private void parseLine(String string) {
        if (string.startsWith("#")) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        String string4 = stringTokenizer.nextToken();
        this.fileExtToMime.put(string4, string3);
    }

    boolean mapsFileExtToMimetype(String string, String string2) {
        this.initIfNecessary();
        String string3 = (String)this.fileExtToMime.get(string);
        boolean bl = false;
        if (string3 != null) {
            bl = string3.equals(string2);
        }
        return bl;
    }

    void getFileExtListByMimeType(List list, String string) {
        this.initIfNecessary();
        Set set = this.fileExtToMime.keySet();
        for (String string2 : set) {
            if (!this.mapsFileExtToMimetype(string2, string)) continue;
            if (string2.startsWith("*.")) {
                string2 = string2.substring(2, string2.length());
            }
            list.add(string2);
        }
    }

    String getMimeTypeByFileExt(String string) {
        this.initIfNecessary();
        return (String)this.fileExtToMime.get(string);
    }
}

