/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.format;

import com.ibm.jvm.format.TraceArgs;
import com.ibm.jvm.format.TraceFormat;
import java.io.PrintStream;
import java.math.BigInteger;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public final class Util {
    private static Properties properties;
    private static Hashtable threads;
    private static int timerType;
    private static Hashtable components;
    private static boolean bigendian;
    static final String[] timerDesc;
    protected static final int BYTE = 1;
    protected static final int INT = 4;
    protected static final int LONG = 8;
    protected static final String SUM_TAB = "        ";
    protected static final BigInteger MILLIS2SECONDS;
    protected static final BigInteger SECONDS2MINUTES;
    protected static final BigInteger MINUTES2HOURS;
    protected static final BigInteger HOURS2DAYS;
    protected static final BigInteger MILLION;

    private Util() {
    }

    protected static final void initStatics() {
        properties = null;
        threads = null;
        components = null;
    }

    protected static final void putThreadID(Long threadID) {
        if (threads == null) {
            threads = new Hashtable();
        }
        threads.put(threadID, threadID);
    }

    protected static final boolean findThreadID(Long threadID) {
        if (threads == null) {
            return true;
        }
        return threads.containsKey(threadID);
    }

    protected static final void putComponent(String comp) {
        if (components == null) {
            components = new Hashtable();
        }
        components.put(comp.toLowerCase(), new TypeList());
    }

    protected static final void putComponent(String comp, Vector types) {
        if (components == null) {
            components = new Hashtable();
        }
        components.put(comp.toLowerCase(), new TypeList(types));
    }

    protected static final boolean findComponentAndType(String comp, String type) {
        if (components == null) {
            return true;
        }
        if (comp.equals("dg")) {
            return true;
        }
        return components.containsKey(comp) && ((TypeList)components.get(comp)).contains(type);
    }

    static final void determineEncoding(byte testChar) {
        Debug.println("Encoding is Ascii: " + (char)testChar + "= D");
        Util.setProperty("ENCODING", "ASCII");
    }

    private static final void reverseByteOrder(byte[] data) {
        for (int i = 0; i < data.length / 2; ++i) {
            byte temp = data[i];
            data[i] = data[data.length - 1 - i];
            data[data.length - 1 - i] = temp;
        }
    }

    protected static final BigInteger constructUnsignedLong(byte[] data, int offset) {
        return Util.constructUnsignedLong(data, offset, 8);
    }

    protected static final BigInteger constructUnsignedLong(byte[] data, int offset, int numBytes) {
        byte[] bytes = new byte[numBytes];
        try {
            System.arraycopy(data, offset, bytes, 0, numBytes);
            if (!bigendian) {
                Util.reverseByteOrder(bytes);
            }
            BigInteger temp = new BigInteger(1, bytes);
            return temp;
        }
        catch (Exception e) {
            TraceFormat.outStream.println("******************* Exception: data.length " + data.length + " offset " + offset + " numBytes " + numBytes);
            return null;
        }
    }

    protected static final int constructTraceID(byte[] data, int offset) {
        return data[offset] << 16 & 0xFF0000 | data[offset + 1] << 8 & 0xFF00 | data[offset + 2] & 0xFF;
    }

    protected static final long constructUnsignedInt(byte[] data, int offset) {
        return !bigendian ? (long)data[offset + 3] << 24 & 0xFF000000L | (long)data[offset + 2] << 16 & 0xFF0000L | (long)data[offset + 1] << 8 & 0xFF00L | (long)data[offset] & 0xFFL : (long)data[offset] << 24 & 0xFF000000L | (long)data[offset + 1] << 16 & 0xFF0000L | (long)data[offset + 2] << 8 & 0xFF00L | (long)data[offset + 3] & 0xFFL;
    }

    protected static final int constructUnsignedByte(byte[] data, int offset) {
        return data[offset] & 0xFF;
    }

    private static final int findNull(byte[] data, int index) {
        while (index < data.length) {
            if (data[index] == 0) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    protected static final String constructString(byte[] data, int offset) {
        return Util.constructString(data, offset, Util.getProperty("ENCODING", "ASCII"));
    }

    protected static final String constructString(byte[] data, int offset, String enc) {
        int nullChar = Util.findNull(data, offset);
        if (nullChar == -1) {
            return "";
        }
        return Util.constructString(data, offset, nullChar - offset, enc);
    }

    protected static final String constructString(byte[] data, int offset, int count) {
        return Util.constructString(data, offset, count, Util.getProperty("ENCODING", "ASCII"));
    }

    static boolean charIsOneOfControlCharactersToRemove(char c) {
        return c < '\t';
    }

    protected static final String constructString(byte[] data, int offset, int count, String enc) {
        try {
            if (offset + count > data.length) {
                return "";
            }
            StringBuffer tempString = new StringBuffer();
            String beforeRemovingControlChars = new String(data, offset, count, enc);
            if (enc.equalsIgnoreCase("ASCII")) {
                for (int i = 0; i < beforeRemovingControlChars.length(); ++i) {
                    char c = beforeRemovingControlChars.charAt(i);
                    if (Util.charIsOneOfControlCharactersToRemove(c)) {
                        String octalRepresentation = Integer.toOctalString(c);
                        String formattedOctalRepresentation = "\\u" + "0000".substring(octalRepresentation.length()) + octalRepresentation;
                        tempString.append(formattedOctalRepresentation);
                        continue;
                    }
                    tempString.append(c);
                }
            } else {
                tempString.append(beforeRemovingControlChars);
            }
            return tempString.toString();
        }
        catch (Exception e) {
            TraceFormat.outStream.println("Util.constructString (1) ****> offset: " + offset + ", count = " + count + " data = " + data);
            TraceFormat.outStream.println("Util.constructString (2) ****> " + e);
            return "";
        }
    }

    protected static final void setProperty(String key, String val) {
        if (properties == null) {
            properties = new Properties();
        }
        properties.setProperty(key, val);
    }

    protected static final String getProperty(String key) {
        if (properties == null) {
            properties = new Properties();
        }
        return properties.getProperty(key);
    }

    protected static final String getProperty(String key, String defaultValue) {
        if (properties == null) {
            properties = new Properties();
        }
        return properties.getProperty(key, defaultValue);
    }

    protected static final void padBuffer(StringBuffer sb, int i, char c) {
        Util.padBuffer(sb, i, c, false);
    }

    protected static final void padBuffer(StringBuffer sb, int i, char c, boolean leftJustified) {
        while (sb.length() < i) {
            if (leftJustified) {
                sb.append(c);
                continue;
            }
            sb.insert(0, c);
        }
    }

    static final void setTimerType(int type) {
        timerType = type;
    }

    static final String getTimerDescription() {
        return timerDesc[timerType];
    }

    static final void printDump(byte[] buffer, int length) {
        for (int i = 0; i < length / 16 + 1; ++i) {
            StringBuffer buf1 = new StringBuffer(100);
            StringBuffer buf2 = new StringBuffer(100);
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 4 && k + j * 4 + i * 16 < length; ++k) {
                    Util.byte2hex(buffer[k + j * 4 + i * 16], buf1);
                    if (buffer[k + j * 4 + i * 16] > 40 && buffer[k + j * 4 + i * 16] < 128) {
                        buf2.append((char)buffer[k + j * 4 + i * 16]);
                        continue;
                    }
                    buf2.append(".");
                }
                buf1.append(" ");
            }
            Debug.println(Util.formatAsHexString(i * 16) + ": " + buf1 + " " + buf2);
        }
    }

    public static final String formatAsHexString(long number) {
        return "0x" + Long.toHexString(number);
    }

    private static void byte2hex(byte b, StringBuffer buf) {
        char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int high = (b & 0xF0) >> 4;
        int low = b & 0xF;
        buf.append(hexChars[high]);
        buf.append(hexChars[low]);
    }

    static final String getFormattedTime(BigInteger time) {
        switch (timerType) {
            case 2: 
            case 4: 
            case 5: 
            case 7: {
                if ((double)TraceFormat.verMod >= 1.1) {
                    time = time.subtract(TraceFormat.overallStartPlatform);
                    BigInteger[] splitTime = time.divideAndRemainder(TraceFormat.timeConversion);
                    BigInteger[] secondsMillis = splitTime[0].add(TraceFormat.overallStartSystem).divideAndRemainder(MILLIS2SECONDS);
                    BigInteger nanos = secondsMillis[1].multiply(MILLION).add(splitTime[1].multiply(MILLION).divide(TraceFormat.timeConversion));
                    BigInteger[] minutesSeconds = secondsMillis[0].divideAndRemainder(SECONDS2MINUTES);
                    BigInteger[] hoursMinutes = minutesSeconds[0].divideAndRemainder(MINUTES2HOURS);
                    BigInteger[] daysHours = hoursMinutes[0].divideAndRemainder(HOURS2DAYS);
                    daysHours[1] = daysHours[1].add(TraceArgs.timeZoneOffset);
                    try {
                        return "00".substring(daysHours[1].toString().length()) + daysHours[1].toString() + ":" + "00".substring(hoursMinutes[1].toString().length()) + hoursMinutes[1].toString() + ":" + "00".substring(minutesSeconds[1].toString().length()) + minutesSeconds[1].toString() + "." + "000000000".substring(nanos.toString().length()) + nanos.toString();
                    }
                    catch (Exception e) {
                        Debug.println(daysHours[1].toString() + ":" + hoursMinutes[1].toString() + ":" + minutesSeconds[1].toString() + "." + nanos.toString());
                        return "Bad Time: " + time.toString(16);
                    }
                }
                return "0000000000000000".substring(time.toString(16).length()) + time.toString(16);
            }
            case 3: {
                long seconds = time.shiftRight(32).longValue() & 0xFFFFFFFFL;
                long nanos = time.longValue() & 0xFFFFFFFFL;
                long ss = seconds % 60L;
                long mm = seconds / 60L % 60L;
                long hh = seconds / 3600L % 24L;
                try {
                    return "00".substring(Long.toString(hh).length()) + Long.toString(hh) + ":" + "00".substring(Long.toString(mm).length()) + Long.toString(mm) + ":" + "00".substring(Long.toString(ss).length()) + Long.toString(ss) + "." + "000000000".substring(Long.toString(nanos).length()) + Long.toString(nanos);
                }
                catch (Exception e) {
                    Debug.println("hh: " + Long.toString(hh) + " mm: " + Long.toString(mm) + " ss: " + Long.toString(ss) + " Nanos: " + Long.toString(nanos));
                    return "Bad Time: " + time.toString(16);
                }
            }
            case 6: {
                long micros = time.shiftRight(12).longValue() & 0xFFFFFFFFFFFFFL;
                long ss = micros / 1000000L % 60L;
                long mm = micros / 60000000L % 60L;
                long hh = micros / 3600000000L % 24L;
                long picos = (time.longValue() & 0xFFFL | (micros %= 1000000L) << 12) * 244140625L / 1000000L;
                try {
                    return "00".substring(Long.toString(hh).length()) + Long.toString(hh) + ":" + "00".substring(Long.toString(mm).length()) + Long.toString(mm) + ":" + "00".substring(Long.toString(ss).length()) + Long.toString(ss) + "." + "000000000000".substring(Long.toString(picos).length()) + Long.toString(picos);
                }
                catch (Exception e) {
                    Debug.println("hh: " + Long.toString(hh) + " mm: " + Long.toString(mm) + " ss: " + Long.toString(ss) + " Picos: " + Long.toString(picos));
                    return "Bad Time: " + time.toString(16);
                }
            }
        }
        return "0000000000000000".substring(time.toString(16).length()) + time.toString(16);
    }

    protected static final int convertEndian(int in) {
        return in >>> 24 | in << 24 | in << 8 & 0xFF0000 | in >> 8 & 0xFF00;
    }

    protected static final String convertAndCheckEyecatcher(int eyecatcher) {
        String eyeCatcherString;
        eyecatcher = bigendian ? eyecatcher : Util.convertEndian(eyecatcher);
        switch (eyecatcher) {
            case 0x48545455: {
                eyeCatcherString = "UTTH (in ASCII)";
                break;
            }
            case 0x55545448: {
                eyeCatcherString = "UTTH (in ASCII)";
                break;
            }
            case 0x55545453: {
                eyeCatcherString = "UTTS (in ASCII)";
                break;
            }
            case 0x55545353: {
                eyeCatcherString = "UTSS (in ASCII)";
                break;
            }
            case 1431589711: {
                eyeCatcherString = "UTSO (in ASCII)";
                break;
            }
            case 0x55545441: {
                eyeCatcherString = "UTTA (in ASCII)";
                break;
            }
            case 1431588946: {
                eyeCatcherString = "UTPR (in ASCII)";
                break;
            }
            case -454827064: {
                eyeCatcherString = "UTTH (in EBCDIC)";
                break;
            }
            case -454827038: {
                eyeCatcherString = "UTTS (in EBCDIC)";
                break;
            }
            case -454827294: {
                eyeCatcherString = "UTSS (in EBCDIC)";
                break;
            }
            case -454827306: {
                eyeCatcherString = "UTSO (in EBCDIC)";
                break;
            }
            case -454827071: {
                eyeCatcherString = "UTTA (in EBCDIC)";
                break;
            }
            case -454830119: {
                eyeCatcherString = "UTPR (in EBCDIC)";
                break;
            }
            case 1213482820: {
                eyeCatcherString = "DGTH (in ASCII)";
                break;
            }
            case 1145525320: {
                eyeCatcherString = "DGTH (in ASCII)";
                break;
            }
            case 1145525331: {
                eyeCatcherString = "DGTS (in ASCII)";
                break;
            }
            case 1145525075: {
                eyeCatcherString = "DGSS (in ASCII)";
                break;
            }
            case 1145525071: {
                eyeCatcherString = "DGSO (in ASCII)";
                break;
            }
            case 1145525313: {
                eyeCatcherString = "DGTA (in ASCII)";
                break;
            }
            case 1145524306: {
                eyeCatcherString = "DGPR (in ASCII)";
                break;
            }
            case -993532984: {
                eyeCatcherString = "DGTH (in EBCDIC)";
                break;
            }
            case -993532958: {
                eyeCatcherString = "DGTS (in EBCDIC)";
                break;
            }
            case -993533214: {
                eyeCatcherString = "DGSS (in EBCDIC)";
                break;
            }
            case -993533226: {
                eyeCatcherString = "DGSO (in EBCDIC)";
                break;
            }
            case -993532991: {
                eyeCatcherString = "DGTA (in EBCDIC)";
                break;
            }
            case -993536039: {
                eyeCatcherString = "DGPR (in EBCDIC)";
                break;
            }
            default: {
                eyeCatcherString = "eyecatcher is bad " + Util.formatAsHexString(eyecatcher) + " *********************************";
            }
        }
        return eyeCatcherString;
    }

    protected static final void setBigEndian(boolean endian) {
        bigendian = endian;
    }

    static {
        timerDesc = new String[]{"Sequence number    ", "Special            ", "Pentium TSC        ", "Time (UTC)         ", "MSPR               ", "MFTB               ", "Time (UTC)         ", "J9 timer(UTC)      "};
        MILLIS2SECONDS = BigInteger.valueOf(1000L);
        SECONDS2MINUTES = BigInteger.valueOf(60L);
        MINUTES2HOURS = BigInteger.valueOf(60L);
        HOURS2DAYS = BigInteger.valueOf(24L);
        MILLION = BigInteger.valueOf(1000000L);
    }

    static class Debug {
        static PrintStream out = TraceFormat.outStream;

        Debug() {
        }

        static void println(Object o) {
            if (TraceArgs.debug) {
                out.println(o);
            }
        }

        static void print(Object o) {
            if (TraceArgs.debug) {
                out.print(o);
            }
        }
    }

    static final class TypeList {
        Hashtable types;

        TypeList() {
        }

        TypeList(Vector typeNames) {
            this.types = new Hashtable();
            for (int i = 0; i < typeNames.size(); ++i) {
                String t = ((String)typeNames.elementAt(i)).toLowerCase();
                this.types.put(t, t);
            }
        }

        final boolean contains(String type) {
            if (this.types == null) {
                return true;
            }
            return this.types.containsKey(type);
        }
    }
}

