/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.impl.marshalling.connection;

import com.ibm.java.diagnostics.healthcenter.connection.ConnectionDataBuilder;
import com.ibm.java.diagnostics.healthcenter.connection.ConnectionType;
import com.ibm.java.diagnostics.healthcenter.connection.HealthCenterConnectionException;
import com.ibm.java.diagnostics.healthcenter.impl.jmx.JMXAgentConnection;
import com.ibm.java.diagnostics.healthcenter.impl.jmx.JMXAgentConnectionManager;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.JMXConnectionDataImpl;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.LocalJMXConnectionDataImpl;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.LocalNativeConnectionDataImpl;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.MQTTConnectionDataImpl;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.connection.AgentConnectionImpl;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.connection.ConnectionDataImpl;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.connection.ConnectionProperties;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.connection.FileConnectionDataImpl;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.connection.ZipFileConnectionDataImpl;
import com.ibm.java.diagnostics.healthcenter.impl.mqtt.MQTTAgentConnection;
import com.ibm.java.diagnostics.healthcenter.impl.mqtt.MQTTAgentConnectionManager;
import com.ibm.java.diagnostics.healthcenter.marshalling.ConnectionDataFactory;
import java.io.File;
import java.io.IOException;
import java.util.zip.ZipFile;

public class ConnectionDataFactoryImpl
implements ConnectionDataFactory {
    public ConnectionDataBuilder createConnectionData() {
        ConnectionDataImpl connectionDataImpl;
        try {
            connectionDataImpl = new LocalNativeConnectionDataImpl();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            connectionDataImpl = new LocalJMXConnectionDataImpl();
        }
        return connectionDataImpl;
    }

    @Override
    public ConnectionDataBuilder createConnectionData(File file) {
        ConnectionDataImpl connectionDataImpl = this.isZipFile(file) ? new ZipFileConnectionDataImpl(file) : new FileConnectionDataImpl(file);
        return connectionDataImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isZipFile(File file) {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file);
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public ConnectionDataBuilder createConnectionData(ConnectionProperties connectionProperties) throws HealthCenterConnectionException {
        AgentConnectionImpl agentConnectionImpl;
        ConnectionDataImpl connectionDataImpl = null;
        if (connectionProperties.getConnectionType().equals((Object)ConnectionType.JMX)) {
            agentConnectionImpl = (JMXAgentConnection)new JMXAgentConnectionManager(connectionProperties).getHealthCenterAgent();
            connectionDataImpl = new JMXConnectionDataImpl((JMXAgentConnection)agentConnectionImpl);
        }
        if (connectionProperties.getConnectionType().equals((Object)ConnectionType.MQTT) || connectionProperties.getConnectionType().equals((Object)ConnectionType.BLUEMIX)) {
            agentConnectionImpl = (MQTTAgentConnection)new MQTTAgentConnectionManager(connectionProperties).getHealthCenterAgent();
            connectionDataImpl = new MQTTConnectionDataImpl((MQTTAgentConnection)agentConnectionImpl, connectionProperties);
        }
        return connectionDataImpl;
    }

    public ConnectionDataBuilder createConnectionData(ConnectionProperties connectionProperties, String string) throws HealthCenterConnectionException {
        AgentConnectionImpl agentConnectionImpl;
        ConnectionDataImpl connectionDataImpl = null;
        if (connectionProperties.getConnectionType().equals((Object)ConnectionType.JMX)) {
            agentConnectionImpl = (JMXAgentConnection)new JMXAgentConnectionManager(connectionProperties).getHealthCenterAgent(string);
            connectionDataImpl = new JMXConnectionDataImpl((JMXAgentConnection)agentConnectionImpl);
        }
        if (connectionProperties.getConnectionType().equals((Object)ConnectionType.MQTT) || connectionProperties.getConnectionType().equals((Object)ConnectionType.BLUEMIX)) {
            agentConnectionImpl = (MQTTAgentConnection)new MQTTAgentConnectionManager(connectionProperties).getHealthCenterAgent(string);
            connectionDataImpl = new MQTTConnectionDataImpl((MQTTAgentConnection)agentConnectionImpl, connectionProperties);
        }
        return connectionDataImpl;
    }
}

