/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.gc.postprocessor.analysis;

import com.ibm.java.diagnostics.common.datamodel.data.Data;
import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.DataPoint;
import com.ibm.java.diagnostics.common.datamodel.data.DataPointBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.Status;
import com.ibm.java.diagnostics.common.datamodel.data.StringData;
import com.ibm.java.diagnostics.common.datamodel.data.StructuredStringDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.SubsystemDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.TableData;
import com.ibm.java.diagnostics.common.datamodel.data.TableDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.TableDataRow;
import com.ibm.java.diagnostics.common.datamodel.data.TwoDimensionalData;
import com.ibm.java.diagnostics.common.datamodel.data.TwoDimensionalDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.axes.Axis;
import com.ibm.java.diagnostics.common.datamodel.data.axes.YDataAxis;
import com.ibm.java.diagnostics.common.datamodel.factory.DataFactory;
import com.ibm.java.diagnostics.common.datamodel.impl.axes.NumberFormatter;
import com.ibm.java.diagnostics.common.datamodel.impl.converters.UnitLabels;
import com.ibm.java.diagnostics.common.datamodel.impl.data.TableDataImpl;
import com.ibm.java.diagnostics.healthcenter.JVMLabels;
import com.ibm.java.diagnostics.healthcenter.environment.EnvironmentData;
import com.ibm.java.diagnostics.healthcenter.environment.data.EnvironmentDataImpl;
import com.ibm.java.diagnostics.healthcenter.environment.labels.EnvironmentLabels;
import com.ibm.java.diagnostics.healthcenter.gc.parser.constants.GCAxes;
import com.ibm.java.diagnostics.healthcenter.gc.parser.constants.GCLabels;
import com.ibm.java.diagnostics.healthcenter.gc.parser.constants.GCReasons;
import com.ibm.java.diagnostics.healthcenter.gc.parser.constants.GCType;
import com.ibm.java.diagnostics.healthcenter.gc.postprocessor.analysis.Messages;
import com.ibm.java.diagnostics.healthcenter.gc.postprocessor.analysis.SummarisingPostProcessorLabels;
import com.ibm.java.diagnostics.healthcenter.gc.postprocessor.analysis.SummarisingPostProcessorPreferenceHelper;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.data.JVMDataImpl;
import com.ibm.java.diagnostics.healthcenter.postprocessor.VMLevelChecker;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Summariser {
    private static final String EMPTY_STRING = "";
    private static final String SPACE = " ";
    private static final String XNOCLASSGC = "-Xnoclassgc";
    private static final String MEGABYTES_UNITS_FOR_COMMANDS = "m";
    private static final Pattern GCPOLICYMATCHER = Pattern.compile("-Xgcpolicy:(.*?)@@@");
    private static final double ALMOST_ZERO = 1.0E-9;
    private static final int MINIMUM_OVERHEAD_FOR_OCCUPANCY_WARNING = 5;
    private static final int NUMBER_OF_POINTS_REQUIRED_FOR_LEAK_ANALYSIS = 100;
    private static final double RECOMMENDED_MAXF = 0.9;
    private static final String XMAXF = "-Xmaxf";
    private static final String MX = "-Xmx";
    private static final String NURSERY_SIZE = "-Xmn";
    private static final String XGCPOLICY_GENCON = "-Xgcpolicy:gencon";
    private static final String XGCPOLICY = "-Xgcpolicy:";
    private static final int MAX_32_BIT_HEAP_SIZE = 1500;
    private static final String OPTIMAL_OCCUPANCY_MESSAGE = Messages.getString("SummarisingPostProcessor.optimal.occupancy.message");
    private static final String TIMEOUTSIDE_GC_MESSAGE = Messages.getString("SummarisingPostProcessor.time.spent.outsideGC");
    private static final String HIGH_OCCUPANCY_MESSAGE = Messages.getString("SummarisingPostProcessor.high.occupancy.message");
    private static final String HIGH_OCCUPANCY_OVERHEAD_MESSAGE = Messages.getString("SummarisingPostProcessor.high.occupancy.overhead.message");
    private static final String HIGH_OCCUPANCY_OVERHEAD_OPTAVGPAUSE_MESSAGE = Messages.getString("SummarisingPostProcessor.high.occupancy.overhead.optavgpause.message");
    private static final String RATE_PLUS_UNITS = Messages.getString("Summariser.rate.plus.units");
    private static final String TRY_GENCON_NOT_OPTAVGPAUSE = Messages.getString("SummarisingPostProcessor.try.gencon.not.optavgpause");
    private static final Pattern J9REGEX = Pattern.compile("20[0-9][0-9][0-9][0-9][0-9][0-9]_[A-Z][A-Z]");
    private static final String MEAN_INTERVAL = Messages.getString("SummarisingPostProcessor.mean.interval");
    private static final String HEAP_GROWING_COLLECTIONS_SHRINKING = Messages.getString("SummarisingPostProcessor.heap.growing.collections.shrinking");
    private static final String TUNE_NURSERY = Messages.getString("SummarisingPostProcessor.tune.nursery");
    private static final String JUST_USE_GENCON = Messages.getString("SummarisingPostProcessor.use.gencon");
    private static final String JUST_USE_GENCON_FROM_OPTAVGPAUSE = "";
    private static final String COLLECTIONS_INCREASING_HEAP_SHRINKING = Messages.getString("SummarisingPostProcessor.collections.increasing.heap.shrinking");
    private static final String COMMAND_LINE = Messages.getString("SummarisingPostProcessor.recommended.command.line");
    private static final String USAGE_GROWING_HEAP_GROWING = Messages.getString("SummarisingPostProcessor.usage.growing.heap.growing");
    private static final String HEAP_INCREASING_WHILE_COLLECTIONS_STEADY = Messages.getString("SummarisingPostProcessor.4");
    private static final String LEAK_WARNING = Messages.getString("SummarisingPostProcessor.leak.warning");
    private static final String HOW_TO_FIX_LEAK = Messages.getString("SummarisingPostProcessor.how.to.fix.leak");
    private static final String USAGE_GROWING = Messages.getString("SummarisingPostProcessor.heap.usage.growing");
    private static final String LOW_OCCUPANCY_MESSAGE = Messages.getString("SummarisingPostProcessor.low.occupancy.message");
    private static final String HIGH_OCCUPANCY_GENCON_RECOMMENDATION = Messages.getString("SummarisingPostProcessor.high.occupancy.gencon.recommendation");
    private static final String NO_LEAK_COMMENT = Messages.getString("SummarisingPostProcessor.no.leaks");
    private static final String FRAGMENTATION_WARNING = Messages.getString("SummarisingPostProcessor.high.fragmentation");
    private static final String OPTAVGPAUSE_FRAGMENTATION_WARNING = Messages.getString("SummarisingPostProcessor.optavgpause.fragmentation.warning");
    private static final String GENCON_FRAGMENTATION_WARNING = Messages.getString("SummarisingPostProcessor.gencon.fragmentation.warning");
    private static final String OPTTHRUPUT_FRAGMENTATION_WARNING = Messages.getString("SummarisingPostProcessor.optthruput.fragmentation.warning");
    private static final String LARGE_OBJECT_WARNING = Messages.getString("SummarisingPostProcessor.large.object.warning");
    private static final String LARGE_PAUSE_WARNING = Messages.getString("SummarisingPostProcessor.large.pause.warning");
    private static final String REALTIME_LARGE_PAUSE_WARNING = Messages.getString("SummarisingPostProcessor.realtime.large.pause.warning");
    private static final String LOTS_SYSTEM_GCS_WARNING = Messages.getString("SummarisingPostProcessor.lots.system.gcs.warning");
    private static final String REALTIME_SYSTEM_GCS_WARNING = Messages.getString("SummarisingPostProcessor.realtime.system.gcs.warning");
    private static final String LOTS_SYNCH_GCS_WARNING = Messages.getString("SummarisingPostProcessor.lots.synch.gcs.warning");
    public static final String TOTAL_NUMBER_OF_SYNCHGC_COLLECTIONS = Messages.getString("SummarisingPostProcessor.total.synchgc");
    public static final String APPLICATION_LEAKING = Messages.getString("application.leaking");
    private static final int ONE_HUNDRED_PERCENT = 100;
    public static final String SUBPOOL = "subpool";
    public static final String OPTTHRUPUT = "optthruput";
    public static final String OPTAVGPAUSE = "optavgpause";
    public static final String GENCON = "gencon";
    public static final String BALANCED = "balanced";
    public static final String REALTIME = Messages.getString("Summariser.realtime.gc.mode");
    public static final String UNKNOWN = Messages.getString("SummarisingPostProcessor.unknown");
    private static final String DASH = " - ";
    private DataFactory factory = DataFactory.getFactory(JVMLabels.GARBAGE_COLLECTION);
    private StructuredStringDataBuilder commentData;
    private String gcMode;
    private TwoDimensionalDataBuilder scopeRecord;
    private double overhead;
    private static final int UNSET = -1;
    public static final String DEFAULT = Messages.getString("Summariser.default.gc.mode");
    private Map<String, String> recommendedCommandLine;
    private SummarisingPostProcessorPreferenceHelper helper = new SummarisingPostProcessorPreferenceHelper();
    private String commandLine;
    private String vmVersion;
    private boolean isDefaultPolicy = false;
    private boolean isVMRealtime = false;
    private boolean isVMSoftRealtime = false;
    private boolean isNode = false;
    private boolean hasAFCounts = false;
    private boolean genconAvailable = false;
    private static final double DEFAULT_MINOR_THRESHOLD = 1.0;
    private static final double DEFAULT_MODERATE_THRESHOLD = 0.3;
    private static final double DEFAULT_MAJOR_THRESHOLD = 0.6;
    private boolean vm_data_initialized = false;

    public void addSummaryData(DataBuilder dataBuilder) {
        Object object;
        Object object2;
        Data data;
        DataBuilder dataBuilder2 = dataBuilder.getTopLevelData(EnvironmentLabels.ENVIRONMENT_LABEL);
        this.extractEnvironmentInformation(dataBuilder2);
        if (dataBuilder2 instanceof EnvironmentData) {
            data = (EnvironmentData)((Object)dataBuilder2);
            object2 = data.getVMLevelChecker();
            object = (JVMDataImpl)dataBuilder.findRootData();
            if (object2 != null) {
                this.vmVersion = ((VMLevelChecker)object2).getVMVersion();
                this.isVMRealtime = ((JVMDataImpl)object).isRealtimeVM();
                this.isVMSoftRealtime = ((JVMDataImpl)object).isSoftRealtimeVM();
                if (((VMLevelChecker)object2).isVMRealtime() || ((JVMDataImpl)object).isRealtimeVM() || ((JVMDataImpl)object).isSoftRealtimeVM()) {
                    this.isVMRealtime = true;
                }
                if (!this.isVMRealtime) {
                    this.hasAFCounts = ((VMLevelChecker)object2).isJava6AfterSr1();
                }
                this.vm_data_initialized = true;
            }
        }
        if ((data = dataBuilder.getData(UnitLabels.VERSION)) instanceof StringData && ((Matcher)(object = J9REGEX.matcher((CharSequence)(object2 = ((StringData)data).getValue().trim())))).find()) {
            this.genconAvailable = true;
        }
        if ((object2 = dataBuilder.getTopLevelData(JVMLabels.GARBAGE_COLLECTION)) instanceof SubsystemDataBuilder) {
            this.addGCSummaryData((SubsystemDataBuilder)object2, dataBuilder);
        }
    }

    private void extractEnvironmentInformation(Data data) {
        this.commandLine = this.findCommandLine(data);
        this.isNode = this.checkIsNode(data);
    }

    private void addGCSummaryData(SubsystemDataBuilder subsystemDataBuilder, DataBuilder dataBuilder) {
        this.recommendedCommandLine = new HashMap<String, String>();
        this.gcMode = this.calculateGCMode(subsystemDataBuilder);
        this.scopeRecord = this.getTwoDimensionalData(subsystemDataBuilder, GCLabels.GC_TYPE_RECORD);
        this.overhead = -1.0;
        this.addNewStructuredData(subsystemDataBuilder);
        this.addNewStringData(subsystemDataBuilder, dataBuilder);
    }

    private void addNewStringData(SubsystemDataBuilder subsystemDataBuilder, DataBuilder dataBuilder) {
        StructuredStringDataBuilder structuredStringDataBuilder = this.generateRecommendation(subsystemDataBuilder, dataBuilder);
        if (structuredStringDataBuilder != null && (!structuredStringDataBuilder.isEmpty() || structuredStringDataBuilder.hasChildren())) {
            subsystemDataBuilder.addData(structuredStringDataBuilder);
        }
        subsystemDataBuilder.clearValue();
        subsystemDataBuilder.setStatus(Status.UNKNOWN);
        String[] stringArray = structuredStringDataBuilder.getProblems();
        if (stringArray != null && stringArray.length > 0) {
            subsystemDataBuilder.setStatus(Status.PROBLEM);
            subsystemDataBuilder.addValue(stringArray[0]);
        } else {
            String[] stringArray2 = structuredStringDataBuilder.getWarnings();
            if (stringArray2 != null && stringArray2.length > 0) {
                subsystemDataBuilder.setStatus(Status.WARNING);
                subsystemDataBuilder.addValue(stringArray2[0]);
            } else {
                String[] stringArray3 = structuredStringDataBuilder.getInformations();
                if (stringArray3 != null && stringArray3.length > 0) {
                    subsystemDataBuilder.setStatus(Status.INFORMATION);
                    subsystemDataBuilder.addValue(stringArray3[0]);
                } else {
                    String[] stringArray4 = structuredStringDataBuilder.getGoodThings();
                    if (stringArray4 != null && stringArray4.length > 0) {
                        subsystemDataBuilder.setStatus(Status.HEALTHY);
                        subsystemDataBuilder.addValue(stringArray4[0]);
                    }
                }
            }
        }
    }

    private void addNewStructuredData(DataBuilder dataBuilder) {
        TableDataImpl tableDataImpl = new TableDataImpl(SummarisingPostProcessorLabels.SUMMARY, new String[]{"", ""});
        this.calculateMeanOverhead(dataBuilder, tableDataImpl, this.gcMode);
        if (GENCON.equals(this.gcMode)) {
            this.calculateSummaryStructuredProperties(dataBuilder, tableDataImpl, GCType.NURSERY_INT, SummarisingPostProcessorLabels.MINOR_COLLECTIONS);
            this.calculateSummaryStructuredProperties(dataBuilder, tableDataImpl, GCType.GLOBAL_INT, SummarisingPostProcessorLabels.GLOBAL_COLLECTIONS);
            this.calculateSummaryStructuredProperties(dataBuilder, tableDataImpl, -1, null);
        } else if (BALANCED.equals(this.gcMode)) {
            this.calculateSummaryStructuredProperties(dataBuilder, tableDataImpl, GCType.GMP_INT, SummarisingPostProcessorLabels.GMP_COLLECTION_COUNT);
            this.calculateSummaryStructuredProperties(dataBuilder, tableDataImpl, GCType.PGC_INT, SummarisingPostProcessorLabels.PGC_COLLECTION_COUNT);
            this.calculateSummaryStructuredProperties(dataBuilder, tableDataImpl, GCType.GLOBAL_INT, SummarisingPostProcessorLabels.GLOBAL_COLLECTIONS);
        } else {
            this.calculateSummaryStructuredProperties(dataBuilder, tableDataImpl, GCType.GLOBAL_INT, null);
        }
        this.calculateCollectionCounts(dataBuilder, tableDataImpl, GCReasons.AF_INT, SummarisingPostProcessorLabels.ALLOCATION_FAILURE_COUNT);
        this.calculateCollectionCounts(dataBuilder, tableDataImpl, GCReasons.CON_INT, SummarisingPostProcessorLabels.CONCURRENT_COLLECTION_COUNT);
        this.calculateCollectionCounts(dataBuilder, tableDataImpl, GCReasons.SYS_INT, SummarisingPostProcessorLabels.FORCED_COLLECTION_COUNT);
        this.calculateRateOfGarbageGeneration(dataBuilder, tableDataImpl);
        if (this.isVMRealtime) {
            this.calculateTotalNumberOfQuantum(dataBuilder, tableDataImpl);
            this.calculateTotalNumberOfSynchGC(dataBuilder, tableDataImpl);
        }
        if (BALANCED.equals(this.gcMode)) {
            this.calulateGMPCycleData(dataBuilder, tableDataImpl);
        }
        if (tableDataImpl.size() > 0) {
            String string = SummarisingPostProcessorLabels.GC_MODE;
            String string2 = this.gcMode;
            if (this.isDefaultPolicy) {
                string2 = MessageFormat.format(DEFAULT, this.gcMode);
            }
            if (!UNKNOWN.equals(string2)) {
                tableDataImpl.addRow(new Object[]{string, string2});
            }
            dataBuilder.addData(tableDataImpl);
        }
    }

    private void calulateGMPCycleData(DataBuilder dataBuilder, TableDataBuilder tableDataBuilder) {
        TwoDimensionalDataBuilder twoDimensionalDataBuilder = this.getTwoDimensionalData(dataBuilder, GCLabels.GMP_COLLECTIONS);
        if (twoDimensionalDataBuilder != null && !twoDimensionalDataBuilder.isEmpty()) {
            tableDataBuilder.addRow(new Object[]{SummarisingPostProcessorLabels.GMP_CYCLE_COUNT, twoDimensionalDataBuilder.getDataPoints().length});
            tableDataBuilder.addRow(new Object[]{SummarisingPostProcessorLabels.GMP_MEAN_COLLECTIONS, twoDimensionalDataBuilder.getMeanY()});
        }
    }

    private StructuredStringDataBuilder generateRecommendation(Data data, DataBuilder dataBuilder) {
        Object object;
        Object object2;
        CharSequence charSequence;
        this.commentData = this.factory.createStructuredStringData(SummarisingPostProcessorLabels.TUNING_RECOMMENDATION);
        if (!this.isNode) {
            this.lookForMissingCollections(data);
            this.checkForOptavgpause(data);
            if (GENCON.equals(this.gcMode)) {
                this.generateNurseryOccupancyRecommendation(data);
                this.generateTenuredOccupancyRecommendation(data);
            } else {
                this.generateOccupancyRecommendation(data);
            }
            this.lookForLongPauses(data);
            this.lookForExcessiveSystemGCs(data);
            this.lookForExcessiveCompaction(data);
        }
        if (this.isNode) {
            charSequence = null;
            if (data != null && (object2 = (TableData)data.getData(SummarisingPostProcessorLabels.SUMMARY)) != null && (object = object2.get(SummarisingPostProcessorLabels.PROPORTION_OF_TIME_SPENT_UNPAUSED)) != null) {
                charSequence = (String)object.get(1);
            }
            if (charSequence != null) {
                this.commentData.addGoodThing(MessageFormat.format(TIMEOUTSIDE_GC_MESSAGE, charSequence));
            }
        }
        if (this.isVMRealtime) {
            this.generateRealtimeRecommendations(data);
            this.lookForSynchGCs(data);
        }
        if (!this.isNode) {
            this.lookForLeaks(data);
        }
        if (!this.isVMRealtime) {
            this.considerFragmentation(data);
        }
        if (!this.isNode) {
            this.lookForPatternsInAllocation(data);
            this.lowFreeHeapCheck(dataBuilder);
            this.loaRecommendations(dataBuilder);
            this.lookForUnwiseCommandLineOptions();
        }
        charSequence = new StringBuffer();
        if (this.recommendedCommandLine.size() > 0) {
            object2 = this.recommendedCommandLine.values().iterator();
            object = new StringBuffer();
            while (object2.hasNext()) {
                ((StringBuffer)object).append((String)object2.next());
                if (!object2.hasNext()) continue;
                ((StringBuffer)object).append(SPACE);
            }
            ((StringBuffer)charSequence).append(MessageFormat.format(COMMAND_LINE, ((StringBuffer)object).toString()));
        }
        this.commentData.addInformation(((StringBuffer)charSequence).toString());
        return this.commentData;
    }

    private void calculateTotalNumberOfQuantum(Data data, TableDataBuilder tableDataBuilder) {
        TwoDimensionalDataBuilder twoDimensionalDataBuilder = this.getTwoDimensionalData(data, GCLabels.GC_REASON_RECORD);
        if (twoDimensionalDataBuilder != null && !twoDimensionalDataBuilder.isEmpty() && twoDimensionalDataBuilder.getMaxY().getRawY() >= (double)GCReasons.QUANTUM_INT) {
            DataPointBuilder[] dataPointBuilderArray = twoDimensionalDataBuilder.getDataPoints();
            int n = 0;
            for (int i = 0; i < dataPointBuilderArray.length; ++i) {
                if (dataPointBuilderArray[i].getRawY() != (double)GCReasons.QUANTUM_INT) continue;
                ++n;
            }
            tableDataBuilder.addRow(new Object[]{SummarisingPostProcessorLabels.TOTAL_NUMBER_OF_QUANTUM_COLLECTIONS, n});
        }
    }

    private void calculateTotalNumberOfSynchGC(Data data, TableDataBuilder tableDataBuilder) {
        TwoDimensionalDataBuilder twoDimensionalDataBuilder = this.getTwoDimensionalData(data, GCLabels.GC_REASON_RECORD);
        if (twoDimensionalDataBuilder != null && !twoDimensionalDataBuilder.isEmpty() && twoDimensionalDataBuilder.getMaxY().getRawY() >= (double)GCReasons.SYNCH_INT) {
            DataPointBuilder[] dataPointBuilderArray = twoDimensionalDataBuilder.getDataPoints();
            int n = 0;
            for (int i = 0; i < dataPointBuilderArray.length; ++i) {
                if (dataPointBuilderArray[i].getRawY() != (double)GCReasons.SYNCH_INT) continue;
                ++n;
            }
            tableDataBuilder.addRow(new Object[]{TOTAL_NUMBER_OF_SYNCHGC_COLLECTIONS, n});
        }
    }

    private void lookForMissingCollections(Data data) {
        TwoDimensionalDataBuilder twoDimensionalDataBuilder = this.getTwoDimensionalData(data, GCLabels.GC_NUMBER_TUPLE);
        if (twoDimensionalDataBuilder != null && !twoDimensionalDataBuilder.isEmpty()) {
            double d;
            long l = (long)twoDimensionalDataBuilder.getMinY().getY();
            long l2 = (long)twoDimensionalDataBuilder.getMaxY().getY();
            long l3 = 1L + l2 - l;
            DataPointBuilder[] dataPointBuilderArray = twoDimensionalDataBuilder.getDataPoints();
            if ((long)dataPointBuilderArray.length != l3 && (d = (double)(l3 - (long)dataPointBuilderArray.length) / (double)l3) > 1.0) {
                String string = d > 0.6 ? "SummarisingPostProcessor.major.dropped" : (d > 0.3 ? "SummarisingPostProcessor.moderate.dropped" : "SummarisingPostProcessor.minor.dropped");
                String string2 = Messages.getString(string);
                String string3 = MessageFormat.format(string2, (int)(d * 100.0));
                this.commentData.addInformation(string3);
            }
        }
    }

    private void lookForUnwiseCommandLineOptions() {
        if (this.commandLine != null) {
            if (this.isVMSoftRealtime && this.commandLine.indexOf(XNOCLASSGC) >= 0 || !this.isVMRealtime && this.commandLine.indexOf(XNOCLASSGC) >= 0) {
                this.commentData.addWarning(Messages.getString("Summariser.do.not.use.xnoclassgc"));
            }
            if (!this.isVMRealtime && this.commandLine.indexOf("-Xcompactgc") >= 0) {
                this.commentData.addWarning(Messages.getString("Summariser.do.not.use.xcompactgc"));
            }
        }
    }

    private void calculateRateOfGarbageGeneration(Data data, TableDataBuilder tableDataBuilder) {
        TwoDimensionalDataBuilder twoDimensionalDataBuilder = this.getTwoDimensionalData(data, GCLabels.AMOUNT_FREED);
        if (twoDimensionalDataBuilder != null && !twoDimensionalDataBuilder.isEmpty()) {
            double d = twoDimensionalDataBuilder.getTotalY();
            double d2 = twoDimensionalDataBuilder.getMaxX().getX() - twoDimensionalDataBuilder.getMinX().getX();
            if (d2 > 1.0E-9) {
                double d3 = d / d2;
                String string = twoDimensionalDataBuilder.getXAxis().getUnits();
                String string2 = twoDimensionalDataBuilder.getYAxis().getUnits();
                if (string.equals(UnitLabels.TIME) || string.equals(UnitLabels.DATE)) {
                    string = UnitLabels.MILLISECONDS;
                }
                if (string.equals(UnitLabels.MINUTES)) {
                    string = UnitLabels.MINUTE;
                }
                if (string.equals(UnitLabels.HOURS)) {
                    string = UnitLabels.HOUR;
                }
                if (string.equals(UnitLabels.DAYS)) {
                    string = UnitLabels.DAY;
                }
                tableDataBuilder.addRow(new Object[]{SummarisingPostProcessorLabels.RATE_OF_GARBAGE_COLLECTION, MessageFormat.format(RATE_PLUS_UNITS, NumberFormatter.prettyString(d3), string2, string)});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculateMeanOverhead(Data data, TableDataBuilder tableDataBuilder, String string) {
        DataPointBuilder[] dataPointBuilderArray;
        TwoDimensionalDataBuilder twoDimensionalDataBuilder = this.getTwoDimensionalData(data, GCLabels.PAUSE_TIMES_WITHOUT_EXCLUSIVE_ACCESS);
        if (twoDimensionalDataBuilder != null && !twoDimensionalDataBuilder.isEmpty() && (dataPointBuilderArray = twoDimensionalDataBuilder.getDataPoints()).length > 1) {
            Axis axis = twoDimensionalDataBuilder.getXAxis().getAxis();
            String string2 = axis.getUnits();
            axis.setUnits(GCAxes.SECONDS);
            Axis axis2 = twoDimensionalDataBuilder.getYAxis().getAxis();
            String string3 = axis2.getUnits();
            axis2.setUnits(GCAxes.SECONDS);
            try {
                double d = 0.0;
                double d2 = 0.0;
                d = twoDimensionalDataBuilder.getTotalY();
                double d3 = dataPointBuilderArray[dataPointBuilderArray.length - 1].getY();
                double d4 = dataPointBuilderArray[dataPointBuilderArray.length - 1].getX();
                double d5 = dataPointBuilderArray[0].getX();
                double d6 = d4 - d5;
                if (d6 < 1.0) {
                    return;
                }
                d2 = d3 + d6;
                this.overhead = d / d2 * 100.0;
                double d7 = 100.0 - this.overhead;
                tableDataBuilder.addRow(new Object[]{SummarisingPostProcessorLabels.PROPORTION_OF_TIME_SPENT_IN_GARBAGE_COLLECTION_PAUSES, NumberFormatter.prettyString(this.overhead) + UnitLabels.PERCENT_SIGN});
                tableDataBuilder.addRow(new Object[]{SummarisingPostProcessorLabels.PROPORTION_OF_TIME_SPENT_UNPAUSED, NumberFormatter.prettyString(d7) + UnitLabels.PERCENT_SIGN});
            }
            finally {
                axis.setUnits(string2);
                axis2.setUnits(string3);
            }
        }
    }

    private void calculateGlobalProperties(Data data, TableDataBuilder tableDataBuilder) {
        TwoDimensionalDataBuilder twoDimensionalDataBuilder = this.getTwoDimensionalData(data, GCLabels.PAUSE_TIMES_WITHOUT_EXCLUSIVE_ACCESS);
        if (twoDimensionalDataBuilder != null && !twoDimensionalDataBuilder.isEmpty()) {
            String string = twoDimensionalDataBuilder.getYAxis().getUnits();
            tableDataBuilder.addRow(new Object[]{Messages.getString("SummarisingPostProcessor.mean.pause"), NumberFormatter.prettyString(twoDimensionalDataBuilder.getMeanY()) + SPACE + string});
        }
    }

    private void calculateSummaryStructuredProperties(Data data, TableDataBuilder tableDataBuilder, int n, String string) {
        this.calculateSummaryMemoryProperties(data, tableDataBuilder, n, string);
        this.calculateSummaryPauseProperties(data, tableDataBuilder, n, string);
    }

    private void generateRealtimeRecommendations(Data data) {
        double d = 0.0;
        double d2 = 0.0;
        if (this.isVMSoftRealtime) {
            d = 3.2;
            d2 = 6.0;
        } else if (this.isVMRealtime) {
            d = 0.5;
            d2 = 1.0;
        }
        TwoDimensionalDataBuilder twoDimensionalDataBuilder = this.getTwoDimensionalData(data, GCLabels.PAUSE_TIMES_WITHOUT_EXCLUSIVE_ACCESS);
        TwoDimensionalDataBuilder twoDimensionalDataBuilder2 = this.getTwoDimensionalData(data, GCLabels.GC_REASON_RECORD);
        if (twoDimensionalDataBuilder2 == null || twoDimensionalDataBuilder2.isEmpty()) {
            return;
        }
        if (twoDimensionalDataBuilder != null && !twoDimensionalDataBuilder.isEmpty()) {
            boolean bl = false;
            if (twoDimensionalDataBuilder.getMeanY() > d) {
                this.commentData.addWarning(Messages.getString("SummarisingPostProcessor.realtime.mean.not.optimal"));
            } else {
                bl = true;
            }
            boolean bl2 = false;
            if (twoDimensionalDataBuilder.getMaxY().getY() > d2) {
                int n = twoDimensionalDataBuilder.getMaxY().getSequenceUID();
                DataPoint dataPoint = twoDimensionalDataBuilder2.getDataPoint(n);
                if (dataPoint != null) {
                    if (dataPoint.getY() == (double)GCReasons.SYNCH_INT) {
                        this.commentData.addWarning(Messages.getString("SummarisingPostProcessor.realtime.pause.due.to.synchgc"));
                    } else if (dataPoint.getY() == (double)GCReasons.SYS_INT) {
                        String string = MessageFormat.format(Messages.getString("SummarisingPostProcessor.realtime.pause.due.to.sysgc"), twoDimensionalDataBuilder.getMaxY().formatYWithUnits());
                        this.commentData.addWarning(string);
                    } else {
                        this.commentData.addWarning(Messages.getString("SummarisingPostProcessor.realtime.max.not.optimal"));
                    }
                }
            } else {
                bl2 = true;
            }
            if (bl2 && bl) {
                this.commentData.addGoodThing(Messages.getString("SummarisingPostProcessor.realtime.optimal"));
            }
        }
    }

    private void calculateSummaryPauseProperties(Data data, TableDataBuilder tableDataBuilder, int n, String string) {
        TwoDimensionalDataBuilder twoDimensionalDataBuilder = this.getTwoDimensionalData(data, GCLabels.PAUSE_TIMES_WITHOUT_EXCLUSIVE_ACCESS);
        TwoDimensionalDataBuilder twoDimensionalDataBuilder2 = null;
        twoDimensionalDataBuilder2 = n == GCType.NURSERY_INT ? this.getTwoDimensionalData(data, GCLabels.AMOUNT_FLIPPED) : (BALANCED.equals(this.gcMode) && n == GCType.GLOBAL_INT ? this.getTwoDimensionalData(data, GCLabels.PAUSE_TIMES_WITHOUT_EXCLUSIVE_ACCESS) : (n == GCType.GLOBAL_INT ? this.getTwoDimensionalData(data, GCLabels.PAUSE_TIMES_WITHOUT_EXCLUSIVE_ACCESS) : (n == GCType.PGC_INT ? this.getTwoDimensionalData(data, GCLabels.LIVE_FLAT_HEAP_AFTER_GC) : (n == GCType.GMP_INT ? this.getTwoDimensionalData(data, GCLabels.LIVE_FLAT_HEAP_AFTER_GC) : this.getTwoDimensionalData(data, GCLabels.PAUSE_TIMES_WITHOUT_EXCLUSIVE_ACCESS)))));
        if (twoDimensionalDataBuilder != null) {
            DataPointBuilder dataPointBuilder;
            TwoDimensionalDataBuilder twoDimensionalDataBuilder3;
            DataPointBuilder[] dataPointBuilderArray = twoDimensionalDataBuilder.getDataPoints();
            DataPointBuilder[] dataPointBuilderArray2 = null;
            if (twoDimensionalDataBuilder2 != null) {
                int n2 = 0;
                dataPointBuilderArray2 = twoDimensionalDataBuilder2.getDataPoints();
                for (int i = 0; i < dataPointBuilderArray2.length; ++i) {
                    if (!this.isCollectionOfGivenScope(dataPointBuilderArray2[i], n)) continue;
                    ++n2;
                }
                tableDataBuilder.addRow(new Object[]{this.makeLabel(string, SummarisingPostProcessorLabels.NUMBER_OF_COLLECTIONS), n2});
            }
            double d = 0.0;
            int n3 = 0;
            String string2 = twoDimensionalDataBuilder.getYAxis().getUnits();
            for (int i = 0; i < dataPointBuilderArray.length; ++i) {
                if (!this.isCollectionOfGivenScope(dataPointBuilderArray[i], n)) continue;
                d += dataPointBuilderArray[i].getY();
                ++n3;
            }
            if (GCType.GLOBAL_INT == n) {
                this.calculatePausePropertiesForGlobals(tableDataBuilder, n, string, dataPointBuilderArray);
            } else {
                this.addIntervalRow(tableDataBuilder, n, string, dataPointBuilderArray);
            }
            double d2 = d / (double)n3;
            tableDataBuilder.addRow(new Object[]{this.makeLabel(string, Messages.getString("SummarisingPostProcessor.mean.pause")), NumberFormatter.prettyString(d2) + SPACE + string2});
            if (this.isVMRealtime && !twoDimensionalDataBuilder.isEmpty()) {
                tableDataBuilder.addRow(new Object[]{Messages.getString("SummarisingPostProcessor.max.pause"), NumberFormatter.prettyString(twoDimensionalDataBuilder.getMaxY().getY()) + SPACE + string2});
                tableDataBuilder.addRow(new Object[]{Messages.getString("SummarisingPostProcessor.min.pause"), NumberFormatter.prettyString(twoDimensionalDataBuilder.getMinY().getY()) + SPACE + string2});
            }
            if ((twoDimensionalDataBuilder3 = this.getTwoDimensionalData(data, GCLabels.MINIMUM_REQUESTED_BYTES)) != null && (dataPointBuilder = twoDimensionalDataBuilder3.getMaxY()) != null) {
                double d3 = dataPointBuilder.getY();
                tableDataBuilder.addRow(new Object[]{SummarisingPostProcessorLabels.LARGEST_MEMORY_REQUEST, NumberFormatter.prettyString(d3) + SPACE + twoDimensionalDataBuilder3.getYAxis().getUnits()});
            }
        } else {
            this.calculateGlobalProperties(data, tableDataBuilder);
        }
    }

    private void addIntervalRow(TableDataBuilder tableDataBuilder, int n, String string, DataPointBuilder[] dataPointBuilderArray) {
        if (dataPointBuilderArray.length > 0) {
            double d = dataPointBuilderArray[0].getRawX();
            double d2 = 0.0;
            int n2 = 0;
            for (int i = 1; i < dataPointBuilderArray.length; ++i) {
                if (!this.isCollectionOfGivenScope(dataPointBuilderArray[i], n)) continue;
                double d3 = dataPointBuilderArray[i].getRawX();
                double d4 = d3 - d - dataPointBuilderArray[i].getRawY() + dataPointBuilderArray[i - 1].getRawY();
                d2 += d4;
                d = d3;
                ++n2;
            }
            double d5 = d2 / (double)n2;
            if (n2 > 0) {
                tableDataBuilder.addRow(new Object[]{this.makeLabel(string, MEAN_INTERVAL), NumberFormatter.prettyString(d5) + SPACE + UnitLabels.MILLISECONDS});
            }
        }
    }

    private void calculatePausePropertiesForGlobals(TableDataBuilder tableDataBuilder, int n, String string, DataPointBuilder[] dataPointBuilderArray) {
        if (dataPointBuilderArray.length > 0) {
            double d = 0.0;
            int n2 = 0;
            String string2 = UnitLabels.MILLISECONDS;
            double d2 = dataPointBuilderArray[0].getX(string2);
            for (int i = 0; i < dataPointBuilderArray.length; ++i) {
                if (!this.isCollectionOfGivenScope(dataPointBuilderArray[i], n)) continue;
                double d3 = dataPointBuilderArray[i].getX(string2);
                double d4 = d3 - d2;
                d += d4;
                d2 = d3;
                ++n2;
            }
            double d5 = d / (double)n2;
            if (n2 > 0) {
                tableDataBuilder.addRow(new Object[]{this.makeLabel(string, MEAN_INTERVAL), NumberFormatter.prettyString(d5) + SPACE + string2});
            }
        }
    }

    private void calculateSummaryMemoryProperties(Data data, TableDataBuilder tableDataBuilder, int n, String string) {
        TwoDimensionalDataBuilder twoDimensionalDataBuilder = this.getTwoDimensionalData(data, GCLabels.UNUSED_HEAP);
        if (twoDimensionalDataBuilder != null) {
            tableDataBuilder.addRow(new Object[]{this.makeLabel(string, Messages.getString("SummarisingPostProcessor.mean.unusable.heap")), NumberFormatter.prettyString(twoDimensionalDataBuilder.getMeanY()) + SPACE + twoDimensionalDataBuilder.getYAxis().getUnits()});
        }
        TwoDimensionalDataBuilder twoDimensionalDataBuilder2 = this.getTwoDimensionalData(data, GCLabels.AMOUNT_FLIPPED);
        TwoDimensionalDataBuilder twoDimensionalDataBuilder3 = this.getTwoDimensionalData(data, GCLabels.AMOUNT_TENURED);
        TwoDimensionalDataBuilder twoDimensionalDataBuilder4 = this.getTwoDimensionalData(data, GCLabels.LIVE_FLAT_HEAP_AFTER_GC);
        if (twoDimensionalDataBuilder4 != null) {
            DataPointBuilder dataPointBuilder;
            TwoDimensionalDataBuilder twoDimensionalDataBuilder5;
            int n2;
            DataPointBuilder[] dataPointBuilderArray = null;
            if (twoDimensionalDataBuilder2 != null) {
                dataPointBuilderArray = twoDimensionalDataBuilder2.getDataPoints();
            }
            DataPointBuilder[] dataPointBuilderArray2 = null;
            if (twoDimensionalDataBuilder3 != null) {
                dataPointBuilderArray2 = twoDimensionalDataBuilder3.getDataPoints();
            }
            double d = 0.0;
            double d2 = 0.0;
            if (twoDimensionalDataBuilder2 != null) {
                for (n2 = 0; n2 < dataPointBuilderArray.length; ++n2) {
                    if (!this.isCollectionOfGivenScope(dataPointBuilderArray[n2], n)) continue;
                    d2 += dataPointBuilderArray[n2].getY();
                }
            }
            if (twoDimensionalDataBuilder3 != null) {
                for (n2 = 0; n2 < dataPointBuilderArray2.length; ++n2) {
                    if (!this.isCollectionOfGivenScope(dataPointBuilderArray2[n2], n)) continue;
                    d += dataPointBuilderArray2[n2].getY();
                }
            }
            if (twoDimensionalDataBuilder2 != null && GCType.GLOBAL_INT != n) {
                tableDataBuilder.addRow(new Object[]{this.makeLabel(string, Messages.getString("SummarisingPostProcessor.total.flipped")), NumberFormatter.prettyString(d2) + SPACE + twoDimensionalDataBuilder2.getYAxis().getUnits()});
            }
            if (twoDimensionalDataBuilder3 != null && d > 0.0) {
                tableDataBuilder.addRow(new Object[]{this.makeLabel(string, Messages.getString("SummarisingPostProcessor.total.amount.tenured")), NumberFormatter.prettyString(d) + SPACE + twoDimensionalDataBuilder3.getYAxis().getUnits()});
            }
            if ((twoDimensionalDataBuilder5 = this.getTwoDimensionalData(data, GCLabels.MINIMUM_REQUESTED_BYTES)) != null && (dataPointBuilder = twoDimensionalDataBuilder5.getMaxY()) != null) {
                double d3 = dataPointBuilder.getY();
                tableDataBuilder.addRow(new Object[]{SummarisingPostProcessorLabels.LARGEST_MEMORY_REQUEST, NumberFormatter.prettyString(d3) + SPACE + twoDimensionalDataBuilder5.getYAxis().getUnits()});
            }
        } else {
            this.calculateGlobalProperties(data, tableDataBuilder);
        }
    }

    private void calculateCollectionCounts(Data data, TableDataBuilder tableDataBuilder, int n, String string) {
        TwoDimensionalDataBuilder twoDimensionalDataBuilder = this.getTwoDimensionalData(data, GCLabels.GC_REASON_RECORD);
        if (twoDimensionalDataBuilder != null) {
            DataPointBuilder[] dataPointBuilderArray = twoDimensionalDataBuilder.getDataPoints();
            int n2 = 0;
            for (int i = 0; i < dataPointBuilderArray.length; ++i) {
                if (dataPointBuilderArray[i].getRawY() != (double)n) continue;
                ++n2;
            }
            if (this.hasAFCounts || n2 > 0) {
                if (n == GCReasons.CON_INT) {
                    if (this.gcMode.equalsIgnoreCase(OPTAVGPAUSE) || this.gcMode.equalsIgnoreCase(GENCON)) {
                        tableDataBuilder.addRow(new Object[]{string, n2});
                    }
                } else {
                    tableDataBuilder.addRow(new Object[]{string, n2});
                }
            }
        }
    }

    private String calculateGCMode(Data data) {
        Object object;
        String string = UNKNOWN;
        if (this.vm_data_initialized && this.vmVersion != null) {
            if (this.isVMRealtime) {
                string = REALTIME;
            } else if (this.commandLine != null) {
                object = GCPOLICYMATCHER.matcher(this.commandLine);
                if (((Matcher)object).find()) {
                    string = ((Matcher)object).group(1);
                } else {
                    if (this.vmVersion.equals("2.4") || this.vmVersion.equals("2.3")) {
                        string = OPTTHRUPUT;
                    } else if (this.vmVersion.equals("2.6")) {
                        string = GENCON;
                    }
                    this.isDefaultPolicy = true;
                }
            }
        }
        if (string.equals(UNKNOWN)) {
            object = this.getTwoDimensionalData(data, GCLabels.NURSERY_SIZE);
            if (object != null && object.getDataPoints().length > 0) {
                string = GENCON;
            } else {
                TwoDimensionalDataBuilder twoDimensionalDataBuilder = this.getTwoDimensionalData(data, GCLabels.GC_TYPE_RECORD);
                if (twoDimensionalDataBuilder != null && twoDimensionalDataBuilder.getDataPoints().length > 0) {
                    if (twoDimensionalDataBuilder.getMaxY().getRawY() >= (double)GCType.PGC_INT || twoDimensionalDataBuilder.getMaxY().getRawY() >= (double)GCType.GMP_INT) {
                        string = BALANCED;
                    } else {
                        TwoDimensionalDataBuilder twoDimensionalDataBuilder2 = this.getTwoDimensionalData(data, GCLabels.INTENDED_KICKOFF);
                        if (twoDimensionalDataBuilder2 != null && twoDimensionalDataBuilder2.getDataPoints().length > 0) {
                            string = OPTAVGPAUSE;
                        } else {
                            DataPointBuilder[] dataPointBuilderArray = twoDimensionalDataBuilder.getDataPoints();
                            for (int i = 0; i < dataPointBuilderArray.length; ++i) {
                                double d = dataPointBuilderArray[i].getY();
                                if ((double)GCReasons.nameToInt("con") != d) continue;
                                string = OPTAVGPAUSE;
                            }
                        }
                    }
                }
            }
        }
        return string;
    }

    private boolean checkIsNode(Data data) {
        TableDataRow tableDataRow;
        TableData tableData;
        if (data != null && (tableData = (TableData)data.getData(EnvironmentLabels.JRE_INFORMATION)) != null && (tableDataRow = tableData.get(EnvironmentLabels.VM_NAME)) != null) {
            return ((String)tableDataRow.get(1)).toLowerCase().contains("node.js");
        }
        return false;
    }

    private String findCommandLine(Data data) {
        Data data2;
        if (data != null && (data2 = data.getData(EnvironmentLabels.COMMAND_LINE)) instanceof StringData) {
            this.commandLine = ((StringData)data2).getValue();
        }
        return this.commandLine;
    }

    private void generateNurseryOccupancyRecommendation(Data data) {
        int n;
        TwoDimensionalDataBuilder twoDimensionalDataBuilder = this.getTwoDimensionalData(data, GCLabels.LIVE_NURSERY_HEAP_AFTER_GC);
        if (twoDimensionalDataBuilder != null && (n = this.getMeanAsPercent(twoDimensionalDataBuilder, this.getTwoDimensionalData(data, GCLabels.NURSERY_SIZE))) > 0) {
            if (n > this.helper.getHighOccupancyThreshold()) {
                String string = Messages.getString("SummarisingPostProcessor.high.nursery.occupancy.message", new Object[]{n, (int)this.overhead});
                this.commentData.addWarning(string);
                TwoDimensionalDataBuilder twoDimensionalDataBuilder2 = this.getTwoDimensionalData(data, GCLabels.NURSERY_SIZE);
                int n2 = n / 60;
                int n3 = this.getMeanAsMB(twoDimensionalDataBuilder2);
                int n4 = n3 * n2;
                this.recommendedCommandLine.put(NURSERY_SIZE, NURSERY_SIZE + n4 + MEGABYTES_UNITS_FOR_COMMANDS);
            } else if (n < this.helper.getLowOccupancyThreshold()) {
                String string = Messages.getString("SummarisingPostProcessor.low.nursery.occupancy.message", new Object[]{n, (int)this.overhead});
                this.commentData.addGoodThing(string);
            } else {
                String string = Messages.getString("SummarisingPostProcessor.medium.nursery.occupancy.message", new Object[]{n, (int)this.overhead});
                this.commentData.addInformation(string);
            }
        }
    }

    private void generateTenuredOccupancyRecommendation(Data data) {
        int n;
        TwoDimensionalDataBuilder twoDimensionalDataBuilder = this.getTwoDimensionalData(data, GCLabels.LIVE_TENURED_HEAP_AFTER_GC);
        if (twoDimensionalDataBuilder != null && (n = this.getMeanAsPercent(twoDimensionalDataBuilder, this.getTwoDimensionalData(data, GCLabels.TENURED_SIZE))) > 0) {
            if (n > this.helper.getHighOccupancyThreshold()) {
                String string = Messages.getString("SummarisingPostProcessor.high.tenured.area.occupancy.message", new Object[]{n, (int)this.overhead});
                this.commentData.addWarning(string);
            } else if (n < this.helper.getLowOccupancyThreshold()) {
                String string = Messages.getString("SummarisingPostProcessor.low.tenured.area.occupancy.message", new Object[]{n, (int)this.overhead});
                this.commentData.addInformation(string);
            } else {
                String string = Messages.getString("SummarisingPostProcessor.medium.tenured.area.occupancy.message", new Object[]{n, (int)this.overhead});
                this.commentData.addInformation(string);
            }
        }
    }

    private int getMeanAsPercent(TwoDimensionalData twoDimensionalData, TwoDimensionalData twoDimensionalData2) {
        if (twoDimensionalData == null || twoDimensionalData2 == null) {
            return -1;
        }
        double d = twoDimensionalData.getMeanY();
        double d2 = twoDimensionalData2.getMeanY();
        return (int)Math.round(d / d2 * 100.0);
    }

    private int getMeanAsMB(TwoDimensionalData twoDimensionalData) {
        return this.getMeanInUnits(twoDimensionalData, GCAxes.MB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getMeanInUnits(TwoDimensionalData twoDimensionalData, String string) {
        int n = -1;
        YDataAxis yDataAxis = twoDimensionalData.getYAxis();
        String string2 = yDataAxis.getAxis().getUnits();
        yDataAxis.getAxis().setUnits(string);
        String string3 = yDataAxis.getUnits();
        if (string3.indexOf(string) > -1) {
            try {
                n = (int)Math.round(twoDimensionalData.getMeanY());
            }
            finally {
                yDataAxis.getAxis().setUnits(string2);
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getMaxAsMB(TwoDimensionalData twoDimensionalData) {
        int n = -1;
        YDataAxis yDataAxis = twoDimensionalData.getYAxis();
        String string = yDataAxis.getAxis().getUnits();
        yDataAxis.getAxis().setUnits(GCAxes.MB);
        String string2 = yDataAxis.getUnits();
        if (string2.indexOf(GCAxes.MB) > -1) {
            try {
                n = (int)Math.round(twoDimensionalData.getMaxY().getY());
            }
            finally {
                yDataAxis.getAxis().setUnits(string);
            }
        }
        return n;
    }

    private void generateOccupancyRecommendation(Data data) {
        TwoDimensionalDataBuilder twoDimensionalDataBuilder = this.getTwoDimensionalData(data, GCLabels.LIVE_FLAT_HEAP_AFTER_GC);
        if (twoDimensionalDataBuilder != null) {
            int n = this.getMeanAsPercent(twoDimensionalDataBuilder, this.getTwoDimensionalData(data, GCLabels.FLAT_HEAP_SIZE));
            if (!this.isVMRealtime && n > 0) {
                if (n < this.helper.getLowOccupancyThreshold()) {
                    String string = MessageFormat.format(LOW_OCCUPANCY_MESSAGE, n);
                    if (n < this.helper.getCriticallyLowOccupancyThreshold()) {
                        this.commentData.addProblem(string);
                    }
                    this.commentData.addWarning(string);
                } else if (n > this.helper.getCriticallyHighOccupancyThreshold()) {
                    String string = MessageFormat.format(HIGH_OCCUPANCY_MESSAGE, n, (int)this.overhead);
                    this.commentData.addProblem(string);
                    this.suggestOccupancy(data);
                } else if (n > this.helper.getHighOccupancyThreshold()) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(MessageFormat.format(HIGH_OCCUPANCY_MESSAGE, n));
                    if (this.overhead > 5.0) {
                        if (OPTAVGPAUSE.equals(this.gcMode)) {
                            stringBuffer.append(MessageFormat.format(HIGH_OCCUPANCY_OVERHEAD_OPTAVGPAUSE_MESSAGE, (int)this.overhead));
                        } else {
                            stringBuffer.append(MessageFormat.format(HIGH_OCCUPANCY_OVERHEAD_MESSAGE, (int)this.overhead));
                        }
                    }
                    this.commentData.addWarning(stringBuffer.toString());
                    if (!GENCON.equals(this.gcMode) && this.genconAvailable) {
                        stringBuffer.append(HIGH_OCCUPANCY_GENCON_RECOMMENDATION);
                        this.recommendedCommandLine.put(XGCPOLICY, XGCPOLICY_GENCON);
                    } else if (!BALANCED.equals(this.gcMode)) {
                        this.suggestOccupancy(data);
                        this.recommendedCommandLine.put(XMAXF, "-Xmaxf0.9");
                    }
                } else {
                    this.commentData.addGoodThing(MessageFormat.format(OPTIMAL_OCCUPANCY_MESSAGE, n));
                }
            }
        }
    }

    private void suggestOccupancy(Data data) {
        TwoDimensionalDataBuilder twoDimensionalDataBuilder = this.getTwoDimensionalData(data, GCLabels.LIVE_FLAT_HEAP_AFTER_GC);
        if (twoDimensionalDataBuilder != null) {
            int n = this.getMeanAsMB(twoDimensionalDataBuilder);
            int n2 = this.getMaxAsMB(twoDimensionalDataBuilder);
            int n3 = (int)Math.max((double)n / 0.3, (double)n2 / 0.8);
            TwoDimensionalDataBuilder twoDimensionalDataBuilder2 = this.getTwoDimensionalData(data, GCLabels.FLAT_HEAP_SIZE);
            int n4 = this.getMaxAsMB(twoDimensionalDataBuilder2);
            if (n4 <= 1500) {
                n3 = Math.min(1500, n3);
            }
            this.recommendedCommandLine.put(MX, MX + n3 + MEGABYTES_UNITS_FOR_COMMANDS);
        }
    }

    private boolean isCollectionOfGivenScope(DataPointBuilder dataPointBuilder, int n) {
        DataPointBuilder dataPointBuilder2;
        boolean bl;
        boolean bl2 = bl = n == GCType.GLOBAL_INT;
        if (n == -1) {
            return true;
        }
        if (this.scopeRecord != null && (dataPointBuilder2 = this.scopeRecord.getDataPoint(dataPointBuilder.getSequenceUID())) != null) {
            bl = dataPointBuilder2.getRawY() == (double)n;
        }
        return bl;
    }

    private String makeLabel(String string, String string2) {
        if (string == null) {
            return string2;
        }
        return string + DASH + string2;
    }

    private void lookForLeaks(Data data) {
        DataPointBuilder[] dataPointBuilderArray;
        TwoDimensionalDataBuilder twoDimensionalDataBuilder = this.getTwoDimensionalData(data, GCLabels.LIVE_FLAT_HEAP_AFTER_GC);
        if (twoDimensionalDataBuilder != null && !twoDimensionalDataBuilder.isEmpty() && (dataPointBuilderArray = twoDimensionalDataBuilder.getDataPoints()).length > 100) {
            this.lookForLeaksBasedOnOccupancy(twoDimensionalDataBuilder, dataPointBuilderArray);
        }
    }

    private void lookForLeaksBasedOnOccupancy(TwoDimensionalData twoDimensionalData, DataPointBuilder[] dataPointBuilderArray) {
        int n;
        double[] dArray = new double[3];
        double d = 1.0 / (double)dArray.length;
        double d2 = twoDimensionalData.getMinX().getRawX();
        double d3 = twoDimensionalData.getMaxX().getRawX();
        double d4 = d3 - d2;
        int[] nArray = new int[dArray.length];
        for (int i = 0; i < dataPointBuilderArray.length; ++i) {
            DataPointBuilder dataPointBuilder = dataPointBuilderArray[i];
            double d5 = dataPointBuilder.getRawX();
            double d6 = dataPointBuilder.getY();
            n = (int)Math.floor((d5 - d2) / (d4 * d));
            if (n >= dArray.length || n < 0) continue;
            dArray[n] = (dArray[n] * (double)nArray[n] + d6) / (double)(nArray[n] + 1);
            nArray[n] = nArray[n] + 1;
        }
        if (!this.isVMRealtime && nArray[1] != 0 && dArray[1] != 0.0) {
            boolean bl;
            int n2 = (int)(dArray[2] / dArray[1] * 100.0 - 100.0);
            double d7 = (double)nArray[2] / (double)nArray[1] * 100.0 - 100.0;
            int n3 = (int)Math.round(d7);
            n = this.helper.getLeakThreshold();
            boolean bl2 = n2 > n;
            boolean bl3 = bl = n3 > n;
            if (bl2) {
                String string = MessageFormat.format(USAGE_GROWING, n2);
                if (bl) {
                    String string2 = string + MessageFormat.format(LEAK_WARNING, n3) + SPACE + HOW_TO_FIX_LEAK;
                    this.commentData.addProblem(string2);
                } else {
                    Object object;
                    int n4;
                    double[] dArray2 = new double[dArray.length];
                    for (n4 = 0; n4 < dataPointBuilderArray.length; ++n4) {
                        object = dataPointBuilderArray[n4];
                        double d8 = object.getRawX();
                        double d9 = object.getY();
                        int n5 = (int)Math.floor((d8 - d2) / (d4 * d));
                        if (n5 >= dArray.length || n5 < 0) continue;
                        dArray2[n5] = (dArray[n5] * (double)nArray[n5] + d9) / (double)(nArray[n5] + 1);
                    }
                    n4 = (int)(dArray2[2] / dArray2[1] * 100.0 - 100.0);
                    if (n4 > n2 / 2 && n3 >= 0) {
                        object = string + MessageFormat.format(USAGE_GROWING_HEAP_GROWING, n4, n3) + HOW_TO_FIX_LEAK;
                        this.commentData.addProblem((String)object);
                    } else if (n3 < 0) {
                        object = MessageFormat.format(string + HEAP_GROWING_COLLECTIONS_SHRINKING, Math.abs(n3));
                        this.commentData.addInformation((String)object);
                    } else {
                        object = MessageFormat.format(string + HEAP_INCREASING_WHILE_COLLECTIONS_STEADY + HOW_TO_FIX_LEAK, n3);
                        this.commentData.addProblem((String)object);
                    }
                }
            } else if (bl) {
                String string = MessageFormat.format(COLLECTIONS_INCREASING_HEAP_SHRINKING, n2, n3);
                if (GENCON.equals(this.gcMode)) {
                    string = string + SPACE + TUNE_NURSERY;
                }
                this.commentData.addInformation(string);
            } else {
                this.commentData.addGoodThing(NO_LEAK_COMMENT);
            }
        }
    }

    public void recommend(Data data) {
        TwoDimensionalDataBuilder twoDimensionalDataBuilder = this.getTwoDimensionalData(data, GCLabels.UNUSED_HEAP);
        if (!BALANCED.equals(this.gcMode)) {
            StringBuffer stringBuffer = new StringBuffer();
            if (twoDimensionalDataBuilder != null && !twoDimensionalDataBuilder.isEmpty()) {
                twoDimensionalDataBuilder.getYAxis().getAxis().setUnits(GCAxes.PERCENT_SIGN);
                double d = twoDimensionalDataBuilder.getMeanY();
                if (d > (double)this.helper.getFragmentationThreshold()) {
                    stringBuffer.append(MessageFormat.format(FRAGMENTATION_WARNING, new Double(d)));
                    if (OPTAVGPAUSE.equals(this.gcMode)) {
                        stringBuffer.append(OPTAVGPAUSE_FRAGMENTATION_WARNING);
                        if (this.genconAvailable) {
                            stringBuffer.append("");
                        }
                    } else if (GENCON.equals(this.gcMode)) {
                        stringBuffer.append(GENCON_FRAGMENTATION_WARNING);
                    } else if (OPTTHRUPUT.equals(this.gcMode)) {
                        stringBuffer.append(OPTTHRUPUT_FRAGMENTATION_WARNING);
                        if (this.genconAvailable) {
                            stringBuffer.append(JUST_USE_GENCON);
                        }
                    }
                    this.commentData.addWarning(stringBuffer.toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void considerFragmentation(Data data) {
        TwoDimensionalDataBuilder twoDimensionalDataBuilder = this.getTwoDimensionalData(data, GCLabels.UNUSED_HEAP);
        StringBuffer stringBuffer = new StringBuffer();
        if (twoDimensionalDataBuilder != null && !twoDimensionalDataBuilder.isEmpty()) {
            String string = twoDimensionalDataBuilder.getYAxis().getUnits();
            try {
                TwoDimensionalDataBuilder twoDimensionalDataBuilder2;
                twoDimensionalDataBuilder.getYAxis().getAxis().setUnits(GCAxes.PERCENT_SIGN);
                double d = GCAxes.PERCENT_SIGN.equals(twoDimensionalDataBuilder.getYAxis().getUnits()) ? twoDimensionalDataBuilder.getMeanY() : ((twoDimensionalDataBuilder2 = this.getTwoDimensionalData(data, GCLabels.FLAT_HEAP_SIZE)) != null ? twoDimensionalDataBuilder.getMeanY() / twoDimensionalDataBuilder2.getMeanY() : 0.0);
                if (d > (double)this.helper.getFragmentationThreshold()) {
                    stringBuffer.append(MessageFormat.format(FRAGMENTATION_WARNING, new Double(d)));
                    if (OPTAVGPAUSE.equals(this.gcMode)) {
                        stringBuffer.append(OPTAVGPAUSE_FRAGMENTATION_WARNING);
                        if (this.genconAvailable) {
                            stringBuffer.append("");
                        }
                    } else if (GENCON.equals(this.gcMode)) {
                        stringBuffer.append(GENCON_FRAGMENTATION_WARNING);
                    } else if (OPTTHRUPUT.equals(this.gcMode)) {
                        stringBuffer.append(OPTTHRUPUT_FRAGMENTATION_WARNING);
                        if (this.genconAvailable) {
                            stringBuffer.append(JUST_USE_GENCON);
                        }
                    }
                    this.commentData.addWarning(stringBuffer.toString());
                }
            }
            finally {
                twoDimensionalDataBuilder.getYAxis().getAxis().setUnits(string);
            }
        }
    }

    private void lookForPatternsInAllocation(Data data) {
        DataPointBuilder dataPointBuilder;
        TwoDimensionalDataBuilder twoDimensionalDataBuilder = this.getTwoDimensionalData(data, GCLabels.MINIMUM_REQUESTED_BYTES);
        if (twoDimensionalDataBuilder != null && !twoDimensionalDataBuilder.isEmpty() && (dataPointBuilder = twoDimensionalDataBuilder.getMaxY()) != null) {
            double d = dataPointBuilder.getY(UnitLabels.BYTES);
            if (!this.isVMRealtime && d > (double)this.helper.getRequestSizeThreshold()) {
                String string = MessageFormat.format(LARGE_OBJECT_WARNING, dataPointBuilder.formatYWithUnits());
                this.commentData.addWarning(string);
            }
        }
    }

    private void lookForLongPauses(Data data) {
        double d;
        DataPointBuilder dataPointBuilder;
        TwoDimensionalDataBuilder twoDimensionalDataBuilder = this.getTwoDimensionalData(data, GCLabels.PAUSE_TIMES_WITHOUT_EXCLUSIVE_ACCESS);
        if (twoDimensionalDataBuilder != null && !twoDimensionalDataBuilder.isEmpty() && (dataPointBuilder = twoDimensionalDataBuilder.getMaxY()) != null && (d = dataPointBuilder.getY(UnitLabels.MILLISECONDS)) > (double)this.helper.getLongPauseThreshold()) {
            String string = this.isVMRealtime ? MessageFormat.format(REALTIME_LARGE_PAUSE_WARNING, dataPointBuilder.formatYWithUnits()) : MessageFormat.format(LARGE_PAUSE_WARNING, dataPointBuilder.formatYWithUnits());
            this.commentData.addWarning(string);
        }
    }

    private void lookForExcessiveCompaction(Data data) {
        String string = "forced gc with compaction";
        String string2 = "forced compaction";
        String string3 = "heap fragmented";
        String string4 = "low free space (less than 4%)";
        String string5 = "very low free space (less than 128kB)";
        TwoDimensionalDataBuilder twoDimensionalDataBuilder = this.getTwoDimensionalData(data, GCLabels.AMOUNT_COMPACTED);
        if (twoDimensionalDataBuilder != null && !twoDimensionalDataBuilder.isEmpty()) {
            DataPointBuilder[] dataPointBuilderArray = twoDimensionalDataBuilder.getDataPoints();
            int n = 0;
            double d = 0.0;
            int n2 = 0;
            for (DataPointBuilder dataPointBuilder : dataPointBuilderArray) {
                String string6 = dataPointBuilder.getComment();
                if (string.equalsIgnoreCase(string6) || string2.equalsIgnoreCase(string6)) {
                    ++n;
                    continue;
                }
                if (string3.equalsIgnoreCase(string6)) {
                    d += 1.0;
                    continue;
                }
                if (!string4.equalsIgnoreCase(string6) && !string5.equalsIgnoreCase(string6)) continue;
                ++n2;
            }
            if (n2 > 0) {
                this.commentData.addProblem(SummarisingPostProcessorLabels.COMPACTION_LOW_MEMORY + SummarisingPostProcessorLabels.INCREASE_HEAP);
            } else if (n > 0) {
                this.commentData.addProblem(SummarisingPostProcessorLabels.COMPACTION_FORCED);
            } else if (d > 0.0) {
                double d2 = this.countGlobalPauses(data, this.gcMode);
                double d3 = d / d2 * 100.0;
                if (GENCON.equalsIgnoreCase(this.gcMode)) {
                    if (d3 > 5.0) {
                        this.commentData.addProblem(SummarisingPostProcessorLabels.COMPACTION_FRAGMENTED + SummarisingPostProcessorLabels.INCREASE_HEAP);
                    }
                } else if ((OPTAVGPAUSE.equalsIgnoreCase(this.gcMode) || OPTTHRUPUT.equalsIgnoreCase(this.gcMode)) && d3 > 15.0) {
                    this.commentData.addProblem(SummarisingPostProcessorLabels.COMPACTION_FRAGMENTED + SummarisingPostProcessorLabels.INCREASE_HEAP);
                }
            }
        }
    }

    private double countGlobalPauses(Data data, String string) {
        TwoDimensionalDataBuilder twoDimensionalDataBuilder = this.getTwoDimensionalData(data, GCLabels.PAUSE_TIMES_WITHOUT_EXCLUSIVE_ACCESS);
        double d = 0.0;
        if (twoDimensionalDataBuilder != null) {
            DataPointBuilder[] dataPointBuilderArray = twoDimensionalDataBuilder.getDataPoints();
            for (int i = 0; i < dataPointBuilderArray.length; ++i) {
                if (dataPointBuilderArray[i].getRawY() != (double)GCType.GLOBAL_INT) continue;
                d += 1.0;
            }
        }
        return d;
    }

    private void lookForExcessiveSystemGCs(Data data) {
        TwoDimensionalDataBuilder twoDimensionalDataBuilder = this.getTwoDimensionalData(data, GCLabels.GC_REASON_RECORD);
        if (twoDimensionalDataBuilder != null && !twoDimensionalDataBuilder.isEmpty() && twoDimensionalDataBuilder.getMaxY().getRawY() >= (double)GCReasons.SYS_INT) {
            DataPointBuilder[] dataPointBuilderArray = twoDimensionalDataBuilder.getDataPoints();
            int n = 0;
            for (int i = 0; i < dataPointBuilderArray.length; ++i) {
                if (dataPointBuilderArray[i].getRawY() != (double)GCReasons.SYS_INT) continue;
                ++n;
            }
            double d = 100 * n / dataPointBuilderArray.length;
            if (this.isVMRealtime && n > 0) {
                this.commentData.addWarning(MessageFormat.format(REALTIME_SYSTEM_GCS_WARNING, n));
            } else if (d > (double)this.helper.getSystemGCProportionThreshold()) {
                this.commentData.addProblem(MessageFormat.format(LOTS_SYSTEM_GCS_WARNING, n, dataPointBuilderArray.length, d));
            } else if (d > 0.0) {
                this.commentData.addInformation(MessageFormat.format(LOTS_SYSTEM_GCS_WARNING, n, dataPointBuilderArray.length, d));
            }
        }
    }

    private void lookForSynchGCs(Data data) {
        TwoDimensionalDataBuilder twoDimensionalDataBuilder = this.getTwoDimensionalData(data, GCLabels.GC_REASON_RECORD);
        if (twoDimensionalDataBuilder != null && !twoDimensionalDataBuilder.isEmpty() && twoDimensionalDataBuilder.getMaxY().getRawY() >= (double)GCReasons.SYNCH_INT) {
            DataPointBuilder[] dataPointBuilderArray = twoDimensionalDataBuilder.getDataPoints();
            int n = 0;
            for (int i = 0; i < dataPointBuilderArray.length; ++i) {
                if (dataPointBuilderArray[i].getRawY() != (double)GCReasons.SYNCH_INT) continue;
                ++n;
            }
            if (n > 0) {
                this.commentData.addWarning(MessageFormat.format(LOTS_SYNCH_GCS_WARNING, n));
            }
        }
    }

    private void checkForOptavgpause(Data data) {
        if (OPTAVGPAUSE.equals(this.gcMode) && this.genconAvailable) {
            this.commentData.addWarning(TRY_GENCON_NOT_OPTAVGPAUSE);
            this.recommendedCommandLine.put(XGCPOLICY, XGCPOLICY_GENCON);
            Data data2 = data.getData(GCLabels.FLAT_HEAP_SIZE);
            if (data2 instanceof TwoDimensionalData && !data2.isEmpty()) {
                TwoDimensionalData twoDimensionalData = (TwoDimensionalData)data2;
                double d = this.getMeanAsMB(twoDimensionalData);
                int n = (int)Math.round(d * 0.25);
                this.recommendedCommandLine.put(NURSERY_SIZE, NURSERY_SIZE + n + MEGABYTES_UNITS_FOR_COMMANDS);
            }
        }
    }

    private TwoDimensionalDataBuilder getTwoDimensionalData(Data data, String string) {
        Data data2 = data.getData(string);
        if (data2 instanceof TwoDimensionalDataBuilder) {
            return (TwoDimensionalDataBuilder)data2;
        }
        return null;
    }

    protected String getFirstSentence(String string) {
        int n = string.indexOf(46);
        if (n > 0) {
            return string.substring(0, n);
        }
        return string;
    }

    public boolean isVMRealtime() {
        return this.isVMRealtime;
    }

    private float getXminfValue(DataBuilder dataBuilder) throws NumberFormatException {
        String string = "-Xminf";
        float f = -1.0f;
        DataBuilder dataBuilder2 = dataBuilder.getTopLevelData(EnvironmentLabels.ENVIRONMENT_LABEL);
        if (dataBuilder2 instanceof EnvironmentDataImpl) {
            int n;
            String string2 = ((EnvironmentDataImpl)dataBuilder2).getJavaParameter(string);
            int n2 = -1;
            int n3 = -1;
            if (string2 == null) {
                return -1.0f;
            }
            string2 = string2.trim();
            for (n = 1; n < string2.length(); ++n) {
                if (!Character.isDigit(string2.charAt(n))) continue;
                n2 = n;
                break;
            }
            if (n2 == -1) {
                return -1.0f;
            }
            for (n = n2; n < string2.length(); ++n) {
                if (!Character.isDigit(string2.charAt(n)) && string2.charAt(n) != '.') {
                    n3 = n;
                }
                if (n3 != -1) continue;
                n3 = string2.length();
            }
            f = Float.parseFloat(string2.substring(n2, n3));
            if (f > 0.0f && f < 1.0f) {
                return f;
            }
            return -1.0f;
        }
        return f;
    }

    private double getCurrentHeapSize(DataBuilder dataBuilder) {
        SubsystemDataBuilder subsystemDataBuilder = (SubsystemDataBuilder)dataBuilder.getTopLevelData(JVMLabels.GARBAGE_COLLECTION);
        double d = -1.0;
        if (subsystemDataBuilder != null) {
            TwoDimensionalDataBuilder twoDimensionalDataBuilder = null;
            if (this.gcMode.equals(GENCON)) {
                twoDimensionalDataBuilder = this.getTwoDimensionalData(subsystemDataBuilder, GCLabels.TENURED_SIZE);
                if (twoDimensionalDataBuilder != null && twoDimensionalDataBuilder.getLastDataPoint() != null) {
                    d = ((DataPointBuilder)twoDimensionalDataBuilder.getLastDataPoint()).getRawY();
                }
            } else {
                twoDimensionalDataBuilder = this.getTwoDimensionalData(subsystemDataBuilder, GCLabels.FLAT_HEAP_SIZE);
                if (twoDimensionalDataBuilder != null && twoDimensionalDataBuilder.getLastDataPoint() != null) {
                    d = ((DataPointBuilder)twoDimensionalDataBuilder.getLastDataPoint()).getRawY();
                }
            }
        }
        return d;
    }

    private double getCurrentFreeHeapSize(DataBuilder dataBuilder) {
        TwoDimensionalDataBuilder twoDimensionalDataBuilder;
        SubsystemDataBuilder subsystemDataBuilder = (SubsystemDataBuilder)dataBuilder.getTopLevelData(JVMLabels.GARBAGE_COLLECTION);
        double d = -1.0;
        if (subsystemDataBuilder != null && (twoDimensionalDataBuilder = this.getTwoDimensionalData(subsystemDataBuilder, GCLabels.FREE_FLAT_HEAP_AFTER_ALL_GCS)) != null && twoDimensionalDataBuilder.getLastDataPoint() != null) {
            d = ((DataPointBuilder)twoDimensionalDataBuilder.getLastDataPoint()).getY(UnitLabels.BYTES);
        }
        return d;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long getMaxHeapSize(DataBuilder dataBuilder) throws NumberFormatException {
        int n;
        String string = MX;
        long l = -1L;
        DataBuilder dataBuilder2 = dataBuilder.getTopLevelData(EnvironmentLabels.ENVIRONMENT_LABEL);
        if (!(dataBuilder2 instanceof EnvironmentDataImpl)) return l;
        String string2 = ((EnvironmentDataImpl)dataBuilder2).getJavaParameter(string);
        int n2 = -1;
        int n3 = -1;
        if (string2 == null) {
            return -1L;
        }
        string2 = string2.trim();
        for (n = 1; n < string2.length(); ++n) {
            if (!Character.isDigit(string2.charAt(n))) continue;
            n2 = n;
            break;
        }
        if (n2 == -1) {
            return -1L;
        }
        for (n = n2; n < string2.length(); ++n) {
            if (!Character.isDigit(string2.charAt(n))) {
                n3 = n;
            }
            if (n3 != -1) continue;
            n3 = string2.length();
        }
        long l2 = Long.parseLong(string2.substring(n2, n3));
        if (n3 == string2.length()) {
            return l2;
        }
        if (n3 != string2.length() - 1) return -1L;
        char c = string2.charAt(n3);
        if (c == 'm') return l2 * 1024L * 1024L;
        if (c == 'M') {
            return l2 * 1024L * 1024L;
        }
        if (c == 'k') return l2 * 1024L;
        if (c != 'K') return -1L;
        return l2 * 1024L;
    }

    private void lowFreeHeapCheck(DataBuilder dataBuilder) {
        try {
            long l = this.getMaxHeapSize(dataBuilder);
            float f = this.getXminfValue(dataBuilder);
            double d = this.getCurrentHeapSize(dataBuilder);
            double d2 = this.getCurrentFreeHeapSize(dataBuilder);
            float f2 = 0.99f;
            if ((l != -1L || f != -1.0f || d != -1.0 || d2 != -1.0) && d > (double)((float)l * f2) && d2 < d * (double)f && d2 < d * 0.3) {
                String string = Messages.getString("Summariser.low.free.heap");
                float f3 = (double)f >= 0.3 ? 70.0f : (1.0f - f) * 100.0f;
                this.commentData.addInformation(MessageFormat.format(string, Float.valueOf(f3)));
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.err.print("NumberFormatException in Summariser: " + numberFormatException.getMessage());
        }
    }

    private void loaRecommendations(DataBuilder dataBuilder) {
        try {
            TwoDimensionalDataBuilder twoDimensionalDataBuilder;
            double d;
            double d2;
            TwoDimensionalDataBuilder twoDimensionalDataBuilder2;
            TwoDimensionalDataBuilder twoDimensionalDataBuilder3;
            double d3;
            double d4;
            double d5;
            DataPointBuilder[] dataPointBuilderArray;
            TwoDimensionalDataBuilder twoDimensionalDataBuilder4;
            DataBuilder dataBuilder2;
            String string = "-Xnoloa";
            int n = 64;
            int n2 = 50;
            DataBuilder dataBuilder3 = dataBuilder.getTopLevelData(EnvironmentLabels.ENVIRONMENT_LABEL);
            if (dataBuilder3 instanceof EnvironmentDataImpl && ((EnvironmentDataImpl)dataBuilder3).getJavaParameter(string) != null && (dataBuilder2 = dataBuilder.getTopLevelData(JVMLabels.GARBAGE_COLLECTION)) instanceof SubsystemDataBuilder && (twoDimensionalDataBuilder4 = this.getTwoDimensionalData(dataBuilder, GCLabels.MINIMUM_REQUESTED_BYTES)) != null && !twoDimensionalDataBuilder4.isEmpty()) {
                dataPointBuilderArray = twoDimensionalDataBuilder4.getDataPoints();
                int n3 = 0;
                for (int i = 0; i < dataPointBuilderArray.length; ++i) {
                    if (!(dataPointBuilderArray[i].getY(UnitLabels.KB) > (double)n)) continue;
                    ++n3;
                }
                double d6 = (double)n3 / (double)dataPointBuilderArray.length * 100.0;
                if (d6 > (double)n2) {
                    String string2 = Messages.getString("Summariser.loa.off.and.large.objects.present");
                    this.commentData.addInformation(MessageFormat.format(string2, d6));
                }
            }
            float f = this.getXloaMinimum(dataBuilder);
            float f2 = 0.9f;
            if (f > 0.0f && f <= 100.0f && (d5 = ((DataPointBuilder)(dataPointBuilderArray = this.getTwoDimensionalData(dataBuilder, GCLabels.TOTAL_LOA)).getLastDataPoint()).getY(UnitLabels.BYTES)) <= (d4 = this.getCurrentHeapSize(dataBuilder)) * (double)(f / 100.0f) * 1.01 && (d3 = ((DataPointBuilder)(twoDimensionalDataBuilder3 = this.getTwoDimensionalData(dataBuilder, GCLabels.FREE_LOA_AFTER_GC)).getLastDataPoint()).getY(UnitLabels.BYTES)) > d5 * (double)f2) {
                String string3 = Messages.getString("Summariser.loa.min.set.warning");
                this.commentData.addInformation(MessageFormat.format(string3, Float.valueOf(f), Float.valueOf(f2 * 100.0f)));
            }
            float f3 = this.getXloaMaximum(dataBuilder);
            float f4 = 0.3f;
            if (f3 >= 0.0f && f3 <= 50.0f && (d4 = ((DataPointBuilder)(twoDimensionalDataBuilder2 = this.getTwoDimensionalData(dataBuilder, GCLabels.TOTAL_LOA)).getLastDataPoint()).getY(UnitLabels.BYTES)) >= (d2 = this.getCurrentHeapSize(dataBuilder)) * (double)(f / 100.0f) * 0.99 && (d = ((DataPointBuilder)(twoDimensionalDataBuilder = this.getTwoDimensionalData(dataBuilder, GCLabels.FREE_LOA_AFTER_GC)).getLastDataPoint()).getY(UnitLabels.BYTES)) < d4 * (double)f4) {
                String string4 = Messages.getString("Summariser.loa.max.set.warning");
                this.commentData.addInformation(MessageFormat.format(string4, Float.valueOf(f4 * 100.0f)));
            }
            if (f3 > 50.0f && f3 <= 100.0f) {
                String string5 = Messages.getString("Summariser.loa.max.set.extreme");
                this.commentData.addInformation(MessageFormat.format(string5, Float.valueOf(f3)));
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.err.print("NumberFormatException: " + numberFormatException.getMessage());
        }
    }

    private float getXloaMinimum(DataBuilder dataBuilder) throws NumberFormatException {
        String string = "-Xloaminimum";
        float f = -1.0f;
        DataBuilder dataBuilder2 = dataBuilder.getTopLevelData(EnvironmentLabels.ENVIRONMENT_LABEL);
        if (dataBuilder2 instanceof EnvironmentDataImpl) {
            int n;
            String string2 = ((EnvironmentDataImpl)dataBuilder2).getJavaParameter(string);
            int n2 = -1;
            int n3 = -1;
            if (string2 == null) {
                return -1.0f;
            }
            string2 = string2.trim();
            for (n = 1; n < string2.length(); ++n) {
                if (!Character.isDigit(string2.charAt(n))) continue;
                n2 = n;
                break;
            }
            if (n2 == -1) {
                return -1.0f;
            }
            for (n = n2; n < string2.length(); ++n) {
                if (!Character.isDigit(string2.charAt(n)) && string2.charAt(n) != '.') {
                    n3 = n;
                }
                if (n3 != -1) continue;
                n3 = string2.length();
            }
            float f2 = Float.parseFloat(string2.substring(n2, n3));
            f = f2 * 100.0f;
            return f;
        }
        return -1.0f;
    }

    private float getXloaMaximum(DataBuilder dataBuilder) throws NumberFormatException {
        String string = "-Xloamaximum";
        float f = -1.0f;
        DataBuilder dataBuilder2 = dataBuilder.getTopLevelData(EnvironmentLabels.ENVIRONMENT_LABEL);
        if (dataBuilder2 instanceof EnvironmentDataImpl) {
            int n;
            String string2 = ((EnvironmentDataImpl)dataBuilder2).getJavaParameter(string);
            int n2 = -1;
            int n3 = -1;
            if (string2 == null) {
                return -1.0f;
            }
            string2 = string2.trim();
            for (n = 1; n < string2.length(); ++n) {
                if (!Character.isDigit(string2.charAt(n))) continue;
                n2 = n;
                break;
            }
            if (n2 == -1) {
                return -1.0f;
            }
            for (n = n2; n < string2.length(); ++n) {
                if (!Character.isDigit(string2.charAt(n)) && string2.charAt(n) != '.') {
                    n3 = n;
                }
                if (n3 != -1) continue;
                n3 = string2.length();
            }
            float f2 = Float.parseFloat(string2.substring(n2, n3));
            f = f2 * 100.0f;
            return f;
        }
        return -1.0f;
    }
}

