/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.gc.parser.j9;

import com.ibm.java.diagnostics.common.datamodel.data.Data;
import com.ibm.java.diagnostics.common.datamodel.data.axes.AxisPair;
import com.ibm.java.diagnostics.common.datamodel.impl.data.DataPointImpl;
import com.ibm.java.diagnostics.healthcenter.stacks.CallSiteProvider;
import com.ibm.java.diagnostics.healthcenter.stacks.CallStack;
import com.ibm.java.diagnostics.healthcenter.stacks.StackData;
import com.ibm.java.diagnostics.healthcenter.stacks.StackTraceDataPoint;

public class AllocationThresholdDataPointImpl
extends DataPointImpl
implements CallSiteProvider {
    private static final String EMPTY_STRING = "";
    private static final String NEWLINE = "\n";
    public static final String TRIGGER = "j9mm.234";
    private StackTraceDataPoint stackDataPoint;
    private double lowThreshold;
    private double highThreshold;
    private Data rootData;

    public AllocationThresholdDataPointImpl(int n, double d, double d2, AxisPair axisPair, double d3, double d4, Data data) {
        super(n, d, d2, axisPair);
        this.lowThreshold = d3;
        this.highThreshold = d4;
        this.rootData = data;
    }

    public String getStackTop() {
        this.getStackDataPoint();
        if (this.stackDataPoint == null) {
            return EMPTY_STRING;
        }
        return this.stackDataPoint.getStackTop();
    }

    private StackTraceDataPoint getStackDataPoint() {
        if (this.stackDataPoint == null) {
            this.stackDataPoint = StackData.findStackTrace(TRIGGER, this.getRawX(), this.rootData);
        }
        return this.stackDataPoint;
    }

    public String getFullStack() {
        this.getStackDataPoint();
        if (this.stackDataPoint == null) {
            return EMPTY_STRING;
        }
        CallStack callStack = this.stackDataPoint.getStack();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getStackTop());
        for (int i = 1; i < callStack.getStackSize(); ++i) {
            stringBuffer.append(NEWLINE);
            stringBuffer.append(callStack.getStackEntry(i).getEntry());
        }
        return stringBuffer.toString();
    }

    public double getLowThreshold() {
        return this.lowThreshold;
    }

    public double getHighThreshold() {
        return this.highThreshold;
    }

    @Override
    public String getCallSite() {
        return this.getStackTop();
    }

    @Override
    public String getTriggerID() {
        return TRIGGER;
    }
}

