/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.agent.mbean;

import com.ibm.java.diagnostics.healthcenter.agent.mbean.Messages;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentLogFactory {
    private static boolean loggingInit = false;
    private static int pid = 0;

    public static Logger setUpLogging(Class<?> clazz) {
        if (clazz == null) {
            Logger logger = Logger.global;
            logger.warning(Messages.getString("AgentLogFactory.could.not.initialize.logging"));
            return logger;
        }
        try {
            LogManager mgr = LogManager.getLogManager();
            if (!loggingInit) {
                loggingInit = true;
                Logger parentLogger = Logger.getLogger("com.ibm.java.diagnostics.healthcenter.agent");
                mgr.addLogger(parentLogger);
            }
            Logger logger = Logger.getLogger(clazz.getName());
            mgr.addLogger(logger);
            String debugProp = System.getProperty("com.ibm.java.diagnostics.healthcenter.agent.debug");
            if (debugProp != null) {
                logger.setLevel(Level.FINEST);
            } else {
                logger.setLevel(Level.INFO);
            }
            return logger;
        }
        catch (Throwable e) {
            e.printStackTrace();
            Logger logger = Logger.global;
            logger.warning(Messages.getString("AgentLogFactory.could.not.initialize.logging") + e.toString());
            return logger;
        }
    }

    public static void setPid(int newPid) {
        pid = newPid;
    }
}

