/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jtc.orb.map;

import com.ibm.jtc.orb.map.Cache;
import com.ibm.jtc.orb.map.CacheFactory;
import com.ibm.jtc.orb.map.ConcurrentCache;
import com.ibm.jtc.orb.map.ConcurrentCacheFactory;
import com.ibm.jtc.orb.map.ConcurrentMapFactory;
import com.ibm.jtc.orb.map.MapFactory;
import com.ibm.jtc.orb.map.ObjectFactory;
import com.ibm.jtc.orb.map.ObjectWrapper;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;

public class CacheFactories {
    public static final CacheFactory PLAIN = Plain.INSTANCE;
    public static final CacheFactory SOFT = Soft.INSTANCE;
    public static final CacheFactory WEAK = Weak.INSTANCE;
    public static final ConcurrentCacheFactory CONCURRENT_PLAIN = Concurrent.INSTANCE;
    public static final ConcurrentCacheFactory CONCURRENT_SOFT = ConcurrentSoft.INSTANCE;
    public static final ConcurrentCacheFactory CONCURRENT_WEAK = ConcurrentWeak.INSTANCE;

    private CacheFactories() {
    }

    private static final class Concurrent
    implements ConcurrentCacheFactory {
        public static final Concurrent INSTANCE = new Concurrent();

        private Concurrent() {
        }

        @Override
        public ConcurrentCache create(ConcurrentMapFactory concurrentMapFactory) {
            return new FutureCacheImpl(concurrentMapFactory);
        }

        @Override
        public ConcurrentCache create(ConcurrentMapFactory concurrentMapFactory, ObjectFactory objectFactory) {
            return new ObjectCacheImpl(concurrentMapFactory, objectFactory);
        }

        @Override
        public ConcurrentCache create(ConcurrentMapFactory concurrentMapFactory, int n) {
            return new FutureCacheImpl(concurrentMapFactory, n);
        }

        @Override
        public ConcurrentCache create(ConcurrentMapFactory concurrentMapFactory, int n, int n2) {
            return new FutureCacheImpl(concurrentMapFactory, n, n2);
        }

        @Override
        public ConcurrentCache create(ConcurrentMapFactory concurrentMapFactory, ObjectFactory objectFactory, int n) {
            return new ObjectCacheImpl(concurrentMapFactory, objectFactory, n);
        }

        @Override
        public ConcurrentCache create(ConcurrentMapFactory concurrentMapFactory, ObjectFactory objectFactory, int n, int n2) {
            return new ObjectCacheImpl(concurrentMapFactory, objectFactory, n, n2);
        }

        private static final class FutureCacheImpl
        implements ConcurrentCache {
            private final ConcurrentMap map;

            FutureCacheImpl(ConcurrentMapFactory concurrentMapFactory) {
                this.map = concurrentMapFactory.create();
            }

            FutureCacheImpl(ConcurrentMapFactory concurrentMapFactory, int n) {
                this.map = concurrentMapFactory.create(n);
            }

            FutureCacheImpl(ConcurrentMapFactory concurrentMapFactory, int n, int n2) {
                this.map = concurrentMapFactory.create(n, 0.75f, n2);
            }

            @Override
            public void clear() {
                this.map.clear();
            }

            @Override
            public Object get(Object object) {
                Object v;
                Object object2 = this.map.get(object);
                if (null == object2 && (v = this.map.putIfAbsent(object, object2 = new FutureImpl(object, this.map))) != null) {
                    object2 = v;
                }
                return object2;
            }

            @Override
            public boolean isEmpty() {
                return this.map.isEmpty();
            }

            @Override
            public Object remove(Object object) {
                return this.map.remove(object);
            }

            private static final class FutureImpl
            implements Cache.FutureEntry {
                private final Object key;
                private final ConcurrentMap map;
                private AtomicReference canonicalValue = null;

                FutureImpl(Object object, ConcurrentMap concurrentMap) {
                    this.key = object;
                    this.map = concurrentMap;
                    this.canonicalValue = new AtomicReference();
                }

                @Override
                public Object get() {
                    return this.canonicalValue.get();
                }

                @Override
                public Object get(Object object) {
                    if (this.canonicalValue.compareAndSet(null, object)) {
                        this.map.put(this.key, object);
                        return object;
                    }
                    return this.canonicalValue.get();
                }
            }
        }

        private static final class ObjectCacheImpl
        implements ConcurrentCache {
            private final ConcurrentMap map;
            private final ObjectFactory valueFactory;

            ObjectCacheImpl(ConcurrentMapFactory concurrentMapFactory, ObjectFactory objectFactory) {
                this.map = concurrentMapFactory.create();
                this.valueFactory = objectFactory;
            }

            ObjectCacheImpl(ConcurrentMapFactory concurrentMapFactory, ObjectFactory objectFactory, int n) {
                this.map = concurrentMapFactory.create(n);
                this.valueFactory = objectFactory;
            }

            ObjectCacheImpl(ConcurrentMapFactory concurrentMapFactory, ObjectFactory objectFactory, int n, int n2) {
                this.map = concurrentMapFactory.create(n, 0.75f, n2);
                this.valueFactory = objectFactory;
            }

            @Override
            public void clear() {
                this.map.clear();
            }

            @Override
            public Object get(Object object) {
                Object v;
                Object object2 = this.map.get(object);
                if (null == object2 && (v = this.map.putIfAbsent(object, object2 = this.valueFactory.create())) != null) {
                    object2 = v;
                }
                return object2;
            }

            @Override
            public boolean isEmpty() {
                return this.map.isEmpty();
            }

            @Override
            public Object remove(Object object) {
                return this.map.remove(object);
            }
        }
    }

    private static final class ConcurrentSoft
    implements ConcurrentCacheFactory {
        public static final ConcurrentSoft INSTANCE = new ConcurrentSoft();

        private ConcurrentSoft() {
        }

        @Override
        public final ConcurrentCache create(ConcurrentMapFactory concurrentMapFactory) {
            return new FutureCacheImpl(concurrentMapFactory);
        }

        @Override
        public final ConcurrentCache create(ConcurrentMapFactory concurrentMapFactory, ObjectFactory objectFactory) {
            return new ObjectCacheImpl(concurrentMapFactory, objectFactory);
        }

        @Override
        public ConcurrentCache create(ConcurrentMapFactory concurrentMapFactory, int n) {
            return new FutureCacheImpl(concurrentMapFactory, n);
        }

        @Override
        public ConcurrentCache create(ConcurrentMapFactory concurrentMapFactory, int n, int n2) {
            return new FutureCacheImpl(concurrentMapFactory, n, n2);
        }

        @Override
        public ConcurrentCache create(ConcurrentMapFactory concurrentMapFactory, ObjectFactory objectFactory, int n) {
            return new ObjectCacheImpl(concurrentMapFactory, objectFactory, n);
        }

        @Override
        public ConcurrentCache create(ConcurrentMapFactory concurrentMapFactory, ObjectFactory objectFactory, int n, int n2) {
            return new ObjectCacheImpl(concurrentMapFactory, objectFactory, n, n2);
        }

        private static final class FutureCacheImpl
        implements ConcurrentCache {
            private final ConcurrentMap map;
            private final ObjectWrapper keyWrapper;
            private final ReferenceQueue queue;

            FutureCacheImpl(ConcurrentMapFactory concurrentMapFactory) {
                this.map = concurrentMapFactory.create();
                this.keyWrapper = concurrentMapFactory.getKeyWrapper();
                this.queue = new ReferenceQueue();
            }

            FutureCacheImpl(ConcurrentMapFactory concurrentMapFactory, int n) {
                this.map = concurrentMapFactory.create(n);
                this.keyWrapper = concurrentMapFactory.getKeyWrapper();
                this.queue = new ReferenceQueue();
            }

            FutureCacheImpl(ConcurrentMapFactory concurrentMapFactory, int n, int n2) {
                this.map = concurrentMapFactory.create(n, 0.75f, n2);
                this.keyWrapper = concurrentMapFactory.getKeyWrapper();
                this.queue = new ReferenceQueue();
            }

            private void clearQueue() {
                Object object = null;
                Value value = (Value)this.queue.poll();
                while (null != value) {
                    object = this.keyWrapper.unwrap(value.keyRef);
                    if (null != object) {
                        this.map.remove(object);
                    }
                    value = (Value)this.queue.poll();
                }
            }

            @Override
            public Object get(Object object) {
                SoftReference<FutureImpl> softReference = (SoftReference<FutureImpl>)this.map.get(object);
                FutureImpl futureImpl = null == softReference ? null : (FutureImpl)((Reference)softReference).get();
                this.clearQueue();
                if (null == futureImpl) {
                    if (null != softReference) {
                        this.map.remove(object);
                    }
                    Object object2 = this.keyWrapper.wrap(object);
                    futureImpl = new FutureImpl(object, object2, this.map, this.queue);
                    SoftReference<FutureImpl> softReference2 = softReference = new SoftReference<FutureImpl>(futureImpl);
                    do {
                        if ((softReference = this.map.putIfAbsent(object, softReference)) == null || (futureImpl = ((Reference)softReference).get()) != null) continue;
                        softReference = softReference2;
                    } while (futureImpl == null);
                }
                return futureImpl;
            }

            @Override
            public void clear() {
                this.map.clear();
            }

            @Override
            public boolean isEmpty() {
                return this.map.isEmpty();
            }

            @Override
            public Object remove(Object object) {
                return this.map.remove(object);
            }

            private static final class FutureImpl
            implements Cache.FutureEntry {
                private final Object key;
                private final Map map;
                private AtomicReference canonicalValue = null;
                private final Object keyRef;
                private final ReferenceQueue queue;

                FutureImpl(Object object, Object object2, Map map, ReferenceQueue referenceQueue) {
                    this.key = object;
                    this.keyRef = object2;
                    this.map = map;
                    this.queue = referenceQueue;
                    this.canonicalValue = new AtomicReference();
                }

                @Override
                public Object get() {
                    return this.canonicalValue.get();
                }

                @Override
                public Object get(Object object) {
                    if (this.canonicalValue.compareAndSet(null, object)) {
                        Value value = new Value(object, this.keyRef, this.queue);
                        this.map.put(this.key, value);
                        return object;
                    }
                    return this.canonicalValue.get();
                }
            }

            private static final class Value
            extends SoftReference {
                final Object keyRef;

                Value(Object object, Object object2, ReferenceQueue referenceQueue) {
                    super(object, referenceQueue);
                    this.keyRef = object2;
                }
            }
        }

        private static final class ObjectCacheImpl
        implements ConcurrentCache {
            private final ConcurrentMap map;
            private final ObjectFactory valueFactory;
            private final ObjectWrapper keyWrapper;
            private final ReferenceQueue queue;

            ObjectCacheImpl(ConcurrentMapFactory concurrentMapFactory, ObjectFactory objectFactory) {
                this.map = concurrentMapFactory.create();
                this.keyWrapper = concurrentMapFactory.getKeyWrapper();
                this.valueFactory = objectFactory;
                this.queue = new ReferenceQueue();
            }

            ObjectCacheImpl(ConcurrentMapFactory concurrentMapFactory, ObjectFactory objectFactory, int n) {
                this.map = concurrentMapFactory.create(n);
                this.valueFactory = objectFactory;
                this.keyWrapper = concurrentMapFactory.getKeyWrapper();
                this.queue = new ReferenceQueue();
            }

            ObjectCacheImpl(ConcurrentMapFactory concurrentMapFactory, ObjectFactory objectFactory, int n, int n2) {
                this.map = concurrentMapFactory.create(n, 0.75f, n2);
                this.valueFactory = objectFactory;
                this.keyWrapper = concurrentMapFactory.getKeyWrapper();
                this.queue = new ReferenceQueue();
            }

            private void clearQueue() {
                Object object = null;
                Value value = (Value)this.queue.poll();
                while (null != value) {
                    object = this.keyWrapper.unwrap(value.keyRef);
                    if (null != object) {
                        this.map.remove(object);
                    }
                    value = (Value)this.queue.poll();
                }
            }

            @Override
            public Object get(Object object) {
                Value value = (Value)this.map.get(object);
                Object object2 = null == value ? null : (Object)value.get();
                this.clearQueue();
                if (null == object2) {
                    if (null != value) {
                        this.map.remove(object);
                    }
                    Object object3 = this.keyWrapper.wrap(object);
                    object2 = this.valueFactory.create();
                    Value value2 = value = new Value(object2, object3, this.queue);
                    do {
                        Value value3;
                        if ((value3 = this.map.putIfAbsent(object, value)) == null || (object2 = value3.get()) != null) continue;
                        value = value2;
                    } while (object2 == null);
                }
                return object2;
            }

            @Override
            public void clear() {
                this.map.clear();
            }

            @Override
            public boolean isEmpty() {
                return this.map.isEmpty();
            }

            @Override
            public Object remove(Object object) {
                return this.map.remove(object);
            }

            private static final class Value
            extends SoftReference {
                final Object keyRef;

                Value(Object object, Object object2, ReferenceQueue referenceQueue) {
                    super(object, referenceQueue);
                    this.keyRef = object2;
                }
            }
        }
    }

    private static final class ConcurrentWeak
    implements ConcurrentCacheFactory {
        public static final ConcurrentWeak INSTANCE = new ConcurrentWeak();

        private ConcurrentWeak() {
        }

        @Override
        public final ConcurrentCache create(ConcurrentMapFactory concurrentMapFactory) {
            return new FutureCacheImpl(concurrentMapFactory);
        }

        @Override
        public final ConcurrentCache create(ConcurrentMapFactory concurrentMapFactory, ObjectFactory objectFactory) {
            return new ObjectCacheImpl(concurrentMapFactory, objectFactory);
        }

        @Override
        public ConcurrentCache create(ConcurrentMapFactory concurrentMapFactory, int n) {
            return new FutureCacheImpl(concurrentMapFactory, n);
        }

        @Override
        public ConcurrentCache create(ConcurrentMapFactory concurrentMapFactory, int n, int n2) {
            return new FutureCacheImpl(concurrentMapFactory, n, n2);
        }

        @Override
        public ConcurrentCache create(ConcurrentMapFactory concurrentMapFactory, ObjectFactory objectFactory, int n) {
            return new ObjectCacheImpl(concurrentMapFactory, objectFactory, n);
        }

        @Override
        public ConcurrentCache create(ConcurrentMapFactory concurrentMapFactory, ObjectFactory objectFactory, int n, int n2) {
            return new ObjectCacheImpl(concurrentMapFactory, objectFactory, n, n2);
        }

        private static final class FutureCacheImpl
        implements ConcurrentCache {
            private final ConcurrentMap map;
            private final ObjectWrapper keyWrapper;
            private final ReferenceQueue queue;

            FutureCacheImpl(ConcurrentMapFactory concurrentMapFactory) {
                this.map = concurrentMapFactory.create();
                this.keyWrapper = concurrentMapFactory.getKeyWrapper();
                this.queue = new ReferenceQueue();
            }

            FutureCacheImpl(ConcurrentMapFactory concurrentMapFactory, int n) {
                this.map = concurrentMapFactory.create(n);
                this.keyWrapper = concurrentMapFactory.getKeyWrapper();
                this.queue = new ReferenceQueue();
            }

            FutureCacheImpl(ConcurrentMapFactory concurrentMapFactory, int n, int n2) {
                this.map = concurrentMapFactory.create(n, 0.75f, n2);
                this.keyWrapper = concurrentMapFactory.getKeyWrapper();
                this.queue = new ReferenceQueue();
            }

            private void clearQueue() {
                Object object = null;
                Value value = (Value)this.queue.poll();
                while (null != value) {
                    object = this.keyWrapper.unwrap(value.keyRef);
                    if (null != object) {
                        this.map.remove(object);
                    }
                    value = (Value)this.queue.poll();
                }
            }

            @Override
            public Object get(Object object) {
                WeakReference<FutureImpl> weakReference = (WeakReference<FutureImpl>)this.map.get(object);
                FutureImpl futureImpl = null == weakReference ? null : (FutureImpl)weakReference.get();
                this.clearQueue();
                if (null == futureImpl) {
                    if (null != weakReference) {
                        this.map.remove(object);
                    }
                    Object object2 = this.keyWrapper.wrap(object);
                    futureImpl = new FutureImpl(object, object2, this.map, this.queue);
                    WeakReference<FutureImpl> weakReference2 = weakReference = new WeakReference<FutureImpl>(futureImpl);
                    do {
                        if ((weakReference = this.map.putIfAbsent(object, weakReference)) == null || (futureImpl = weakReference.get()) != null) continue;
                        weakReference = weakReference2;
                    } while (futureImpl == null);
                }
                return futureImpl;
            }

            @Override
            public void clear() {
                this.map.clear();
            }

            @Override
            public boolean isEmpty() {
                return this.map.isEmpty();
            }

            @Override
            public Object remove(Object object) {
                return this.map.remove(object);
            }

            private static final class FutureImpl
            implements Cache.FutureEntry {
                private final Object key;
                private final Map map;
                private AtomicReference canonicalValue;
                private final Object keyRef;
                private final ReferenceQueue queue;

                FutureImpl(Object object, Object object2, Map map, ReferenceQueue referenceQueue) {
                    this.key = object;
                    this.keyRef = object2;
                    this.map = map;
                    this.queue = referenceQueue;
                    this.canonicalValue = new AtomicReference();
                }

                @Override
                public Object get() {
                    return this.canonicalValue.get();
                }

                @Override
                public Object get(Object object) {
                    if (this.canonicalValue.compareAndSet(null, object)) {
                        Value value = new Value(object, this.keyRef, this.queue);
                        this.map.put(this.key, value);
                        return object;
                    }
                    return this.canonicalValue.get();
                }
            }

            private static final class Value
            extends WeakReference {
                final Object keyRef;

                Value(Object object, Object object2, ReferenceQueue referenceQueue) {
                    super(object, referenceQueue);
                    this.keyRef = object2;
                }
            }
        }

        private static final class ObjectCacheImpl
        implements ConcurrentCache {
            private final ConcurrentMap map;
            private final ObjectFactory valueFactory;
            private final ObjectWrapper keyWrapper;
            private final ReferenceQueue queue;

            ObjectCacheImpl(ConcurrentMapFactory concurrentMapFactory, ObjectFactory objectFactory) {
                this.map = concurrentMapFactory.create();
                this.keyWrapper = concurrentMapFactory.getKeyWrapper();
                this.valueFactory = objectFactory;
                this.queue = new ReferenceQueue();
            }

            ObjectCacheImpl(ConcurrentMapFactory concurrentMapFactory, ObjectFactory objectFactory, int n) {
                this.map = concurrentMapFactory.create(n);
                this.valueFactory = objectFactory;
                this.keyWrapper = concurrentMapFactory.getKeyWrapper();
                this.queue = new ReferenceQueue();
            }

            ObjectCacheImpl(ConcurrentMapFactory concurrentMapFactory, ObjectFactory objectFactory, int n, int n2) {
                this.map = concurrentMapFactory.create(n, 0.75f, n2);
                this.valueFactory = objectFactory;
                this.keyWrapper = concurrentMapFactory.getKeyWrapper();
                this.queue = new ReferenceQueue();
            }

            private void clearQueue() {
                Object object = null;
                Value value = (Value)this.queue.poll();
                while (null != value) {
                    object = this.keyWrapper.unwrap(value.keyRef);
                    if (null != object) {
                        this.map.remove(object);
                    }
                    value = (Value)this.queue.poll();
                }
            }

            @Override
            public Object get(Object object) {
                Value value = (Value)this.map.get(object);
                Object object2 = null == value ? null : (Object)value.get();
                this.clearQueue();
                if (null == object2) {
                    if (null != value) {
                        this.map.remove(object);
                    }
                    Object object3 = this.keyWrapper.wrap(object);
                    object2 = this.valueFactory.create();
                    Value value2 = value = new Value(object2, object3, this.queue);
                    do {
                        Value value3;
                        if ((value3 = this.map.putIfAbsent(object, value)) == null || (object2 = value3.get()) != null) continue;
                        value = value2;
                    } while (object2 == null);
                }
                return object2;
            }

            @Override
            public void clear() {
                this.map.clear();
            }

            @Override
            public boolean isEmpty() {
                return this.map.isEmpty();
            }

            @Override
            public Object remove(Object object) {
                return this.map.remove(object);
            }

            private static final class Value
            extends WeakReference {
                final Object keyRef;

                Value(Object object, Object object2, ReferenceQueue referenceQueue) {
                    super(object, referenceQueue);
                    this.keyRef = object2;
                }
            }
        }
    }

    private static final class Plain
    implements CacheFactory {
        public static final Plain INSTANCE = new Plain();

        private Plain() {
        }

        @Override
        public final Cache create(MapFactory mapFactory) {
            return new FutureCacheImpl(mapFactory);
        }

        @Override
        public final Cache create(MapFactory mapFactory, ObjectFactory objectFactory) {
            return new ObjectCacheImpl(mapFactory, objectFactory);
        }

        private static final class FutureCacheImpl
        implements Cache {
            private final Map map;

            FutureCacheImpl(MapFactory mapFactory) {
                this.map = mapFactory.create();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object get(Object object) {
                Map map = this.map;
                synchronized (map) {
                    Object object2 = this.map.get(object);
                    if (null == object2) {
                        object2 = new FutureImpl(object, this.map);
                        this.map.put(object, object2);
                    }
                    return object2;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clear() {
                Map map = this.map;
                synchronized (map) {
                    Iterator iterator = this.map.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        if (entry.getValue() instanceof FutureImpl) continue;
                        iterator.remove();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isEmpty() {
                Map map = this.map;
                synchronized (map) {
                    return this.map.isEmpty();
                }
            }

            private static final class FutureImpl
            implements Cache.FutureEntry {
                private final Object key;
                private final Map map;
                private Object canonicalValue = null;

                FutureImpl(Object object, Map map) {
                    this.key = object;
                    this.map = map;
                }

                @Override
                public synchronized Object get() {
                    return this.canonicalValue;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object get(Object object) {
                    Object object2 = this;
                    synchronized (object2) {
                        if (null != this.canonicalValue) {
                            return this.canonicalValue;
                        }
                        this.canonicalValue = object;
                    }
                    object2 = this.map;
                    synchronized (object2) {
                        this.map.put(this.key, object);
                    }
                    return object;
                }
            }
        }

        private static final class ObjectCacheImpl
        implements Cache {
            private final Map map;
            private final ObjectFactory valueFactory;

            ObjectCacheImpl(MapFactory mapFactory, ObjectFactory objectFactory) {
                this.map = mapFactory.create();
                this.valueFactory = objectFactory;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object get(Object object) {
                Map map = this.map;
                synchronized (map) {
                    Object object2 = this.map.get(object);
                    if (null == object2) {
                        object2 = this.valueFactory.create();
                        this.map.put(object, object2);
                    }
                    return object2;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clear() {
                Map map = this.map;
                synchronized (map) {
                    this.map.clear();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isEmpty() {
                Map map = this.map;
                synchronized (map) {
                    return this.map.isEmpty();
                }
            }
        }
    }

    private static final class Soft
    implements CacheFactory {
        public static final Soft INSTANCE = new Soft();

        private Soft() {
        }

        @Override
        public final Cache create(MapFactory mapFactory) {
            return new FutureCacheImpl(mapFactory);
        }

        @Override
        public final Cache create(MapFactory mapFactory, ObjectFactory objectFactory) {
            return new ObjectCacheImpl(mapFactory, objectFactory);
        }

        private static final class FutureCacheImpl
        implements Cache {
            private final Map map;
            private final ObjectWrapper keyWrapper;
            private final ReferenceQueue queue;

            FutureCacheImpl(MapFactory mapFactory) {
                this.map = mapFactory.create();
                this.keyWrapper = mapFactory.getKeyWrapper();
                this.queue = new ReferenceQueue();
            }

            private void clearQueue() {
                Object object = null;
                Value value = (Value)this.queue.poll();
                while (null != value) {
                    object = this.keyWrapper.unwrap(value.keyRef);
                    if (null != object) {
                        this.map.remove(object);
                    }
                    value = (Value)this.queue.poll();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object get(Object object) {
                Map map = this.map;
                synchronized (map) {
                    Reference reference = (Reference)this.map.get(object);
                    Object object2 = null == reference ? null : reference.get();
                    this.clearQueue();
                    if (null == object2) {
                        if (null != reference) {
                            this.map.remove(object);
                        }
                        Object object3 = this.keyWrapper.wrap(object);
                        object2 = new FutureImpl(object, object3, this.map, this.queue);
                        reference = new SimpleReference(object2);
                        this.map.put(object, reference);
                    }
                    return object2;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clear() {
                Map map = this.map;
                synchronized (map) {
                    Iterator iterator = this.map.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        if (entry.getValue() instanceof FutureImpl) continue;
                        iterator.remove();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isEmpty() {
                Map map = this.map;
                synchronized (map) {
                    return this.map.isEmpty();
                }
            }

            private static final class FutureImpl
            implements Cache.FutureEntry {
                private final Object key;
                private final Object keyRef;
                private final Map map;
                private final ReferenceQueue queue;
                private Object canonicalValue = null;

                FutureImpl(Object object, Object object2, Map map, ReferenceQueue referenceQueue) {
                    this.key = object;
                    this.keyRef = object2;
                    this.map = map;
                    this.queue = referenceQueue;
                }

                @Override
                public synchronized Object get() {
                    return this.canonicalValue;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object get(Object object) {
                    Object object2 = this;
                    synchronized (object2) {
                        if (null != this.canonicalValue) {
                            return this.canonicalValue;
                        }
                        this.canonicalValue = object;
                    }
                    object2 = new Value(object, this.keyRef, this.queue);
                    Map map = this.map;
                    synchronized (map) {
                        this.map.put(this.key, object2);
                    }
                    return object;
                }
            }

            private static interface Reference {
                public Object get();
            }

            private static final class SimpleReference
            implements Reference {
                private final Object object;

                SimpleReference(Object object) {
                    this.object = object;
                }

                @Override
                public Object get() {
                    return this.object;
                }
            }

            private static final class Value
            extends SoftReference
            implements Reference {
                final Object keyRef;

                Value(Object object, Object object2, ReferenceQueue referenceQueue) {
                    super(object, referenceQueue);
                    this.keyRef = object2;
                }
            }
        }

        private static final class ObjectCacheImpl
        implements Cache {
            private final Map map;
            private final ObjectFactory valueFactory;
            private final ObjectWrapper keyWrapper;
            private final ReferenceQueue queue;

            ObjectCacheImpl(MapFactory mapFactory, ObjectFactory objectFactory) {
                this.map = mapFactory.create();
                this.keyWrapper = mapFactory.getKeyWrapper();
                this.valueFactory = objectFactory;
                this.queue = new ReferenceQueue();
            }

            private void clearQueue() {
                Object object = null;
                Value value = (Value)this.queue.poll();
                while (null != value) {
                    object = this.keyWrapper.unwrap(value.keyRef);
                    if (null != object) {
                        this.map.remove(object);
                    }
                    value = (Value)this.queue.poll();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object get(Object object) {
                Map map = this.map;
                synchronized (map) {
                    Value value = (Value)this.map.get(object);
                    Object object2 = null == value ? null : (Object)value.get();
                    this.clearQueue();
                    if (null == object2) {
                        if (null != value) {
                            this.map.remove(object);
                        }
                        Object object3 = this.keyWrapper.wrap(object);
                        object2 = this.valueFactory.create();
                        value = new Value(object2, object3, this.queue);
                        this.map.put(object, value);
                    }
                    return object2;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clear() {
                Map map = this.map;
                synchronized (map) {
                    this.map.clear();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isEmpty() {
                Map map = this.map;
                synchronized (map) {
                    return this.map.isEmpty();
                }
            }

            private static final class Value
            extends SoftReference {
                final Object keyRef;

                Value(Object object, Object object2, ReferenceQueue referenceQueue) {
                    super(object, referenceQueue);
                    this.keyRef = object2;
                }
            }
        }
    }

    private static final class Weak
    implements CacheFactory {
        public static final Weak INSTANCE = new Weak();

        private Weak() {
        }

        @Override
        public final Cache create(MapFactory mapFactory) {
            return new FutureCacheImpl(mapFactory);
        }

        @Override
        public final Cache create(MapFactory mapFactory, ObjectFactory objectFactory) {
            return new ObjectCacheImpl(mapFactory, objectFactory);
        }

        private static final class FutureCacheImpl
        implements Cache {
            private final Map map;
            private final ObjectWrapper keyWrapper;
            private final ReferenceQueue queue;

            FutureCacheImpl(MapFactory mapFactory) {
                this.map = mapFactory.create();
                this.keyWrapper = mapFactory.getKeyWrapper();
                this.queue = new ReferenceQueue();
            }

            private void clearQueue() {
                Object object = null;
                Value value = (Value)this.queue.poll();
                while (null != value) {
                    object = this.keyWrapper.unwrap(value.keyRef);
                    if (null != object) {
                        this.map.remove(object);
                    }
                    value = (Value)this.queue.poll();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object get(Object object) {
                Map map = this.map;
                synchronized (map) {
                    Reference reference = (Reference)this.map.get(object);
                    Object object2 = null == reference ? null : reference.get();
                    this.clearQueue();
                    if (null == object2) {
                        if (null != reference) {
                            this.map.remove(object);
                        }
                        Object object3 = this.keyWrapper.wrap(object);
                        object2 = new FutureImpl(object, object3, this.map, this.queue);
                        reference = new SimpleReference(object2);
                        this.map.put(object, reference);
                    }
                    return object2;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clear() {
                Map map = this.map;
                synchronized (map) {
                    Iterator iterator = this.map.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        if (entry.getValue() instanceof FutureImpl) continue;
                        iterator.remove();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isEmpty() {
                Map map = this.map;
                synchronized (map) {
                    return this.map.isEmpty();
                }
            }

            private static final class FutureImpl
            implements Cache.FutureEntry {
                private final Object key;
                private final Object keyRef;
                private final Map map;
                private final ReferenceQueue queue;
                private Object canonicalValue = null;

                FutureImpl(Object object, Object object2, Map map, ReferenceQueue referenceQueue) {
                    this.key = object;
                    this.keyRef = object2;
                    this.map = map;
                    this.queue = referenceQueue;
                }

                @Override
                public synchronized Object get() {
                    return this.canonicalValue;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object get(Object object) {
                    Object object2 = this;
                    synchronized (object2) {
                        if (null != this.canonicalValue) {
                            return this.canonicalValue;
                        }
                        this.canonicalValue = object;
                    }
                    object2 = new Value(object, this.keyRef, this.queue);
                    Map map = this.map;
                    synchronized (map) {
                        this.map.put(this.key, object2);
                    }
                    return object;
                }
            }

            private static interface Reference {
                public Object get();
            }

            private static final class SimpleReference
            implements Reference {
                private final Object object;

                SimpleReference(Object object) {
                    this.object = object;
                }

                @Override
                public Object get() {
                    return this.object;
                }
            }

            private static final class Value
            extends WeakReference
            implements Reference {
                final Object keyRef;

                Value(Object object, Object object2, ReferenceQueue referenceQueue) {
                    super(object, referenceQueue);
                    this.keyRef = object2;
                }
            }
        }

        private static final class ObjectCacheImpl
        implements Cache {
            private final Map map;
            private final ObjectFactory valueFactory;
            private final ObjectWrapper keyWrapper;
            private final ReferenceQueue queue;

            ObjectCacheImpl(MapFactory mapFactory, ObjectFactory objectFactory) {
                this.map = mapFactory.create();
                this.keyWrapper = mapFactory.getKeyWrapper();
                this.valueFactory = objectFactory;
                this.queue = new ReferenceQueue();
            }

            private void clearQueue() {
                Object object = null;
                Value value = (Value)this.queue.poll();
                while (null != value) {
                    object = this.keyWrapper.unwrap(value.keyRef);
                    if (null != object) {
                        this.map.remove(object);
                    }
                    value = (Value)this.queue.poll();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object get(Object object) {
                Map map = this.map;
                synchronized (map) {
                    Value value = (Value)this.map.get(object);
                    Object object2 = null == value ? null : (Object)value.get();
                    this.clearQueue();
                    if (null == object2) {
                        if (null != value) {
                            this.map.remove(object);
                        }
                        Object object3 = this.keyWrapper.wrap(object);
                        object2 = this.valueFactory.create();
                        value = new Value(object2, object3, this.queue);
                        this.map.put(object, value);
                    }
                    return object2;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clear() {
                Map map = this.map;
                synchronized (map) {
                    this.map.clear();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isEmpty() {
                Map map = this.map;
                synchronized (map) {
                    return this.map.isEmpty();
                }
            }

            private static final class Value
            extends WeakReference {
                final Object keyRef;

                Value(Object object, Object object2, ReferenceQueue referenceQueue) {
                    super(object, referenceQueue);
                    this.keyRef = object2;
                }
            }
        }
    }
}

