/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jit.crypto;

import com.ibm.oti.vm.VM;
import sun.reflect.CallerSensitive;
import sun.reflect.Reflection;

public final class JITAESCryptInHardware {
    private static final JITAESCryptInHardware crypto;
    static boolean disableHardwareAcceleration;
    static final String osArch;

    private JITAESCryptInHardware() {
    }

    @CallerSensitive
    public static JITAESCryptInHardware getCrypto() {
        ClassLoader callerClassLoader = Reflection.getCallerClass().getClassLoader();
        if (callerClassLoader != null && callerClassLoader != VM.getVMLangAccess().getExtClassLoader()) {
            throw new SecurityException(JITAESCryptInHardware.class.getName());
        }
        return crypto;
    }

    private native boolean isAESSupportedByHardwareImpl();

    public native boolean expandAESKeyInHardware(byte[] var1, int[] var2, int var3);

    public native boolean doAESInHardware(byte[] var1, int var2, int var3, byte[] var4, int var5, int[] var6, int var7, boolean var8);

    public boolean isAESSupportedByHardware() {
        return !disableHardwareAcceleration && this.isAESSupportedByHardwareImpl();
    }

    static {
        osArch = VM.getVMLangAccess().internalGetProperties().getProperty("os.arch");
        crypto = new JITAESCryptInHardware();
        disableHardwareAcceleration = "true".equalsIgnoreCase(VM.getVMLangAccess().internalGetProperties().getProperty("com.ibm.jit.crypto.nohardwarecrypt"));
    }
}

