/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm26.j9.walkers.MemorySegmentIterator;
import com.ibm.j9ddr.vm26.pointer.UDATAPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm26.pointer.generated.J9MemorySegmentListPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9MemorySegmentPointer;
import com.ibm.j9ddr.vm26.types.UDATA;
import java.io.PrintStream;

public class SegmentsUtil {
    private static final String nl = System.getProperty("line.separator");

    public static void dbgDumpSegmentList(PrintStream out, J9MemorySegmentListPointer segmentListPointer) throws CorruptDataException {
        String fmt = null;
        if (J9BuildFlags.env_data64) {
            out.append("+----------------+----------------+----------------+----------------+--------+--------+\n");
            out.append("|    segment     |     start      |     alloc      |      end       |  type  |  size  |\n");
            out.append("+----------------+----------------+----------------+----------------+--------+--------+\n");
            fmt = " %016x %016x %016x %016x %08x %8x";
        } else {
            out.append("+--------+--------+--------+--------+--------+--------+\n");
            out.append("|segment | start  | alloc  |  end   |  type  |  size  |\n");
            out.append("+--------+--------+--------+--------+--------+--------+\n");
            fmt = " %08x %08x %08x %08x %08x %8x";
        }
        MemorySegmentIterator segmentIterator = new MemorySegmentIterator(segmentListPointer, -1, false);
        long totalMemory = 0L;
        long totalMemoryInUse = 0L;
        while (segmentIterator.hasNext()) {
            J9MemorySegmentPointer seg = (J9MemorySegmentPointer)segmentIterator.next();
            totalMemory += seg.size().longValue();
            totalMemoryInUse += seg.heapAlloc().sub(seg.heapBase()).longValue();
            String msg = String.format(fmt, seg.getAddress(), seg.heapBase().getAddress(), seg.heapAlloc().getAddress(), seg.heapTop().getAddress(), seg.type().longValue(), seg.size().longValue());
            out.append(msg);
            out.append(nl);
            seg = segmentListPointer.nextSegment();
        }
        if (J9BuildFlags.env_data64) {
            out.append("+----------------+----------------+----------------+----------------+--------+--------+\n");
        } else {
            out.append("+--------+--------+--------+--------+--------+--------+\n");
        }
        SegmentsUtil.printMemoryUsed(out, totalMemory, totalMemoryInUse);
        out.append(nl);
    }

    public static void dbgDumpJITCodeSegmentList(PrintStream out, J9MemorySegmentListPointer segmentListPointer) throws CorruptDataException {
        String fmt = null;
        if (J9BuildFlags.env_data64) {
            out.append("+----------------+----------------+----------------+----------------+----------------+--------+\n");
            out.append("|    segment     |     start      |    warmAlloc   |    coldAlloc   |      end       |  size  |\n");
            out.append("+----------------+----------------+----------------+----------------+----------------+--------+\n");
            fmt = " %016x %016x %016x %016x %016x %8x";
        } else {
            out.append("+--------+--------+--------+--------+--------+--------+\n");
            out.append("|segment | start  |  warm  |  cold  |  end   |  size  |\n");
            out.append("+--------+--------+--------+--------+--------+--------+\n");
            fmt = " %08x %08x %08x %08x %08x %8x";
        }
        MemorySegmentIterator segmentIterator = new MemorySegmentIterator(segmentListPointer, -1, false);
        long totalMemory = 0L;
        long totalMemoryInUse = 0L;
        while (segmentIterator.hasNext()) {
            J9MemorySegmentPointer seg = (J9MemorySegmentPointer)segmentIterator.next();
            UDATA heapBase = UDATAPointer.cast(seg.heapBase()).at(0L);
            long warmAlloc = UDATAPointer.cast(heapBase).at(0L).longValue();
            long coldAlloc = UDATAPointer.cast(heapBase.add(UDATA.SIZEOF)).at(0L).longValue();
            totalMemory += seg.size().longValue();
            totalMemoryInUse += warmAlloc - seg.heapBase().longValue() + (seg.heapTop().longValue() - coldAlloc);
            String msg = String.format(fmt, seg.getAddress(), seg.heapBase().getAddress(), warmAlloc, coldAlloc, seg.heapTop().getAddress(), seg.size().longValue());
            out.append(msg);
            out.append(nl);
            seg = segmentListPointer.nextSegment();
        }
        if (J9BuildFlags.env_data64) {
            out.append("+----------------+----------------+----------------+----------------+----------------+--------+\n");
        } else {
            out.append("+--------+--------+--------+--------+--------+--------+\n");
        }
        SegmentsUtil.printMemoryUsed(out, totalMemory, totalMemoryInUse);
        out.append(nl);
    }

    private static void printMemoryUsed(PrintStream out, long totalMemory, long totalMemoryInUse) {
        long totalMemoryFree = totalMemory - totalMemoryInUse;
        out.println(String.format("Total memory:           %016d (%016x)", totalMemory, totalMemory));
        out.println(String.format("Total memory in use:    %016d (%016x)", totalMemoryInUse, totalMemoryInUse));
        out.println(String.format("Total memory free:      %016d (%016x)", totalMemoryFree, totalMemoryFree));
    }
}

