/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm24.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm24.j9.gc.GCHeapLinkedFreeHeader;
import com.ibm.j9ddr.vm24.j9.gc.GCObjectModel;
import com.ibm.j9ddr.vm24.pointer.ObjectClassReferencePointer;
import com.ibm.j9ddr.vm24.pointer.VoidPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm24.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9IndexableObjectPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm24.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm24.structure.J9Consts;
import com.ibm.j9ddr.vm24.structure.J9Object;
import com.ibm.j9ddr.vm24.types.I32;
import com.ibm.j9ddr.vm24.types.U32;
import com.ibm.j9ddr.vm24.types.UDATA;

class GCObjectModel_V1
extends GCObjectModel {
    protected GCObjectModel_V1() throws CorruptDataException {
    }

    @Override
    public U32 getAge(J9ObjectPointer object) throws CorruptDataException {
        return J9ObjectHelper.flags(object).bitAnd(J9Object.OBJECT_HEADER_AGE_MASK);
    }

    @Override
    public UDATA getConsumedSizeInBytesWithHeader(J9ObjectPointer object) throws CorruptDataException {
        return this.adjustSizeInBytes(this.getSizeInBytesWithHeader(object));
    }

    @Override
    public U32 getObjectShape(J9ObjectPointer object) throws CorruptDataException {
        return J9ObjectHelper.flags(object).bitAnd(J9Object.OBJECT_HEADER_SHAPE_MASK);
    }

    @Override
    public U32 getClassShape(J9ClassPointer clazz) throws CorruptDataException {
        return clazz.romClass().instanceShape().bitAnd(J9Object.OBJECT_HEADER_SHAPE_MASK);
    }

    @Override
    public UDATA getSizeInBytesDeadObject(J9ObjectPointer object) throws CorruptDataException {
        if (this.isSingleSlotDeadObject(object)) {
            return this.getSizeInBytesSingleSlotDeadObject(object);
        }
        return this.getSizeInBytesMultiSlotDeadObject(object);
    }

    @Override
    public UDATA getSizeInBytesMultiSlotDeadObject(J9ObjectPointer object) throws CorruptDataException {
        return GCHeapLinkedFreeHeader.fromJ9Object(object).getSize();
    }

    @Override
    public UDATA getSizeInBytesSingleSlotDeadObject(J9ObjectPointer object) {
        return new UDATA(ObjectClassReferencePointer.SIZEOF);
    }

    @Override
    public UDATA getSizeInBytesWithHeader(J9ObjectPointer object) throws CorruptDataException {
        if (this.isIndexable(object)) {
            return this.indexableObjectModel.getSizeInBytesWithHeader(J9IndexableObjectPointer.cast(object));
        }
        return this.mixedObjectModel.getSizeInBytesWithHeader(object);
    }

    @Override
    public boolean isDeadObject(J9ObjectPointer object) throws CorruptDataException {
        return J9ObjectHelper.clazz(object).anyBitsIn(J9Consts.J9_GC_OBJ_HEAP_HOLE);
    }

    @Override
    public boolean isIndexable(J9ObjectPointer object) throws CorruptDataException {
        return J9ObjectHelper.flags(object).allBitsIn(J9Object.OBJECT_HEADER_INDEXABLE);
    }

    @Override
    public boolean isOld(J9ObjectPointer object) throws CorruptDataException {
        return J9ObjectHelper.flags(object).allBitsIn(J9Object.OBJECT_HEADER_OLD);
    }

    @Override
    public boolean isRemembered(J9ObjectPointer object) throws CorruptDataException {
        return J9ObjectHelper.flags(object).allBitsIn(J9Object.OBJECT_HEADER_REMEMBERED);
    }

    @Override
    public boolean isSingleSlotDeadObject(J9ObjectPointer object) throws CorruptDataException {
        return UDATA.cast(J9ObjectHelper.clazz(object)).bitAnd(J9Consts.J9_GC_OBJ_HEAP_HOLE_MASK).eq(J9Consts.J9_GC_SINGLE_SLOT_HOLE);
    }

    @Override
    public UDATA adjustSizeInBytes(UDATA sizeInBytes) {
        long bytes = sizeInBytes.longValue();
        if (J9BuildFlags.gc_alignObjects) {
            bytes = bytes + (J9Consts.J9_GC_OBJECT_ALIGNMENT_IN_BYTES - 1L) & (J9Consts.J9_GC_OBJECT_ALIGNMENT_IN_BYTES - 1L ^ 0xFFFFFFFFFFFFFFFFL);
        }
        if (J9BuildFlags.gc_minimumObjectSize && bytes < J9Consts.J9_GC_MINIMUM_OBJECT_SIZE) {
            bytes = J9Consts.J9_GC_MINIMUM_OBJECT_SIZE;
        }
        return new UDATA(bytes);
    }

    @Override
    public UDATA getSizeInElements(J9ObjectPointer object) throws IllegalArgumentException, CorruptDataException {
        if (this.isIndexable(object)) {
            return this.indexableObjectModel.getSizeInElements(J9IndexableObjectPointer.cast(object));
        }
        throw new IllegalArgumentException("this API is only valid on indexable objects");
    }

    @Override
    public int getObjectHashCode(J9ObjectPointer object) throws CorruptDataException {
        I32 basicHash = new I32(J9ObjectHelper.flags(object)).rightShift(16).bitAnd(Short.MAX_VALUE);
        return basicHash.leftShift(16).bitOr(basicHash).intValue();
    }

    @Override
    public UDATA getHeaderSize(J9ObjectPointer object) throws CorruptDataException {
        if (this.isIndexable(object)) {
            return this.indexableObjectModel.getHeaderSize(J9IndexableObjectPointer.cast(object));
        }
        return this.mixedObjectModel.getHeaderSize(object);
    }

    @Override
    public VoidPointer getElementAddress(J9IndexableObjectPointer indexableObjectPointer, int elementIndex, int elementSize) throws CorruptDataException {
        return this.indexableObjectModel.getElementAddress(indexableObjectPointer, elementIndex, elementSize);
    }
}

